/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner.actions;

import java.awt.Component;
import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;
import org.openide.util.NbBundle;

public class SplitRowAction
extends AbstractGridAction {
    private String name = NbBundle.getMessage(SplitRowAction.class, (String)"SplitRowAction_Name");

    @Override
    public Object getValue(String key) {
        return key.equals("Name") ? this.name : null;
    }

    @Override
    public boolean isEnabled(DesignerContext context) {
        return context.getFocusedRow() != -1;
    }

    @Override
    public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
        GridInfoProvider gridInfo = gridManager.getGridInfo();
        int[] originalColumnBounds = gridInfo.getColumnBounds();
        int[] originalRowBounds = gridInfo.getRowBounds();
        int row = context.getFocusedRow();
        GridUtils.removePaddingComponents(gridManager);
        gridManager.insertRow(row + 1);
        for (Component component : gridManager.getContainer().getComponents()) {
            int height;
            int y = gridInfo.getGridY(component);
            if (y + (height = gridInfo.getGridHeight(component)) - 1 != row) continue;
            gridManager.setGridHeight(component, ++height);
        }
        GridUtils.addPaddingComponents(gridManager, originalColumnBounds.length - 1, originalRowBounds.length);
        GridUtils.revalidateGrid(gridManager);
        int[] newColumnBounds = gridInfo.getColumnBounds();
        int[] newRowBounds = gridInfo.getRowBounds();
        int[] oldRowBounds = new int[originalRowBounds.length + 1];
        System.arraycopy(originalRowBounds, 0, oldRowBounds, 0, ++row + 1);
        oldRowBounds[row + 1] = oldRowBounds[row];
        System.arraycopy(originalRowBounds, row + 1, oldRowBounds, row + 2, originalRowBounds.length - row - 1);
        return new GridBoundsChange(originalColumnBounds, oldRowBounds, newColumnBounds, newRowBounds);
    }
}

