/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.OverlayLayout;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.fakepeer.FakePeerContainer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GlassPane;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridBagManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.UndoRedoSupport;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DesignContainerAction;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class GridDesigner
extends JPanel {
    public static final Color SELECTION_COLOR = FormLoaderSettings.getInstance().getSelectionBorderColor();
    public static final Image RESIZE_HANDLE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/resources/resize_handle.png", (boolean)false).getImage();
    private JPanel innerPane;
    private GlassPane glassPane;
    private VisualReplicator replicator;
    private PropertySheet sheet;
    private GridCustomizer customizer;
    private Set<RADVisualComponent> metaSelection = new HashSet<RADVisualComponent>();
    private PropertyChangeListener selectedNodeListener;
    boolean updateScheduled = false;
    private List<Node> selectedNodes = new ArrayList<Node>();

    public void setDesignedContainer(RADVisualContainer metaContainer) {
        this.removeAll();
        FormModel formModel = metaContainer.getFormModel();
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        this.innerPane = new JPanel(){

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        this.innerPane.setLayout(new OverlayLayout(this.innerPane));
        this.glassPane = new GlassPane(this);
        this.glassPane.setOpaque(false);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        UndoRedoSupport support = UndoRedoSupport.getSupport(formModel);
        support.reset(this.glassPane);
        toolBar.add(this.initUndoRedoButton(toolBar.add(support.getRedoAction())));
        toolBar.add(this.initUndoRedoButton(toolBar.add(support.getUndoAction())));
        JToggleButton padButton = this.initPaddingButton();
        toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        toolBar.add(padButton);
        toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        this.initPreviewButton(toolBar, metaContainer);
        toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        toolBar.add(Box.createGlue());
        rightPanel.add((Component)toolBar, "First");
        Dimension headerDim = new JLabel("99").getPreferredSize();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setViewportView(this.innerPane);
        scrollPane.setPreferredSize(new Dimension(500, 500));
        int unitIncrement = headerDim.height;
        scrollPane.getVerticalScrollBar().setUnitIncrement(unitIncrement);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(unitIncrement);
        rightPanel.add(scrollPane);
        splitPane.setRightComponent(rightPanel);
        this.add(splitPane);
        this.replicator = new VisualReplicator(true, FormUtils.getViewConverters(), FormEditor.getBindingSupport(formModel));
        this.replicator.setTopMetaComponent(metaContainer);
        final Object[] bean = new Object[1];
        FormLAF.executeWithLookAndFeel(formModel, new Runnable(){

            @Override
            public void run() {
                bean[0] = (Container)GridDesigner.this.replicator.createClone();
            }
        });
        Container container = metaContainer.getContainerDelegate(bean[0]);
        this.innerPane.removeAll();
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(Color.WHITE);
        GroupLayout layout = new GroupLayout(mainPanel);
        layout.setHonorsVisibility(false);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup().addGap(30 + headerDim.width).addComponent(container, -2, -2, -2).addContainerGap(-1, Short.MAX_VALUE);
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup().addGap(20 + headerDim.height).addComponent(container, -2, -2, -2).addContainerGap(-1, Short.MAX_VALUE);
        layout.setVerticalGroup(vGroup);
        mainPanel.setLayout(layout);
        this.glassPane.setPanes(this.innerPane, container);
        this.configureGridManager();
        splitPane.setLeftComponent(this.initLeftColumn());
        this.innerPane.add(this.glassPane);
        FakePeerContainer fakePeerContainer = new FakePeerContainer();
        fakePeerContainer.setLayout(new BorderLayout());
        fakePeerContainer.setBackground(mainPanel.getBackground());
        fakePeerContainer.setFont(FakePeerSupport.getDefaultAWTFont());
        fakePeerContainer.add(mainPanel);
        this.innerPane.add(fakePeerContainer);
    }

    private void configureGridManager() {
        RADVisualContainer metacont = (RADVisualContainer)this.replicator.getTopMetaComponent();
        Object bean = this.replicator.getClonedComponent(metacont);
        Container container = metacont.getContainerDelegate(bean);
        LayoutManager layout = container.getLayout();
        GridBagManager gridManager = null;
        if (layout instanceof GridBagLayout) {
            gridManager = new GridBagManager(this.replicator);
        }
        this.glassPane.setGridManager(gridManager);
        this.customizer = gridManager.getCustomizer(this.glassPane);
    }

    private JComponent initLeftColumn() {
        Object leftPanel;
        this.sheet = new PropertySheet();
        this.sheet.setPreferredSize(new Dimension(310, 500));
        if (this.customizer == null) {
            leftPanel = this.sheet;
        } else {
            leftPanel = new JPanel();
            ((Container)leftPanel).setLayout(new BorderLayout());
            ((Container)leftPanel).add((Component)this.sheet);
            ((Container)leftPanel).add(this.customizer.getComponent(), "First");
        }
        return leftPanel;
    }

    private JToggleButton initPaddingButton() {
        JToggleButton button = new JToggleButton();
        ImageIcon image = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/layoutsupport/griddesigner/resources/pad_empty.png", (boolean)false);
        button.setIcon(image);
        button.setFocusPainted(false);
        button.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.padEmptyCells"));
        Dimension dim = button.getPreferredSize();
        button.setMaximumSize(new Dimension(dim.width, Short.MAX_VALUE));
        button.setSelected(FormLoaderSettings.getInstance().getPadEmptyCells());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean padEmptyCells = ((JToggleButton)e.getSource()).isSelected();
                FormLoaderSettings.getInstance().setPadEmptyCells(padEmptyCells);
                GridDesigner.this.glassPane.updateLayout();
            }
        });
        return button;
    }

    private void initPreviewButton(JToolBar toolBar, final RADVisualComponent metaComp) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestAction testAction = (TestAction)SystemAction.get(TestAction.class);
                testAction.createPreview(metaComp, null);
            }
        };
        TestAction testAction = (TestAction)SystemAction.get(TestAction.class);
        action.putValue("Name", testAction.getName());
        action.putValue("SmallIcon", testAction.getValue("SmallIcon"));
        JButton button = toolBar.add(action);
        button.setToolTipText(NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.previewLayout"));
        button.setFocusPainted(false);
    }

    private JButton initUndoRedoButton(JButton button) {
        String text = (String)button.getAction().getValue("Name");
        Mnemonics.setLocalizedText((AbstractButton)button, (String)text);
        text = button.getText();
        button.setText(null);
        button.setToolTipText(text);
        button.setFocusPainted(false);
        return button;
    }

    public void setSelection(Set<Component> selection) {
        this.metaSelection.clear();
        RADVisualContainer metacont = (RADVisualContainer)this.replicator.getTopMetaComponent();
        for (RADVisualComponent metacomp : metacont.getSubComponents()) {
            Component comp = (Component)this.replicator.getClonedComponent(metacomp);
            if (!selection.contains(comp)) continue;
            this.metaSelection.add(metacomp);
        }
        this.updatePropertySheet();
        this.updateCustomizer();
    }

    private PropertyChangeListener getSelectedNodeListener() {
        if (this.selectedNodeListener == null) {
            this.selectedNodeListener = this.createSelectedNodeListener();
        }
        return this.selectedNodeListener;
    }

    private PropertyChangeListener createSelectedNodeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!GridDesigner.this.glassPane.isUserActionInProgress() && !GridDesigner.this.updateScheduled) {
                    GridDesigner.this.updateScheduled = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GridDesigner.this.updateScheduled = false;
                            GridDesigner.this.glassPane.updateLayout();
                            GridDesigner.this.updateCustomizer();
                        }
                    });
                }
            }
        };
    }

    private void updatePropertySheet() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.metaSelection.size());
        for (RADVisualComponent metacomp : this.metaSelection) {
            RADComponentNode node = metacomp.getNodeReference();
            if (node == null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<Node> nodes = new ArrayList<Node>(GridDesigner.this.metaSelection.size());
                        for (RADVisualComponent metacomp : GridDesigner.this.metaSelection) {
                            nodes.add((Node)new LayoutConstraintsNode((Node)metacomp.getNodeReference()));
                        }
                        GridDesigner.this.setSelectedNodes(nodes);
                        GridDesigner.this.sheet.setNodes(nodes.toArray(new Node[nodes.size()]));
                    }
                });
                return;
            }
            nodes.add((Node)new LayoutConstraintsNode((Node)node));
        }
        this.setSelectedNodes(nodes);
        this.sheet.setNodes(nodes.toArray(new Node[nodes.size()]));
    }

    void setSelectedNodes(List<Node> nodes) {
        for (Node node : this.selectedNodes) {
            node.removePropertyChangeListener(this.getSelectedNodeListener());
        }
        this.selectedNodes = nodes;
        for (Node node : this.selectedNodes) {
            node.addPropertyChangeListener(this.getSelectedNodeListener());
        }
    }

    void updateCustomizer() {
        if (this.customizer != null) {
            DesignerContext context = this.glassPane.currentContext();
            this.customizer.setContext(context);
        }
    }

    void updateContextMenu(DesignerContext context, JPopupMenu menu) {
        if (this.metaSelection.isEmpty()) {
            RADVisualContainer parent;
            RADVisualContainer root;
            if (context.getFocusedColumn() == -1 == (context.getFocusedRow() == -1) && this.haveIdenticalLayoutDelegate(root = (RADVisualContainer)this.replicator.getTopMetaComponent(), parent = root.getParentContainer())) {
                menu.add(new DesignContainerAction(this, parent, true));
            }
        } else if (this.metaSelection.size() == 1) {
            RADVisualContainer cont;
            RADVisualContainer root = (RADVisualContainer)this.replicator.getTopMetaComponent();
            RADVisualComponent comp = this.metaSelection.iterator().next();
            if (comp instanceof RADVisualContainer && this.haveIdenticalLayoutDelegate(root, cont = (RADVisualContainer)comp)) {
                menu.add(new DesignContainerAction(this, cont, false));
            }
        }
    }

    private boolean haveIdenticalLayoutDelegate(RADVisualContainer cont1, RADVisualContainer cont2) {
        if (cont1 == null || cont2 == null) {
            return false;
        }
        LayoutSupportManager support1 = cont1.getLayoutSupport();
        if (support1 == null) {
            return false;
        }
        String delegate1 = support1.getLayoutDelegate().getClass().getName();
        LayoutSupportManager support2 = cont2.getLayoutSupport();
        if (support2 == null) {
            return false;
        }
        String delegate2 = support2.getLayoutDelegate().getClass().getName();
        return delegate1.equals(delegate2);
    }

    static class LayoutConstraintsNode
    extends FilterNode {
        LayoutConstraintsNode(Node original) {
            super(original);
        }

        public Node.PropertySet[] getPropertySets() {
            for (Node.PropertySet pSet : super.getPropertySets()) {
                String name = pSet.getName();
                if (!"layout".equals(name)) continue;
                final Node.PropertySet set = pSet;
                String displayName = NbBundle.getMessage(GridDesigner.class, (String)"GridDesigner.layoutConstraints");
                return new Node.PropertySet[]{new Node.PropertySet(set.getName(), displayName, set.getShortDescription()){

                    public Node.Property<?>[] getProperties() {
                        return set.getProperties();
                    }
                }};
            }
            return new Node.PropertySet[0];
        }
    }
}

