/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructureChange;
import org.netbeans.modules.form.codestructure.CodeSupport;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.codestructure.DefaultCodeExpression;
import org.netbeans.modules.form.codestructure.UsedCodeObject;
import org.netbeans.modules.form.codestructure.UsingCodeObject;

public class CodeStructure {
    public static final CodeExpression[] EMPTY_PARAMS = new CodeExpression[0];
    private static final int VARIABLE_CREATE = 1;
    private static final int VARIABLE_RENAME = 2;
    private static final int VARIABLE_RELEASE = 3;
    private static final int VARIABLE_ATTACH = 4;
    private static final int VARIABLE_DETACH = 5;
    private static UsingCodeObject globalUsingObject;
    private Map<String, Variable> namesToVariables = new HashMap<String, Variable>(50);
    private Map<Object, Variable> expressionsToVariables = new HashMap<Object, Variable>(50);
    private Set<String> externalVariables = null;
    private int defaultVariableType = -1;
    private boolean undoRedoRecording = false;
    private int undoRedoMark = 0;
    private int oldestMark = 0;
    private int lastUndone = -1;
    private int undoRedoHardLimit = 10000;
    private Map<Integer, CodeStructureChange> undoMap;
    private Map<Integer, CodeStructureChange> redoMap;
    private FormJavaSource javaSource;
    private static int traceCount;
    private static final boolean TRACE = false;

    public CodeStructure(boolean startUndoRedoRecording) {
        if (startUndoRedoRecording) {
            this.setUndoRedoRecording(true);
        }
    }

    public void setFormJavaSource(FormJavaSource formJavaSource) {
        this.javaSource = formJavaSource;
    }

    public CodeExpression createExpression(Constructor ctor, CodeExpression[] params) {
        CodeSupport.ConstructorOrigin origin = new CodeSupport.ConstructorOrigin(ctor, params);
        return new DefaultCodeExpression(this, origin);
    }

    public CodeExpression createExpression(CodeExpression parent, Method method, CodeExpression[] params) {
        CodeSupport.MethodOrigin origin = new CodeSupport.MethodOrigin(parent, method, params);
        return new DefaultCodeExpression(this, origin);
    }

    public CodeExpression createExpression(CodeExpression parent, Field field) {
        CodeSupport.FieldOrigin origin = new CodeSupport.FieldOrigin(parent, field);
        return new DefaultCodeExpression(this, origin);
    }

    public CodeExpression createExpression(Class type, Object value, String javaInitStr) {
        return new DefaultCodeExpression(this, new CodeSupport.ValueOrigin(type, value, javaInitStr));
    }

    public CodeExpression createExpression(CodeExpressionOrigin origin) {
        return new DefaultCodeExpression(this, origin);
    }

    public CodeExpression createNullExpression(Class type) {
        return new DefaultCodeExpression(this, new CodeSupport.ValueOrigin(type, null, "null"));
    }

    public CodeExpression createDefaultExpression() {
        return new DefaultCodeExpression(this);
    }

    public void registerExpression(CodeExpression expression) {
        if (globalUsingObject == null) {
            globalUsingObject = new GlobalUsingObject();
        }
        expression.addUsingObject(globalUsingObject, 2, CodeStructure.class);
    }

    public static void removeExpression(CodeExpression expression) {
        CodeStructure.unregisterUsedCodeObject(expression);
        CodeStructure.unregisterUsingCodeObject(expression);
        expression.getCodeStructure().removeExpressionFromVariable(expression);
    }

    public static CodeExpression[] filterExpressions(Iterator it, Object originMetaObject) {
        ArrayList<CodeExpression> list = new ArrayList<CodeExpression>();
        while (it.hasNext()) {
            CodeExpression exp = (CodeExpression)it.next();
            if (!originMetaObject.equals(exp.getOrigin().getMetaObject())) continue;
            list.add(exp);
        }
        return list.toArray(new CodeExpression[list.size()]);
    }

    public static CodeStatement createStatement(CodeExpression expression, Method m, CodeExpression[] params) {
        CodeSupport.MethodStatement statement = new CodeSupport.MethodStatement(expression, m, params);
        CodeStructure.registerUsingCodeObject(statement);
        return statement;
    }

    public static CodeStatement createStatement(CodeExpression expression, Field f, CodeExpression assignExp) {
        CodeSupport.FieldStatement statement = new CodeSupport.FieldStatement(expression, f, assignExp);
        CodeStructure.registerUsingCodeObject(statement);
        return statement;
    }

    public static void removeStatement(CodeStatement statement) {
        CodeStructure.unregisterUsingCodeObject(statement);
    }

    public static void removeStatements(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CodeStructure.unregisterUsingCodeObject((CodeStatement)list.get(i));
        }
    }

    public static CodeStatement[] filterStatements(Iterator it, Object metaObject) {
        ArrayList<CodeStatement> list = new ArrayList<CodeStatement>();
        while (it.hasNext()) {
            CodeStatement statement = (CodeStatement)it.next();
            if (!metaObject.equals(statement.getMetaObject())) continue;
            list.add(statement);
        }
        return list.toArray(new CodeStatement[list.size()]);
    }

    public CodeGroup createCodeGroup() {
        return new CodeSupport.DefaultCodeGroup();
    }

    public static CodeExpressionOrigin createOrigin(Constructor ctor, CodeExpression[] params) {
        return new CodeSupport.ConstructorOrigin(ctor, params);
    }

    public static CodeExpressionOrigin createOrigin(CodeExpression parent, Method m, CodeExpression[] params) {
        return new CodeSupport.MethodOrigin(parent, m, params);
    }

    public static CodeExpressionOrigin createOrigin(CodeExpression parent, Field f) {
        return new CodeSupport.FieldOrigin(parent, f);
    }

    public static CodeExpressionOrigin createOrigin(Class type, Object value, String javaStr) {
        return new CodeSupport.ValueOrigin(type, value, javaStr);
    }

    public static Iterator getDefinedExpressionsIterator(CodeExpression exp) {
        return exp.getUsingObjectsIterator(1, CodeExpression.class);
    }

    public static Iterator getUsingExpressionsIterator(CodeExpression exp) {
        return exp.getUsingObjectsIterator(2, CodeExpression.class);
    }

    public static Iterator getDefinedStatementsIterator(CodeExpression exp) {
        return exp.getUsingObjectsIterator(1, CodeStatement.class);
    }

    public static Iterator getUsingStatementsIterator(CodeExpression exp) {
        return exp.getUsingObjectsIterator(2, CodeStatement.class);
    }

    static void registerUsingCodeObject(CodeStatement statement) {
        CodeExpression[] params;
        CodeExpression parent = statement.getParentExpression();
        if (parent != null) {
            parent.addUsingObject(statement, 1, CodeStatement.class);
        }
        if ((params = statement.getStatementParameters()) != null) {
            for (int i = 0; i < params.length; ++i) {
                params[i].addUsingObject(statement, 2, CodeStatement.class);
            }
        }
    }

    static void registerUsingCodeObject(CodeExpression expression) {
        CodeExpression[] params;
        CodeExpressionOrigin origin = expression.getOrigin();
        CodeExpression parent = origin.getParentExpression();
        if (parent != null) {
            parent.addUsingObject(expression, 1, CodeExpression.class);
        }
        if ((params = origin.getCreationParameters()) != null) {
            for (int i = 0; i < params.length; ++i) {
                params[i].addUsingObject(expression, 2, CodeExpression.class);
            }
        }
    }

    static void unregisterUsingCodeObject(UsingCodeObject usingObject) {
        Iterator it = usingObject.getUsedObjectsIterator();
        while (it.hasNext()) {
            UsedCodeObject usedObject = (UsedCodeObject)it.next();
            if (usedObject.removeUsingObject(usingObject) || !(usedObject instanceof UsingCodeObject)) continue;
            CodeStructure.unregisterUsingCodeObject((UsingCodeObject)((Object)usedObject));
        }
    }

    static void unregisterObjectUsage(UsingCodeObject usingObject, UsedCodeObject usedObject) {
        if (!usedObject.removeUsingObject(usingObject) && usedObject instanceof UsingCodeObject) {
            CodeStructure.unregisterUsingCodeObject((UsingCodeObject)((Object)usedObject));
        }
    }

    static void unregisterUsedCodeObject(UsedCodeObject usedObject) {
        ArrayList usingObjects = new ArrayList();
        Iterator it = usedObject.getUsingObjectsIterator(0, null);
        while (it.hasNext()) {
            usingObjects.add(it.next());
        }
        for (UsingCodeObject usingObject : usingObjects) {
            if (usingObject.usedObjectRemoved(usedObject)) continue;
            if (usingObject instanceof UsedCodeObject) {
                CodeStructure.unregisterUsedCodeObject((UsedCodeObject)((Object)usingObject));
            }
            CodeStructure.unregisterUsingCodeObject(usingObject);
        }
    }

    public CodeVariable createVariable(int type, Class declaredType, String name) {
        if (this.getVariable(name) != null) {
            return null;
        }
        if (type < 0 || name == null) {
            throw new IllegalArgumentException();
        }
        Variable var = new Variable(type, declaredType, "", name);
        this.namesToVariables.put(name, var);
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(1, var));
        }
        return var;
    }

    public boolean renameVariable(String oldName, String newName) {
        Variable var = this.namesToVariables.get(oldName);
        if (var == null || newName == null || newName.equals(var.getName()) || this.namesToVariables.get(newName) != null) {
            return false;
        }
        this.namesToVariables.remove(oldName);
        var.name = newName;
        this.namesToVariables.put(newName, var);
        if (this.undoRedoRecording) {
            VariableChange change = new VariableChange(2, var);
            change.oldName = oldName;
            change.newName = newName;
            this.logUndoableChange(change);
        }
        return true;
    }

    public CodeVariable releaseVariable(String name) {
        Variable var = this.namesToVariables.remove(name);
        if (var == null) {
            return null;
        }
        Map expressionsMap = var.expressionsMap;
        if (expressionsMap == null) {
            return var;
        }
        Iterator it = expressionsMap.values().iterator();
        while (it.hasNext()) {
            this.expressionsToVariables.remove(it.next());
        }
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(3, var));
        }
        return var;
    }

    public boolean isVariableNameReserved(String name) {
        return this.namesToVariables.get(name) != null || this.javaSource.containsField(name, true);
    }

    public CodeVariable createVariableForExpression(CodeExpression expression, int type, String name) {
        CodeVariable var = expression == null ? null : expression.getVariable();
        String typeParameters = var == null ? "" : var.getDeclaredTypeParameters();
        return this.createVariableForExpression(expression, type, typeParameters, name);
    }

    public CodeVariable createVariableForExpression(CodeExpression expression, int type, String typeParameters, String name) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        if (this.getVariable(expression) != null) {
            return null;
        }
        if (type < 0) {
            throw new IllegalArgumentException();
        }
        if (this.expressionsToVariables.get(expression) != null) {
            this.removeExpressionFromVariable(expression);
        }
        name = this.getFreeVariableName(name, expression.getOrigin().getType());
        Variable var = new Variable(type, expression.getOrigin().getType(), typeParameters, name);
        CodeStatement statement = this.createVariableAssignment(var, expression);
        var.addCodeExpression(expression, statement);
        this.namesToVariables.put(name, var);
        this.expressionsToVariables.put(expression, var);
        if (this.undoRedoRecording) {
            this.logUndoableChange(new VariableChange(1, var));
            VariableChange change = new VariableChange(4, var);
            change.expression = expression;
            change.statement = statement;
            this.logUndoableChange(change);
        }
        return var;
    }

    private String getFreeVariableName(String name, Class type) {
        if (name == null || this.namesToVariables.get(name) != null) {
            String baseName;
            int n = 0;
            if (name != null) {
                char c;
                int i = name.length();
                int exp = 1;
                while (--i >= 0 && (c = name.charAt(i)) >= '0' && c <= '9') {
                    n += (c - 48) * exp;
                    exp *= 10;
                }
                baseName = i >= 0 ? name.substring(0, i + 1) : name;
            } else {
                String typeName = type.getName();
                int i = typeName.lastIndexOf(36);
                if (i < 0 && (i = typeName.lastIndexOf(43)) < 0) {
                    i = typeName.lastIndexOf(46);
                }
                baseName = Character.toLowerCase(typeName.charAt(i + 1)) + typeName.substring(i + 2);
            }
            this.javaSource.refresh();
            while (this.namesToVariables.get(name = baseName + ++n) != null || this.javaSource.containsField(name, false)) {
            }
        }
        return name;
    }

    public String getExternalVariableName(Class type, String suggestedName, boolean register) {
        String name = this.getFreeVariableName(suggestedName, type);
        if (register) {
            this.createVariable(4096, type, name);
            if (this.externalVariables == null) {
                this.externalVariables = new HashSet<String>();
            }
            this.externalVariables.add(name);
        }
        return name;
    }

    public void clearExternalVariableNames() {
        if (this.externalVariables != null) {
            Iterator<String> it = this.externalVariables.iterator();
            while (it.hasNext()) {
                this.releaseVariable(it.next());
            }
            this.externalVariables.clear();
        }
    }

    public void attachExpressionToVariable(CodeExpression expression, CodeVariable variable) {
        if (expression == null) {
            return;
        }
        if (variable.getAssignment(expression) != null) {
            return;
        }
        int mask = 20480;
        if ((variable.getType() & mask) == 4096 && variable.getAttachedExpressions().size() > 0) {
            throw new IllegalStateException("Standalone local variable declaration required for: " + variable.getName());
        }
        Variable prevVar = this.expressionsToVariables.get(expression);
        if (prevVar != null && prevVar != variable) {
            this.removeExpressionFromVariable(expression);
        }
        Variable var = (Variable)variable;
        CodeStatement statement = this.createVariableAssignment(var, expression);
        var.addCodeExpression(expression, statement);
        this.expressionsToVariables.put(expression, var);
        if (this.undoRedoRecording) {
            VariableChange change = new VariableChange(4, var);
            change.expression = expression;
            change.statement = statement;
            this.logUndoableChange(change);
        }
    }

    public void removeExpressionFromVariable(CodeExpression expression) {
        if (expression == null) {
            return;
        }
        Variable var = this.expressionsToVariables.remove(expression);
        if (var == null) {
            return;
        }
        CodeStatement statement = var.removeCodeExpression(expression);
        if (this.undoRedoRecording) {
            VariableChange change = new VariableChange(5, var);
            change.expression = expression;
            change.statement = statement;
            this.logUndoableChange(change);
        }
        if (var.expressionsMap.isEmpty() && (var.getType() & 0x8000) == 0) {
            this.releaseVariable(var.getName());
        }
    }

    public CodeVariable getVariable(String name) {
        return this.namesToVariables.get(name);
    }

    public CodeVariable getVariable(CodeExpression expression) {
        return this.expressionsToVariables.get(expression);
    }

    public Iterator getVariablesIterator(int type, int typeMask, Class declaredType) {
        return new VariablesIterator(this.namesToVariables.values().iterator(), type, typeMask, declaredType);
    }

    public Collection getAllVariables() {
        return Collections.unmodifiableCollection(this.namesToVariables.values());
    }

    public void setDefaultVariableType(int type) {
        if (type < 0) {
            this.defaultVariableType = -1;
        } else {
            int fdMask;
            if (((type &= 0xF0DF) & 0x3000) == 0) {
                type |= 0x2000;
            }
            if ((type & (fdMask = 16400)) == fdMask) {
                type &= 0xFFFFBFFF;
            }
            this.defaultVariableType = type;
        }
    }

    int getDefaultVariableType() {
        return this.defaultVariableType > -1 ? this.defaultVariableType : 8194;
    }

    protected Map getNamesToVariablesMap() {
        return this.namesToVariables;
    }

    protected Map getExpressionsToVariables() {
        return this.expressionsToVariables;
    }

    private CodeStatement createVariableAssignment(CodeVariable var, CodeExpression expression) {
        CodeSupport.AssignVariableStatement statement = new CodeSupport.AssignVariableStatement(var, expression);
        return statement;
    }

    public void setUndoRedoRecording(boolean record) {
        this.undoRedoRecording = record;
        if (record && this.undoMap == null) {
            this.undoMap = new HashMap<Integer, CodeStructureChange>(500);
            this.redoMap = new HashMap<Integer, CodeStructureChange>(100);
        }
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    void logUndoableChange(CodeStructureChange change) {
        this.redoMap.clear();
        this.lastUndone = -1;
        if (this.undoMap.isEmpty()) {
            this.oldestMark = this.undoRedoMark;
        }
        CodeStructure.t("adding undoable change " + this.undoRedoMark);
        this.undoMap.put(new Integer(this.undoRedoMark++), change);
        if (this.undoMap.size() > this.undoRedoHardLimit) {
            CodeStructure.t("undo/redo hard limit reached: " + this.undoMap.size() + " > " + this.undoRedoHardLimit);
        }
        while (this.undoMap.size() > this.undoRedoHardLimit) {
            Integer mark = new Integer(this.oldestMark++);
            this.undoMap.remove(mark);
        }
    }

    public Object markForUndo() {
        this.redoMap.clear();
        CodeStructure.t("mark for undo: " + this.undoRedoMark);
        Integer newMark = new Integer(this.undoRedoMark);
        return newMark;
    }

    public void releaseUndoableChanges(Object fromMark, Object toMark) {
        int m1;
        int m2 = (Integer)toMark;
        CodeStructure.t("release marks from " + m1 + " to " + m2);
        for (m1 = ((Integer)fromMark).intValue(); m1 < m2; ++m1) {
            Integer m = new Integer(m1);
            this.undoMap.remove(m);
            this.redoMap.remove(m);
        }
    }

    public boolean undoToMark(Object mark) {
        int currentMark = this.undoRedoMark;
        int lastMark = (Integer)mark;
        if (currentMark <= lastMark) {
            return false;
        }
        CodeStructure.t("undo to mark " + mark);
        if (this.undoMap.get((Integer)mark) == null) {
            CodeStructure.t("mark already dropped from the queue");
            return false;
        }
        boolean undoRedoOn = this.undoRedoRecording;
        this.undoRedoRecording = false;
        while (currentMark > lastMark) {
            Integer key;
            CodeStructureChange change;
            if ((change = this.undoMap.remove(key = new Integer(--currentMark))) == null) continue;
            change.undo();
            this.redoMap.put(key, change);
            this.lastUndone = currentMark;
            CodeStructure.t("undone: " + key);
        }
        if (undoRedoOn) {
            this.undoRedoRecording = true;
        }
        return true;
    }

    public boolean redoToMark(Object mark) {
        if (this.lastUndone < 0) {
            return false;
        }
        int toMark = (Integer)mark;
        if (this.lastUndone >= toMark || toMark > this.undoRedoMark) {
            return false;
        }
        CodeStructure.t("redo to mark " + mark);
        boolean undoRedoOn = this.undoRedoRecording;
        this.undoRedoRecording = false;
        while (this.lastUndone < toMark) {
            Integer key;
            CodeStructureChange change;
            if ((change = this.redoMap.remove(key = new Integer(this.lastUndone++))) == null) continue;
            change.redo();
            this.undoMap.put(key, change);
            CodeStructure.t("redone: " + key);
        }
        if (undoRedoOn) {
            this.undoRedoRecording = true;
        }
        return true;
    }

    static void t(String str) {
    }

    static {
        traceCount = 0;
    }

    private class VariableChange
    implements CodeStructureChange {
        private int changeType;
        private Variable variable;
        private CodeExpression expression;
        private CodeStatement statement;
        private String oldName;
        private String newName;

        VariableChange(int type, Variable var) {
            this.changeType = type;
            this.variable = var;
        }

        @Override
        public void undo() {
            switch (this.changeType) {
                case 1: {
                    CodeStructure.this.namesToVariables.remove(this.variable.name);
                    break;
                }
                case 2: {
                    CodeStructure.this.namesToVariables.remove(this.newName);
                    this.variable.name = this.oldName;
                    CodeStructure.this.namesToVariables.put(this.oldName, this.variable);
                    break;
                }
                case 3: {
                    Iterator it = this.variable.expressionsMap.values().iterator();
                    while (it.hasNext()) {
                        CodeStructure.this.expressionsToVariables.put(it.next(), this.variable);
                    }
                    CodeStructure.this.namesToVariables.put(this.variable.name, this.variable);
                    break;
                }
                case 4: {
                    CodeStructure.this.expressionsToVariables.remove(this.expression);
                    this.variable.expressionsMap.remove(this.expression);
                    break;
                }
                case 5: {
                    this.variable.expressionsMap.put(this.expression, this.statement);
                    CodeStructure.this.expressionsToVariables.put(this.expression, this.variable);
                }
            }
        }

        @Override
        public void redo() {
            switch (this.changeType) {
                case 1: {
                    CodeStructure.this.namesToVariables.put(this.variable.name, this.variable);
                    break;
                }
                case 2: {
                    CodeStructure.this.namesToVariables.remove(this.oldName);
                    this.variable.name = this.newName;
                    CodeStructure.this.namesToVariables.put(this.newName, this.variable);
                    break;
                }
                case 3: {
                    CodeStructure.this.namesToVariables.remove(this.variable.name);
                    Iterator it = this.variable.expressionsMap.values().iterator();
                    while (it.hasNext()) {
                        CodeStructure.this.expressionsToVariables.remove(it.next());
                    }
                    break;
                }
                case 4: {
                    this.variable.expressionsMap.put(this.expression, this.statement);
                    CodeStructure.this.expressionsToVariables.put(this.expression, this.variable);
                    break;
                }
                case 5: {
                    CodeStructure.this.expressionsToVariables.remove(this.expression);
                    this.variable.expressionsMap.remove(this.expression);
                }
            }
        }
    }

    private static final class VariablesIterator
    implements Iterator {
        private int type;
        private int typeMask;
        private Class declaredType;
        private Iterator subIterator;
        private CodeVariable currentVar;

        public VariablesIterator(Iterator subIterator, int type, int typeMask, Class declaredType) {
            this.type = type;
            this.typeMask = typeMask;
            this.declaredType = declaredType;
            this.subIterator = subIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.currentVar != null) {
                return true;
            }
            while (this.subIterator.hasNext()) {
                CodeVariable var = (CodeVariable)this.subIterator.next();
                if (this.type >= 0 && (this.type & this.typeMask) != (var.getType() & this.typeMask) || this.declaredType != null && !this.declaredType.equals(var.getDeclaredType())) continue;
                this.currentVar = var;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            CodeVariable var = this.currentVar;
            this.currentVar = null;
            return var;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    final class Variable
    implements CodeVariable {
        private int type;
        private Class declaredType;
        private String declaredTypeParameters;
        private String name;
        private Map<CodeExpression, CodeStatement> expressionsMap;
        private CodeStatement declarationStatement;

        Variable(int type, Class declaredType, String declaredTypeParameters, String name) {
            if ((type & 0x10) != 0) {
                type &= 0xFFFFBFFF;
            }
            this.type = type;
            this.declaredType = declaredType;
            this.declaredTypeParameters = declaredTypeParameters;
            this.name = name;
        }

        @Override
        public int getType() {
            return (this.type & 0x30DF) != 12511 ? this.type : CodeStructure.this.getDefaultVariableType();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getDeclaredType() {
            return this.declaredType;
        }

        @Override
        public String getDeclaredTypeParameters() {
            return this.declaredTypeParameters;
        }

        @Override
        public Collection getAttachedExpressions() {
            return this.expressionsMap != null ? Collections.unmodifiableCollection(this.expressionsMap.keySet()) : Collections.EMPTY_LIST;
        }

        @Override
        public CodeStatement getDeclaration() {
            if (this.declarationStatement == null) {
                this.declarationStatement = new CodeSupport.DeclareVariableStatement(this);
            }
            return this.declarationStatement;
        }

        @Override
        public CodeStatement getAssignment(CodeExpression expression) {
            return this.expressionsMap != null ? this.expressionsMap.get(expression) : null;
        }

        void addCodeExpression(CodeExpression expression, CodeStatement statement) {
            if (this.expressionsMap == null) {
                this.expressionsMap = new HashMap<CodeExpression, CodeStatement>();
            }
            this.expressionsMap.put(expression, statement);
        }

        CodeStatement removeCodeExpression(CodeExpression expression) {
            if (this.expressionsMap != null) {
                return this.expressionsMap.remove(expression);
            }
            return null;
        }
    }

    private static class GlobalUsingObject
    implements UsingCodeObject {
        private GlobalUsingObject() {
        }

        @Override
        public void usageRegistered(UsedCodeObject usedObject) {
        }

        @Override
        public boolean usedObjectRemoved(UsedCodeObject usedObject) {
            return true;
        }

        @Override
        public UsedCodeObject getDefiningObject() {
            return null;
        }

        @Override
        public Iterator getUsedObjectsIterator() {
            return null;
        }
    }
}

