/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableURLClassLoader
extends URLClassLoader
implements Closeable {
    public CloseableURLClassLoader(URL[] urls, ClassLoader parent) throws Error {
        super(urls, parent);
        try {
            this.getLoaders();
        }
        catch (Throwable t) {
            throw new Error("cannot create CloseableURLClassLoader", t);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            for (Object l : this.getLoaders()) {
                Field jarField;
                JarFile jar;
                if (!l.getClass().getName().equals("sun.misc.URLClassPath$JarLoader") || (jar = (JarFile)this.getField(l, jarField = l.getClass().getDeclaredField("jar"))) == null) continue;
                jar.close();
            }
        }
        catch (Throwable t) {
            IOException e = new IOException("cannot close class loader");
            e.initCause(t);
            throw e;
        }
    }

    private ArrayList<?> getLoaders() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field ucpField = URLClassLoader.class.getDeclaredField("ucp");
        Object urlClassPath = this.getField(this, ucpField);
        if (urlClassPath == null) {
            throw new AssertionError((Object)"urlClassPath not set in URLClassLoader");
        }
        Field loadersField = urlClassPath.getClass().getDeclaredField("loaders");
        return (ArrayList)this.getField(urlClassPath, loadersField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getField(Object o, Field f) throws IllegalArgumentException, IllegalAccessException {
        boolean prev = f.isAccessible();
        try {
            f.setAccessible(true);
            Object object = f.get(o);
            Object var6_5 = null;
            f.setAccessible(prev);
            return object;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            f.setAccessible(prev);
            throw throwable;
        }
    }
}

