/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Warner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ElementVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolve {
    protected static final Context.Key<Resolve> resolveKey = new Context.Key();
    Names names;
    Log log;
    Symtab syms;
    Check chk;
    Infer infer;
    ClassReader reader;
    TreeInfo treeinfo;
    Types types;
    JCDiagnostic.Factory diags;
    public final boolean boxingEnabled;
    public final boolean varargsEnabled;
    public final boolean allowMethodHandles;
    private final boolean debugResolve;
    private final boolean ideMode;
    Scope polymorphicSignatureScope;
    final SymbolNotFoundError varNotFound;
    final InapplicableSymbolError wrongMethod;
    final InapplicableSymbolsError wrongMethods;
    final SymbolNotFoundError methodNotFound;
    final SymbolNotFoundError typeNotFound;
    private final InapplicableMethodException inapplicableMethodException;
    Warner noteWarner = new Warner();
    private final Formattable.LocalizedString noArgs = new Formattable.LocalizedString("compiler.misc.no.args");
    private Map<MethodResolutionPhase, Symbol> methodResolutionCache = new HashMap<MethodResolutionPhase, Symbol>(MethodResolutionPhase.values().length);
    final List<MethodResolutionPhase> methodResolutionSteps = List.of(MethodResolutionPhase.BASIC, MethodResolutionPhase.BOX, MethodResolutionPhase.VARARITY);
    private MethodResolutionPhase currentStep = null;

    public static Resolve instance(Context context) {
        Resolve instance = context.get(resolveKey);
        if (instance == null) {
            instance = new Resolve(context);
        }
        return instance;
    }

    protected Resolve(Context context) {
        context.put(resolveKey, this);
        this.syms = Symtab.instance(context);
        this.varNotFound = new SymbolNotFoundError(68);
        this.wrongMethod = new InapplicableSymbolError(this.syms.errSymbol);
        this.wrongMethods = new InapplicableSymbolsError(this.syms.errSymbol);
        this.methodNotFound = new SymbolNotFoundError(71);
        this.typeNotFound = new SymbolNotFoundError(72);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.infer = Infer.instance(context);
        this.reader = ClassReader.instance(context);
        this.treeinfo = TreeInfo.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Source source = Source.instance(context);
        this.boxingEnabled = source.allowBoxing();
        this.varargsEnabled = source.allowVarargs();
        Options options = Options.instance(context);
        this.debugResolve = options.isSet("debugresolve");
        Target target = Target.instance(context);
        this.allowMethodHandles = target.hasMethodHandles();
        this.polymorphicSignatureScope = new Scope(this.syms.noSymbol);
        this.inapplicableMethodException = new InapplicableMethodException(this.diags);
        this.ideMode = options.get("ide") != null;
    }

    public static boolean isStatic(Env<AttrContext> env) {
        return ((AttrContext)env.info).staticLevel > ((AttrContext)env.outer.info).staticLevel;
    }

    static boolean isInitializer(Env<AttrContext> env) {
        Symbol owner = ((AttrContext)env.info).scope.owner;
        return owner.isConstructor() || owner.owner.kind == 2 && (owner.kind == 4 || owner.kind == 16 && (owner.flags() & 0x100000L) != 0L) && (owner.flags() & 8L) == 0L;
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol c) {
        return this.isAccessible(env, c, false);
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol c, boolean checkInner) {
        boolean isAccessible = false;
        if (c == null) {
            return isAccessible;
        }
        switch ((short)(c.flags() & 7L)) {
            case 2: {
                isAccessible = env.enclClass.sym.outermostClass() == c.owner.outermostClass();
                break;
            }
            case 0: {
                isAccessible = env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || env.enclMethod != null && (env.enclMethod.mods.flags & 0x20000000L) != 0L;
                break;
            }
            default: {
                isAccessible = true;
                break;
            }
            case 4: {
                boolean bl = isAccessible = env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || this.isInnerSubClass(env.enclClass.sym, c.owner);
            }
        }
        return !checkInner || c.type.isErroneous() || c.type.getEnclosingType() == Type.noType ? isAccessible : isAccessible && this.isAccessible(env, c.type.getEnclosingType(), checkInner);
    }

    private boolean isInnerSubClass(Symbol.ClassSymbol c, Symbol base) {
        while (c != null && !c.isSubClass(base, this.types)) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    boolean isAccessible(Env<AttrContext> env, Type t) {
        return this.isAccessible(env, t, false);
    }

    boolean isAccessible(Env<AttrContext> env, Type t, boolean checkInner) {
        return t.tag == 11 ? this.isAccessible(env, this.types.elemtype(t)) : this.isAccessible(env, t.tsym, checkInner);
    }

    public boolean isAccessible(Env<AttrContext> env, Type site, Symbol sym) {
        return this.isAccessible(env, site, sym, false);
    }

    public boolean isAccessible(Env<AttrContext> env, Type site, Symbol sym, boolean checkInner) {
        if (sym.name == this.names.init && sym.owner != site.tsym) {
            return false;
        }
        switch ((short)(sym.flags() & 7L)) {
            case 2: {
                return (env.enclClass.sym == sym.owner || env.enclClass.sym.outermostClass() == sym.owner.outermostClass()) && sym.isInheritedIn(site.tsym, this.types);
            }
            case 0: {
                return (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge()) && this.isAccessible(env, site, checkInner) && sym.isInheritedIn(site.tsym, this.types) && this.notOverriddenIn(site, sym);
            }
            case 4: {
                return (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge() || this.isProtectedAccessible(sym, env.enclClass.sym, site) || ((AttrContext)env.info).selectSuper && (sym.flags() & 8L) == 0L && sym.kind != 2) && this.isAccessible(env, site, checkInner) && this.notOverriddenIn(site, sym);
            }
        }
        return this.isAccessible(env, site, checkInner) && this.notOverriddenIn(site, sym);
    }

    private boolean notOverriddenIn(Type site, Symbol sym) {
        if (sym.kind != 16 || sym.isConstructor() || sym.isStatic()) {
            return true;
        }
        Symbol.MethodSymbol s2 = ((Symbol.MethodSymbol)sym).implementation(site.tsym, this.types, true);
        return s2 == null || s2 == sym || sym.owner == s2.owner || s2.isPolymorphicSignatureGeneric() || !this.types.isSubSignature(this.types.memberType(site, s2), this.types.memberType(site, sym));
    }

    private boolean isProtectedAccessible(Symbol sym, Symbol.ClassSymbol c, Type site) {
        while (c != null && (!c.isSubClass(sym.owner, this.types) || (c.flags() & 0x200L) != 0L || (sym.flags() & 8L) == 0L && sym.kind != 2 && !site.tsym.isSubClass(c, this.types))) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    Type rawInstantiate(Env<AttrContext> env, Type site, Symbol m, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) throws Infer.InferenceException {
        boolean polymorphicSignature;
        boolean bl = polymorphicSignature = m.isPolymorphicSignatureGeneric() && this.allowMethodHandles;
        if (useVarargs && (m.flags() & 0x400000000L) == 0L) {
            throw this.inapplicableMethodException.setMessage();
        }
        Type mt = this.types.memberType(site, m);
        List<Type> tvars = null;
        if (((AttrContext)env.info).tvars != null) {
            tvars = this.types.newInstances(((AttrContext)env.info).tvars);
            mt = this.types.subst(mt, ((AttrContext)env.info).tvars, tvars);
        }
        if (typeargtypes == null) {
            typeargtypes = List.nil();
        }
        if (mt.tag == 16 || !typeargtypes.nonEmpty()) {
            Type.ForAll pmt;
            if (mt.tag == 16 && typeargtypes.nonEmpty()) {
                pmt = (Type.ForAll)mt;
                if (typeargtypes.length() != pmt.tvars.length()) {
                    throw this.inapplicableMethodException.setMessage("arg.length.mismatch");
                }
                List<Type> formals = pmt.tvars;
                List<Type> actuals = typeargtypes;
                while (formals.nonEmpty() && actuals.nonEmpty()) {
                    List<Type> bounds = this.types.subst(this.types.getBounds((Type.TypeVar)formals.head), pmt.tvars, typeargtypes);
                    while (bounds.nonEmpty()) {
                        if (!this.types.isSubtypeUnchecked((Type)actuals.head, (Type)bounds.head, warn)) {
                            throw this.inapplicableMethodException.setMessage("explicit.param.do.not.conform.to.bounds", actuals.head, bounds);
                        }
                        bounds = bounds.tail;
                    }
                    formals = formals.tail;
                    actuals = actuals.tail;
                }
                mt = this.types.subst(pmt.qtype, pmt.tvars, typeargtypes);
            } else if (mt.tag == 16) {
                pmt = (Type.ForAll)mt;
                List<Type> tvars1 = this.types.newInstances(pmt.tvars);
                tvars = tvars.appendList(tvars1);
                mt = this.types.subst(pmt.qtype, pmt.tvars, tvars1);
            }
        }
        boolean instNeeded = tvars.tail != null || polymorphicSignature;
        List<Type> l = argtypes;
        while (l.tail != null && !instNeeded) {
            if (((Type)l.head).tag == 16) {
                instNeeded = true;
            }
            l = l.tail;
        }
        if (instNeeded) {
            return polymorphicSignature ? this.infer.instantiatePolymorphicSignatureInstance(env, site, m.name, (Symbol.MethodSymbol)m, argtypes) : this.infer.instantiateMethod(env, tvars, (Type.MethodType)mt, m, argtypes, allowBoxing, useVarargs, warn);
        }
        this.checkRawArgumentsAcceptable(env, argtypes, mt.getParameterTypes(), allowBoxing, useVarargs, warn);
        return mt;
    }

    Type instantiate(Env<AttrContext> env, Type site, Symbol m, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) {
        try {
            return this.rawInstantiate(env, site, m, argtypes, typeargtypes, allowBoxing, useVarargs, warn);
        }
        catch (InapplicableMethodException ex) {
            return null;
        }
    }

    boolean argumentsAcceptable(Env<AttrContext> env, List<Type> argtypes, List<Type> formals, boolean allowBoxing, boolean useVarargs, Warner warn) {
        try {
            this.checkRawArgumentsAcceptable(env, argtypes, formals, allowBoxing, useVarargs, warn);
            return true;
        }
        catch (InapplicableMethodException ex) {
            return false;
        }
    }

    void checkRawArgumentsAcceptable(Env<AttrContext> env, List<Type> argtypes, List<Type> formals, boolean allowBoxing, boolean useVarargs, Warner warn) {
        Type varargsFormal;
        Type type = varargsFormal = useVarargs ? formals.last() : null;
        if (varargsFormal == null && argtypes.size() != formals.size()) {
            throw this.inapplicableMethodException.setMessage("arg.length.mismatch");
        }
        while (argtypes.nonEmpty() && formals.nonEmpty() && formals.head != varargsFormal) {
            boolean works;
            boolean bl = works = allowBoxing ? this.types.isConvertible((Type)argtypes.head, (Type)formals.head, warn) : this.types.isSubtypeUnchecked((Type)argtypes.head, (Type)formals.head, warn);
            if (!works) {
                throw this.inapplicableMethodException.setMessage("no.conforming.assignment.exists", argtypes.head, formals.head);
            }
            argtypes = argtypes.tail;
            formals = formals.tail;
        }
        if (formals.head != varargsFormal) {
            throw this.inapplicableMethodException.setMessage("arg.length.mismatch");
        }
        if (useVarargs) {
            Type elt = this.types.elemtype(varargsFormal);
            while (argtypes.nonEmpty()) {
                if (!this.types.isConvertible((Type)argtypes.head, elt, warn)) {
                    throw this.inapplicableMethodException.setMessage("varargs.argument.mismatch", argtypes.head, elt);
                }
                argtypes = argtypes.tail;
            }
            if (!this.isAccessible(env, elt)) {
                Symbol.ClassSymbol location = env.enclClass.sym;
                throw this.inapplicableMethodException.setMessage("inaccessible.varargs.type", elt, Kinds.kindName(location), location);
            }
        }
    }

    Symbol findField(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        while (c.type.tag == 14) {
            c = c.type.getUpperBound().tsym;
        }
        Symbol bestSoFar = this.varNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 4 && (e.sym.flags_field & 0x1000L) == 0L) {
                return this.isAccessible(env, site, e.sym) ? e.sym : new AccessError(env, site, e.sym);
            }
            e = e.next();
        }
        Type st = this.types.supertype(c.type);
        if (st != null && (st.tag == 10 || st.tag == 14)) {
            sym = this.findField(env, site, name, st.tsym);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != 65 && l.nonEmpty()) {
            sym = this.findField(env, site, name, ((Type)l.head).tsym);
            if (bestSoFar.kind < 65 && sym.kind < 65 && sym.owner != bestSoFar.owner) {
                bestSoFar = new AmbiguityError(bestSoFar, sym);
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            l = l.tail;
        }
        return bestSoFar;
    }

    public Symbol.VarSymbol resolveInternalField(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name) {
        Symbol sym = this.findField(env, site, name, site.tsym);
        if (sym.kind == 4) {
            return (Symbol.VarSymbol)sym;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.field", name));
    }

    Symbol findVar(Env<AttrContext> env, Name name) {
        AnnotatedConstruct origin;
        Symbol sym;
        Scope.Entry e;
        Symbol bestSoFar = this.varNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            e = ((AttrContext)env1.info).scope.lookup(name);
            while (e.scope != null && (e.sym.kind != 4 || (e.sym.flags_field & 0x1000L) != 0L)) {
                e = e.next();
            }
            Symbol symbol = sym = e.scope != null ? e.sym : this.findField(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            if (sym.exists()) {
                if (staticOnly && sym.kind == 4 && sym.owner.kind == 2 && (sym.flags() & 8L) == 0L) {
                    return new StaticError(sym);
                }
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym = this.findField(env, this.syms.predefClass.type, name, this.syms.predefClass);
        if (sym.exists()) {
            return sym;
        }
        if (bestSoFar.exists()) {
            return bestSoFar;
        }
        e = env.toplevel.namedImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            origin = e.getOrigin().owner.type;
            if (sym.kind == 4) {
                if (e.sym.owner.type != origin) {
                    sym = sym.clone(e.getOrigin().owner);
                }
                return this.isAccessible(env, (Type)origin, sym) ? sym : new AccessError(env, (Type)origin, sym);
            }
            e = e.next();
        }
        origin = null;
        e = env.toplevel.starImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            if (sym.kind == 4) {
                if (bestSoFar.kind < 65 && sym.owner != bestSoFar.owner) {
                    return new AmbiguityError(bestSoFar, sym);
                }
                if (bestSoFar.kind >= 4) {
                    origin = e.getOrigin().owner;
                    bestSoFar = this.isAccessible(env, ((Symbol)origin).type, sym) ? sym : new AccessError(env, ((Symbol)origin).type, sym);
                }
            }
            e = e.next();
        }
        if (bestSoFar.kind == 4 && bestSoFar.owner.type != ((Symbol)origin).type) {
            return bestSoFar.clone((Symbol)origin);
        }
        return bestSoFar;
    }

    Symbol selectBest(Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, Symbol sym, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean operator) {
        if (sym.kind == 31) {
            return bestSoFar;
        }
        if (!sym.isInheritedIn(site.tsym, this.types)) {
            return bestSoFar;
        }
        Assert.check(sym.kind < 65);
        try {
            this.rawInstantiate(env, site, sym, argtypes, typeargtypes, allowBoxing, useVarargs, Warner.noWarnings);
        }
        catch (InapplicableMethodException ex) {
            switch (bestSoFar.kind) {
                case 71: {
                    return this.wrongMethod.setWrongSym(sym, ex.getDiagnostic());
                }
                case 70: {
                    this.wrongMethods.addCandidate(this.currentStep, this.wrongMethod.sym, this.wrongMethod.explanation);
                }
                case 69: {
                    return this.wrongMethods.addCandidate(this.currentStep, sym, ex.getDiagnostic());
                }
            }
            return bestSoFar;
        }
        if (!this.isAccessible(env, site, sym)) {
            return bestSoFar.kind == 71 ? new AccessError(env, site, sym) : bestSoFar;
        }
        return bestSoFar.kind > 65 ? sym : this.mostSpecific(sym, bestSoFar, env, site, allowBoxing && operator, useVarargs);
    }

    Symbol mostSpecific(Symbol m1, Symbol m2, Env<AttrContext> env, final Type site, boolean allowBoxing, boolean useVarargs) {
        switch (m2.kind) {
            case 16: {
                if (m1 == m2) {
                    return m1;
                }
                boolean m1SignatureMoreSpecific = this.signatureMoreSpecific(env, site, m1, m2, allowBoxing, useVarargs);
                boolean m2SignatureMoreSpecific = this.signatureMoreSpecific(env, site, m2, m1, allowBoxing, useVarargs);
                if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
                    Symbol mostSpecific;
                    boolean m2Abstract;
                    Type mt2;
                    Type mt1 = this.types.memberType(site, m1);
                    if (!this.types.overrideEquivalent(mt1, mt2 = this.types.memberType(site, m2))) {
                        return this.ambiguityError(m1, m2);
                    }
                    if ((m1.flags() & 0x80000000L) != (m2.flags() & 0x80000000L)) {
                        return (m1.flags() & 0x80000000L) != 0L ? m2 : m1;
                    }
                    Symbol.TypeSymbol m1Owner = (Symbol.TypeSymbol)m1.owner;
                    Symbol.TypeSymbol m2Owner = (Symbol.TypeSymbol)m2.owner;
                    if (this.types.asSuper(m1Owner.type, m2Owner) != null && ((m1.owner.flags_field & 0x200L) == 0L || (m2.owner.flags_field & 0x200L) != 0L) && m1.overrides(m2, m1Owner, this.types, false)) {
                        return m1;
                    }
                    if (this.types.asSuper(m2Owner.type, m1Owner) != null && ((m2.owner.flags_field & 0x200L) == 0L || (m1.owner.flags_field & 0x200L) != 0L) && m2.overrides(m1, m2Owner, this.types, false)) {
                        return m2;
                    }
                    boolean m1Abstract = (m1.flags() & 0x400L) != 0L;
                    boolean bl = m2Abstract = (m2.flags() & 0x400L) != 0L;
                    if (m1Abstract && !m2Abstract) {
                        return m2;
                    }
                    if (m2Abstract && !m1Abstract) {
                        return m1;
                    }
                    if (!m1Abstract && !m2Abstract) {
                        return this.ambiguityError(m1, m2);
                    }
                    if (!this.types.isSameTypes(m1.erasure(this.types).getParameterTypes(), m2.erasure(this.types).getParameterTypes())) {
                        return this.ambiguityError(m1, m2);
                    }
                    if (this.types.returnTypeSubstitutable(mt1, mt2)) {
                        mostSpecific = m1;
                    } else if (this.types.returnTypeSubstitutable(mt2, mt1)) {
                        mostSpecific = m2;
                    } else {
                        return this.ambiguityError(m1, m2);
                    }
                    List<Type> allThrown = this.chk.intersect(mt1.getThrownTypes(), mt2.getThrownTypes());
                    Type newSig = this.types.createMethodTypeWithThrown(mostSpecific.type, allThrown);
                    Symbol.MethodSymbol result = new Symbol.MethodSymbol(mostSpecific.flags(), mostSpecific.name, newSig, mostSpecific.owner){

                        public Symbol.MethodSymbol implementation(Symbol.TypeSymbol origin, Types types, boolean checkResult) {
                            if (origin == site.tsym) {
                                return this;
                            }
                            return super.implementation(origin, types, checkResult);
                        }
                    };
                    return result;
                }
                if (m1SignatureMoreSpecific) {
                    return m1;
                }
                if (m2SignatureMoreSpecific) {
                    return m2;
                }
                return this.ambiguityError(m1, m2);
            }
            case 65: {
                AmbiguityError e = (AmbiguityError)m2;
                Symbol err1 = this.mostSpecific(m1, e.sym, env, site, allowBoxing, useVarargs);
                Symbol err2 = this.mostSpecific(m1, e.sym2, env, site, allowBoxing, useVarargs);
                if (err1 == err2) {
                    return err1;
                }
                if (err1 == e.sym && err2 == e.sym2) {
                    return m2;
                }
                if (err1 instanceof AmbiguityError && err2 instanceof AmbiguityError && ((AmbiguityError)err1).sym == ((AmbiguityError)err2).sym) {
                    return this.ambiguityError(m1, m2);
                }
                return this.ambiguityError(err1, err2);
            }
        }
        throw new AssertionError();
    }

    private boolean signatureMoreSpecific(Env<AttrContext> env, Type site, Symbol m1, Symbol m2, boolean allowBoxing, boolean useVarargs) {
        this.noteWarner.clear();
        Type mtype1 = this.types.memberType(site, this.adjustVarargs(m1, m2, useVarargs));
        Type mtype2 = this.instantiate(env, site, this.adjustVarargs(m2, m1, useVarargs), this.types.lowerBoundArgtypes(mtype1), null, allowBoxing, false, this.noteWarner);
        return mtype2 != null && !this.noteWarner.hasLint(Lint.LintCategory.UNCHECKED);
    }

    private Symbol adjustVarargs(Symbol to, Symbol from, boolean useVarargs) {
        List<Type> fromArgs = from.type.getParameterTypes();
        List<Type> toArgs = to.type.getParameterTypes();
        if (useVarargs && (from.flags() & 0x400000000L) != 0L && (to.flags() & 0x400000000L) != 0L) {
            Type varargsTypeFrom = fromArgs.last();
            Type varargsTypeTo = toArgs.last();
            ListBuffer args = ListBuffer.lb();
            if (toArgs.length() < fromArgs.length()) {
                while (fromArgs.head != varargsTypeFrom) {
                    args.append(toArgs.head == varargsTypeTo ? this.types.elemtype(varargsTypeTo) : (Type)toArgs.head);
                    fromArgs = fromArgs.tail;
                    toArgs = toArgs.head == varargsTypeTo ? toArgs : toArgs.tail;
                }
            } else {
                args.appendList(toArgs.reverse().tail.reverse());
            }
            args.append(this.types.elemtype(varargsTypeTo));
            Type mtype = this.types.createMethodTypeWithParameters(to.type, args.toList());
            return new Symbol.MethodSymbol(to.flags_field & 0xFFFFFFFBFFFFFFFFL, to.name, mtype, to.owner);
        }
        return to;
    }

    Symbol ambiguityError(Symbol m1, Symbol m2) {
        if (((m1.flags() | m2.flags()) & 0x80000000000L) != 0L) {
            return (m1.flags() & 0x80000000000L) == 0L ? m1 : m2;
        }
        return new AmbiguityError(m1, m2);
    }

    Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, boolean operator) {
        SymbolNotFoundError bestSoFar = this.methodNotFound;
        return this.findMethod(env, site, name, argtypes, typeargtypes, site.tsym.type, true, bestSoFar, allowBoxing, useVarargs, operator, new HashSet<Symbol.TypeSymbol>());
    }

    private Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, Type intype, boolean abstractok, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean operator, Set<Symbol.TypeSymbol> seen) {
        Type ct = intype;
        while (ct.tag == 10 || ct.tag == 14) {
            while (ct.tag == 14) {
                ct = ct.getUpperBound();
            }
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)ct.tsym;
            if (!seen.add(c)) {
                return bestSoFar;
            }
            if ((c.flags() & 0x4600L) == 0L) {
                abstractok = false;
            }
            Scope.Entry e = c.members().lookup(name);
            while (e.scope != null) {
                if (e.sym.kind == 16 && (e.sym.flags_field & 0x1000L) == 0L) {
                    bestSoFar = this.selectBest(env, site, argtypes, typeargtypes, e.sym, bestSoFar, allowBoxing, useVarargs, operator);
                }
                e = e.next();
            }
            if (name == this.names.init) break;
            if (abstractok) {
                Symbol concrete = this.methodNotFound;
                if ((bestSoFar.flags() & 0x400L) == 0L) {
                    concrete = bestSoFar;
                }
                List<Type> l = this.types.interfaces(c.type);
                while (l.nonEmpty()) {
                    bestSoFar = this.findMethod(env, site, name, argtypes, typeargtypes, (Type)l.head, abstractok, bestSoFar, allowBoxing, useVarargs, operator, seen);
                    l = l.tail;
                }
                if (concrete != bestSoFar && concrete.kind < 31 && bestSoFar.kind < 31 && this.types.isSubSignature(concrete.type, bestSoFar.type)) {
                    bestSoFar = concrete;
                }
            }
            ct = this.types.supertype(ct);
        }
        return bestSoFar;
    }

    Symbol findFun(Env<AttrContext> env, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Type origin;
        Symbol sym;
        Symbol bestSoFar = this.methodNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if ((sym = this.findMethod(env1, env1.enclClass.sym.type, name, argtypes, typeargtypes, allowBoxing, useVarargs, false)).exists()) {
                if (staticOnly && sym.kind == 16 && sym.owner.kind == 2 && (sym.flags() & 8L) == 0L) {
                    return new StaticError(sym);
                }
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, typeargtypes, allowBoxing, useVarargs, false);
        if (sym.exists()) {
            return sym;
        }
        Scope.Entry e = env.toplevel.namedImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            origin = e.getOrigin().owner.type;
            if (sym.kind == 16) {
                if (e.sym.owner.type != origin) {
                    sym = sym.clone(e.getOrigin().owner);
                }
                if (!this.isAccessible(env, origin, sym)) {
                    sym = new AccessError(env, origin, sym);
                }
                bestSoFar = this.selectBest(env, origin, argtypes, typeargtypes, sym, bestSoFar, allowBoxing, useVarargs, false);
            }
            e = e.next();
        }
        if (bestSoFar.exists()) {
            return bestSoFar;
        }
        e = env.toplevel.starImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            origin = e.getOrigin().owner.type;
            if (sym.kind == 16) {
                if (e.sym.owner.type != origin) {
                    sym = sym.clone(e.getOrigin().owner);
                }
                if (!this.isAccessible(env, origin, sym)) {
                    sym = new AccessError(env, origin, sym);
                }
                bestSoFar = this.selectBest(env, origin, argtypes, typeargtypes, sym, bestSoFar, allowBoxing, useVarargs, false);
            }
            e = e.next();
        }
        return bestSoFar;
    }

    Symbol loadClass(Env<AttrContext> env, Name name) {
        try {
            Symbol.ClassSymbol c = this.reader.loadClass(name);
            return this.isAccessible(env, c) ? c : new AccessError(c);
        }
        catch (ClassReader.BadClassFile err) {
            if (this.ideMode) {
                return this.typeNotFound;
            }
            throw err;
        }
        catch (Symbol.CompletionFailure ex) {
            return this.typeNotFound;
        }
    }

    Symbol findMemberType(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 2) {
                return this.isAccessible(env, site, e.sym) ? e.sym : new AccessError(env, site, e.sym);
            }
            e = e.next();
        }
        Type st = this.types.supertype(c.type);
        if (st != null && st.tag == 10) {
            sym = this.findMemberType(env, site, name, st.tsym);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != 65 && l.nonEmpty()) {
            sym = this.findMemberType(env, site, name, ((Type)l.head).tsym);
            if (bestSoFar.kind < 65 && sym.kind < 65 && sym.owner != bestSoFar.owner) {
                bestSoFar = new AmbiguityError(bestSoFar, sym);
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            l = l.tail;
        }
        return bestSoFar;
    }

    Symbol findGlobalType(Env<AttrContext> env, Scope scope, Name name) {
        Symbol bestSoFar = this.typeNotFound;
        Scope.Entry e = scope.lookup(name);
        while (e.scope != null) {
            Symbol sym = this.loadClass(env, e.sym.flatName());
            if (bestSoFar.kind == 2 && sym.kind == 2 && bestSoFar != sym) {
                return new AmbiguityError(bestSoFar, sym);
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            e = e.next();
        }
        return bestSoFar;
    }

    Symbol findType(Env<AttrContext> env, Name name) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        boolean staticOnly = false;
        Env<AttrContext> env1 = env;
        while (env1.outer != null) {
            JCTree.JCClassDecl encl;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            Scope.Entry e = ((AttrContext)env1.info).scope.lookup(name);
            while (e.scope != null) {
                if (e.sym.kind == 2) {
                    if (staticOnly && e.sym.type.tag == 14 && e.sym.owner.kind == 2) {
                        return new StaticError(e.sym);
                    }
                    return e.sym;
                }
                e = e.next();
            }
            sym = this.findMemberType(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            if (staticOnly && sym.kind == 2 && sym.type.tag == 10 && sym.type.getEnclosingType().tag == 10 && env1.enclClass.sym.type.isParameterized() && sym.type.getEnclosingType().isParameterized()) {
                return new StaticError(sym);
            }
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            JCTree.JCClassDecl jCClassDecl = encl = env1.baseClause ? (JCTree.JCClassDecl)env1.tree : env1.enclClass;
            if ((encl.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        if (env.tree.getTag() != 2) {
            sym = this.findGlobalType(env, env.toplevel.namedImportScope, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((sym = this.findGlobalType(env, env.toplevel.packge.members(), name)).exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((sym = this.findGlobalType(env, env.toplevel.starImportScope, name)).exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return bestSoFar;
    }

    Symbol findIdent(Env<AttrContext> env, Name name, int kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findVar(env, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 2) != 0) {
            sym = this.findType(env, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 1) != 0) {
            return this.reader.enterPackage(name);
        }
        return bestSoFar;
    }

    Symbol findIdentInPackage(Env<AttrContext> env, Symbol.TypeSymbol pck, Name name, int kind) {
        Name fullname = Symbol.TypeSymbol.formFullName(name, pck);
        Symbol bestSoFar = this.typeNotFound;
        Symbol.PackageSymbol pack = null;
        if ((kind & 1) != 0 && (pack = this.reader.enterPackage(fullname)).exists()) {
            return pack;
        }
        if ((kind & 2) != 0) {
            Symbol sym = this.loadClass(env, fullname);
            if (sym.exists()) {
                if (name == sym.name) {
                    return sym;
                }
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return pack != null ? pack : bestSoFar;
    }

    Symbol findIdentInType(Env<AttrContext> env, Type site, Name name, int kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findField(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 2) != 0) {
            sym = this.findMemberType(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return bestSoFar;
    }

    Symbol access(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes) {
        if (sym.kind >= 65) {
            ResolveError errSym = (ResolveError)sym;
            if (!(site.isErroneous() || Type.isErroneous(argtypes) || typeargtypes != null && Type.isErroneous(typeargtypes))) {
                this.logResolveError(errSym, pos, location, site, name, argtypes, typeargtypes);
            }
            sym = errSym.access(name, qualified ? site.tsym : this.syms.noSymbol);
        }
        return sym;
    }

    Symbol access(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes) {
        return this.access(sym, pos, site.tsym, site, name, qualified, argtypes, typeargtypes);
    }

    Symbol access(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, boolean qualified) {
        if (sym.kind >= 65) {
            return this.access(sym, pos, location, site, name, qualified, List.<Type>nil(), null);
        }
        return sym;
    }

    Symbol access(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified) {
        return this.access(sym, pos, site.tsym, site, name, qualified);
    }

    void checkNonAbstract(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if ((sym.flags() & 0x400L) != 0L) {
            this.log.error(pos, "abstract.cant.be.accessed.directly", Kinds.kindName(sym), sym, sym.location());
        }
    }

    public void printscopes(Scope s) {
        while (s != null) {
            if (s.owner != null) {
                System.err.print(s.owner + ": ");
            }
            Scope.Entry e = s.elems;
            while (e != null) {
                if ((e.sym.flags() & 0x400L) != 0L) {
                    System.err.print("abstract ");
                }
                System.err.print(e.sym + " ");
                e = e.sibling;
            }
            System.err.println();
            s = s.next;
        }
    }

    void printscopes(Env<AttrContext> env) {
        while (env.outer != null) {
            System.err.println("------------------------------");
            this.printscopes(((AttrContext)env.info).scope);
            env = env.outer;
        }
    }

    public void printscopes(Type t) {
        while (t.tag == 10) {
            this.printscopes(t.tsym.members());
            t = this.types.supertype(t);
        }
    }

    Symbol resolveIdent(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name, int kind) {
        return this.access(this.findIdent(env, name, kind), pos, env.enclClass.sym.type, name, false);
    }

    Symbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.startResolution();
        List<MethodResolutionPhase> steps = this.methodResolutionSteps;
        while (steps.nonEmpty() && ((MethodResolutionPhase)((Object)steps.head)).isApplicable(this.boxingEnabled, this.varargsEnabled) && sym.kind >= 64) {
            this.currentStep = (MethodResolutionPhase)((Object)steps.head);
            ((AttrContext)env.info).varArgs = ((MethodResolutionPhase)((Object)steps.head)).isVarargsRequired;
            sym = this.findFun(env, name, argtypes, typeargtypes, ((MethodResolutionPhase)((Object)steps.head)).isBoxingRequired, ((AttrContext)env.info).varArgs);
            this.methodResolutionCache.put((MethodResolutionPhase)((Object)steps.head), sym);
            steps = steps.tail;
        }
        if (sym.kind >= 65) {
            MethodResolutionPhase errPhase = this.firstErroneousResolutionPhase();
            sym = this.access(this.methodResolutionCache.get((Object)errPhase), pos, env.enclClass.sym.type, name, false, argtypes, typeargtypes);
            ((AttrContext)env.info).varArgs = errPhase.isVarargsRequired;
        }
        return sym;
    }

    private Symbol startResolution() {
        this.wrongMethod.clear();
        this.wrongMethods.clear();
        return this.methodNotFound;
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.resolveQualifiedMethod(pos, env, site.tsym, site, name, argtypes, typeargtypes);
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.startResolution();
        List<MethodResolutionPhase> steps = this.methodResolutionSteps;
        while (steps.nonEmpty() && ((MethodResolutionPhase)((Object)steps.head)).isApplicable(this.boxingEnabled, this.varargsEnabled) && sym.kind >= 64) {
            this.currentStep = (MethodResolutionPhase)((Object)steps.head);
            ((AttrContext)env.info).varArgs = ((MethodResolutionPhase)((Object)steps.head)).isVarargsRequired();
            sym = this.findMethod(env, site, name, argtypes, typeargtypes, ((MethodResolutionPhase)((Object)steps.head)).isBoxingRequired(), ((AttrContext)env.info).varArgs, false);
            this.methodResolutionCache.put((MethodResolutionPhase)((Object)steps.head), sym);
            steps = steps.tail;
        }
        if (sym.kind >= 65) {
            if (site.tsym.isPolymorphicSignatureGeneric()) {
                ((AttrContext)env.info).varArgs = false;
                sym = this.findPolymorphicSignatureInstance(env, site, name, null, argtypes);
            } else {
                MethodResolutionPhase errPhase = this.firstErroneousResolutionPhase();
                sym = this.access(this.methodResolutionCache.get((Object)errPhase), pos, location, site, name, true, argtypes, typeargtypes);
                ((AttrContext)env.info).varArgs = errPhase.isVarargsRequired;
            }
        } else if (this.allowMethodHandles && sym.isPolymorphicSignatureGeneric()) {
            ((AttrContext)env.info).varArgs = false;
            sym = this.findPolymorphicSignatureInstance(env, site, name, (Symbol.MethodSymbol)sym, argtypes);
        }
        return sym;
    }

    Symbol findPolymorphicSignatureInstance(Env<AttrContext> env, Type site, Name name, Symbol.MethodSymbol spMethod, List<Type> argtypes) {
        Type mtype = this.infer.instantiatePolymorphicSignatureInstance(env, site, name, spMethod, argtypes);
        long flags = 0x12000000400L | (spMethod != null ? spMethod.flags() & 7L : 9L);
        Symbol m = null;
        Scope.Entry e = this.polymorphicSignatureScope.lookup(name);
        while (e.scope != null) {
            Symbol sym = e.sym;
            if (this.types.isSameType(mtype, sym.type) && (sym.flags() & 8L) == (flags & 8L) && this.types.isSameType(sym.owner.type, site)) {
                m = sym;
                break;
            }
            e = e.next();
        }
        if (m == null) {
            m = new Symbol.MethodSymbol(flags, name, mtype, site.tsym);
            this.polymorphicSignatureScope.enter(m);
        }
        return m;
    }

    public Symbol.MethodSymbol resolveInternalMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.resolveQualifiedMethod(pos, env, site.tsym, site, name, argtypes, typeargtypes);
        if (sym.kind == 16) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.meth", name));
    }

    Symbol resolveConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.startResolution();
        List<MethodResolutionPhase> steps = this.methodResolutionSteps;
        while (steps.nonEmpty() && ((MethodResolutionPhase)((Object)steps.head)).isApplicable(this.boxingEnabled, this.varargsEnabled) && sym.kind >= 64) {
            this.currentStep = (MethodResolutionPhase)((Object)steps.head);
            ((AttrContext)env.info).varArgs = ((MethodResolutionPhase)((Object)steps.head)).isVarargsRequired();
            sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes, ((MethodResolutionPhase)((Object)steps.head)).isBoxingRequired(), ((AttrContext)env.info).varArgs);
            this.methodResolutionCache.put((MethodResolutionPhase)((Object)steps.head), sym);
            steps = steps.tail;
        }
        if (sym.kind >= 65) {
            MethodResolutionPhase errPhase = this.firstErroneousResolutionPhase();
            sym = this.access(this.methodResolutionCache.get((Object)errPhase), pos, site, this.names.init, true, argtypes, typeargtypes);
            ((AttrContext)env.info).varArgs = errPhase.isVarargsRequired();
        }
        return sym;
    }

    Symbol resolveDiamond(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.startResolution();
        List<MethodResolutionPhase> steps = this.methodResolutionSteps;
        while (steps.nonEmpty() && ((MethodResolutionPhase)((Object)steps.head)).isApplicable(this.boxingEnabled, this.varargsEnabled) && sym.kind >= 64) {
            this.currentStep = (MethodResolutionPhase)((Object)steps.head);
            ((AttrContext)env.info).varArgs = ((MethodResolutionPhase)((Object)steps.head)).isVarargsRequired();
            sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes, ((MethodResolutionPhase)((Object)steps.head)).isBoxingRequired(), ((AttrContext)env.info).varArgs);
            this.methodResolutionCache.put((MethodResolutionPhase)((Object)steps.head), sym);
            steps = steps.tail;
        }
        if (sym.kind >= 65) {
            final JCDiagnostic details = sym.kind == 70 ? ((InapplicableSymbolError)sym).explanation : null;
            ResolveError errSym = new ResolveError(70, "diamond error"){

                @Override
                JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
                    String key = details == null ? "cant.apply.diamond" : "cant.apply.diamond.1";
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, key, Resolve.this.diags.fragment("diamond", site.tsym), details);
                }
            };
            MethodResolutionPhase errPhase = this.firstErroneousResolutionPhase();
            sym = this.access(errSym, pos, site, this.names.init, true, argtypes, typeargtypes);
            ((AttrContext)env.info).varArgs = errPhase.isVarargsRequired();
        }
        return sym;
    }

    Symbol resolveConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol sym = this.findMethod(env, site, this.names.init, argtypes, typeargtypes, allowBoxing, useVarargs, false);
        this.chk.checkDeprecated(pos, ((AttrContext)env.info).scope.owner, sym);
        return sym;
    }

    public Symbol.MethodSymbol resolveInternalConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes);
        if (sym.kind == 16) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.ctor", site));
    }

    Symbol resolveOperator(JCDiagnostic.DiagnosticPosition pos, int optag, Env<AttrContext> env, List<Type> argtypes) {
        Name name = this.treeinfo.operatorName(optag);
        Symbol sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, null, false, false, true);
        if (this.boxingEnabled && sym.kind >= 69) {
            sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, null, true, false, true);
        }
        return this.access(sym, pos, env.enclClass.sym.type, name, false, argtypes, null);
    }

    Symbol resolveUnaryOperator(JCDiagnostic.DiagnosticPosition pos, int optag, Env<AttrContext> env, Type arg) {
        return this.resolveOperator(pos, optag, env, List.of(arg));
    }

    Symbol resolveBinaryOperator(JCDiagnostic.DiagnosticPosition pos, int optag, Env<AttrContext> env, Type left, Type right) {
        return this.resolveOperator(pos, optag, env, List.of(left, right));
    }

    Symbol resolveSelf(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol.TypeSymbol c, Name name) {
        Symbol sym;
        boolean staticInnerDecl = false;
        if (!(env.tree.getTag() != 5 || (TreeInfo.flags(env.tree) & 0x208L) == 0L || (sym = ((JCTree.JCVariableDecl)env.tree).sym) != null && sym.kind == 4 && ((Symbol.VarSymbol)sym).getConstValue() != null || (sym = env.enclClass.sym) == null || sym.owner.kind == 1 || (sym.flags() & 8L) != 0L && sym.name != this.names.empty)) {
            staticInnerDecl = true;
        }
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol sym2;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclClass.sym == c && (sym2 = ((AttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                if (staticOnly && !staticInnerDecl) {
                    sym2 = new StaticError(sym2);
                }
                return this.access(sym2, pos, env.enclClass.sym.type, name, true);
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        this.log.error(pos, "not.encl.class", c);
        return this.syms.errSymbol;
    }

    Symbol resolveSelfContaining(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol member, boolean isSuperCall) {
        Name name = this.names._this;
        Env<AttrContext> env1 = isSuperCall ? env.outer : env;
        boolean staticOnly = false;
        if (env1 != null) {
            while (env1 != null && env1.outer != null) {
                Symbol sym;
                if (Resolve.isStatic(env1)) {
                    staticOnly = true;
                }
                if (env1.enclClass.sym.isSubClass(member.owner, this.types) && (sym = ((AttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                    if (staticOnly) {
                        sym = new StaticError(sym);
                    }
                    return this.access(sym, pos, env.enclClass.sym.type, name, true);
                }
                if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                    staticOnly = true;
                }
                env1 = env1.outer;
            }
        }
        this.log.error(pos, "encl.class.required", member);
        return this.syms.errSymbol;
    }

    Type resolveImplicitThis(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type t) {
        return this.resolveImplicitThis(pos, env, t, false);
    }

    Type resolveImplicitThis(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type t, boolean isSuperCall) {
        Type thisType = ((t.tsym.owner.kind & 0x14) != 0 ? this.resolveSelf((JCDiagnostic.DiagnosticPosition)pos, env, (Symbol.TypeSymbol)t.getEnclosingType().tsym, (Name)this.names._this) : this.resolveSelfContaining((JCDiagnostic.DiagnosticPosition)pos, env, (Symbol)t.tsym, (boolean)isSuperCall)).type;
        if (((AttrContext)env.info).isSelfCall && thisType.tsym == env.enclClass.sym) {
            this.log.error(pos, "cant.ref.before.ctor.called", "this");
        }
        return thisType;
    }

    public void logAccessError(Env<AttrContext> env, JCTree tree, Type type) {
        AccessError error = new AccessError(env, type.getEnclosingType(), type.tsym);
        this.logResolveError(error, tree.pos(), type.getEnclosingType().tsym, type.getEnclosingType(), null, null, null);
    }

    private void logResolveError(ResolveError error, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        JCDiagnostic d = error.getDiagnostic(JCDiagnostic.DiagnosticType.ERROR, pos, location, site, name, argtypes, typeargtypes);
        if (d != null) {
            d.setFlag(JCDiagnostic.DiagnosticFlag.RESOLVE_ERROR);
            this.log.report(d);
        }
    }

    public Object methodArguments(List<Type> argtypes) {
        return argtypes.isEmpty() ? this.noArgs : argtypes;
    }

    private MethodResolutionPhase firstErroneousResolutionPhase() {
        MethodResolutionPhase bestSoFar = MethodResolutionPhase.BASIC;
        Symbol sym = this.methodNotFound;
        List<MethodResolutionPhase> steps = this.methodResolutionSteps;
        while (steps.nonEmpty() && ((MethodResolutionPhase)((Object)steps.head)).isApplicable(this.boxingEnabled, this.varargsEnabled) && sym.kind >= 69) {
            sym = this.methodResolutionCache.get(steps.head);
            bestSoFar = (MethodResolutionPhase)((Object)steps.head);
            steps = steps.tail;
        }
        return bestSoFar;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MethodResolutionPhase {
        BASIC(false, false),
        BOX(true, false),
        VARARITY(true, true);

        boolean isBoxingRequired;
        boolean isVarargsRequired;

        private MethodResolutionPhase(boolean isBoxingRequired, boolean isVarargsRequired) {
            this.isBoxingRequired = isBoxingRequired;
            this.isVarargsRequired = isVarargsRequired;
        }

        public boolean isBoxingRequired() {
            return this.isBoxingRequired;
        }

        public boolean isVarargsRequired() {
            return this.isVarargsRequired;
        }

        public boolean isApplicable(boolean boxingEnabled, boolean varargsEnabled) {
            return !(!varargsEnabled && this.isVarargsRequired || !boxingEnabled && this.isBoxingRequired);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AmbiguityError
    extends InvalidSymbolError {
        Symbol sym2;

        AmbiguityError(Symbol sym1, Symbol sym2) {
            super(65, sym1, "ambiguity error");
            this.sym2 = sym2;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            AmbiguityError pair = this;
            while (true) {
                if (pair.sym.kind == 65) {
                    pair = (AmbiguityError)pair.sym;
                    continue;
                }
                if (pair.sym2.kind != 65) break;
                pair = (AmbiguityError)pair.sym2;
            }
            Name sname = pair.sym.name;
            if (sname == Resolve.this.names.init) {
                sname = pair.sym.owner.name;
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "ref.ambiguous", sname, Kinds.kindName(pair.sym), pair.sym, pair.sym.location(site, Resolve.this.types), Kinds.kindName(pair.sym2), pair.sym2, pair.sym2.location(site, Resolve.this.types));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StaticError
    extends InvalidSymbolError {
        StaticError(Symbol sym) {
            super(67, sym, "static error");
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            Symbol errSym = this.sym.kind == 2 && this.sym.type.tag == 10 ? Resolve.this.types.erasure((Type)this.sym.type).tsym : this.sym;
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "non-static.cant.be.ref", Kinds.kindName(this.sym), errSym);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AccessError
    extends InvalidSymbolError {
        private Env<AttrContext> env;
        private Type site;

        AccessError(Symbol sym) {
            this(null, null, sym);
        }

        AccessError(Env<AttrContext> env, Type site, Symbol sym) {
            super(66, sym, "access error");
            this.env = env;
            this.site = site;
            if (Resolve.this.debugResolve) {
                Resolve.this.log.error("proc.messager", sym + " @ " + site + " is inaccessible.");
            }
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (this.sym.owner.type.tag == 19) {
                return null;
            }
            if (this.sym.name == Resolve.this.names.init && this.sym.owner != site.tsym) {
                return new SymbolNotFoundError(71).getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
            }
            if ((this.sym.flags() & 1L) != 0L || this.env != null && this.site != null && !Resolve.this.isAccessible(this.env, this.site)) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.access.class.intf.cant.access", this.sym, this.sym.location());
            }
            if ((this.sym.flags() & 6L) != 0L) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "report.access", this.sym, Flags.asFlagSet(this.sym.flags() & 6L), this.sym.location());
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.public.cant.access", this.sym, this.sym.location());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InapplicableSymbolsError
    extends ResolveError {
        private List<Candidate> candidates;

        InapplicableSymbolsError(Symbol sym) {
            super(69, "inapplicable symbols");
            this.candidates = List.nil();
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (this.candidates.nonEmpty()) {
                JCDiagnostic err = Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.apply.symbols", name == Resolve.this.names.init ? Kinds.KindName.CONSTRUCTOR : Kinds.absentKind(this.kind), this.getName(), argtypes);
                return new JCDiagnostic.MultilineDiagnostic(err, this.candidateDetails(site));
            }
            return new SymbolNotFoundError(71).getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
        }

        List<JCDiagnostic> candidateDetails(Type site) {
            List<JCDiagnostic> details = List.nil();
            for (Candidate c : this.candidates) {
                details = details.prepend(c.getDiagnostic(site));
            }
            return details.reverse();
        }

        Symbol addCandidate(MethodResolutionPhase currentStep, Symbol sym, JCDiagnostic details) {
            Candidate c = new Candidate(currentStep, sym, details);
            if (c.isValid() && !this.candidates.contains(c)) {
                this.candidates = this.candidates.append(c);
            }
            return this;
        }

        void clear() {
            this.candidates = List.nil();
        }

        private Name getName() {
            Symbol sym = ((Candidate)this.candidates.head).sym;
            return sym.name == Resolve.this.names.init ? sym.owner.name : sym.name;
        }

        private class Candidate {
            final MethodResolutionPhase step;
            final Symbol sym;
            final JCDiagnostic details;

            private Candidate(MethodResolutionPhase step, Symbol sym, JCDiagnostic details) {
                this.step = step;
                this.sym = sym;
                this.details = details;
            }

            JCDiagnostic getDiagnostic(Type site) {
                return Resolve.this.diags.fragment("inapplicable.method", Kinds.kindName(this.sym), this.sym.location(site, Resolve.this.types), this.sym.asMemberOf(site, Resolve.this.types), this.details);
            }

            public boolean equals(Object o) {
                Symbol s2;
                Symbol s1;
                return o instanceof Candidate && ((s1 = this.sym) != (s2 = ((Candidate)o).sym) && (s1.overrides(s2, s1.owner.type.tsym, Resolve.this.types, false) || s2.overrides(s1, s2.owner.type.tsym, Resolve.this.types, false)) || (s1.isConstructor() || s2.isConstructor()) && s1.owner != s2.owner);
            }

            boolean isValid() {
                return (this.sym.flags() & 0x400000000L) != 0L && this.step == MethodResolutionPhase.VARARITY || (this.sym.flags() & 0x400000000L) == 0L && this.step == (Resolve.this.boxingEnabled ? MethodResolutionPhase.BOX : MethodResolutionPhase.BASIC);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InapplicableSymbolError
    extends InvalidSymbolError {
        JCDiagnostic explanation;

        InapplicableSymbolError(Symbol sym) {
            super(70, sym, "inapplicable symbol error");
        }

        InapplicableSymbolError setWrongSym(Symbol sym, JCDiagnostic explanation) {
            this.sym = sym;
            if (this.sym == sym && explanation != null) {
                this.explanation = explanation;
            }
            return this;
        }

        InapplicableSymbolError setWrongSym(Symbol sym) {
            this.sym = sym;
            return this;
        }

        @Override
        public String toString() {
            return super.toString() + " explanation=" + this.explanation;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (name == Resolve.this.names.error) {
                return null;
            }
            if (this.isOperator(name)) {
                boolean isUnaryOp = argtypes.size() == 1;
                String key = argtypes.size() == 1 ? "operator.cant.be.applied" : "operator.cant.be.applied.1";
                Type first = (Type)argtypes.head;
                Type second = !isUnaryOp ? (Type)argtypes.tail.head : null;
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, key, name, first, second);
            }
            Symbol ws = this.sym.asMemberOf(site, Resolve.this.types);
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.apply.symbol" + (this.explanation != null ? ".1" : ""), Kinds.kindName(ws), ws.name == Resolve.this.names.init ? ws.owner.name : ws.name, Resolve.this.methodArguments(ws.type.getParameterTypes()), Resolve.this.methodArguments(argtypes), Kinds.kindName(ws.owner), ws.owner.type, this.explanation);
        }

        void clear() {
            this.explanation = null;
        }

        @Override
        public Symbol access(Name name, Symbol.TypeSymbol location) {
            return Resolve.this.types.createErrorType((Name)name, (Symbol)location, (Type)Resolve.this.syms.errSymbol.type).tsym;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SymbolNotFoundError
    extends ResolveError {
        SymbolNotFoundError(int kind) {
            super(kind, "symbol not found error");
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            argtypes = argtypes == null ? List.nil() : argtypes;
            List<Object> list = typeargtypes = typeargtypes == null ? List.nil() : typeargtypes;
            if (name == Resolve.this.names.error) {
                return null;
            }
            if (this.isOperator(name)) {
                boolean isUnaryOp = argtypes.size() == 1;
                String key = argtypes.size() == 1 ? "operator.cant.be.applied" : "operator.cant.be.applied.1";
                Type first = (Type)argtypes.head;
                Type second = !isUnaryOp ? (Type)argtypes.tail.head : null;
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, key, name, first, second);
            }
            boolean hasLocation = false;
            if (location == null) {
                location = site.tsym;
            }
            if (!location.name.isEmpty()) {
                if (location.kind == 1 && !site.tsym.exists()) {
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "doesnt.exist", location);
                }
                hasLocation = !location.name.equals(Resolve.this.names._this) && !location.name.equals(Resolve.this.names._super);
            }
            boolean isConstructor = this.kind == 71 && name == Resolve.this.names.table.names.init;
            Kinds.KindName kindname = isConstructor ? Kinds.KindName.CONSTRUCTOR : Kinds.absentKind(this.kind);
            Name idname = isConstructor ? site.tsym.name : name;
            String errKey = this.getErrorKey(kindname, typeargtypes.nonEmpty(), hasLocation);
            if (hasLocation) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, errKey, kindname, idname, typeargtypes, argtypes, this.getLocationDiag(location, site));
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, errKey, kindname, idname, typeargtypes, argtypes);
        }

        private String getErrorKey(Kinds.KindName kindname, boolean hasTypeArgs, boolean hasLocation) {
            String key = "cant.resolve";
            String suffix = hasLocation ? ".location" : "";
            switch (kindname) {
                case METHOD: 
                case CONSTRUCTOR: {
                    suffix = suffix + ".args";
                    suffix = suffix + (hasTypeArgs ? ".params" : "");
                }
            }
            return key + suffix;
        }

        private JCDiagnostic getLocationDiag(Symbol location, Type site) {
            if (location.kind == 4) {
                return Resolve.this.diags.fragment("location.1", Kinds.kindName(location), location, location.type);
            }
            return Resolve.this.diags.fragment("location", Kinds.typeKindName(site), site, null);
        }
    }

    abstract class InvalidSymbolError
    extends ResolveError {
        Symbol sym;

        InvalidSymbolError(int kind, Symbol sym, String debugName) {
            super(kind, debugName);
            this.sym = sym;
        }

        public boolean exists() {
            return true;
        }

        public String toString() {
            return super.toString() + " wrongSym=" + this.sym;
        }

        public Symbol access(Name name, Symbol.TypeSymbol location) {
            if (this.sym.kind >= 65) {
                return ((ResolveError)this.sym).access(name, location);
            }
            if ((this.sym.kind & 0x40) == 0 && (this.sym.kind & 2) != 0) {
                return Resolve.this.types.createErrorType((Name)name, (Symbol)location, (Type)this.sym.type).tsym;
            }
            return this.sym;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ResolveError
    extends Symbol {
        final String debugName;

        ResolveError(int kind, String debugName) {
            super(kind, 0L, null, null, null);
            this.debugName = debugName;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new AssertionError();
        }

        @Override
        public String toString() {
            return this.debugName;
        }

        @Override
        public boolean exists() {
            return false;
        }

        protected Symbol access(Name name, Symbol.TypeSymbol location) {
            return Resolve.this.types.createErrorType((Name)name, (Symbol)location, (Type)Resolve.this.syms.errSymbol.type).tsym;
        }

        abstract JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType var1, JCDiagnostic.DiagnosticPosition var2, Symbol var3, Type var4, Name var5, List<Type> var6, List<Type> var7);

        boolean isOperator(Name name) {
            int i;
            for (i = 0; i < name.getByteLength() && "+-~!*/%&|^<>=".indexOf(name.getByteAt(i)) >= 0; ++i) {
            }
            return i > 0 && i == name.getByteLength();
        }
    }

    public static class InapplicableMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        JCDiagnostic diagnostic = null;
        JCDiagnostic.Factory diags;

        InapplicableMethodException(JCDiagnostic.Factory diags) {
            this.diags = diags;
        }

        InapplicableMethodException setMessage() {
            this.diagnostic = null;
            return this;
        }

        InapplicableMethodException setMessage(String key) {
            this.diagnostic = key != null ? this.diags.fragment(key, new Object[0]) : null;
            return this;
        }

        InapplicableMethodException setMessage(String key, Object ... args) {
            this.diagnostic = key != null ? this.diags.fragment(key, args) : null;
            return this;
        }

        InapplicableMethodException setMessage(JCDiagnostic diag) {
            this.diagnostic = diag;
            return this;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diagnostic;
        }
    }
}

