/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.web.WebAppFilterNode;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;

public class WebAppNodeFactory
implements NodeFactory {
    private static final String KEY_WEBAPP = "webapp";

    public NodeList createNodes(Project project) {
        Project prj = (Project)project.getLookup().lookup(Project.class);
        return new NList(prj);
    }

    private static class NList
    extends AbstractMavenNodeList<String>
    implements PropertyChangeListener {
        private Project project;
        private NbMavenProject mavenproject;
        private String currentWebAppKey;

        private NList(Project prj) {
            this.project = prj;
            this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        }

        public List<String> keys() {
            URI webapp = this.mavenproject.getWebAppDirectory();
            if (webapp != null) {
                this.currentWebAppKey = WebAppNodeFactory.KEY_WEBAPP + webapp.toString();
                return Collections.singletonList(this.currentWebAppKey);
            }
            return Collections.emptyList();
        }

        public Node node(String key) {
            return this.createWebAppNode();
        }

        private Node createWebAppNode() {
            WebAppFilterNode n = null;
            try {
                FileObject fo = URLMapper.findFileObject((URL)this.mavenproject.getWebAppDirectory().toURL());
                if (fo != null) {
                    DataFolder fold = DataFolder.findFolder((FileObject)fo);
                    File fil = FileUtil.toFile((FileObject)fo);
                    if (fold != null) {
                        n = new WebAppFilterNode(this.project, fold.getNodeDelegate().cloneNode(), fil);
                    }
                }
            }
            catch (MalformedURLException exc) {
                n = null;
            }
            return n;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.fireChange();
            }
        }

        public void addNotify() {
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }

        public void removeNotify() {
            NbMavenProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }
    }
}

