/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Properties;
import org.netbeans.modules.j2ee.persistence.dd.common.Property;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.DataNucleusProvider;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.EclipseLinkProvider;
import org.netbeans.modules.j2ee.persistence.provider.HibernateProvider;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.KodoProvider;
import org.netbeans.modules.j2ee.persistence.provider.OpenJPAProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ToplinkProvider;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.spi.server.ServerStatusProvider;
import org.netbeans.modules.j2ee.persistence.spi.server.ServerStatusProvider2;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class ProviderUtil {
    public static final Provider HIBERNATE_PROVIDER = new HibernateProvider("1.0");
    public static final Provider HIBERNATE_PROVIDER2_0 = new HibernateProvider("2.0");
    public static final Provider TOPLINK_PROVIDER1_0 = ToplinkProvider.create("1.0");
    public static final Provider ECLIPSELINK_PROVIDER = new EclipseLinkProvider("2.0");
    public static final Provider ECLIPSELINK_PROVIDER1_0 = new EclipseLinkProvider("1.0");
    public static final Provider KODO_PROVIDER = new KodoProvider();
    public static final Provider DATANUCLEUS_PROVIDER = new DataNucleusProvider();
    public static final Provider OPENJPA_PROVIDER = new OpenJPAProvider("2.0");
    public static final Provider OPENJPA_PROVIDER1_0 = new OpenJPAProvider("1.0");
    public static final Provider DEFAULT_PROVIDER = new DefaultProvider();
    private static final Provider TOPLINK_PROVIDER_55_COMPATIBLE = ToplinkProvider.create55Compatible();

    private ProviderUtil() {
    }

    public static Provider getProvider(String providerClass, Project project) {
        if (null == providerClass || "".equals(providerClass.trim())) {
            return ProviderUtil.getContainerManagedProvider(project);
        }
        for (Provider each : ProviderUtil.getAllProviders()) {
            if (!each.getProviderClass().equals(providerClass.trim())) continue;
            return each;
        }
        return DEFAULT_PROVIDER;
    }

    private static Provider getContainerManagedProvider(Project project) {
        PersistenceProviderSupplier providerSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (providerSupplier == null || !providerSupplier.supportsDefaultProvider() || providerSupplier.getSupportedProviders().isEmpty()) {
            return null;
        }
        return providerSupplier.getSupportedProviders().get(0);
    }

    public static DatabaseConnection getConnection(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit pu) {
        Parameters.notNull((CharSequence)"pu", (Object)pu);
        if (pu.getProperties() == null) {
            return null;
        }
        String url = null;
        String driver = null;
        String username = null;
        Property[] properties = pu.getProperties().getProperty2();
        Provider provider = ProviderUtil.getProvider(pu);
        for (int i = 0; i < properties.length; ++i) {
            String key = properties[i].getName();
            if (key == null) continue;
            if (key.equals(provider.getJdbcUrl())) {
                url = properties[i].getValue();
                continue;
            }
            if (key.equals(provider.getJdbcDriver())) {
                driver = properties[i].getValue();
                continue;
            }
            if (!key.equals(provider.getJdbcUsername())) continue;
            username = properties[i].getValue();
        }
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            DatabaseConnection c = connections[i];
            if (!c.getDatabaseURL().equals(url) || !c.getDriverClass().equals(driver) || !c.getUser().equals(username)) continue;
            return c;
        }
        return null;
    }

    public static void setTableGeneration(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String tableGenerationStrategy, Project project) {
        String providerClass = persistenceUnit.getProvider();
        Provider provider = ProviderUtil.getProvider(providerClass, project);
        ProviderUtil.setTableGeneration(persistenceUnit, tableGenerationStrategy, provider);
    }

    public static void setTableGeneration(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String tableGenerationStrategy, Provider provider) {
        Property existing;
        if (provider == null) {
            return;
        }
        String version = "1.0";
        if (persistenceUnit instanceof PersistenceUnit) {
            version = "2.0";
        }
        Property tableGenerationProperty = provider.getTableGenerationProperty(tableGenerationStrategy, version);
        Properties properties = persistenceUnit.getProperties();
        if (properties == null) {
            properties = persistenceUnit.newProperties();
            persistenceUnit.setProperties(properties);
        }
        if ((existing = ProviderUtil.getProperty(properties.getProperty2(), provider.getTableGenerationPropertyName())) != null && tableGenerationProperty == null) {
            properties.removeProperty2(existing);
        } else if (existing != null && tableGenerationProperty != null) {
            existing.setValue(tableGenerationProperty.getValue());
        } else if (tableGenerationProperty != null) {
            properties.addProperty2(tableGenerationProperty);
        }
    }

    public static void setProvider(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, Provider provider, DatabaseConnection connection, String tableGenerationStrategy) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        ProviderUtil.removeProviderProperties(persistenceUnit);
        persistenceUnit.setProvider(provider.getProviderClass());
        ProviderUtil.setDatabaseConnection(persistenceUnit, provider, connection);
        ProviderUtil.setTableGeneration(persistenceUnit, tableGenerationStrategy, provider);
    }

    public static void removeProviderProperties(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        ArrayList<Provider> olds = ProviderUtil.getProviders(persistenceUnit);
        HashSet providersProperties = new HashSet();
        for (Provider old : olds) {
            providersProperties.addAll(old.getPropertyNames());
        }
        Property[] properties = ProviderUtil.getProperties(persistenceUnit);
        for (int i = 0; i < properties.length; ++i) {
            Property each = properties[i];
            if (!providersProperties.contains(each.getName())) continue;
            persistenceUnit.getProperties().removeProperty2(each);
        }
        persistenceUnit.setProvider(null);
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit buildPersistenceUnit(String name, Provider provider, DatabaseConnection connection, String version) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        Parameters.notNull((CharSequence)"connection", (Object)connection);
        BaseBean persistenceUnit = null;
        persistenceUnit = "2.0".equals(version) ? new PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit();
        persistenceUnit.setName(name);
        persistenceUnit.setProvider(provider.getProviderClass());
        Properties properties = persistenceUnit.newProperties();
        Map<String, String> connectionProperties = provider.getConnectionPropertiesMap(connection, version);
        for (String propertyName : connectionProperties.keySet()) {
            Property property = properties.newProperty();
            property.setName(propertyName);
            property.setValue(connectionProperties.get(propertyName));
            properties.addProperty2(property);
        }
        Map defaultProperties = provider.getDefaultVendorSpecificProperties();
        for (String propertyName : defaultProperties.keySet()) {
            Property property = properties.newProperty();
            property.setName(propertyName);
            property.setValue((String)defaultProperties.get(propertyName));
            properties.addProperty2(property);
        }
        persistenceUnit.setProperties(properties);
        return persistenceUnit;
    }

    public static void setDatabaseConnection(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, DatabaseConnection connection) {
        ProviderUtil.setDatabaseConnection(persistenceUnit, null, connection);
    }

    public static void setDatabaseConnection(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, Provider provider, DatabaseConnection connection) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        if (provider == null) {
            provider = ProviderUtil.getProvider(persistenceUnit);
        }
        Property[] properties = ProviderUtil.getProperties(persistenceUnit);
        String version = persistenceUnit instanceof PersistenceUnit ? "2.0" : "1.0";
        Map<String, String> propertiesMap = provider.getConnectionPropertiesMap(connection, version);
        for (String name : propertiesMap.keySet()) {
            String value;
            Property property = ProviderUtil.getProperty(properties, name);
            if (property == null) {
                if (persistenceUnit.getProperties() == null) {
                    persistenceUnit.setProperties(persistenceUnit.newProperties());
                }
                property = persistenceUnit.getProperties().newProperty();
                property.setName(name);
                persistenceUnit.getProperties().addProperty2(property);
            }
            if ((value = propertiesMap.get(name)) == null) {
                value = "";
            }
            property.setValue(value);
        }
    }

    static Property[] getProperties(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        if (persistenceUnit.getProperties() != null) {
            return persistenceUnit.getProperties().getProperty2();
        }
        return new Property[0];
    }

    private static Property getProperty(Property[] properties, String propertyName) {
        if (null == properties) {
            return null;
        }
        for (int i = 0; i < properties.length; ++i) {
            Property each = properties[i];
            if (each.getName() == null || !each.getName().equals(propertyName)) continue;
            return each;
        }
        return null;
    }

    public static Property getProperty(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String propertyName) {
        if (persistenceUnit.getProperties() == null) {
            return null;
        }
        return ProviderUtil.getProperty(persistenceUnit.getProperties().getProperty2(), propertyName);
    }

    public static Provider getProvider(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        return ProviderUtil.getProvider(persistenceUnit, ProviderUtil.getAllProviders());
    }

    public static Provider getProvider(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, Provider[] providers) {
        long top_version;
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        String version = persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit ? "1.0" : "2.0";
        long longVersion = top_version = Math.round(Double.parseDouble(version) * 100.0);
        Provider top_provider = null;
        if (providers == null) {
            providers = ProviderUtil.getAllProviders();
        }
        Set<Provider> candidates = new HashSet<Provider>();
        for (Provider each : providers) {
            if (!each.getProviderClass().equals(persistenceUnit.getProvider())) continue;
            candidates.add(each);
        }
        if ((candidates = ProviderUtil.filterProvidersByProperties(candidates, persistenceUnit.getProperties() != null ? persistenceUnit.getProperties().getProperty2() : null)).size() == 1) {
            return candidates.iterator().next();
        }
        for (Provider each : candidates) {
            String provVersion = each.getVersion();
            if (provVersion == null) {
                return each;
            }
            long cur_version = Math.round(Double.parseDouble(provVersion) * 100.0);
            if (longVersion == cur_version) {
                top_provider = each;
                top_version = cur_version;
                break;
            }
            if (cur_version < top_version) continue;
            top_provider = each;
            top_version = cur_version;
        }
        return top_provider == null ? DEFAULT_PROVIDER : top_provider;
    }

    private static Set<Provider> filterProvidersByProperties(Set<Provider> providers, Property[] properties) {
        HashSet<Provider> ret = null;
        if (providers != null) {
            if (providers.size() <= 1 || properties == null || properties.length == 0) {
                ret = new HashSet<Provider>(providers);
            } else {
                ret = new HashSet<Provider>(providers);
                HashMap rates = new HashMap();
                int lowrate = Integer.MAX_VALUE;
                for (Provider each : providers) {
                    int rate = 0;
                    for (Property prop : properties) {
                        if (!each.getPropertyNames().contains(prop.getName())) continue;
                        ++rate;
                    }
                    if (rates.get(rate) == null) {
                        rates.put(rate, new ArrayList());
                    }
                    ((ArrayList)rates.get(rate)).add(each);
                    if (rate >= lowrate) continue;
                    lowrate = rate;
                }
                if (rates.size() > 1) {
                    for (Provider prov : (ArrayList)rates.get(lowrate)) {
                        ret.remove(prov);
                    }
                }
            }
        }
        return ret;
    }

    public static String getVersion(Provider provider) {
        return provider.getVersion();
    }

    public static ArrayList<Provider> getProviders(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (Provider each : ProviderUtil.getAllProviders()) {
            if (!each.getProviderClass().equals(persistenceUnit.getProvider())) continue;
            providers.add(each);
        }
        if (providers.size() == 0) {
            providers.add(DEFAULT_PROVIDER);
        }
        return providers;
    }

    public static boolean isValid(PUDataObject puDataObject) {
        return null == puDataObject ? false : puDataObject.parseDocument();
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] getPersistenceUnits(PUDataObject puDataObject) {
        if (puDataObject.getPersistence() == null) {
            return new org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[0];
        }
        return puDataObject.getPersistence().getPersistenceUnit();
    }

    public static void renameManagedClass(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String newName, String oldName, PUDataObject dataObject) {
        dataObject.removeClass(persistenceUnit, oldName, false);
        dataObject.addClass(persistenceUnit, newName, false);
    }

    public static void removeManagedClass(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String clazz, PUDataObject dataObject) {
        dataObject.removeClass(persistenceUnit, clazz, false);
    }

    public static void addManagedClass(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String clazz, PUDataObject dataObject) {
        dataObject.addClass(persistenceUnit, clazz, false);
    }

    public static void addPersistenceUnit(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, Project project) throws InvalidPersistenceXmlException {
        String version = persistenceUnit instanceof PersistenceUnit ? "2.0" : "1.0";
        PUDataObject pud = ProviderUtil.getPUDataObject(project, version);
        pud.addPersistenceUnit(persistenceUnit);
        pud.save();
    }

    public static PUDataObject getPUDataObject(FileObject fo) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!(dataObject instanceof PUDataObject)) {
            throw new InvalidPersistenceXmlException(FileUtil.getFileDisplayName((FileObject)fo));
        }
        return (PUDataObject)dataObject;
    }

    public static synchronized PUDataObject getPUDataObject(Project project, String version) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"project", (Object)project);
        FileObject puFileObject = ProviderUtil.getDDFile(project);
        if (puFileObject == null) {
            try {
                puFileObject = ProviderUtil.createPersistenceDDFile(project, version);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        if (puFileObject == null) {
            return null;
        }
        return ProviderUtil.getPUDataObject(puFileObject);
    }

    public static synchronized PUDataObject getPUDataObject(Project project) throws InvalidPersistenceXmlException {
        return ProviderUtil.getPUDataObject(project, null);
    }

    private static FileObject createPersistenceDDFile(Project project, String vers) throws IOException {
        final FileObject persistenceLocation = PersistenceLocation.createLocation((Project)project);
        if (persistenceLocation == null) {
            return null;
        }
        final FileObject[] dd = new FileObject[1];
        String ret = vers == null ? PersistenceUtils.getJPAVersion(project) : vers;
        final String version = ret != null ? ret : "1.0";
        persistenceLocation.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dd[0] = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)("org-netbeans-modules-j2ee-persistence/persistence-" + version + ".xml")), (FileObject)persistenceLocation, (String)"persistence");
            }
        });
        PersistenceUtils.logUsage(ProviderUtil.class, "USG_PERSISTENCE_XML_CREATED", new String[]{version});
        return dd[0];
    }

    public static boolean persistenceExists(Project project) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"project", (Object)project);
        if (ProviderUtil.getDDFile(project) == null) {
            return false;
        }
        PUDataObject pud = ProviderUtil.getPUDataObject(project);
        return pud.getPersistence().getPersistenceUnit().length > 0;
    }

    public static FileObject getDDFile(Project project) {
        int i = 0;
        PersistenceScope[] persistenceScopes = PersistenceUtils.getPersistenceScopes(project);
        if (i < persistenceScopes.length) {
            return persistenceScopes[i].getPersistenceXml();
        }
        return null;
    }

    public static Provider[] getAllProviders() {
        return new Provider[]{ECLIPSELINK_PROVIDER, ECLIPSELINK_PROVIDER1_0, TOPLINK_PROVIDER1_0, HIBERNATE_PROVIDER2_0, HIBERNATE_PROVIDER, KODO_PROVIDER, DATANUCLEUS_PROVIDER, OPENJPA_PROVIDER, OPENJPA_PROVIDER1_0, TOPLINK_PROVIDER_55_COMPATIBLE};
    }

    public static boolean makePortableIfPossible(Project project, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        return ProviderUtil.normalizeIfPossible(project, persistenceUnit, true);
    }

    public static boolean normalizeIfPossible(Project project, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        return ProviderUtil.normalizeIfPossible(project, persistenceUnit, false);
    }

    private static boolean normalizeIfPossible(Project project, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, boolean donotrestore) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        if (Util.isJavaSE(project)) {
            return false;
        }
        Provider defaultProvider = ProviderUtil.getContainerManagedProvider(project);
        if (defaultProvider == null) {
            return false;
        }
        boolean requiredTag = ProviderUtil.isProviderTagRequired(project);
        if (!(persistenceUnit.getProperties() != null && persistenceUnit.getProperties().sizeProperty2() != 0 || requiredTag)) {
            if (defaultProvider.getProviderClass() != null && defaultProvider.getProviderClass().equals(persistenceUnit.getProvider())) {
                persistenceUnit.setProvider(null);
                return true;
            }
        } else if (persistenceUnit.getProvider() == null && (persistenceUnit.getProperties().sizeProperty2() > 0 || requiredTag) && !donotrestore) {
            persistenceUnit.setProvider(defaultProvider.getProviderClass());
        }
        return false;
    }

    public static boolean isValidServerInstanceOrNone(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        ServerStatusProvider serverStatusProvider = (ServerStatusProvider)project.getLookup().lookup(ServerStatusProvider.class);
        if (serverStatusProvider == null) {
            return true;
        }
        return serverStatusProvider.validServerInstancePresent();
    }

    public static boolean canServerBeSelected(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        ServerStatusProvider2 serverStatusProvider = (ServerStatusProvider2)project.getLookup().lookup(ServerStatusProvider2.class);
        return serverStatusProvider != null;
    }

    public static void migrateProperties(String prevProvider, String curProvider, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        block3: {
            block2: {
                if (!prevProvider.equals("oracle.toplink.essentials.PersistenceProvider") || !curProvider.equals("org.eclipse.persistence.jpa.PersistenceProvider")) break block2;
                Property[] toplinkProps = persistenceUnit.getProperties().getProperty2();
                for (int i = 0; i < toplinkProps.length; ++i) {
                    if (!toplinkProps[i].getName().contains("toplink")) continue;
                    String propName = toplinkProps[i].getName();
                    propName = propName.replace("toplink", "eclipselink");
                    Property eclipselinkProp = persistenceUnit.getProperties().newProperty();
                    eclipselinkProp.setName(propName);
                    eclipselinkProp.setValue(toplinkProps[i].getValue());
                    persistenceUnit.getProperties().removeProperty2(toplinkProps[i]);
                    persistenceUnit.getProperties().addProperty2(eclipselinkProp);
                }
                break block3;
            }
            if (!prevProvider.equals("org.eclipse.persistence.jpa.PersistenceProvider") || !curProvider.equals("oracle.toplink.essentials.PersistenceProvider")) break block3;
            Property[] eclipselinkProps = persistenceUnit.getProperties().getProperty2();
            for (int i = 0; i < eclipselinkProps.length; ++i) {
                if (!eclipselinkProps[i].getName().contains("eclipselink")) continue;
                String propName = eclipselinkProps[i].getName();
                propName = propName.replace("eclipselink", "toplink");
                Property toplinkProp = persistenceUnit.getProperties().newProperty();
                toplinkProp.setName(propName);
                toplinkProp.setValue(eclipselinkProps[i].getValue());
                persistenceUnit.getProperties().removeProperty2(eclipselinkProps[i]);
                persistenceUnit.getProperties().addProperty2(toplinkProp);
            }
        }
    }

    private static boolean isProviderTagRequired(Project project) {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sgs.length < 1) {
            return false;
        }
        FileObject sourceRoot = sgs[0].getRootFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourceRoot, (String)"classpath/compile");
        FileObject utxClass = classPath.findResource("org/springframework/transaction/annotation/Transactional.class");
        return utxClass != null;
    }
}

