/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards.support;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DBSchemaFileList {
    private final Map<FileObject, String> dbschema2DisplayName = new HashMap<FileObject, String>();
    private final List dbschemaList;

    public DBSchemaFileList(Project project, FileObject configFilesFolder) {
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)project);
        for (int i = 0; i < sourceGroups.length; ++i) {
            this.searchRoot(sourceGroups[i].getRootFolder(), sourceGroups[i].getDisplayName());
        }
        if (configFilesFolder != null) {
            String configFilesDisplayName = NbBundle.getMessage(DBSchemaFileList.class, (String)"LBL_Node_DocBase");
            this.searchRoot(configFilesFolder, configFilesDisplayName);
        }
        ArrayList<FileObject> tempDBSchemaList = new ArrayList<FileObject>(this.dbschema2DisplayName.keySet());
        Collections.sort(tempDBSchemaList, new DBSchemaComparator());
        this.dbschemaList = Collections.unmodifiableList(tempDBSchemaList);
    }

    private void searchRoot(FileObject root, String rootDisplayName) {
        Enumeration ch = root.getChildren(true);
        while (ch.hasMoreElements()) {
            FileObject f = (FileObject)ch.nextElement();
            if (!f.getExt().equals("dbschema") || f.isFolder() || this.dbschema2DisplayName.containsKey(f)) continue;
            String relativeParent = FileUtil.getRelativePath((FileObject)root, (FileObject)f.getParent()) + File.separator;
            if (relativeParent.startsWith("/")) {
                relativeParent = relativeParent.substring(1);
            }
            String relative = relativeParent + f.getName();
            String displayName = NbBundle.getMessage(DBSchemaFileList.class, (String)"LBL_SchemaLocation", (Object)rootDisplayName, (Object)relative);
            this.dbschema2DisplayName.put(f, displayName);
        }
    }

    public List<FileObject> getFileList() {
        return this.dbschemaList;
    }

    public String getDisplayName(FileObject dbschemaFile) {
        return this.dbschema2DisplayName.get(dbschemaFile);
    }

    private final class DBSchemaComparator
    implements Comparator {
        private DBSchemaComparator() {
        }

        public int compare(Object o1, Object o2) {
            FileObject f1 = (FileObject)o1;
            FileObject f2 = (FileObject)o2;
            String displayName1 = (String)DBSchemaFileList.this.dbschema2DisplayName.get(f1);
            String displayName2 = (String)DBSchemaFileList.this.dbschema2DisplayName.get(f2);
            return displayName1.compareTo(displayName2);
        }
    }
}

