/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.mapping.HibernateMappingDataObject;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.spi.hibernate.HibernateFileLocationProvider;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.HibernateMappingWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class HibernateMappingWizard
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private Project project;
    private WizardDescriptor wizard;
    private HibernateMappingWizardDescriptor descriptor;
    private transient WizardDescriptor.Panel[] panels;
    private final String resourceAttr = "resource";
    private static String DEFAULT_MAPPING_FILENAME = "hibernate.hbm";
    private Logger logger = Logger.getLogger(HibernateMappingWizard.class.getName());

    public static HibernateMappingWizard create() {
        return new HibernateMappingWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnv == null) {
                this.logger.info("Unsupported project " + this.project + ". Existing config wizard.");
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                Project p = Templates.getProject((WizardDescriptor)this.wizard);
                SourceGroup[] groups = ProjectUtils.getSources((Project)p).getSourceGroups("generic");
                WizardDescriptor.Panel targetChooser = Templates.createSimpleTargetChooser((Project)p, (SourceGroup[])groups);
                this.panels = new WizardDescriptor.Panel[]{targetChooser, this.descriptor};
            }
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.project = Templates.getProject((WizardDescriptor)wizard);
        String wizardTitle = NbBundle.getMessage(HibernateMappingWizard.class, (String)"LBL_MappingWizardTitle");
        this.descriptor = new HibernateMappingWizardDescriptor(this.project, wizardTitle);
        if (Templates.getTargetFolder((WizardDescriptor)wizard) == null) {
            FileObject location;
            HibernateFileLocationProvider provider = this.project != null ? (HibernateFileLocationProvider)this.project.getLookup().lookup(HibernateFileLocationProvider.class) : null;
            FileObject fileObject = location = provider != null ? provider.getSourceLocation() : null;
            if (location != null) {
                Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)location);
            }
        }
        if (wizard instanceof TemplateWizard) {
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnv == null) {
                return;
            }
            List<FileObject> mappingFiles = hibernateEnv.getAllHibernateMappingFileObjects();
            String targetName = DEFAULT_MAPPING_FILENAME;
            if (!mappingFiles.isEmpty() && this.foundMappingFileInProject(mappingFiles, DEFAULT_MAPPING_FILENAME)) {
                int mappingFilesCount = mappingFiles.size();
                targetName = "hibernate" + mappingFilesCount++ + ".hbm";
                while (this.foundMappingFileInProject(mappingFiles, targetName)) {
                    targetName = "hibernate" + mappingFilesCount++ + ".hbm";
                }
            }
            ((TemplateWizard)wizard).setTargetName(targetName);
        }
    }

    private boolean foundMappingFileInProject(List<FileObject> mappingFiles, String mappingFileName) {
        for (FileObject fo : mappingFiles) {
            if (!fo.getName().equals(mappingFileName)) continue;
            return true;
        }
        return false;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public Set instantiate() throws IOException {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder targetDataFolder = DataFolder.findFolder((FileObject)targetFolder);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject templateFileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataObject templateDataObject = DataObject.find((FileObject)templateFileObject);
        HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
        DataObject newOne = templateDataObject.createFromTemplate(targetDataFolder, targetName);
        FileObject confFile = null;
        MyClass myClass = new MyClass();
        if (this.descriptor.getConfigurationFile() != null && !"".equals(this.descriptor.getConfigurationFile())) {
            confFile = this.descriptor.getConfigurationFile();
            DataObject confDataObject = DataObject.find((FileObject)confFile);
            HibernateCfgDataObject hco = (HibernateCfgDataObject)confDataObject;
            SessionFactory sf = hco.getHibernateConfiguration().getSessionFactory();
            int mappingIndex = sf.addMapping(true);
            sf.setAttributeValue("Mapping", mappingIndex, "resource", HibernateUtil.getRelativeSourcePath(newOne.getPrimaryFile(), hibernateEnv.getSourceLocation()));
            hco.modelUpdatedFromUI();
            hco.save();
        }
        try {
            HibernateMappingDataObject hmo = (HibernateMappingDataObject)newOne;
            if (this.descriptor.getClassName() != null && !"".equals(this.descriptor.getClassName())) {
                myClass.setAttributeValue("name", this.descriptor.getClassName());
                if (this.descriptor.getDatabaseTable() != null && !"".equals(this.descriptor.getDatabaseTable())) {
                    myClass.setAttributeValue("table", this.descriptor.getDatabaseTable());
                    myClass.setAttributeValue("dynamic-insert", null);
                    myClass.setAttributeValue("dynamic-update", null);
                    myClass.setAttributeValue("mutable", null);
                    myClass.setAttributeValue("optimistic-lock", null);
                    myClass.setAttributeValue("polymorphism", null);
                    myClass.setAttributeValue("select-before-update", null);
                }
                hmo.addMyClass(myClass);
            }
            hmo.save();
            return Collections.singleton(hmo.getPrimaryFile());
        }
        catch (Exception e) {
            return Collections.EMPTY_SET;
        }
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public String name() {
        return NbBundle.getMessage(HibernateMappingWizard.class, (String)"LBL_MappingWizardTitle");
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }
}

