/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.HibernateRenameRefactoringElement;
import org.netbeans.modules.hibernate.refactoring.JavaClassRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.JavaFieldRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.JavaPackageRenameTransaction;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class HibernateRenamePlugin
implements RefactoringPlugin {
    private RenameRefactoring refactoring;
    private List<FileObject> mFileObjs;

    public HibernateRenamePlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        NonRecursiveFolder folder;
        TreePathHandle treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        FileObject fo = null;
        if (treePathHandle != null && (TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePathHandle.getKind()) || treePathHandle.getKind() == Tree.Kind.VARIABLE || treePathHandle.getKind() == Tree.Kind.MEMBER_SELECT || treePathHandle.getKind() == Tree.Kind.IDENTIFIER)) {
            fo = treePathHandle.getFileObject();
        }
        if (fo == null) {
            fo = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
        }
        boolean recursive = true;
        if (fo == null && (folder = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)) != null) {
            recursive = false;
            fo = folder.getFolder();
        }
        if (fo == null) {
            return null;
        }
        Project proj = FileOwnerQuery.getOwner((FileObject)fo);
        if (proj == null) {
            return null;
        }
        HibernateEnvironment env = (HibernateEnvironment)proj.getLookup().lookup(HibernateEnvironment.class);
        if (env == null) {
            return null;
        }
        this.mFileObjs = env.getAllHibernateMappingFileObjects();
        if (this.mFileObjs == null || this.mFileObjs.size() == 0) {
            return null;
        }
        try {
            if (treePathHandle != null) {
                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePathHandle.getKind())) {
                    this.renameJavaClass(refactoringElements, treePathHandle, fo);
                } else if (treePathHandle.getKind() == Tree.Kind.VARIABLE || treePathHandle.getKind() == Tree.Kind.MEMBER_SELECT || treePathHandle.getKind() == Tree.Kind.IDENTIFIER) {
                    this.renameJavaField(refactoringElements, treePathHandle, fo);
                }
            } else if (fo.isFolder()) {
                this.renameJavaPackage(refactoringElements, treePathHandle, fo, recursive);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return null;
    }

    private void renameJavaClass(RefactoringElementsBag refactoringElements, TreePathHandle treePathHandle, FileObject fo) throws IOException {
        HibernateRefactoringUtil.RenamedClassName clazz = null;
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js != null) {
            clazz = HibernateRefactoringUtil.getRenamedClassName(treePathHandle, js, this.refactoring.getNewName());
        }
        if (clazz != null) {
            String oldBinaryName = clazz.getOldBinaryName();
            String newBinaryName = clazz.getNewBinaryName();
            if (oldBinaryName != null && newBinaryName != null) {
                Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getJavaClassOccurrences(this.mFileObjs, oldBinaryName);
                for (FileObject mFileObj : occurrences.keySet()) {
                    List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(mFileObj);
                    for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                        HibernateRenameRefactoringElement elem = new HibernateRenameRefactoringElement(mFileObj, oldBinaryName, newBinaryName, foundPlace.getLocation(), foundPlace.getText());
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                    }
                }
                refactoringElements.registerTransaction((Transaction)new JavaClassRenameTransaction(occurrences.keySet(), oldBinaryName, newBinaryName));
            }
        }
    }

    private void renameJavaField(RefactoringElementsBag refactoringElements, final TreePathHandle treePathHandle, FileObject fo) throws IOException {
        final String[] classAndVariableNames = new String[]{null, null};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
        if (javaSource == null) {
            return;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws IOException {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)cc);
                if (element == null || element.getKind() != ElementKind.FIELD) {
                    return;
                }
                classAndVariableNames[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element.getEnclosingElement()));
                classAndVariableNames[1] = element.getSimpleName().toString();
            }
        }, true);
        String className = classAndVariableNames[0];
        String oldVariableName = classAndVariableNames[1];
        String newVariableName = this.refactoring.getNewName();
        if (oldVariableName != null && newVariableName != null) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getJavaFieldOccurrences(this.mFileObjs, className, oldVariableName);
            for (FileObject mFileObj : occurrences.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(mFileObj);
                for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                    HibernateRenameRefactoringElement elem = new HibernateRenameRefactoringElement(mFileObj, oldVariableName, newVariableName, foundPlace.getLocation(), foundPlace.getText());
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                }
            }
            refactoringElements.registerTransaction((Transaction)new JavaFieldRenameTransaction(occurrences.keySet(), className, oldVariableName, newVariableName));
        }
    }

    private void renameJavaPackage(RefactoringElementsBag refactoringElements, TreePathHandle treePathHandle, FileObject fo, boolean recursive) throws IOException {
        String newPackageName;
        String oldPackageName = HibernateRefactoringUtil.getPackageName(fo);
        String string = newPackageName = recursive ? HibernateRefactoringUtil.getRenamedPackageName(fo, this.refactoring.getNewName()) : this.refactoring.getNewName();
        if (oldPackageName != null && newPackageName != null) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getJavaPackageOccurrences(this.mFileObjs, oldPackageName);
            for (FileObject mFileObj : occurrences.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(mFileObj);
                for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                    HibernateRenameRefactoringElement elem = new HibernateRenameRefactoringElement(mFileObj, oldPackageName, newPackageName, foundPlace.getLocation(), foundPlace.getText());
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                }
            }
            refactoringElements.registerTransaction((Transaction)new JavaPackageRenameTransaction(occurrences.keySet(), oldPackageName, newPackageName));
        }
        String oldResourcePath = oldPackageName.replace('.', '/');
        String newResourcePath = newPackageName.replace('.', '/');
        Project proj = FileOwnerQuery.getOwner((FileObject)fo);
        HibernateEnvironment env = (HibernateEnvironment)proj.getLookup().lookup(HibernateEnvironment.class);
        if (env == null) {
            return;
        }
        List<FileObject> configFiles = env.getAllHibernateConfigFileObjects();
        if (configFiles.isEmpty()) {
            return;
        }
        Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getMappingResourceOccurrences(configFiles, oldResourcePath, true);
        for (FileObject configFile : occurrences.keySet()) {
            List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(configFile);
            for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                HibernateRenameRefactoringElement elem = new HibernateRenameRefactoringElement(configFile, oldResourcePath, newResourcePath, foundPlace.getLocation(), foundPlace.getText());
                refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
            }
        }
        refactoringElements.registerTransaction((Transaction)new HibernateMappingRenameTransaction(occurrences.keySet(), oldResourcePath, newResourcePath, true));
    }
}

