/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Position;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorBoxViewChildren;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutPart;
import org.netbeans.modules.editor.lib2.view.TextLayoutUtils;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.modules.editor.lib2.view.VisualUpdate;
import org.netbeans.modules.editor.lib2.view.WrapInfo;
import org.netbeans.modules.editor.lib2.view.WrapInfoUpdater;
import org.netbeans.modules.editor.lib2.view.WrapLine;

public final class ParagraphViewChildren
extends EditorBoxViewChildren<EditorView> {
    private static final Logger LOG = Logger.getLogger(ParagraphViewChildren.class.getName());
    private static final long serialVersionUID = 0L;
    private WrapInfo wrapInfo;

    public ParagraphViewChildren(int capacity) {
        super(capacity);
    }

    @Override
    protected boolean rawOffsetUpdate() {
        return true;
    }

    @Override
    protected boolean handleTabableViews() {
        return true;
    }

    @Override
    protected double getMajorAxisChildrenSpan(EditorBoxView<EditorView> boxView) {
        return this.wrapInfo != null ? this.wrapInfo.childrenWidth : super.getMajorAxisChildrenSpan(boxView);
    }

    @Override
    protected void setMajorAxisChildrenSpan(EditorBoxView<EditorView> boxView, double majorAxisSpan) {
        if (this.wrapInfo != null) {
            this.wrapInfo.childrenWidth = majorAxisSpan;
        } else {
            super.setMajorAxisChildrenSpan(boxView, majorAxisSpan);
        }
    }

    @Override
    protected float getMinorAxisChildrenSpan(EditorBoxView<EditorView> boxView) {
        return this.wrapInfo != null ? this.wrapInfo.childrenHeight : super.getMinorAxisChildrenSpan(boxView);
    }

    @Override
    protected void setMinorAxisChildrenSpan(EditorBoxView<EditorView> boxView, float minorAxisSpan) {
        if (this.wrapInfo != null) {
            this.wrapInfo.childrenHeight = minorAxisSpan;
        } else {
            super.setMinorAxisChildrenSpan(boxView, minorAxisSpan);
        }
    }

    @Override
    protected EditorView getEditorViewChildrenValid(EditorBoxView<EditorView> boxView, int index) {
        return (EditorView)this.get(index);
    }

    @Override
    protected void updateLayout(EditorBoxView<EditorView> boxView, VisualUpdate<EditorView> visualUpdate, Shape alloc) {
        boolean heightChanged;
        double origWidth = boxView.getMajorAxisSpan();
        float origHeight = boxView.getMinorAxisSpan();
        this.recomputeLayout(boxView);
        double width = boxView.getMajorAxisSpan();
        float height = boxView.getMinorAxisSpan();
        boolean widthChanged = origWidth != width;
        boolean bl = heightChanged = origHeight != height;
        if (alloc != null) {
            if (this.wrapInfo == null) {
                super.updateLayout(boxView, visualUpdate, alloc);
            } else {
                Rectangle2D.Double repaintBounds = ViewUtils.shape2Bounds(alloc);
                if (this.wrapInfo == null) {
                    repaintBounds.x += visualUpdate.visualOffset;
                    repaintBounds.width -= visualUpdate.visualOffset;
                }
                if (widthChanged) {
                    visualUpdate.markWidthChanged();
                    repaintBounds.width = 1.073741823E9;
                }
                if (heightChanged) {
                    visualUpdate.markHeightChanged();
                    repaintBounds.height = 1.073741823E9;
                }
                visualUpdate.repaintBounds = ViewUtils.toRect(repaintBounds);
            }
        } else if (widthChanged || heightChanged) {
            boxView.preferenceChanged(null, widthChanged, heightChanged);
        }
    }

    void recomputeLayout(EditorBoxView<EditorView> boxView) {
        ParagraphView paragraphView = (ParagraphView)boxView;
        DocumentView docView = paragraphView.getDocumentView();
        if (docView != null) {
            boolean wrapDone = false;
            double childrenWidth = this.getMajorAxisChildrenSpan(boxView);
            float childrenHeight = this.getMinorAxisChildrenSpan(boxView);
            if (docView.getLineWrapType() != DocumentView.LineWrapType.NONE && !paragraphView.isRTL()) {
                this.wrapInfo = null;
                float visibleWidth = docView.getVisibleWidth();
                if (visibleWidth > docView.getDefaultCharWidth() && childrenWidth > (double)visibleWidth) {
                    wrapDone = true;
                    this.wrapInfo = new WrapInfo(childrenWidth, childrenHeight);
                    float prefWidth = new WrapInfoUpdater(this.wrapInfo, paragraphView).initWrapInfo();
                    float prefHeight = this.wrapInfo.preferredHeight();
                    boxView.setMajorAxisSpan(prefWidth);
                    boxView.setMinorAxisSpan(prefHeight);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("WrapInfo.init(): pref[" + prefWidth + "," + prefHeight + "] " + this.wrapInfo.toString(paragraphView));
                    }
                }
            }
            if (!wrapDone) {
                boxView.setMajorAxisSpan(childrenWidth);
                boxView.setMinorAxisSpan(childrenHeight);
            }
        }
    }

    private ViewSearchResult getTextLayoutViewIndex(EditorBoxView<EditorView> boxView, double visualOffset, boolean last) {
        ViewSearchResult result = new ViewSearchResult(boxView, visualOffset);
        int high = this.size() - 1;
        if (high == -1) {
            result.index = -1;
            return result;
        }
        int low = 0;
        while (low <= high) {
            double midVisualOffset;
            HighlightsView hView;
            Object layout;
            int mid = low + high >>> 1;
            EditorView view = boxView.getEditorView(mid);
            if (view instanceof HighlightsView && (layout = (hView = (HighlightsView)view).layout()) instanceof TextLayoutPart) {
                TextLayoutPart part = (TextLayoutPart)layout;
                int tlStartIndex = mid - part.index();
                double tlStartVisualOffset = this.getViewVisualOffset(tlStartIndex);
                double tlEndVisualOffset = this.getViewVisualOffset(tlStartIndex + part.viewCount());
                if (visualOffset >= tlStartVisualOffset && visualOffset <= tlEndVisualOffset) {
                    result.index = last ? tlStartIndex + part.viewCount() - 1 : tlStartIndex;
                    result.textLayoutPart = (TextLayoutPart)((HighlightsView)boxView.getEditorView(result.index)).layout();
                }
            }
            if ((midVisualOffset = this.getViewVisualOffset(mid)) < visualOffset) {
                low = mid + 1;
                continue;
            }
            if (midVisualOffset > visualOffset) {
                high = mid - 1;
                continue;
            }
            high = mid;
            break;
        }
        result.index = Math.max(high, 0);
        result.view = boxView.getEditorView(result.index);
        return result;
    }

    private int getOffset(ViewSearchResult result) {
        assert (result.textLayoutPart.index() == 0);
        TextHitInfo hitInfo = HighlightsViewUtils.x2Index(result.textLayout(), (float)result.visualOffset);
        return result.view.getStartOffset() + hitInfo.getCharIndex();
    }

    private void updatePartViewIndex(ViewSearchResult result) {
        if (result.textLayoutPart != null) {
            int offset = this.getOffset(result);
            result.index = this.getViewIndex(offset, result.index, result.index + result.textLayoutPart.viewCount());
            result.view = result.boxView.getEditorView(result.index);
        }
    }

    @Override
    protected void paint(EditorBoxView<EditorView> boxView, Graphics2D g, Shape alloc, Rectangle clipBounds) {
        if (this.wrapInfo != null) {
            Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
            double relY = (double)clipBounds.y - allocBounds.y;
            float wrapLineHeight = this.wrapInfo.childrenHeight;
            int startWrapLineIndex = relY < (double)wrapLineHeight ? 0 : (int)(relY / (double)wrapLineHeight);
            int endWrapLineIndex = relY >= (double)boxView.getMinorAxisSpan() ? this.wrapInfo.wrapLineCount() : (int)((relY += (double)((float)clipBounds.height + (wrapLineHeight - 1.0f))) / (double)wrapLineHeight);
            this.wrapInfo.paintWrapLines(this, (ParagraphView)boxView, startWrapLineIndex, endWrapLineIndex, g, alloc, clipBounds);
        } else {
            super.paint(boxView, g, alloc, clipBounds);
        }
    }

    @Override
    protected void paintChildren(EditorBoxView<EditorView> boxView, Graphics2D g, Shape alloc, Rectangle clipBounds, double startVisualOffset, double endVisualOffset) {
        if (((ParagraphView)boxView).isRTL()) {
            int startIndex = Math.max(this.getTextLayoutViewIndex(boxView, (double)startVisualOffset, (boolean)false).index, 0);
            int endIndex = this.getTextLayoutViewIndex(boxView, (double)endVisualOffset, (boolean)true).index + 1;
            this.paintChildren(boxView, g, alloc, clipBounds, startIndex, endIndex);
        } else {
            super.paintChildren(boxView, g, alloc, clipBounds, startVisualOffset, endVisualOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintChildren(EditorBoxView<EditorView> boxView, Graphics2D g, Shape alloc, Rectangle clipBounds, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            HighlightsView hView;
            Object layout;
            EditorView view = this.getEditorViewChildrenValid(boxView, i);
            Shape childAlloc = this.getChildAllocation(boxView, i, i + 1, alloc);
            if (view instanceof HighlightsView && (layout = (hView = (HighlightsView)view).layout()) instanceof TextLayoutPart) {
                TextLayoutPart part = (TextLayoutPart)layout;
                TextLayout textLayout = part.textLayout();
                DocumentView docView = ((ParagraphView)boxView).getDocumentView();
                int layoutStartViewIndex = i - part.index();
                Shape textLayoutAlloc = this.getChildAllocation(boxView, layoutStartViewIndex, layoutStartViewIndex + part.viewCount(), alloc);
                Rectangle2D.Double textLayoutBounds = ViewUtils.shape2Bounds(textLayoutAlloc);
                int endPartRelIndex = Math.min(layoutStartViewIndex + part.viewCount(), endIndex) - layoutStartViewIndex;
                TextHitInfo startHit = TextHitInfo.leading(part.offsetShift());
                TextHitInfo endHit = TextLayoutUtils.endHit(boxView, part, layoutStartViewIndex, endPartRelIndex);
                for (int j = part.index(); j < endPartRelIndex; ++j) {
                    HighlightsView partView = (HighlightsView)boxView.getEditorView(layoutStartViewIndex + j);
                    TextLayoutPart paintPart = (TextLayoutPart)partView.layout();
                    if (paintPart.foreground() != null) continue;
                    int shift = paintPart.offsetShift();
                    int length = partView.getLength();
                    TextHitInfo shiftHit = TextHitInfo.leading(shift);
                    TextHitInfo shiftLengthHit = TextHitInfo.leading(shift + length);
                    Shape partAlloc = TextLayoutUtils.getRealAlloc(textLayout, textLayoutBounds, shiftHit, shiftLengthHit);
                    partView.partPaintBackground(g, partAlloc, textLayoutBounds, clipBounds);
                }
                Shape origClip = g.getClip();
                Color origColor = g.getColor();
                try {
                    Shape renderTextLayoutAlloc = TextLayoutUtils.getRealAlloc(textLayout, textLayoutBounds, startHit, endHit);
                    Color foreColor = part.textLayoutForeground();
                    g.setColor(foreColor);
                    g.clip(renderTextLayoutAlloc);
                    HighlightsViewUtils.paintTextLayout(g, textLayoutBounds, textLayout, docView);
                }
                finally {
                    g.setColor(origColor);
                    g.setClip(origClip);
                }
                for (int j = part.index(); j < endPartRelIndex; ++j) {
                    HighlightsView partView = (HighlightsView)boxView.getEditorView(layoutStartViewIndex + j);
                    TextLayoutPart paintPart = (TextLayoutPart)partView.layout();
                    int shift = paintPart.offsetShift();
                    int length = partView.getLength();
                    TextHitInfo shiftHit = TextHitInfo.leading(shift);
                    TextHitInfo shiftLengthHit = TextHitInfo.leading(shift + length);
                    Shape partAlloc = TextLayoutUtils.getRealAlloc(textLayout, textLayoutBounds, shiftHit, shiftLengthHit);
                    if (paintPart.foreground() != null) {
                        partView.partPaintBackground(g, partAlloc, textLayoutBounds, clipBounds);
                    }
                    partView.partPaintForeground(g, partAlloc, textLayoutBounds, clipBounds);
                }
                i = layoutStartViewIndex + endPartRelIndex - 1;
                continue;
            }
            view.paint(g, childAlloc, clipBounds);
        }
    }

    @Override
    public Shape modelToViewChecked(EditorBoxView<EditorView> boxView, int offset, Shape alloc, Position.Bias bias) {
        if (this.wrapInfo != null) {
            int wrapLineIndex = this.findWrapLineIndex(boxView, offset);
            WrapLine wrapLine = (WrapLine)this.wrapInfo.get(wrapLineIndex);
            Rectangle2D.Double wrapLineBounds = this.wrapLineAlloc(alloc, wrapLineIndex);
            Shape ret = null;
            StringBuilder logBuilder = null;
            if (LOG.isLoggable(Level.FINE)) {
                logBuilder = new StringBuilder(100);
                logBuilder.append("ParagraphViewChildren.modelToViewChecked(): offset=").append(offset).append(", wrapLineIndex=").append(wrapLineIndex).append(", orig-allocBounds=").append(ViewUtils.toString(alloc)).append("\n    ");
            }
            if (wrapLine.startViewPart != null && offset < wrapLine.startViewPart.getEndOffset()) {
                Shape startPartAlloc = this.startPartAlloc(wrapLineBounds, wrapLine);
                if (logBuilder != null) {
                    logBuilder.append("START-part:").append(ViewUtils.toString(startPartAlloc));
                }
                ret = wrapLine.startViewPart.modelToViewChecked(offset, startPartAlloc, bias);
            } else if (wrapLine.endViewPart != null && offset >= wrapLine.endViewPart.getStartOffset()) {
                Shape endPartAlloc = this.endPartAlloc(wrapLineBounds, wrapLine, boxView);
                if (logBuilder != null) {
                    logBuilder.append("END-part:").append(ViewUtils.toString(endPartAlloc));
                }
                ret = wrapLine.endViewPart.modelToViewChecked(offset, endPartAlloc, bias);
            } else {
                assert (wrapLine.hasFullViews()) : this.wrapInfo.dumpWrapLine(boxView, wrapLineIndex);
                for (int i = wrapLine.startViewIndex; i < wrapLine.endViewIndex; ++i) {
                    EditorView view = boxView.getEditorView(i);
                    if (offset >= view.getEndOffset()) continue;
                    Shape viewAlloc = this.viewAlloc(wrapLineBounds, wrapLine, i, boxView);
                    ret = view instanceof HighlightsView ? ((HighlightsView)view).modelToViewChecked(offset, viewAlloc, bias, i) : view.modelToViewChecked(offset, viewAlloc, bias);
                    assert (ret != null);
                    break;
                }
            }
            if (logBuilder != null) {
                logBuilder.append("\n    RET=").append(ViewUtils.toString(ret)).append('\n');
                LOG.fine(logBuilder.toString());
            }
            return ret;
        }
        int index = this.getViewIndex(offset, bias);
        if (index >= 0) {
            EditorView view = this.getEditorViewChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            if (view instanceof HighlightsView) {
                return ((HighlightsView)view).modelToViewChecked(offset, childAlloc, bias, index);
            }
            return view.modelToViewChecked(offset, childAlloc, bias);
        }
        return alloc;
    }

    @Override
    public int viewToModelChecked(EditorBoxView<EditorView> boxView, double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        int offset;
        int index;
        if (this.wrapInfo != null) {
            int wrapLineIndex = this.findWrapLineIndex(alloc, y);
            Rectangle2D.Double wrapLineAlloc = this.wrapLineAlloc(alloc, wrapLineIndex);
            WrapLine wrapLine = (WrapLine)this.wrapInfo.get(wrapLineIndex);
            IndexAndAlloc indexAndAlloc = this.findIndexAndAlloc(boxView, x, wrapLineAlloc, wrapLine);
            return indexAndAlloc.viewOrPart.viewToModelChecked(x, y, indexAndAlloc.alloc, biasReturn);
        }
        if (((ParagraphView)boxView).isRTL()) {
            Rectangle2D.Double relXY = ViewUtils.shape2RelBounds(alloc, x, y);
            ViewSearchResult result = this.getTextLayoutViewIndex(boxView, relXY.getX(), false);
            if (result.textLayoutPart != null) {
                return this.getOffset(result);
            }
        }
        if ((index = this.getViewIndexAtPoint(boxView, x, y, alloc)) >= 0) {
            EditorView view = this.getEditorViewChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            offset = view instanceof HighlightsView ? ((HighlightsView)view).viewToModelChecked(x, y, childAlloc, biasReturn, index) : view.viewToModelChecked(x, y, childAlloc, biasReturn);
        } else {
            offset = boxView.getStartOffset();
        }
        return offset;
    }

    int getNextVisualPositionY(EditorBoxView<EditorView> boxView, int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet, double x) {
        switch (direction) {
            case 1: {
                int retOffsetNorth;
                if (offset == -1) {
                    if (this.wrapInfo != null) {
                        int lastWrapLineIndex = this.wrapInfo.wrapLineCount() - 1;
                        retOffsetNorth = this.visualPositionOnWrapLine(boxView, alloc, biasRet, x, lastWrapLineIndex);
                    } else {
                        retOffsetNorth = this.visualPosition(boxView, alloc, biasRet, x);
                    }
                } else {
                    int wrapLineIndex;
                    retOffsetNorth = this.wrapInfo != null ? ((wrapLineIndex = this.findWrapLineIndex(boxView, offset)) > 0 ? this.visualPositionOnWrapLine(boxView, alloc, biasRet, x, wrapLineIndex - 1) : -1) : -1;
                }
                return retOffsetNorth;
            }
            case 5: {
                int wrapLineIndex;
                int retOffsetSouth = offset == -1 ? (this.wrapInfo != null ? this.visualPositionOnWrapLine(boxView, alloc, biasRet, x, 0) : this.visualPosition(boxView, alloc, biasRet, x)) : (this.wrapInfo != null ? ((wrapLineIndex = this.findWrapLineIndex(boxView, offset)) < this.wrapInfo.wrapLineCount() - 1 ? this.visualPositionOnWrapLine(boxView, alloc, biasRet, x, wrapLineIndex + 1) : -1) : -1);
                return retOffsetSouth;
            }
            case 3: 
            case 7: {
                throw new IllegalStateException("Not intended to handle EAST and WEST directions");
            }
        }
        throw new IllegalArgumentException("Bad direction: " + direction);
    }

    private int visualPositionOnWrapLine(EditorBoxView<EditorView> boxView, Shape alloc, Position.Bias[] biasRet, double x, int wrapLineIndex) {
        WrapLine wrapLine = (WrapLine)this.wrapInfo.get(wrapLineIndex);
        Rectangle2D.Double wrapLineAlloc = this.wrapLineAlloc(alloc, wrapLineIndex);
        IndexAndAlloc indexAndAlloc = this.findIndexAndAlloc(boxView, x, wrapLineAlloc, wrapLine);
        double y = ViewUtils.shapeAsRect(indexAndAlloc.alloc).getY();
        return indexAndAlloc.viewOrPart.viewToModelChecked(x, y, indexAndAlloc.alloc, biasRet);
    }

    private int visualPosition(EditorBoxView<EditorView> boxView, Shape alloc, Position.Bias[] biasRet, double x) {
        int childIndex;
        Rectangle2D allocRect = ViewUtils.shapeAsRect(alloc);
        double y = allocRect.getY();
        if (((ParagraphView)boxView).isRTL()) {
            ViewSearchResult result = this.getTextLayoutViewIndex(boxView, x - allocRect.getX(), false);
            if (result.textLayoutPart != null) {
                return this.getOffset(result);
            }
            childIndex = result.index;
        } else {
            childIndex = this.getViewIndexAtPoint(boxView, x, y, alloc);
        }
        EditorView child = boxView.getEditorView(childIndex);
        Shape childAlloc = boxView.getChildAllocation(childIndex, alloc);
        return child.viewToModelChecked(x, y, childAlloc, biasRet);
    }

    private IndexAndAlloc findIndexAndAlloc(EditorBoxView<EditorView> boxView, double x, Shape wrapLineAlloc, WrapLine wrapLine) {
        IndexAndAlloc indexAndAlloc = new IndexAndAlloc();
        if (wrapLine.startViewPart != null && (x < (double)wrapLine.startViewX || !wrapLine.hasFullViews() && wrapLine.endViewPart == null)) {
            indexAndAlloc.index = -1;
            indexAndAlloc.viewOrPart = wrapLine.startViewPart;
            indexAndAlloc.alloc = this.startPartAlloc(wrapLineAlloc, wrapLine);
            return indexAndAlloc;
        }
        if (wrapLine.hasFullViews()) {
            Rectangle2D.Double viewBounds = ViewUtils.shape2Bounds(wrapLineAlloc);
            viewBounds.x += (double)wrapLine.startViewX;
            double lastVisualOffset = boxView.getViewVisualOffset(wrapLine.startViewIndex);
            for (int i = wrapLine.startViewIndex; i < wrapLine.endViewIndex; ++i) {
                double nextVisualOffset = boxView.getViewVisualOffset(i + 1);
                viewBounds.width = nextVisualOffset - lastVisualOffset;
                if (x < viewBounds.x + viewBounds.width || i == wrapLine.endViewIndex - 1 && wrapLine.endViewPart == null) {
                    indexAndAlloc.index = i;
                    indexAndAlloc.viewOrPart = boxView.getEditorView(i);
                    indexAndAlloc.alloc = viewBounds;
                    return indexAndAlloc;
                }
                viewBounds.x += viewBounds.width;
                lastVisualOffset = nextVisualOffset;
            }
        }
        assert (wrapLine.endViewPart != null) : "Null endViewPart";
        indexAndAlloc.index = -2;
        indexAndAlloc.viewOrPart = wrapLine.endViewPart;
        indexAndAlloc.alloc = this.endPartAlloc(wrapLineAlloc, wrapLine, boxView);
        return indexAndAlloc;
    }

    private int findWrapLineIndex(Shape alloc, double y) {
        int wrapLineIndex;
        float wrapLineHeight;
        Rectangle2D allocRect = ViewUtils.shapeAsRect(alloc);
        double relY = y - allocRect.getY();
        if (relY < (double)(wrapLineHeight = this.wrapInfo.childrenHeight)) {
            wrapLineIndex = 0;
        } else {
            wrapLineIndex = (int)(relY / (double)wrapLineHeight);
            int wrapLineCount = this.wrapInfo.wrapLineCount();
            if (wrapLineIndex >= wrapLineCount) {
                wrapLineIndex = wrapLineCount - 1;
            }
        }
        return wrapLineIndex;
    }

    private int findWrapLineIndex(EditorBoxView<EditorView> boxView, int offset) {
        int wrapLineCount = this.wrapInfo.wrapLineCount();
        int wrapLineIndex = 0;
        WrapLine wrapLine = null;
        while (++wrapLineIndex < wrapLineCount && this.getWrapLineStartOffset(boxView, wrapLine = (WrapLine)this.wrapInfo.get(wrapLineIndex)) <= offset) {
        }
        return --wrapLineIndex;
    }

    private Rectangle2D.Double wrapLineAlloc(Shape alloc, int wrapLineIndex) {
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
        allocBounds.y += (double)((float)wrapLineIndex * this.wrapInfo.childrenHeight);
        allocBounds.height = this.wrapInfo.childrenHeight;
        return allocBounds;
    }

    private Shape startPartAlloc(Shape wrapLineAlloc, WrapLine wrapLine) {
        Rectangle2D.Double startPartBounds = ViewUtils.shape2Bounds(wrapLineAlloc);
        startPartBounds.width = wrapLine.startViewX;
        return startPartBounds;
    }

    private Shape endPartAlloc(Shape wrapLineAlloc, WrapLine wrapLine, EditorBoxView<EditorView> boxView) {
        Rectangle2D.Double endPartBounds = ViewUtils.shape2Bounds(wrapLineAlloc);
        endPartBounds.width = wrapLine.endViewPart.getPreferredSpan(0);
        endPartBounds.x += (double)wrapLine.startViewX;
        if (wrapLine.hasFullViews()) {
            endPartBounds.x += boxView.getViewVisualOffset(wrapLine.endViewIndex) - boxView.getViewVisualOffset(wrapLine.startViewIndex);
        }
        return endPartBounds;
    }

    private Shape viewAlloc(Shape wrapLineAlloc, WrapLine wrapLine, int viewIndex, EditorBoxView<EditorView> boxView) {
        double startViewVisualOffset = boxView.getViewVisualOffset(wrapLine.startViewIndex);
        double visualOffset = viewIndex != wrapLine.startViewIndex ? boxView.getViewVisualOffset(viewIndex) : startViewVisualOffset;
        Rectangle2D.Double viewBounds = ViewUtils.shape2Bounds(wrapLineAlloc);
        viewBounds.x += (double)wrapLine.startViewX + (visualOffset - startViewVisualOffset);
        viewBounds.width = boxView.getViewVisualOffset(viewIndex + 1) - visualOffset;
        return viewBounds;
    }

    private int getWrapLineStartOffset(EditorBoxView<EditorView> boxView, WrapLine wrapLine) {
        if (wrapLine.startViewPart != null) {
            return wrapLine.startViewPart.getStartOffset();
        }
        if (wrapLine.hasFullViews()) {
            return boxView.getView(wrapLine.startViewIndex).getStartOffset();
        }
        assert (wrapLine.endViewPart != null) : "Invalid wrapLine: " + wrapLine;
        return wrapLine.endViewPart.getStartOffset();
    }

    @Override
    public StringBuilder appendChildrenInfo(EditorBoxView<EditorView> boxView, StringBuilder sb, int indent, int importantIndex) {
        super.appendChildrenInfo(boxView, sb, indent, importantIndex);
        if (this.wrapInfo != null) {
            this.wrapInfo.appendInfo(sb, (ParagraphView)boxView, indent);
        }
        return sb;
    }

    private static final class ViewSearchResult {
        final EditorBoxView<EditorView> boxView;
        final double visualOffset;
        int index;
        EditorView view;
        TextLayoutPart textLayoutPart;

        public ViewSearchResult(EditorBoxView<EditorView> boxView, double visualOffset) {
            this.boxView = boxView;
            this.visualOffset = visualOffset;
        }

        TextLayout textLayout() {
            return this.textLayoutPart.textLayout();
        }
    }

    private static final class IndexAndAlloc {
        int index;
        EditorView viewOrPart;
        Shape alloc;

        private IndexAndAlloc() {
        }
    }
}

