/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.diff.builtin.provider.BuiltInDiffProvider;
import org.netbeans.modules.diff.cmdline.CmdlineDiffProvider;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class DiffModuleConfig {
    public static final String PREF_EXTERNAL_DIFF_COMMAND = "externalDiffCommand";
    private static final String PREF_IGNORE_LEADINGTRAILING_WHITESPACE = "ignoreWhitespace";
    private static final String PREF_IGNORE_INNER_WHITESPACE = "ignoreInnerWhitespace";
    private static final String PREF_IGNORE_CASE = "ignoreCase";
    private static final String PREF_USE_INTERNAL_DIFF = "useInternalDiff";
    private static final String PREF_ADDED_COLOR = "addedColor";
    private static final String PREF_CHANGED_COLOR = "changedColor";
    private static final String PREF_DELETED_COLOR = "deletedColor";
    private static final String PREF_MERGE_UNRESOLVED_COLOR = "merge.unresolvedColor";
    private static final String PREF_MERGE_APPLIED_COLOR = "merge.appliedColor";
    private static final String PREF_MERGE_NOTAPPLIED_COLOR = "merge.notappliedColor";
    private static final String PREF_SIDEBAR_DELETED_COLOR = "sidebar.deletedColor";
    private static final String PREF_SIDEBAR_CHANGED_COLOR = "sidebar.changedColor";
    private static final DiffModuleConfig INSTANCE = new DiffModuleConfig();
    private final Color defaultAddedColor = new Color(180, 255, 180);
    private final Color defaultChangedColor = new Color(160, 200, 255);
    private final Color defaultDeletedColor = new Color(255, 160, 180);
    private final Color defaultAppliedColor = new Color(180, 255, 180);
    private final Color defaultNotAppliedColor = new Color(160, 200, 255);
    private final Color defaultUnresolvedColor = new Color(255, 160, 180);
    private final Color defaultSidebarDeletedColor = new Color(255, 225, 232);
    private final Color defaultSidebarChangedColor = new Color(233, 241, 255);

    public static DiffModuleConfig getDefault() {
        return INSTANCE;
    }

    private DiffModuleConfig() {
    }

    public Color getAddedColor() {
        return this.getColor(PREF_ADDED_COLOR, this.defaultAddedColor);
    }

    public Color getChangedColor() {
        return this.getColor(PREF_CHANGED_COLOR, this.defaultChangedColor);
    }

    public Color getDeletedColor() {
        return this.getColor(PREF_DELETED_COLOR, this.defaultDeletedColor);
    }

    public Color getAppliedColor() {
        return this.getColor(PREF_MERGE_APPLIED_COLOR, this.defaultAppliedColor);
    }

    public Color getNotAppliedColor() {
        return this.getColor(PREF_MERGE_NOTAPPLIED_COLOR, this.defaultNotAppliedColor);
    }

    public Color getUnresolvedColor() {
        return this.getColor(PREF_MERGE_UNRESOLVED_COLOR, this.defaultUnresolvedColor);
    }

    public Color getSidebarDeletedColor() {
        return this.getColor(PREF_SIDEBAR_DELETED_COLOR, this.defaultSidebarDeletedColor);
    }

    public Color getSidebarChangedColor() {
        return this.getColor(PREF_SIDEBAR_CHANGED_COLOR, this.defaultSidebarChangedColor);
    }

    public void setChangedColor(Color changedColor) {
        this.putColor(PREF_CHANGED_COLOR, changedColor);
    }

    public void setAddedColor(Color addedColor) {
        this.putColor(PREF_ADDED_COLOR, addedColor);
    }

    public void setDeletedColor(Color deletedColor) {
        this.putColor(PREF_DELETED_COLOR, deletedColor);
    }

    public void setNotAppliedColor(Color notAppliedColor) {
        this.putColor(PREF_MERGE_NOTAPPLIED_COLOR, notAppliedColor);
    }

    public void setAppliedColor(Color appliedColor) {
        this.putColor(PREF_MERGE_APPLIED_COLOR, appliedColor);
    }

    public void setUnresolvedColor(Color unresolvedColor) {
        this.putColor(PREF_MERGE_UNRESOLVED_COLOR, unresolvedColor);
    }

    public void setSidebarDeletedColor(Color deletedColor) {
        this.putColor(PREF_SIDEBAR_DELETED_COLOR, deletedColor);
    }

    public void setSidebarChangedColor(Color changedColor) {
        this.putColor(PREF_SIDEBAR_CHANGED_COLOR, changedColor);
    }

    private void putColor(String key, Color color) {
        this.getPreferences().putInt(key, color.getRGB());
    }

    private Color getColor(String key, Color defaultColor) {
        int rgb = this.getPreferences().getInt(key, defaultColor.getRGB());
        return new Color(rgb);
    }

    public DiffProvider getDefaultDiffProvider() {
        Collection providers = Lookup.getDefault().lookup(new Lookup.Template(DiffProvider.class)).allInstances();
        for (DiffProvider p : providers) {
            if (this.isUseInteralDiff()) {
                if (!(p instanceof BuiltInDiffProvider)) continue;
                ((BuiltInDiffProvider)p).setOptions(this.getOptions());
                return p;
            }
            if (!(p instanceof CmdlineDiffProvider)) continue;
            ((CmdlineDiffProvider)p).setDiffCommand(this.getDiffCommand());
            return p;
        }
        return null;
    }

    private void setDefaultProvider(DiffProvider ds) {
        FileObject services = FileUtil.getConfigFile((String)"Services/DiffProviders");
        DataFolder df = DataFolder.findFolder((FileObject)services);
        DataObject[] children = df.getChildren();
        for (int i = 0; i < children.length; ++i) {
            InstanceDataObject ido;
            if (!(children[i] instanceof InstanceDataObject) || !(ido = (InstanceDataObject)children[i]).instanceOf(ds.getClass())) continue;
            try {
                if (!ds.equals(ido.instanceCreate())) continue;
                df.setOrder(new DataObject[]{ido});
                break;
            }
            catch (IOException ioex) {
                continue;
            }
            catch (ClassNotFoundException cnfex) {
                // empty catch block
            }
        }
    }

    private String getDiffCommand() {
        return this.getPreferences().get(PREF_EXTERNAL_DIFF_COMMAND, "diff {0} {1}");
    }

    public void setOptions(BuiltInDiffProvider.Options options) {
        this.getPreferences().putBoolean(PREF_IGNORE_LEADINGTRAILING_WHITESPACE, options.ignoreLeadingAndtrailingWhitespace);
        this.getPreferences().putBoolean(PREF_IGNORE_INNER_WHITESPACE, options.ignoreInnerWhitespace);
        this.getPreferences().putBoolean(PREF_IGNORE_CASE, options.ignoreCase);
        this.getBuiltinProvider().setOptions(options);
    }

    public BuiltInDiffProvider.Options getOptions() {
        BuiltInDiffProvider.Options options = new BuiltInDiffProvider.Options();
        options.ignoreLeadingAndtrailingWhitespace = this.getPreferences().getBoolean(PREF_IGNORE_LEADINGTRAILING_WHITESPACE, true);
        options.ignoreInnerWhitespace = this.getPreferences().getBoolean(PREF_IGNORE_INNER_WHITESPACE, false);
        options.ignoreCase = this.getPreferences().getBoolean(PREF_IGNORE_CASE, false);
        return options;
    }

    private BuiltInDiffProvider getBuiltinProvider() {
        Collection diffs = Lookup.getDefault().lookupAll(DiffProvider.class);
        for (DiffProvider diff : diffs) {
            if (!(diff instanceof BuiltInDiffProvider)) continue;
            return (BuiltInDiffProvider)diff;
        }
        throw new IllegalStateException("No builtin diff provider");
    }

    public void setUseInteralDiff(boolean useInternal) {
        this.getPreferences().putBoolean(PREF_USE_INTERNAL_DIFF, useInternal);
        Collection diffs = Lookup.getDefault().lookupAll(DiffProvider.class);
        if (useInternal) {
            this.setDefaultProvider(this.getBuiltinProvider());
        } else {
            for (DiffProvider diff : diffs) {
                if (!(diff instanceof CmdlineDiffProvider)) continue;
                this.setDefaultProvider(diff);
                break;
            }
        }
    }

    public boolean isUseInteralDiff() {
        return this.getPreferences().getBoolean(PREF_USE_INTERNAL_DIFF, true);
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(DiffModuleConfig.class);
    }

    public int getSpacesPerTabFor(String mimeType) {
        int spacesPerTab = 1;
        Preferences pref = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        if (pref != null) {
            spacesPerTab = pref.getInt("tab-size", 1);
        }
        return spacesPerTab;
    }
}

