/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.support.APTIncludeResolverImpl;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTFileSearch;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class APTIncludeHandlerImpl
implements APTIncludeHandler {
    private List<IncludeDirEntry> systemIncludePaths;
    private List<IncludeDirEntry> userIncludePaths;
    private List<IncludeDirEntry> userIncludeFilePaths;
    private Map<CharSequence, Integer> recurseIncludes = null;
    private static final int MAX_INCLUDE_DEEP = 4;
    private LinkedList<APTIncludeHandler.IncludeInfo> inclStack = null;
    private StartEntry startFile;
    private final APTFileSearch fileSearch;

    APTIncludeHandlerImpl(StartEntry startFile) {
        this(startFile, new ArrayList<IncludeDirEntry>(0), new ArrayList<IncludeDirEntry>(0), new ArrayList<IncludeDirEntry>(0), startFile.getFileSearch());
    }

    public APTIncludeHandlerImpl(StartEntry startFile, List<IncludeDirEntry> systemIncludePaths, List<IncludeDirEntry> userIncludePaths, List<IncludeDirEntry> userIncludeFilePaths, APTFileSearch fileSearch) {
        this.startFile = startFile;
        this.systemIncludePaths = systemIncludePaths;
        this.userIncludePaths = userIncludePaths;
        this.userIncludeFilePaths = userIncludeFilePaths;
        this.fileSearch = fileSearch;
    }

    @Override
    public APTIncludeHandler.IncludeState pushInclude(CharSequence path, APTInclude aptInclude, int resolvedDirIndex) {
        return this.pushIncludeImpl(path, aptInclude.getToken().getLine(), aptInclude.getToken().getOffset(), resolvedDirIndex);
    }

    @Override
    public CharSequence popInclude() {
        return this.popIncludeImpl();
    }

    @Override
    public APTIncludeResolver getResolver(FileSystem fs, CharSequence path) {
        return new APTIncludeResolverImpl(fs, path, this.getCurDirIndex(), this.systemIncludePaths, this.userIncludePaths, this.fileSearch);
    }

    @Override
    public StartEntry getStartEntry() {
        return this.startFile;
    }

    private CharSequence getCurPath() {
        assert (this.inclStack != null);
        APTIncludeHandler.IncludeInfo info = this.inclStack.getLast();
        return info.getIncludedPath();
    }

    private int getCurDirIndex() {
        if (this.inclStack != null && !this.inclStack.isEmpty()) {
            APTIncludeHandler.IncludeInfo info = this.inclStack.getLast();
            return info.getIncludedDirIndex();
        }
        return 0;
    }

    @Override
    public APTIncludeHandler.State getState() {
        return this.createStateImpl();
    }

    @Override
    public void setState(APTIncludeHandler.State state) {
        if (state instanceof StateImpl) {
            StateImpl stateImpl = (StateImpl)state;
            assert (!stateImpl.isCleaned());
            stateImpl.restoreTo(this);
        }
    }

    private StateImpl createStateImpl() {
        return new StateImpl(this);
    }

    List<IncludeDirEntry> getUserIncludeFilePaths() {
        return Collections.unmodifiableList(this.userIncludeFilePaths);
    }

    boolean isFirstLevel() {
        return this.inclStack == null || this.inclStack.isEmpty();
    }

    private APTIncludeHandler.IncludeState pushIncludeImpl(CharSequence path, int directiveLine, int directiveOffset, int resolvedDirIndex) {
        if (this.recurseIncludes == null) {
            assert (this.inclStack == null) : this.inclStack.toString() + " started on " + this.startFile;
            this.inclStack = new LinkedList();
            this.recurseIncludes = new HashMap<CharSequence, Integer>();
        }
        assert (CharSequences.isCompact((CharSequence)path)) : "must be char sequence key " + path;
        Integer counter = this.recurseIncludes.get(path);
        Integer n = counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
        if (counter < 4) {
            this.recurseIncludes.put(path, counter);
            this.inclStack.addLast(new IncludeInfoImpl(path, directiveLine, directiveOffset, resolvedDirIndex));
            return APTIncludeHandler.IncludeState.Success;
        }
        assert (this.recurseIncludes.get(path) != null) : "included file must be in map";
        APTUtils.LOG.log(Level.WARNING, "RECURSIVE inclusion:\n\t{0}\n\tin {1}\n", new Object[]{path, this.getCurPath()});
        return APTIncludeHandler.IncludeState.Recursive;
    }

    private CharSequence popIncludeImpl() {
        assert (this.inclStack != null);
        assert (!this.inclStack.isEmpty());
        assert (this.recurseIncludes != null);
        APTIncludeHandler.IncludeInfo inclInfo = this.inclStack.removeLast();
        CharSequence path = inclInfo.getIncludedPath();
        Integer counter = this.recurseIncludes.remove(path);
        assert (counter != null) : "must be added before";
        counter = counter - 1;
        assert (counter >= 0) : "can't be negative";
        if (counter != 0) {
            this.recurseIncludes.put(path, counter);
        }
        return path;
    }

    public String toString() {
        return APTIncludeHandlerImpl.toString(this.startFile.getStartFile(), this.systemIncludePaths, this.userIncludePaths, this.userIncludeFilePaths, this.recurseIncludes, this.inclStack);
    }

    private static String toString(CharSequence startFile, List<IncludeDirEntry> systemIncludePaths, List<IncludeDirEntry> userIncludePaths, List<IncludeDirEntry> userIncludeFilePaths, Map<CharSequence, Integer> recurseIncludes, LinkedList<APTIncludeHandler.IncludeInfo> inclStack) {
        StringBuilder retValue = new StringBuilder();
        if (!userIncludeFilePaths.isEmpty()) {
            retValue.append("User File Includes:\n");
            retValue.append(APTUtils.includes2String(userIncludeFilePaths));
        }
        retValue.append("User includes:\n");
        retValue.append(APTUtils.includes2String(userIncludePaths));
        retValue.append("\nSys includes:\n");
        retValue.append(APTUtils.includes2String(systemIncludePaths));
        retValue.append("\nInclude Stack starting from:\n");
        retValue.append(startFile).append("\n");
        retValue.append(APTIncludeHandlerImpl.includesStack2String(inclStack));
        return retValue.toString();
    }

    private static String includesStack2String(LinkedList<APTIncludeHandler.IncludeInfo> inclStack) {
        StringBuilder retValue = new StringBuilder();
        if (inclStack == null) {
            retValue.append("<not from #include>");
        } else {
            Iterator it = inclStack.iterator();
            while (it.hasNext()) {
                APTIncludeHandler.IncludeInfo info = (APTIncludeHandler.IncludeInfo)it.next();
                retValue.append(info);
                if (!it.hasNext()) continue;
                retValue.append("->\n");
            }
        }
        return retValue.toString();
    }

    private static final class IncludeInfoImpl
    implements APTIncludeHandler.IncludeInfo,
    SelfPersistent,
    Persistent {
        private final CharSequence path;
        private final int directiveLine;
        private final int directiveOffset;
        private final int resolvedDirIndex;

        public IncludeInfoImpl(CharSequence path, int directiveLine, int directiveOffset, int resolvedDirIndex) {
            assert (path != null);
            this.path = path;
            assert (directiveLine >= 0);
            this.directiveLine = directiveLine;
            this.directiveOffset = directiveOffset;
            this.resolvedDirIndex = resolvedDirIndex;
        }

        public IncludeInfoImpl(RepositoryDataInput input) throws IOException {
            assert (input != null);
            this.path = FilePathCache.getManager().getString(input.readCharSequenceUTF());
            this.directiveLine = input.readInt();
            this.directiveOffset = input.readInt();
            this.resolvedDirIndex = input.readInt();
        }

        @Override
        public CharSequence getIncludedPath() {
            return this.path;
        }

        @Override
        public int getIncludeDirectiveLine() {
            return this.directiveLine;
        }

        @Override
        public int getIncludeDirectiveOffset() {
            return this.directiveOffset;
        }

        public String toString() {
            String retValue = "(" + this.getIncludeDirectiveLine() + "/" + this.getIncludeDirectiveOffset() + ": " + this.getIncludedPath() + ":" + this.getIncludedDirIndex() + ")";
            return retValue;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            IncludeInfoImpl other = (IncludeInfoImpl)obj;
            return this.directiveLine == other.directiveLine && this.directiveOffset == other.directiveOffset && this.path.equals(other.path) && this.resolvedDirIndex == other.resolvedDirIndex;
        }

        public int hashCode() {
            int hash = 3;
            hash = 73 * hash + (this.path != null ? this.path.hashCode() : 0);
            hash = 73 * hash + this.directiveLine;
            hash = 73 * hash + this.directiveOffset;
            hash = 73 * hash + this.resolvedDirIndex;
            return hash;
        }

        public void write(RepositoryDataOutput output) throws IOException {
            assert (output != null);
            output.writeCharSequenceUTF((CharSequence)((Object)this.path).toString());
            output.writeInt(this.directiveLine);
            output.writeInt(this.directiveOffset);
            output.writeInt(this.resolvedDirIndex);
        }

        @Override
        public int getIncludedDirIndex() {
            return this.resolvedDirIndex;
        }
    }

    public static final class StateImpl
    implements APTIncludeHandler.State,
    Persistent,
    SelfPersistent {
        private final List<IncludeDirEntry> systemIncludePaths;
        private final List<IncludeDirEntry> userIncludePaths;
        private final List<IncludeDirEntry> userIncludeFilePaths;
        private final StartEntry startFile;
        private final Map<CharSequence, Integer> recurseIncludes;
        private final LinkedList<APTIncludeHandler.IncludeInfo> inclStack;
        private int hashCode = 0;

        protected StateImpl(APTIncludeHandlerImpl handler) {
            this.systemIncludePaths = handler.systemIncludePaths;
            this.userIncludePaths = handler.userIncludePaths;
            this.userIncludeFilePaths = handler.userIncludeFilePaths;
            this.startFile = handler.startFile;
            if (handler.recurseIncludes != null && !handler.recurseIncludes.isEmpty()) {
                assert (handler.inclStack != null && !handler.inclStack.isEmpty()) : "must be in sync with inclStack";
                this.recurseIncludes = new HashMap<CharSequence, Integer>(handler.recurseIncludes);
            } else {
                this.recurseIncludes = null;
            }
            if (handler.inclStack != null && !handler.inclStack.isEmpty()) {
                assert (handler.recurseIncludes != null && !handler.recurseIncludes.isEmpty()) : "must be in sync with recurseIncludes";
                this.inclStack = new LinkedList(handler.inclStack);
            } else {
                this.inclStack = null;
            }
        }

        private StateImpl(StateImpl other, boolean cleanState) {
            this.startFile = other.startFile;
            this.inclStack = other.inclStack;
            if (cleanState) {
                this.systemIncludePaths = Collections.emptyList();
                this.userIncludePaths = Collections.emptyList();
                this.userIncludeFilePaths = Collections.emptyList();
                this.recurseIncludes = null;
            } else {
                this.systemIncludePaths = other.systemIncludePaths;
                this.userIncludePaths = other.userIncludePaths;
                this.userIncludeFilePaths = other.userIncludeFilePaths;
                this.recurseIncludes = other.recurseIncludes;
            }
        }

        int getIncludeStackDepth() {
            return this.inclStack == null ? 0 : this.inclStack.size();
        }

        private void restoreTo(APTIncludeHandlerImpl handler) {
            handler.userIncludePaths = this.userIncludePaths;
            handler.userIncludeFilePaths = this.userIncludeFilePaths;
            handler.systemIncludePaths = this.systemIncludePaths;
            handler.startFile = this.startFile;
            if (!this.isCleaned()) {
                if (this.recurseIncludes != null) {
                    handler.recurseIncludes = new HashMap();
                    handler.recurseIncludes.putAll(this.recurseIncludes);
                }
                if (this.inclStack != null) {
                    handler.inclStack = new LinkedList();
                    handler.inclStack.addAll(this.inclStack);
                }
            }
        }

        public String toString() {
            return APTIncludeHandlerImpl.toString(this.startFile.getStartFile(), this.systemIncludePaths, this.userIncludePaths, this.userIncludeFilePaths, this.recurseIncludes, this.inclStack);
        }

        public void write(RepositoryDataOutput output) throws IOException {
            int i;
            assert (output != null);
            this.startFile.write(output);
            assert (this.systemIncludePaths != null);
            assert (this.userIncludePaths != null);
            int size = this.systemIncludePaths.size();
            output.writeInt(size);
            for (i = 0; i < size; ++i) {
                output.writeCharSequenceUTF(this.systemIncludePaths.get(i).getAsSharedCharSequence());
            }
            size = this.userIncludePaths.size();
            output.writeInt(size);
            for (i = 0; i < size; ++i) {
                output.writeCharSequenceUTF(this.userIncludePaths.get(i).getAsSharedCharSequence());
            }
            size = this.userIncludeFilePaths.size();
            output.writeInt(size);
            for (i = 0; i < size; ++i) {
                output.writeCharSequenceUTF(this.userIncludeFilePaths.get(i).getAsSharedCharSequence());
            }
            if (this.recurseIncludes == null) {
                output.writeInt(-1);
            } else {
                Set<Map.Entry<CharSequence, Integer>> entrySet = this.recurseIncludes.entrySet();
                assert (entrySet != null);
                Iterator<Map.Entry<CharSequence, Integer>> setIterator = entrySet.iterator();
                assert (setIterator != null);
                output.writeInt(entrySet.size());
                while (setIterator.hasNext()) {
                    Map.Entry<CharSequence, Integer> entry = setIterator.next();
                    assert (entry != null);
                    output.writeUTF(((Object)entry.getKey()).toString());
                    output.writeInt(entry.getValue().intValue());
                }
            }
            if (this.inclStack == null) {
                output.writeInt(-1);
            } else {
                size = this.inclStack.size();
                output.writeInt(size);
                for (APTIncludeHandler.IncludeInfo inclInfo : this.inclStack) {
                    assert (inclInfo != null);
                    IncludeInfoImpl inclInfoImpl = new IncludeInfoImpl(inclInfo.getIncludedPath(), inclInfo.getIncludeDirectiveLine(), inclInfo.getIncludeDirectiveOffset(), inclInfo.getIncludedDirIndex());
                    assert (inclInfoImpl != null);
                    inclInfoImpl.write(output);
                }
            }
        }

        public StateImpl(FileSystem fs, RepositoryDataInput input) throws IOException {
            IncludeDirEntry path;
            int i;
            assert (input != null);
            APTStringManager pathManager = FilePathCache.getManager();
            this.startFile = new StartEntry(fs, input);
            int size = input.readInt();
            this.systemIncludePaths = new ArrayList<IncludeDirEntry>(size);
            for (i = 0; i < size; ++i) {
                path = IncludeDirEntry.get(fs, input.readUTF());
                this.systemIncludePaths.add(i, path);
            }
            size = input.readInt();
            this.userIncludePaths = new ArrayList<IncludeDirEntry>(size);
            for (i = 0; i < size; ++i) {
                path = IncludeDirEntry.get(fs, input.readUTF());
                this.userIncludePaths.add(i, path);
            }
            size = input.readInt();
            this.userIncludeFilePaths = new ArrayList<IncludeDirEntry>(size);
            for (i = 0; i < size; ++i) {
                path = IncludeDirEntry.get(fs, input.readUTF());
                this.userIncludeFilePaths.add(i, path);
            }
            size = input.readInt();
            if (size == -1) {
                this.recurseIncludes = null;
            } else {
                this.recurseIncludes = new HashMap<CharSequence, Integer>();
                for (i = 0; i < size; ++i) {
                    CharSequence key = pathManager.getString((CharSequence)input.readUTF());
                    Integer value = input.readInt();
                    this.recurseIncludes.put(key, value);
                }
            }
            size = input.readInt();
            if (size == -1) {
                this.inclStack = null;
            } else {
                this.inclStack = new LinkedList();
                for (i = 0; i < size; ++i) {
                    IncludeInfoImpl impl = new IncludeInfoImpl(input);
                    assert (impl != null);
                    this.inclStack.add(i, impl);
                }
            }
        }

        final StartEntry getStartEntry() {
            return this.startFile;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return this.startFile.equals(other.startFile) && this.compareStacks(this.inclStack, other.inclStack);
        }

        public int hashCode() {
            int hash = this.hashCode;
            if (hash == 0) {
                hash = 5;
                hash = 67 * hash + (this.startFile != null ? this.startFile.hashCode() : 0);
                this.hashCode = hash = 67 * hash + (this.inclStack != null ? this.inclStack.hashCode() : 0);
            }
            return hash;
        }

        private boolean compareStacks(LinkedList<APTIncludeHandler.IncludeInfo> inclStack1, LinkedList<APTIncludeHandler.IncludeInfo> inclStack2) {
            if (inclStack1 != null) {
                int size = inclStack1.size();
                if (inclStack2 == null || inclStack2.size() != size) {
                    return false;
                }
                Iterator it1 = inclStack1.iterator();
                Iterator it2 = inclStack2.iterator();
                while (it1.hasNext()) {
                    APTIncludeHandler.IncludeInfo cur2;
                    APTIncludeHandler.IncludeInfo cur1 = (APTIncludeHandler.IncludeInfo)it1.next();
                    if (cur1.equals(cur2 = (APTIncludeHandler.IncludeInfo)it2.next())) continue;
                    return false;
                }
                return true;
            }
            return inclStack2 == null;
        }

        LinkedList<APTIncludeHandler.IncludeInfo> getIncludeStack() {
            return this.inclStack;
        }

        boolean isCleaned() {
            return this.recurseIncludes == null && this.inclStack != null;
        }

        APTIncludeHandler.State copy(boolean cleanState) {
            return new StateImpl(this, cleanState);
        }

        List<IncludeDirEntry> getSysIncludePaths() {
            return this.systemIncludePaths;
        }

        List<IncludeDirEntry> getUserIncludePaths() {
            return this.userIncludePaths;
        }

        List<IncludeDirEntry> getUserIncludeFilePaths() {
            return this.userIncludeFilePaths;
        }
    }
}

