/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoTable;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.MACINFO;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfMacroInfoSection
extends ElfSection {
    private final HashMap<Long, DwarfMacinfoTable> macinfoTables = new HashMap();

    public DwarfMacroInfoSection(DwarfReader reader, int sectionIdx) {
        super(reader, sectionIdx);
    }

    public DwarfMacinfoTable getMacinfoTable(long offset) {
        Long lOffset = offset;
        DwarfMacinfoTable table = this.macinfoTables.get(lOffset);
        if (table == null) {
            table = new DwarfMacinfoTable(this, offset);
            this.macinfoTables.put(lOffset, table);
        }
        return table;
    }

    public long readMacinfoTable(DwarfMacinfoTable table, long offset, boolean baseOnly) throws IOException {
        long currPos = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset() + offset);
        MACINFO type = MACINFO.get(this.reader.readByte());
        if (baseOnly && type.equals((Object)MACINFO.DW_MACINFO_start_file)) {
            long lineNum = this.reader.readUnsignedLEB128();
            if (lineNum == 0L) {
                long fileIdx = this.reader.readUnsignedLEB128();
            } else {
                this.reader.seek(this.header.getSectionOffset() + offset);
            }
            type = MACINFO.get(this.reader.readByte());
        }
        Stack<Integer> fileIndeces = new Stack<Integer>();
        int fileIdx = -1;
        while (type != null && (!baseOnly || baseOnly && fileIdx == -1)) {
            DwarfMacinfoEntry entry = new DwarfMacinfoEntry(type);
            if (type.equals((Object)MACINFO.DW_MACINFO_define) || type.equals((Object)MACINFO.DW_MACINFO_undef)) {
                entry.lineNum = this.reader.readUnsignedLEB128();
                entry.definition = this.reader.readString();
                entry.fileIdx = fileIdx;
            } else if (type.equals((Object)MACINFO.DW_MACINFO_start_file)) {
                if (baseOnly) break;
                entry.lineNum = this.reader.readUnsignedLEB128();
                entry.fileIdx = this.reader.readUnsignedLEB128();
                fileIndeces.push(fileIdx);
                fileIdx = entry.fileIdx;
            } else if (type.equals((Object)MACINFO.DW_MACINFO_end_file)) {
                if (!fileIndeces.empty()) {
                    fileIdx = (Integer)fileIndeces.pop();
                }
            } else if (type.equals((Object)MACINFO.DW_MACINFO_vendor_ext)) {
                this.reader.readUnsignedLEB128();
                this.reader.readString();
            }
            table.addEntry(entry);
            type = MACINFO.get(this.reader.readByte());
        }
        long readBytes = this.reader.getFilePointer() - (this.header.getSectionOffset() + offset + 1L);
        this.reader.seek(currPos);
        return readBytes;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<Integer> getCommandIncudedFiles(DwarfMacinfoTable table, long offset) throws IOException {
        ArrayList<Integer> res = new ArrayList<Integer>();
        long currPos = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset() + offset);
        int level = 0;
        MACINFO type;
        while ((type = MACINFO.get(this.reader.readByte())) != null) {
            switch (type) {
                case DW_MACINFO_start_file: {
                    int lineNum = this.reader.readUnsignedLEB128();
                    int fileIdx = this.reader.readUnsignedLEB128();
                    if (++level != 1) break;
                    if (lineNum != 0) return res;
                    res.add(fileIdx);
                    break;
                }
                case DW_MACINFO_end_file: {
                    --level;
                    break;
                }
                case DW_MACINFO_vendor_ext: {
                    this.reader.readUnsignedLEB128();
                    this.reader.readString();
                    break;
                }
                case DW_MACINFO_define: 
                case DW_MACINFO_undef: {
                    int lineNum = this.reader.readUnsignedLEB128();
                    this.reader.readString();
                }
            }
        }
        return res;
    }

    @Override
    public void dump(PrintStream out) {
        super.dump(out);
        for (DwarfMacinfoTable macinfoTable : this.macinfoTables.values()) {
            macinfoTable.dump(out);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }
}

