/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public final class MyRandomAccessFile
extends RandomAccessFile {
    private MappedByteBuffer buffer;
    private long bufferShift = 0L;
    private long bufferSize;
    private final FileChannel channel = this.getChannel();

    public MyRandomAccessFile(String fileName) throws IOException {
        super(fileName, "r");
        this.bufferSize = Math.min(this.channel.size(), 0x7FFFFFFEL);
        try {
            this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferShift, this.bufferSize);
        }
        catch (IOException ex) {
            this.channel.close();
            this.close();
            throw ex;
        }
    }

    public int read() throws IOException {
        if (this.buffer.remaining() == 0) {
            if (this.bufferShift + this.bufferSize < this.channel.size()) {
                long position = this.bufferShift + this.bufferSize;
                this.bufferShift += 0x3FFFFFFFL;
                this.bufferSize = Math.min(this.channel.size() - this.bufferShift, 0x7FFFFFFEL);
                ByteOrder order = this.buffer.order();
                this.buffer.clear();
                this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferShift, this.bufferSize);
                this.buffer.order(order);
                this.buffer.position((int)(position - this.bufferShift));
                return this.read();
            }
            return -1;
        }
        return 0xFF & this.buffer.get();
    }

    public MappedByteBuffer getBuffer() {
        return this.buffer;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.buffer.get(b, off, len);
        return len;
    }

    public long getFilePointer() throws IOException {
        return (long)this.buffer.position() + this.bufferShift;
    }

    public void seek(long pos) throws IOException {
        long filePointer = this.getFilePointer();
        if (pos == filePointer) {
            return;
        }
        if (pos == this.channel.size()) {
            return;
        }
        if (pos >= this.bufferShift && pos < this.bufferShift + this.bufferSize) {
            this.buffer.position((int)(pos - this.bufferShift));
        } else {
            this.bufferShift = Math.max(pos - 0x3FFFFFFFL, 0L);
            this.bufferSize = Math.min(this.channel.size() - this.bufferShift, 0x7FFFFFFEL);
            ByteOrder order = this.buffer.order();
            this.buffer.clear();
            this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferShift, this.bufferSize);
            this.buffer.order(order);
            this.buffer.position((int)(pos - this.bufferShift));
        }
    }

    public void dispose() {
        try {
            this.buffer.clear();
            this.channel.close();
            this.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

