/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.FileMagic;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.MemberHeader;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.reader.MyRandomAccessFile;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.trace.TraceDwarf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dwarf {
    private DwarfReader dwarfReader;
    private List<MemberHeader> offsets;
    private FileMagic magic;
    private String fileName;
    private List<FileMagic> toDispose = new ArrayList<FileMagic>();
    private final Mode mode;

    public Dwarf(String objFileName) throws IOException {
        if (TraceDwarf.TRACED) {
            System.out.println("\n**** Dwarfing " + objFileName + "\n");
        }
        this.fileName = objFileName;
        try {
            this.magic = new FileMagic(objFileName);
            if (this.magic.getMagic() == Magic.Arch) {
                this.skipFirstHeader(this.magic.getReader());
                this.offsets = this.getObjectTable(this.magic.getReader());
                if (this.offsets.isEmpty()) {
                    throw new WrongFileFormatException("Not an ELF file");
                }
                this.mode = Mode.Archive;
            } else {
                this.dwarfReader = new DwarfReader(objFileName, this.magic.getReader(), this.magic.getMagic(), 0L, this.magic.getReader().length());
                if (this.dwarfReader.getLinkedObjectFiles().size() > 0) {
                    File dSYM = new File(objFileName + ".dSYM/Contents/Resources/DWARF/" + new File(objFileName).getName());
                    if (dSYM.exists()) {
                        this.dwarfReader.setdSYM(dSYM.getAbsolutePath());
                    }
                    this.mode = Mode.MachoLOF;
                } else {
                    this.mode = Mode.Normal;
                }
            }
        }
        catch (IOException ex) {
            this.dispose();
            throw ex;
        }
    }

    public final void dispose() {
        if (this.magic != null) {
            this.magic.dispose();
            this.magic = null;
        }
        for (FileMagic file : this.toDispose) {
            file.dispose();
        }
        this.toDispose.clear();
    }

    public ElfSection getSection(String sectionName) {
        return this.dwarfReader.getSection(sectionName);
    }

    public ElfReader.SharedLibraries readPubNames() throws IOException {
        return this.dwarfReader.readPubNames();
    }

    public String getFileName() {
        return this.fileName;
    }

    public Iterator<CompilationUnit> iteratorCompilationUnits() throws IOException {
        if (this.mode == Mode.Archive) {
            return new ArchiveIterator(this.magic.getReader());
        }
        if (this.mode == Mode.Normal) {
            return this.iteratorFileCompilationUnits();
        }
        return new MacArchiveIterator();
    }

    public List<CompilationUnit> getCompilationUnits() throws IOException {
        if (this.mode == Mode.Archive) {
            return this.getArchiveCompilationUnits(this.magic.getReader());
        }
        if (this.mode == Mode.Normal) {
            return this.getFileCompilationUnits();
        }
        return this.getMachoLOFCompilationUnits();
    }

    private void skipFirstHeader(RandomAccessFile reader) throws IOException {
        byte c;
        reader.seek(8L);
        byte[] next = new byte[60];
        reader.readFully(next);
        int length = 0;
        for (int i = 0; i < 10 && (c = next[i + 48]) != 32; ++i) {
            length *= 10;
            length += c - 48;
        }
        reader.skipBytes(length);
    }

    private List<MemberHeader> getObjectTable(RandomAccessFile reader) throws IOException {
        byte[] next = new byte[60];
        ArrayList<MemberHeader> offsetsList = new ArrayList<MemberHeader>();
        while (reader.getFilePointer() + 60L < reader.length()) {
            reader.readFully(next);
            int length = this.readNumber(next, 48);
            int nameLength = 0;
            if (next[0] == 47 && next[1] == 47) {
                reader.skipBytes(length);
                continue;
            }
            if (next[0] == 35 && next[1] == 49 && next[2] == 47) {
                nameLength = this.readNumber(next, 3);
                reader.skipBytes(nameLength);
            } else if (next[0] == 10) break;
            long pointer = reader.getFilePointer();
            byte[] bytes = new byte[8];
            reader.readFully(bytes);
            if (FileMagic.isElfMagic(bytes) || FileMagic.isCoffMagic(bytes) || FileMagic.isMachoMagic(bytes)) {
                offsetsList.add(new MemberHeader(pointer, length));
            }
            reader.skipBytes(length - 8 - nameLength);
            if (length % 2 != 1) continue;
            reader.skipBytes(1);
        }
        return offsetsList;
    }

    private int readNumber(byte[] next, int shift) {
        byte c;
        int length = 0;
        for (int i = 0; i < 10 && (c = next[i + shift]) != 32; ++i) {
            length *= 10;
            length += c - 48;
        }
        return length;
    }

    private List<CompilationUnit> getFileCompilationUnits() throws IOException {
        DwarfDebugInfoSection debugInfo = (DwarfDebugInfoSection)this.dwarfReader.getSection(".debug_info");
        List<CompilationUnit> result = null;
        result = debugInfo != null ? debugInfo.getCompilationUnits() : new LinkedList<CompilationUnit>();
        return result;
    }

    private Iterator<CompilationUnit> iteratorFileCompilationUnits() throws IOException {
        DwarfDebugInfoSection debugInfo = (DwarfDebugInfoSection)this.dwarfReader.getSection(".debug_info");
        Iterator<CompilationUnit> result = null;
        result = debugInfo != null ? debugInfo.iteratorCompilationUnits() : new LinkedList().iterator();
        return result;
    }

    private List<CompilationUnit> getMachoLOFCompilationUnits() throws IOException {
        LinkedList<CompilationUnit> result = new LinkedList<CompilationUnit>();
        for (String string : this.dwarfReader.getLinkedObjectFiles()) {
            Dwarf gimli = new Dwarf(string);
            result.addAll(gimli.getCompilationUnits());
            this.toDispose.add(gimli.magic);
        }
        return result;
    }

    private List<CompilationUnit> getArchiveCompilationUnits(MyRandomAccessFile reader) throws IOException {
        LinkedList<CompilationUnit> result = new LinkedList<CompilationUnit>();
        for (MemberHeader member : this.offsets) {
            long shiftIvArchive = member.getOffset();
            int length = member.getLength();
            reader.seek(shiftIvArchive);
            byte[] bytes = new byte[8];
            reader.readFully(bytes);
            if (FileMagic.isElfMagic(bytes)) {
                this.dwarfReader = new DwarfReader(this.fileName, reader, Magic.Elf, shiftIvArchive, length);
            } else if (FileMagic.isCoffMagic(bytes)) {
                this.dwarfReader = new DwarfReader(this.fileName, reader, Magic.Coff, shiftIvArchive, length);
            } else if (FileMagic.isMachoMagic(bytes)) {
                this.dwarfReader = new DwarfReader(this.fileName, reader, Magic.Macho, shiftIvArchive, length);
            }
            result.addAll(this.getFileCompilationUnits());
        }
        return result;
    }

    public static String fileFinder(String binaryPath, String path) {
        if ((binaryPath = binaryPath.replace('\\', '/')).startsWith("/")) {
            binaryPath = binaryPath.substring(1);
        }
        if ((path = path.replace('\\', '/')).startsWith("/")) {
            path = path.substring(1);
        }
        String[] splitReal = binaryPath.split("/");
        String[] splitVirtual = path.split("/");
        for (int i = 0; i < splitReal.length; ++i) {
            int startReal = -1;
            int startVirtual = -1;
            int len = -1;
            for (int j = 0; j < splitVirtual.length; ++j) {
                int k;
                if (!splitReal[i].equals(splitVirtual[j])) continue;
                startReal = i;
                startVirtual = j;
                len = 1;
                while (startReal + len < splitReal.length && startVirtual + len < splitVirtual.length && splitReal[startReal + len].equals(splitVirtual[startVirtual + len])) {
                    ++len;
                }
                if (len <= 1 && startVirtual != splitVirtual.length - 2) continue;
                StringBuilder buf = new StringBuilder();
                for (k = 0; k < startReal + len; ++k) {
                    buf.append('/').append(splitReal[k]);
                }
                for (k = startVirtual + len; k < splitVirtual.length; ++k) {
                    buf.append('/').append(splitVirtual[k]);
                }
                return buf.toString();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArchiveIterator
    implements Iterator<CompilationUnit> {
        private int archiveIndex = 0;
        private MyRandomAccessFile reader;
        private Iterator<CompilationUnit> currentIterator;

        public ArchiveIterator(MyRandomAccessFile reader) throws IOException {
            this.reader = reader;
            this.advanceArchive();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            try {
                this.advanceArchive();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            return this.currentIterator != null;
        }

        @Override
        public CompilationUnit next() {
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceArchive() throws IOException {
            block7: {
                while (this.archiveIndex < Dwarf.this.offsets.size()) {
                    block6: {
                        MemberHeader member = (MemberHeader)Dwarf.this.offsets.get(this.archiveIndex);
                        ++this.archiveIndex;
                        long shiftIvArchive = member.getOffset();
                        int length = member.getLength();
                        this.reader.seek(shiftIvArchive);
                        byte[] bytes = new byte[8];
                        this.reader.readFully(bytes);
                        try {
                            if (FileMagic.isElfMagic(bytes)) {
                                Dwarf.this.dwarfReader = new DwarfReader(Dwarf.this.fileName, this.reader, Magic.Elf, shiftIvArchive, length);
                                break block6;
                            }
                            if (FileMagic.isCoffMagic(bytes)) {
                                Dwarf.this.dwarfReader = new DwarfReader(Dwarf.this.fileName, this.reader, Magic.Coff, shiftIvArchive, length);
                                break block6;
                            }
                            if (!FileMagic.isMachoMagic(bytes)) break block6;
                            Dwarf.this.dwarfReader = new DwarfReader(Dwarf.this.fileName, this.reader, Magic.Macho, shiftIvArchive, length);
                        }
                        catch (Exception e) {
                            if (!TraceDwarf.TRACED) continue;
                            e.printStackTrace();
                            continue;
                        }
                    }
                    this.currentIterator = Dwarf.this.iteratorFileCompilationUnits();
                    if (!this.currentIterator.hasNext()) {
                        continue;
                    }
                    break block7;
                }
                this.currentIterator = null;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MacArchiveIterator
    implements Iterator<CompilationUnit> {
        private List<String> objectFiles;
        private int archiveIndex = 0;
        private Iterator<CompilationUnit> currentList;
        private Dwarf currentDwarf;

        public MacArchiveIterator() throws IOException {
            this.objectFiles = Dwarf.this.dwarfReader.getLinkedObjectFiles();
            this.advanceArchive();
        }

        @Override
        public boolean hasNext() {
            if (this.currentList == null) {
                return false;
            }
            if (this.currentList.hasNext()) {
                return true;
            }
            try {
                this.advanceArchive();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            return this.currentList != null;
        }

        @Override
        public CompilationUnit next() {
            return this.currentList.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceArchive() throws IOException {
            block6: {
                while (true) {
                    String fileFinder;
                    if (this.currentDwarf != null) {
                        Dwarf.this.toDispose.remove(this.currentDwarf.magic);
                        this.currentDwarf.magic.dispose();
                        this.currentDwarf = null;
                    }
                    if (this.archiveIndex >= this.objectFiles.size()) break;
                    String member = this.objectFiles.get(this.archiveIndex);
                    if (!new File(member).exists() && (fileFinder = Dwarf.fileFinder(Dwarf.this.fileName, member)) != null && new File(fileFinder).exists()) {
                        member = fileFinder;
                    }
                    ++this.archiveIndex;
                    try {
                        this.currentDwarf = new Dwarf(member);
                        Dwarf.this.toDispose.add(this.currentDwarf.magic);
                        this.currentList = this.currentDwarf.iteratorCompilationUnits();
                        if (!this.currentList.hasNext()) {
                        }
                        break block6;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                this.currentList = null;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        Normal,
        Archive,
        MachoLOF;

    }
}

