/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.netbeans.modules.cnd.repository.sfs.SharedStringBuffer;
import org.netbeans.modules.cnd.repository.sfs.UTF;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;

public class BufferDataInput
implements RepositoryDataInput,
SharedStringBuffer {
    private ByteBuffer buffer;
    private static final int sharedArrySize = 1024;
    private final byte[] sharedByteArray = new byte[1024];
    private final char[] sharedCharArray = new char[1024];

    public BufferDataInput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public byte readByte() throws IOException {
        return this.buffer.get();
    }

    public char readChar() throws IOException {
        return this.buffer.getChar();
    }

    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    public int readUnsignedShort() throws IOException {
        short result = this.buffer.getShort();
        return result & 0xFFFF;
    }

    public boolean readBoolean() throws IOException {
        return this.buffer.get() != 0;
    }

    public double readDouble() throws IOException {
        return this.buffer.getDouble();
    }

    public float readFloat() throws IOException {
        return this.buffer.getFloat();
    }

    public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        block4: while (this.buffer.hasRemaining()) {
            byte b = this.buffer.get();
            switch (b) {
                case 13: {
                    byte next;
                    if (!this.buffer.hasRemaining() || (next = this.buffer.get()) == 10) break block4;
                    this.buffer.position(this.buffer.position() - 1);
                    break block4;
                }
                case 10: {
                    break block4;
                }
                default: {
                    sb.append((char)b);
                    continue block4;
                }
            }
        }
        return sb.toString();
    }

    public long readLong() throws IOException {
        return this.buffer.getLong();
    }

    public short readShort() throws IOException {
        return this.buffer.getShort();
    }

    public String readUTF() throws IOException {
        return UTF.readUTF((DataInput)((Object)this));
    }

    public int readUnsignedByte() throws IOException {
        byte b = this.buffer.get();
        return (short)b & 0xFF;
    }

    public int skipBytes(int n) throws IOException {
        int skip = Math.min(n, this.buffer.remaining());
        this.buffer.position(this.buffer.position() + skip);
        return skip;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.buffer.get(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.buffer.get(b);
    }

    public CharSequence readCharSequenceUTF() throws IOException {
        return UTF.readCharSequenceUTF((DataInput)((Object)this));
    }

    @Override
    public final byte[] getSharedByteArray() {
        return this.sharedByteArray;
    }

    @Override
    public final char[] getSharedCharArray() {
        return this.sharedCharArray;
    }

    @Override
    public final int getSharedArrayLehgth() {
        return 1024;
    }
}

