/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.queries.DatabaseQuery;

public class StatementQueryMechanism
extends CallQueryMechanism {
    protected SQLStatement sqlStatement;
    protected Vector sqlStatements;

    public StatementQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    public StatementQueryMechanism(DatabaseQuery query, SQLStatement statement) {
        super(query);
        this.sqlStatement = statement;
    }

    public void clearStatement() {
    }

    public DatabaseQueryMechanism clone(DatabaseQuery queryClone) {
        StatementQueryMechanism clone = (StatementQueryMechanism)super.clone(queryClone);
        if (!this.hasMultipleStatements() && this.getSQLStatement() != null) {
            clone.setSQLStatement((SQLStatement)this.sqlStatement.clone());
        } else {
            Vector currentStatements = this.getSQLStatements();
            if (currentStatements != null) {
                NonSynchronizedVector statementClone = NonSynchronizedVector.newInstance(currentStatements.size());
                Enumeration enumtr = currentStatements.elements();
                while (enumtr.hasMoreElements()) {
                    ((Vector)statementClone).addElement(((SQLStatement)enumtr.nextElement()).clone());
                }
                clone.setSQLStatements(statementClone);
            }
        }
        return clone;
    }

    public Integer deleteObject() throws DatabaseException {
        if (this.call == null && !this.hasMultipleCalls()) {
            this.prepareDeleteObject();
            if (this.call == null && !this.hasMultipleCalls()) {
                return 1;
            }
        }
        return super.deleteObject();
    }

    public Integer executeNoSelect() throws DatabaseException {
        if (this.call == null && !this.hasMultipleCalls()) {
            this.prepareExecuteNoSelect();
        }
        return super.executeNoSelect();
    }

    public Expression getSelectionCriteria() {
        return this.getSQLStatement().getWhereClause();
    }

    public SQLStatement getSQLStatement() {
        return this.sqlStatement;
    }

    public Vector getSQLStatements() {
        if (this.sqlStatements == null) {
            this.sqlStatements = NonSynchronizedVector.newInstance(3);
        }
        return this.sqlStatements;
    }

    public boolean hasMultipleStatements() {
        return this.sqlStatements != null && !this.sqlStatements.isEmpty();
    }

    public void insertObject() throws DatabaseException {
        if (this.call == null && !this.hasMultipleCalls()) {
            this.prepareInsertObject();
        }
        super.insertObject();
    }

    public void insertObject(boolean reprepare) {
        if (reprepare) {
            this.setCalls(null);
            this.trimFieldsForInsert();
            this.prepareInsertObject();
        }
        this.insertObject();
    }

    public void trimFieldsForInsert() {
        this.getDescriptor().getObjectBuilder().trimFieldsForInsert(this.getSession(), this.getModifyRow());
    }

    public boolean isCallQueryMechanism() {
        return false;
    }

    public boolean isStatementQueryMechanism() {
        return true;
    }

    public void prepare() {
        if (!this.hasMultipleStatements() && this.getSQLStatement() == null) {
            throw QueryException.sqlStatementNotSetProperly(this.getQuery());
        }
    }

    public void prepareCursorSelectAllRows() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareCursorSelectAllRows();
    }

    public void prepareDeleteAll() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareDeleteAll();
    }

    public void prepareDeleteObject() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareDeleteObject();
    }

    public void prepareDoesExist(DatabaseField field) {
        this.setCallFromStatement();
        this.clearStatement();
        this.getCall().returnOneRow();
        this.prepareCall();
    }

    public void prepareExecuteNoSelect() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareExecuteNoSelect();
    }

    public void prepareExecuteSelect() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareExecuteSelect();
    }

    public void prepareInsertObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        if (this.hasMultipleStatements()) {
            Enumeration statementEnum = this.getSQLStatements().elements();
            while (statementEnum.hasMoreElements()) {
                ((SQLModifyStatement)statementEnum.nextElement()).setModifyRow(this.getModifyRow());
            }
        } else if (this.getSQLStatement() != null) {
            ((SQLModifyStatement)this.getSQLStatement()).setModifyRow(this.getModifyRow());
        }
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareInsertObject();
    }

    public void prepareSelectAllRows() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareSelectAllRows();
    }

    public void prepareSelectOneRow() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareSelectOneRow();
    }

    public void prepareUpdateObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        if (this.hasMultipleStatements()) {
            Enumeration statementEnum = this.getSQLStatements().elements();
            while (statementEnum.hasMoreElements()) {
                ((SQLModifyStatement)statementEnum.nextElement()).setModifyRow(this.getModifyRow());
            }
        } else if (this.getSQLStatement() != null) {
            ((SQLModifyStatement)this.getSQLStatement()).setModifyRow(this.getModifyRow());
        }
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareUpdateObject();
    }

    public void prepareUpdateAll() {
        this.setCallFromStatement();
        this.clearStatement();
        super.prepareUpdateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCallFromStatement() {
        this.getSession().startOperationProfile("Timer:SqlGeneration", this.getQuery(), Integer.MAX_VALUE);
        try {
            if (this.hasMultipleStatements()) {
                Enumeration statementEnum = this.getSQLStatements().elements();
                while (statementEnum.hasMoreElements()) {
                    DatabaseCall call = null;
                    call = this.getDescriptor() != null ? this.getDescriptor().buildCallFromStatement((SQLStatement)statementEnum.nextElement(), this.getSession()) : ((SQLStatement)statementEnum.nextElement()).buildCall(this.getSession());
                    if (call == null) continue;
                    this.addCall(call);
                }
            } else {
                DatabaseCall call = null;
                call = this.getDescriptor() != null ? this.getDescriptor().buildCallFromStatement(this.getSQLStatement(), this.getSession()) : this.getSQLStatement().buildCall(this.getSession());
                if (call != null) {
                    this.setCall(call);
                }
            }
            Object var4_4 = null;
            this.getSession().endOperationProfile("Timer:SqlGeneration", this.getQuery(), Integer.MAX_VALUE);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.getSession().endOperationProfile("Timer:SqlGeneration", this.getQuery(), Integer.MAX_VALUE);
            throw throwable;
        }
    }

    public void setSQLStatement(SQLStatement statement) {
        this.sqlStatement = statement;
    }

    protected void setSQLStatements(Vector sqlStatements) {
        this.sqlStatements = sqlStatements;
    }

    public Integer updateObject() throws DatabaseException {
        if (this.call == null && !this.hasMultipleCalls()) {
            this.prepareUpdateObject();
            if (this.call == null && !this.hasMultipleCalls()) {
                return 1;
            }
        }
        return super.updateObject();
    }
}

