/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class FieldExpression
extends DataExpression {
    protected DatabaseField field;
    protected transient DatabaseField aliasedField;

    public FieldExpression() {
    }

    public FieldExpression(DatabaseField newField) {
        this.field = newField;
    }

    public FieldExpression(DatabaseField newField, Expression myBase) {
        this.field = newField;
        this.baseExpression = myBase;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FieldExpression expression = (FieldExpression)object;
        return this.getField() == expression.getField() || this.getField() != null && this.getField().equals(expression.getField());
    }

    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getField() != null) {
            hashCode += this.getField().hashCode();
        }
        return hashCode;
    }

    public void clearAliases() {
        super.clearAliases();
        this.aliasedField = null;
    }

    public String descriptionOfNodeType() {
        return "Field";
    }

    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    private DatabaseTable getAliasedTable() {
        DatabaseTable alias;
        DataExpression base = (DataExpression)this.getBaseExpression();
        DatabaseField field = this.getField();
        if (!field.hasTableName() && base.getDescriptor() != null) {
            field = base.getDescriptor().buildField(field);
        }
        if ((alias = base.aliasForTable(field.getTable())) == null) {
            return field.getTable();
        }
        return alias;
    }

    public DatabaseField getClonedField() {
        return this.getField().clone();
    }

    public Vector getClonedFields() {
        Vector<DatabaseField> result = new Vector<DatabaseField>(1);
        result.addElement(this.getField().clone());
        return result;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Vector getFields() {
        Vector<DatabaseField> result = new Vector<DatabaseField>(1);
        result.addElement(this.getField());
        return result;
    }

    private void initializeAliasedField() {
        DatabaseField tempField = this.getField().clone();
        DatabaseTable aliasedTable = this.getAliasedTable();
        this.aliasedField = tempField;
        this.aliasedField.setTable(aliasedTable);
    }

    public boolean isAttribute() {
        return true;
    }

    public boolean isFieldExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        Expression expression = super.normalize(normalizer);
        if (this.getBaseExpression() != null && this.getBaseExpression().isFieldExpression() || this.getBaseExpression().isTableExpression() || this.getBaseExpression().isQueryKeyExpression() && ((QueryKeyExpression)this.getBaseExpression()).isAttribute()) {
            this.getBuilder().getStatement().setRequiresAliases(true);
        }
        return expression;
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        if (this.getBaseExpression() != null && this.getBaseExpression().isFieldExpression() || this.getBaseExpression().isQueryKeyExpression() && ((QueryKeyExpression)this.getBaseExpression()).isAttribute()) {
            this.getBaseExpression().printSQL(printer);
            printer.printString(".");
        }
        printer.printField(this.getAliasedField());
    }

    public void printJava(ExpressionJavaPrinter printer) {
        this.getBaseExpression().printJava(printer);
        printer.printString(".getField(\"" + this.getField().getQualifiedName() + "\")");
    }

    public Expression rebuildOn(Expression newBase) {
        FieldExpression expression = new FieldExpression(this.getField(), this.getBaseExpression().rebuildOn(newBase));
        expression.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return expression;
    }

    public void setField(DatabaseField newField) {
        this.field = newField;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context);
        return twistedBase.getField(this.getField());
    }

    public void validateNode() {
        Vector tables;
        DataExpression base = (DataExpression)this.getBaseExpression();
        if (this.getField().getTable().hasName() && (tables = base.getOwnedTables()) != null && !tables.contains(this.getField().getTable())) {
            throw QueryException.invalidTableForFieldInExpression(this.getField());
        }
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (!this.getBaseExpression().isExpressionBuilder()) {
            throw QueryException.cannotConformExpression();
        }
        DatabaseMapping mapping = session.getDescriptor(object.getClass()).getObjectBuilder().getMappingForField(this.getField());
        if (mapping == null) {
            throw QueryException.cannotConformExpression();
        }
        return mapping.valueFromObject(object, this.getField(), session);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getField().toString());
    }

    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        DatabaseField field = this.getField();
        if (field != null) {
            newFields.addElement(field);
            this.writeField(printer, field, statement);
        }
    }

    protected void writeField(ExpressionSQLPrinter printer, DatabaseField field, SQLSelectStatement statement) {
        if (this.field == field) {
            if (printer.isFirstElementPrinted()) {
                printer.printString(", ");
            } else {
                printer.setIsFirstElementPrinted(true);
            }
            this.printSQL(printer);
        } else {
            super.writeField(printer, field, statement);
        }
    }

    protected void writeForUpdateOf(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        if (printer.getPlatform().shouldPrintAliasForUpdate()) {
            this.writeAlias(printer, this.field, statement);
        } else {
            this.writeField(printer, this.field, statement);
        }
    }
}

