/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class Utils {
    private static final String VALUE = "value";

    public static String getUriTemplate(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Path", VALUE);
    }

    public static String getConsumeMime(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Consumes", VALUE);
    }

    public static String getProduceMime(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Produces", VALUE);
    }

    static void fillQueryParams(Map<String, String> map, Element element) {
        if (!(element instanceof ExecutableElement)) {
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> list = executableElement.getParameters();
        for (VariableElement variableElement : list) {
            String string = null;
            if (Utils.hasAnnotationType(variableElement, "javax.ws.rs.QueryParam")) {
                string = Utils.getAnnotationValue(variableElement, "javax.ws.rs.QueryParam", VALUE);
            }
            String string2 = null;
            if (Utils.hasAnnotationType(variableElement, "javax.ws.rs.DefaultValue")) {
                string2 = Utils.getAnnotationValue(variableElement, "javax.ws.rs.DefaultValue", VALUE);
            }
            if (string == null) continue;
            map.put(string, string2);
        }
    }

    public static String getApplicationPath(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.ApplicationPath", VALUE);
    }

    public static String getHttpMethod(Element element) {
        if (Utils.hasAnnotationType(element, "javax.ws.rs.GET")) {
            return "GET";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.POST")) {
            return "POST";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.PUT")) {
            return "PUT";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.DELETE")) {
            return "DELETE";
        }
        return null;
    }

    public static boolean hasUriTemplate(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Path");
    }

    public static boolean hasHttpMethod(Element element) {
        return element.getKind() == ElementKind.METHOD && (Utils.hasAnnotationType(element, "javax.ws.rs.GET") || Utils.hasAnnotationType(element, "javax.ws.rs.POST") || Utils.hasAnnotationType(element, "javax.ws.rs.PUT") || Utils.hasAnnotationType(element, "javax.ws.rs.DELETE"));
    }

    public static boolean hasConsumeMime(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Consumes");
    }

    public static boolean hasProduceMime(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Produces");
    }

    private static String getAnnotationValue(Element element, String string, String string2) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(string)) continue;
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!executableElement.getSimpleName().toString().equals(string2)) continue;
                String string3 = ((Object)annotationMirror.getElementValues().get(executableElement)).toString();
                string3 = Utils.stripQuotes(string3);
                return string3;
            }
        }
        return "";
    }

    private static boolean hasAnnotationType(Element element, String string) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String stripQuotes(String string) {
        int n;
        int n2 = string.indexOf(34);
        if (n2 != -1 && (n = string.lastIndexOf(34)) != -1 && n2 != n) {
            return string.substring(n2 + 1, n);
        }
        return string;
    }

    static boolean checkForJsr311Bootstrap(TypeElement typeElement, Project project, AnnotationModelHelper annotationModelHelper) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null && !restSupport.isRestSupportOn() && Utils.isRest(typeElement, annotationModelHelper)) {
            try {
                restSupport.ensureRestDevelopmentReady();
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return false;
    }

    public static ClasspathInfo getClassPathInfo(RestSupport restSupport) {
        FileObject fileObject = restSupport.findSourceRoot();
        if (fileObject != null) {
            return ClasspathInfo.create((FileObject)fileObject);
        }
        return null;
    }

    static boolean isRest(TypeElement typeElement, AnnotationModelHelper annotationModelHelper) {
        boolean bl = false;
        if (typeElement.getKind() != ElementKind.INTERFACE) {
            if (annotationModelHelper.hasAnnotation(typeElement.getAnnotationMirrors(), "javax.ws.rs.Path")) {
                bl = true;
            } else {
                for (Element element : typeElement.getEnclosedElements()) {
                    if (!Utils.hasHttpMethod(element)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    static boolean isRestApplication(TypeElement typeElement, AnnotationModelHelper annotationModelHelper) {
        boolean bl = false;
        if (typeElement.getKind() != ElementKind.INTERFACE && annotationModelHelper.hasAnnotation(typeElement.getAnnotationMirrors(), "javax.ws.rs.ApplicationPath")) {
            bl = true;
        }
        return bl;
    }
}

