/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.lexer.Language;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.DefaultLanguageConfig;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsClassPathProvider;
import org.netbeans.modules.javascript.editing.JsCodeCompletion;
import org.netbeans.modules.javascript.editing.JsDeclarationFinder;
import org.netbeans.modules.javascript.editing.JsFormatter;
import org.netbeans.modules.javascript.editing.JsIndexer;
import org.netbeans.modules.javascript.editing.JsKeystrokeHandler;
import org.netbeans.modules.javascript.editing.JsOccurrenceFinder;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.JsRenameHandler;
import org.netbeans.modules.javascript.editing.JsSemanticAnalyzer;
import org.netbeans.modules.javascript.editing.JsTypeSearcher;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;

public class JsLanguage
extends DefaultLanguageConfig {
    protected static boolean jsClassPathRegistered = false;

    public JsLanguage() {
        JsLanguage.registerJsClassPathIfNeeded();
    }

    static synchronized void registerJsClassPathIfNeeded() {
        if (!jsClassPathRegistered) {
            jsClassPathRegistered = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassPath classPath = JsClassPathProvider.getBootClassPath();
                    if (classPath != null) {
                        GlobalPathRegistry.getDefault().register("JavascriptBootClassPath", new ClassPath[]{classPath});
                    }
                }
            });
        }
    }

    public String getLineCommentPrefix() {
        return JsUtils.getLineCommentPrefix();
    }

    public boolean isIdentifierChar(char c) {
        return JsUtils.isIdentifierChar(c);
    }

    public Language getLexerLanguage() {
        return JsTokenId.language();
    }

    public String getDisplayName() {
        return "JavaScript";
    }

    public String getPreferredExtension() {
        return "js";
    }

    public Set<String> getLibraryPathIds() {
        return Collections.singleton("JavascriptBootClassPath");
    }

    public KeystrokeHandler getKeystrokeHandler() {
        return new JsKeystrokeHandler();
    }

    public boolean hasFormatter() {
        return true;
    }

    public Formatter getFormatter() {
        return new JsFormatter();
    }

    public Parser getParser() {
        return new JsParser();
    }

    public CodeCompletionHandler getCompletionHandler() {
        return new JsCodeCompletion();
    }

    public boolean hasStructureScanner() {
        return true;
    }

    public StructureScanner getStructureScanner() {
        return new JsAnalyzer();
    }

    public EmbeddingIndexerFactory getIndexerFactory() {
        return new JsIndexer.Factory();
    }

    public DeclarationFinder getDeclarationFinder() {
        return new JsDeclarationFinder();
    }

    public SemanticAnalyzer getSemanticAnalyzer() {
        return new JsSemanticAnalyzer();
    }

    public boolean hasOccurrencesFinder() {
        return true;
    }

    public OccurrencesFinder getOccurrencesFinder() {
        return new JsOccurrenceFinder();
    }

    public InstantRenamer getInstantRenamer() {
        return new JsRenameHandler();
    }

    public IndexSearcher getIndexSearcher() {
        return new JsTypeSearcher();
    }
}

