/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

final class CompletionImplProfile {
    private static final Logger LOG = Logger.getLogger(CompletionImplProfile.class.getName());
    static final RequestProcessor RP = new RequestProcessor("Completion Slowness");
    private final Object profiler;
    private boolean profiling;
    private final long time;

    CompletionImplProfile(long when) {
        Action a;
        this.time = when;
        Object p = null;
        FileObject fo = FileUtil.getConfigFile((String)"Actions/Profile/org-netbeans-modules-profiler-actions-SelfSamplerAction.instance");
        if (fo != null && (a = (Action)fo.getAttribute("delegate")) != null) {
            p = a.getValue("logger-completion");
        }
        this.profiler = p;
        this.profiling = true;
        if (this.profiler instanceof Runnable) {
            Runnable r = (Runnable)this.profiler;
            r.run();
            LOG.log(Level.FINE, "Profiling started {0} at {1}", new Object[]{this.profiler, this.time});
        }
    }

    final synchronized void stop() {
        if (!this.profiling) {
            return;
        }
        final long now = System.currentTimeMillis();
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    CompletionImplProfile.this.stopImpl(now);
                }
                catch (Exception ex) {
                    LOG.log(Level.INFO, "Cannot stop profiling", ex);
                }
            }
        });
        this.profiling = false;
    }

    private void stopImpl(long now) throws Exception {
        long delta = now - this.time;
        LOG.log(Level.FINE, "Profiling stopped at {0}", now);
        ActionListener ss = (ActionListener)this.profiler;
        int report = Integer.getInteger("org.netbeans.modules.editor.completion.slowness.report", 2000);
        if (delta < (long)report) {
            LOG.log(Level.FINE, "Cancel profiling of {0}. Profiling {1}. Time {2} ms.", new Object[]{ss, this.profiling, delta});
            if (ss != null) {
                ss.actionPerformed(new ActionEvent(this, 0, "cancel"));
            }
            return;
        }
        try {
            LOG.log(Level.FINE, "Obtaining snapshot for {0} ms.", delta);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if (ss != null) {
                ss.actionPerformed(new ActionEvent(dos, 0, "write"));
            }
            dos.close();
            if (dos.size() > 0) {
                Object[] params = new Object[]{out.toByteArray(), delta, "CodeCompletion"};
                Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Slowness detected", params);
                LOG.log(Level.FINE, "Snapshot sent to UI logger. Size {0} bytes.", dos.size());
            } else {
                LOG.log(Level.WARNING, "No snapshot taken");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

