/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;

final class SessionGenerateFromImplVisitor
implements MethodType.MethodTypeVisitor,
AbstractMethodController.GenerateFromImpl {
    private MethodModel intfMethod;
    private String destination;
    private String home;
    private String component;

    SessionGenerateFromImplVisitor() {
    }

    @Override
    public void getInterfaceMethodFromImpl(MethodType methodType, String home, String component) {
        this.home = home;
        this.component = component;
        methodType.accept(this);
    }

    @Override
    public MethodModel getInterfaceMethod() {
        return this.intfMethod;
    }

    @Override
    public String getDestinationInterface() {
        return this.destination;
    }

    @Override
    public void visit(MethodType.BusinessMethodType bmt) {
        this.intfMethod = bmt.getMethodElement();
        this.destination = this.component;
    }

    @Override
    public void visit(MethodType.CreateMethodType cmt) {
        this.intfMethod = cmt.getMethodElement();
        String origName = this.intfMethod.getName();
        String newName = this.chopAndUpper(origName, "ejb");
        this.intfMethod = MethodModel.create((String)newName, (String)this.home, (String)this.intfMethod.getBody(), (List)this.intfMethod.getParameters(), (List)this.intfMethod.getExceptions(), Collections.singleton(Modifier.PUBLIC));
        this.destination = this.home;
    }

    @Override
    public void visit(MethodType.HomeMethodType hmt) {
        assert (false) : "session beans do not have home methods";
    }

    @Override
    public void visit(MethodType.FinderMethodType fmt) {
        assert (false) : "session beans do not have finder methods";
    }

    private String chopAndUpper(String fullName, String chop) {
        StringBuffer buffer = new StringBuffer(fullName);
        buffer.delete(0, chop.length());
        buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
        return buffer.toString();
    }
}

