/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.impl.FieldCustomizerPanel;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FieldCustomizer {
    private final Entity entity;
    private final FieldCustomizerPanel panel;

    public FieldCustomizer(Entity entity, MethodModel.Variable element, String description, boolean localEnabled, boolean remoteEnabled, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter) {
        this.entity = entity;
        this.panel = new FieldCustomizerPanel(element, description, localEnabled, remoteEnabled, localGetter, localSetter, remoteGetter, remoteSetter);
    }

    public boolean customizeField() {
        DialogDescriptor notifyDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(FieldCustomizer.class, (String)"LBL_AddCmpField"), true, 2, (Object)-1, null);
        this.panel.addPropertyChangeListener(new Validator(this.panel, (NotifyDescriptor)notifyDescriptor, this.entity));
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor) == NotifyDescriptor.OK_OPTION;
    }

    public MethodModel.Variable getField() {
        return MethodModel.Variable.create(this.panel.getReturnType(), this.panel.getMethodName());
    }

    public String getDescription() {
        return this.panel.getDescription();
    }

    public boolean isLocalGetter() {
        return this.panel.isLocalGetter();
    }

    public boolean isLocalSetter() {
        return this.panel.isLocalSetter();
    }

    public boolean isRemoteGetter() {
        return this.panel.isRemoteGetter();
    }

    public boolean isRemoteSetter() {
        return this.panel.isRemoteSetter();
    }

    private static class Validator
    implements PropertyChangeListener {
        private final FieldCustomizerPanel panel;
        private final NotifyDescriptor notifyDescriptor;
        private final Entity entity;

        public Validator(FieldCustomizerPanel panel, NotifyDescriptor notifyDescriptor, Entity entity) {
            this.panel = panel;
            this.notifyDescriptor = notifyDescriptor;
            this.entity = entity;
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            this.validate();
        }

        private boolean validate() {
            String name = this.panel.getMethodName();
            if (!Utilities.isJavaIdentifier((String)name)) {
                this.setError(NbBundle.getMessage(FieldCustomizer.class, (String)"ERROR_nameNonJavaIdentifier"));
                return false;
            }
            CmpField[] cmpField = this.entity.getCmpField();
            for (int i = 0; i < cmpField.length; ++i) {
                CmpField field = cmpField[i];
                if (!name.equals(field.getFieldName())) continue;
                this.setError(NbBundle.getMessage(FieldCustomizer.class, (String)"MSG_Duplicate_Field_Name", (Object)name));
                return false;
            }
            String returnType = this.panel.getReturnType();
            if ("".equals(returnType)) {
                this.setError(NbBundle.getMessage(FieldCustomizer.class, (String)"ERROR_returnTypeInvalid"));
                return false;
            }
            if (!(this.panel.isLocalGetter() || this.panel.isLocalSetter() || this.panel.isRemoteGetter() || this.panel.isRemoteSetter())) {
                this.setError(NbBundle.getMessage(FieldCustomizer.class, (String)"ERROR_selectSomeInterface"));
                return false;
            }
            this.unsetError();
            return true;
        }

        private void setError(String message) {
            this.notifyDescriptor.setValid(false);
            this.panel.setError(message);
        }

        private void unsetError() {
            this.notifyDescriptor.setValid(true);
            this.panel.setError("");
        }
    }
}

