/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentDescriptorConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ServerLibraryConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.dd.model.WebApplicationModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public class WarDeploymentConfiguration
extends WLDeploymentConfiguration
implements ServerLibraryConfiguration,
ModuleConfiguration,
ContextRootConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener,
DeploymentDescriptorConfiguration {
    private static final Logger LOGGER = Logger.getLogger(WarDeploymentConfiguration.class.getName());
    private final ChangeSupport serverLibraryChangeSupport = new ChangeSupport((Object)this);
    private final File file;
    private final J2eeModule j2eeModule;
    private final DataObject dataObject;
    private final FileChangeListener weblogicXmlListener = new WeblogicXmlListener();
    private final Version serverVersion;
    private final boolean isWebProfile;
    private WebApplicationModel webLogicWebApp;
    private Set<ServerLibraryDependency> originalDeps;

    public WarDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null, false);
    }

    public WarDeploymentConfiguration(J2eeModule j2eeModule, Version serverVersion, boolean isWebProfile) {
        super(j2eeModule);
        this.j2eeModule = j2eeModule;
        this.serverVersion = serverVersion;
        this.isWebProfile = isWebProfile;
        this.file = j2eeModule.getDeploymentConfigurationFile("WEB-INF/weblogic.xml");
        FileUtil.addFileChangeListener((FileChangeListener)this.weblogicXmlListener, (File)this.file);
        this.getWeblogicWebApp();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.file));
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        this.dataObject = dataObject;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void dispose() {
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public boolean isDescriptorRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            WarDeploymentConfiguration warDeploymentConfiguration = this;
            synchronized (warDeploymentConfiguration) {
                this.webLogicWebApp = null;
            }
        }
    }

    public final synchronized WebApplicationModel getWeblogicWebApp() {
        if (this.webLogicWebApp == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.webLogicWebApp = WebApplicationModel.forFile(this.file);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException re) {
                        LOGGER.log(Level.INFO, null, re);
                    }
                } else {
                    this.webLogicWebApp = this.generateWeblogicWebApp();
                    this.webLogicWebApp.write(this.file);
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.webLogicWebApp;
    }

    public void save(OutputStream os) throws ConfigurationException {
        WebApplicationModel webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        try {
            webLogicWebApp.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyWeblogicWebApp(WeblogicWebAppModifier modifier) throws ConfigurationException {
        assert (this.dataObject != null) : "DataObject has not been initialized yet";
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            WebApplicationModel newWeblogicWebApp = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newWeblogicWebApp = WebApplicationModel.forInputStream(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                WebApplicationModel oldWeblogicWebApp = this.getWeblogicWebApp();
                if (oldWeblogicWebApp == null) {
                    String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_configFileCannotParse", (Object)this.file.getPath());
                    throw new ConfigurationException(msg);
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_weblogicXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newWeblogicWebApp = oldWeblogicWebApp;
            }
            modifier.modify(newWeblogicWebApp);
            boolean modified = this.dataObject.isModified();
            this.replaceDocument(doc, newWeblogicWebApp);
            if (!modified && (cookie = (SaveCookie)this.dataObject.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            WarDeploymentConfiguration warDeploymentConfiguration = this;
            synchronized (warDeploymentConfiguration) {
                this.webLogicWebApp = newWeblogicWebApp;
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private WebApplicationModel generateWeblogicWebApp() {
        WebApplicationModel webApp = WebApplicationModel.generate(this.serverVersion);
        webApp.setContextRoot("");
        webApp.setKeepJspGenerated(true);
        webApp.setDebug(true);
        if (!this.isWebProfile) {
            webApp.setFastSwap(true);
        }
        return webApp;
    }

    private void replaceDocument(final StyledDocument doc, WebApplicationModel graph) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            graph.write(out);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
        });
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    public String getContextRoot() throws ConfigurationException {
        WebApplicationModel webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadContextRoot", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        return webLogicWebApp.getContextRoot();
    }

    public void setContextRoot(String contextRoot) throws ConfigurationException {
        if (!this.isCorrectCP(contextRoot)) {
            String ctxRoot = contextRoot;
            StringTokenizer tok = new StringTokenizer(contextRoot, "/");
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                buf.append("/" + tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_invalidCP", (Object)contextRoot), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            contextRoot = ctxRoot;
        }
        final String newContextPath = contextRoot;
        this.modifyWeblogicWebApp(new WeblogicWebAppModifier(){

            @Override
            public void modify(WebApplicationModel webLogicWebApp) {
                webLogicWebApp.setContextRoot(newContextPath);
            }
        });
    }

    @Override
    public void bindDatasourceReference(final String referenceName, final String jndiName) throws ConfigurationException {
        if (referenceName == null || referenceName.length() == 0 || jndiName == null || jndiName.length() == 0) {
            return;
        }
        this.modifyWeblogicWebApp(new WeblogicWebAppModifier(){

            @Override
            public void modify(WebApplicationModel webLogicWebApp) {
                webLogicWebApp.setReference(referenceName, jndiName);
            }
        });
    }

    @Override
    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        WebApplicationModel webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadReferenceName", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        return webLogicWebApp.getReferenceJndiName(referenceName);
    }

    public void configureLibrary(final @NonNull ServerLibraryDependency library) throws ConfigurationException {
        assert (library != null);
        this.modifyWeblogicWebApp(new WeblogicWebAppModifier(){

            @Override
            public void modify(WebApplicationModel webLogicWebApp) {
                webLogicWebApp.addLibrary(library);
            }
        });
    }

    public Set<ServerLibraryDependency> getLibraries() throws ConfigurationException {
        WebApplicationModel webLogicWebApp = this.getWeblogicWebApp();
        if (webLogicWebApp == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadServerLibraries", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        return webLogicWebApp.getLibraries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLibraryChangeListener(@NonNull ChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        boolean load = false;
        WarDeploymentConfiguration warDeploymentConfiguration = this;
        synchronized (warDeploymentConfiguration) {
            load = this.originalDeps == null;
        }
        if (load) {
            Set<Object> deps = null;
            try {
                deps = this.getLibraries();
            }
            catch (ConfigurationException ex) {
                deps = Collections.emptySet();
            }
            WarDeploymentConfiguration warDeploymentConfiguration2 = this;
            synchronized (warDeploymentConfiguration2) {
                if (this.originalDeps == null) {
                    this.originalDeps = deps;
                }
            }
        }
        this.serverLibraryChangeSupport.addChangeListener(listener);
    }

    public void removeLibraryChangeListener(@NonNull ChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.serverLibraryChangeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        HashSet<ServerLibraryDependency> oldDeps = null;
        WarDeploymentConfiguration warDeploymentConfiguration = this;
        synchronized (warDeploymentConfiguration) {
            if (this.originalDeps == null) {
                return;
            }
            oldDeps = new HashSet<ServerLibraryDependency>(this.originalDeps);
        }
        HashSet<ServerLibraryDependency> deps = new HashSet<ServerLibraryDependency>();
        try {
            deps.addAll(this.getLibraries());
        }
        catch (ConfigurationException ex) {
            // empty catch block
        }
        boolean fire = false;
        for (ServerLibraryDependency old : oldDeps) {
            if (deps.remove(old)) continue;
            fire = true;
            break;
        }
        if (!deps.isEmpty()) {
            fire = true;
        }
        if (fire) {
            this.serverLibraryChangeSupport.fireChange();
        }
    }

    private static interface WeblogicWebAppModifier {
        public void modify(WebApplicationModel var1);
    }

    private class WeblogicXmlListener
    implements FileChangeListener {
        private WeblogicXmlListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            WarDeploymentConfiguration.this.fireChange();
        }

        public void fileChanged(FileEvent fe) {
            WarDeploymentConfiguration.this.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            WarDeploymentConfiguration.this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            WarDeploymentConfiguration.this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

