/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory2;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.config.EarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.EjbDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;

public class WLModuleConfigurationFactory
implements ModuleConfigurationFactory2 {
    public ModuleConfiguration create(J2eeModule j2eeModule) throws ConfigurationException {
        if (J2eeModule.Type.WAR.equals(j2eeModule.getType())) {
            return new WarDeploymentConfiguration(j2eeModule);
        }
        if (J2eeModule.Type.EJB.equals(j2eeModule.getType())) {
            return new EjbDeploymentConfiguration(j2eeModule);
        }
        if (J2eeModule.Type.EAR.equals(j2eeModule.getType())) {
            return new EarDeploymentConfiguration(j2eeModule);
        }
        throw new ConfigurationException("Not supported module: " + j2eeModule.getType());
    }

    public ModuleConfiguration create(J2eeModule j2eeModule, String instanceUrl) throws ConfigurationException {
        if (!instanceUrl.startsWith("deployer:WebLogic:http://")) {
            return this.create(j2eeModule);
        }
        try {
            WLDeploymentManager dm = (WLDeploymentManager)WLDeploymentFactory.getInstance().getDeploymentManager(instanceUrl, null, null);
            Version version = dm.getServerVersion();
            if (J2eeModule.Type.WAR.equals(j2eeModule.getType())) {
                return new WarDeploymentConfiguration(j2eeModule, version, dm.isWebProfile());
            }
            if (J2eeModule.Type.EJB.equals(j2eeModule.getType())) {
                return new EjbDeploymentConfiguration(j2eeModule, version, dm.isWebProfile());
            }
            if (J2eeModule.Type.EAR.equals(j2eeModule.getType())) {
                return new EarDeploymentConfiguration(j2eeModule, version, dm.isWebProfile());
            }
        }
        catch (DeploymentManagerCreationException ex) {
            return this.create(j2eeModule);
        }
        throw new ConfigurationException("Not supported module: " + j2eeModule.getType());
    }
}

