/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.dd.model.EjbJarModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class EjbDeploymentConfiguration
extends WLDeploymentConfiguration
implements ModuleConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private final File file;
    private final J2eeModule j2eeModule;
    private final DataObject dataObject;
    private final Version serverVersion;
    private final boolean isWebProfile;
    private EjbJarModel weblogicEjbJar;

    public EjbDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null, false);
    }

    public EjbDeploymentConfiguration(J2eeModule j2eeModule, Version serverVersion, boolean isWebProfile) {
        super(j2eeModule);
        this.j2eeModule = j2eeModule;
        this.serverVersion = serverVersion;
        this.isWebProfile = isWebProfile;
        this.file = j2eeModule.getDeploymentConfigurationFile("META-INF/weblogic-ejb-jar.xml");
        this.getWeblogicEjbJar();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.file));
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        this.dataObject = dataObject;
    }

    public synchronized EjbJarModel getWeblogicEjbJar() {
        if (this.weblogicEjbJar == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.weblogicEjbJar = EjbJarModel.forFile(this.file);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.weblogicEjbJar = this.genereateWeblogicEjbJar();
                    this.weblogicEjbJar.write(this.file);
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.weblogicEjbJar;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void dispose() {
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            EjbDeploymentConfiguration ejbDeploymentConfiguration = this;
            synchronized (ejbDeploymentConfiguration) {
                this.weblogicEjbJar = null;
            }
        }
    }

    public void save(OutputStream os) throws ConfigurationException {
        EjbJarModel weblogicEjbJar = this.getWeblogicEjbJar();
        if (weblogicEjbJar == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        try {
            weblogicEjbJar.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyWeblogicEjbJar(WeblogicEjbJarModifier modifier) throws ConfigurationException {
        assert (this.dataObject != null) : "DataObject has not been initialized yet";
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            EjbJarModel newWeblogicEjbJar = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newWeblogicEjbJar = EjbJarModel.forInputStream(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                EjbJarModel oldWeblogicEjbJar = this.getWeblogicEjbJar();
                if (oldWeblogicEjbJar == null) {
                    String msg = NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_configFileCannotParse", (Object)this.file.getPath());
                    throw new ConfigurationException(msg);
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_weblogicEjbJarXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newWeblogicEjbJar = oldWeblogicEjbJar;
            }
            modifier.modify(newWeblogicEjbJar);
            boolean modified = this.dataObject.isModified();
            this.replaceDocument(doc, newWeblogicEjbJar);
            if (!modified && (cookie = (SaveCookie)this.dataObject.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            EjbDeploymentConfiguration ejbDeploymentConfiguration = this;
            synchronized (ejbDeploymentConfiguration) {
                this.weblogicEjbJar = newWeblogicEjbJar;
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private void replaceDocument(final StyledDocument doc, EjbJarModel graph) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            graph.write(out);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
        });
    }

    @Override
    public void bindDatasourceReferenceForEjb(final String ejbName, final String ejbType, final String referenceName, final String jndiName) throws ConfigurationException {
        if (ejbName == null || ejbName.length() == 0 || referenceName == null || referenceName.length() == 0 || jndiName == null || jndiName.length() == 0) {
            return;
        }
        this.modifyWeblogicEjbJar(new WeblogicEjbJarModifier(){

            @Override
            public void modify(EjbJarModel webLogicEjbJar) {
                webLogicEjbJar.setReference(ejbName, ejbType, referenceName, jndiName);
            }
        });
    }

    @Override
    public String findDatasourceJndiNameForEjb(String ejbName, String referenceName) throws ConfigurationException {
        EjbJarModel webLogicEjbJar = this.getWeblogicEjbJar();
        if (webLogicEjbJar == null) {
            String msg = NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_CannotReadReferenceName", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        return webLogicEjbJar.getReferenceJndiName(ejbName, referenceName);
    }

    private EjbJarModel genereateWeblogicEjbJar() {
        return EjbJarModel.generate(this.serverVersion);
    }

    private static interface WeblogicEjbJarModifier {
        public void modify(EjbJarModel var1);
    }
}

