/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.hints.pom.spi.SelectionPOMFixProvider;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class StatusProvider
implements UpToDateStatusProviderFactory {
    private static final String LAYER_POM = "pom";
    private static final String LAYER_POM_SELECTION = "pom-selection";
    private static final RequestProcessor RP = new RequestProcessor("StatusProvider");

    public UpToDateStatusProvider createUpToDateStatusProvider(Document document) {
        return new StatusProviderImpl(document);
    }

    static class StatusProviderImpl
    extends UpToDateStatusProvider {
        private Document document;
        private POMModel model;
        private Project project;
        private FileChangeListener listener;

        StatusProviderImpl(Document doc) {
            this.document = doc;
            this.listener = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            StatusProviderImpl.this.checkHints();
                        }
                    });
                }
            };
            this.initializeModel();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    StatusProviderImpl.this.checkHints();
                }
            });
        }

        private void checkHints() {
            HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM, StatusProviderImpl.findHints(this.model, this.project, -1, -1));
        }

        static List<ErrorDescription> findHints(final POMModel model, final Project project, final int selectionStart, final int selectionEnd) {
            assert (model != null);
            if (!model.getModelSource().isEditable()) {
                return new ArrayList<ErrorDescription>();
            }
            try {
                model.getBaseDocument();
                model.sync();
            }
            catch (IOException ex) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.FINE, "Error while syncing pom model.", ex);
            }
            final ArrayList<ErrorDescription> err = new ArrayList<ErrorDescription>();
            if (!model.getState().equals((Object)Model.State.VALID)) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.FINE, "Pom model document is not valid, is {0}", model.getState());
                return err;
            }
            if (model.getProject() == null) {
                Logger.getLogger(StatusProvider.class.getName()).log(Level.FINE, "Pom model root element missing");
                return err;
            }
            return (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List<ErrorDescription>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<ErrorDescription> run() {
                    boolean isInTransaction = model.isIntransaction();
                    if (!isInTransaction && !model.startTransaction()) {
                        return err;
                    }
                    try {
                        Lookup.Result res;
                        Lookup lkp = Lookups.forPath((String)"org-netbeans-modules-maven-hints");
                        if (selectionStart == -1 && selectionEnd == -1) {
                            res = lkp.lookupResult(POMErrorFixProvider.class);
                            for (POMErrorFixProvider prov : res.allInstances()) {
                                List<ErrorDescription> lst;
                                if (!prov.getConfiguration().isEnabled(prov.getConfiguration().getPreferences()) || (lst = prov.getErrorsForDocument(model, project)) == null) continue;
                                err.addAll(lst);
                            }
                        } else {
                            res = lkp.lookupResult(SelectionPOMFixProvider.class);
                            for (SelectionPOMFixProvider prov : res.allInstances()) {
                                List<ErrorDescription> lst;
                                if (!prov.getConfiguration().isEnabled(prov.getConfiguration().getPreferences()) || (lst = prov.getErrorsForDocument(model, project, selectionStart, selectionEnd)) == null) continue;
                                err.addAll(lst);
                            }
                        }
                        List list = err;
                        return list;
                    }
                    finally {
                        if (!isInTransaction && model.isIntransaction()) {
                            model.endTransaction();
                        }
                    }
                }
            });
        }

        private void initializeModel() {
            FileObject fo = NbEditorUtilities.getFileObject((Document)this.document);
            if (fo != null) {
                ModelSource ms = Utilities.createModelSource((FileObject)fo);
                this.model = POMModelFactory.getDefault().getModel(ms);
                this.model.setAutoSyncActive(false);
                this.project = FileOwnerQuery.getOwner((FileObject)fo);
                fo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)fo));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpToDateStatus getUpToDate() {
            if (!this.model.isIntransaction()) {
                FileObject fo = NbEditorUtilities.getFileObject((Document)this.document);
                boolean ok = false;
                try {
                    JEditorPane[] panes;
                    DataObject dobj;
                    EditorCookie ed;
                    if (fo.isValid() && (ed = (EditorCookie)(dobj = DataObject.find((FileObject)fo)).getCookie(EditorCookie.class)) != null && (panes = ed.getOpenedPanes()) != null && panes.length > 0 && panes[0].getSelectionStart() != panes[0].getSelectionEnd()) {
                        HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM_SELECTION, StatusProviderImpl.findHints(this.model, this.project, panes[0].getSelectionStart(), panes[0].getSelectionEnd()));
                        ok = true;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    Logger.getLogger(StatusProvider.class.getName()).log(Level.INFO, "Touched somehow invalidated FileObject", ex);
                }
                finally {
                    if (!ok) {
                        HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM_SELECTION, Collections.emptyList());
                    }
                }
            }
            return UpToDateStatus.UP_TO_DATE_OK;
        }
    }
}

