/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.source;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.source.SourceDataObject;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.CloneableOpenSupport;

public class CppEditorSupport
extends DataEditorSupport
implements EditCookie,
EditorCookie,
EditorCookie.Observable,
OpenCookie,
CloseCookie,
PrintCookie,
ReadOnlySupport {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            CppEditorSupport.this.saveDocument();
            CppEditorSupport.this.getDataObject().setModified(false);
        }
    };
    private final InstanceContent ic;
    private boolean readonly;

    public CppEditorSupport(SourceDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new Environment((DataObject)obj));
        this.ic = obj.getInstanceContent();
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    protected boolean asynchronousOpen() {
        return true;
    }

    private void addSaveCookie() {
        this.ic.add((Object)this.saveCookie);
    }

    private void removeSaveCookie() {
        this.ic.remove((Object)this.saveCookie);
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
    }

    UndoRedo.Manager getUndoRedoImpl() {
        return super.getUndoRedo();
    }

    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        DataObject dao = this.getDataObject();
        FileObject fo = dao.getPrimaryFile();
        boolean resetLS = true;
        if (CndFileUtils.isLocalFileSystem((FileSystem)fo.getFileSystem())) {
            resetLS = false;
        } else {
            int ch;
            InputStream in = fo.getInputStream();
            block3: while ((ch = in.read()) != -1) {
                switch (ch) {
                    case 10: 
                    case 13: {
                        resetLS = false;
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            in.close();
        }
        super.loadFromStreamToKit(doc, stream, kit);
        if (resetLS) {
            doc.putProperty("__EndOfLine__", "\n");
        }
    }

    protected String documentID() {
        DataObject dataObject = this.getDataObject();
        if (dataObject != null && dataObject.isValid()) {
            return dataObject.getPrimaryFile().getNameExt();
        }
        return "";
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(DataObject obj) {
            super(obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            ReadOnlySupport readOnly = (ReadOnlySupport)this.getDataObject().getLookup().lookup(ReadOnlySupport.class);
            if (readOnly != null && readOnly.isReadOnly()) {
                throw new IOException();
            }
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(CppEditorSupport.class);
        }
    }
}

