/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.javadoc.JavadocImports;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.ColoringManager;
import org.netbeans.modules.java.editor.semantic.LexerBasedHighlightLayer;
import org.netbeans.modules.java.editor.semantic.RemoveUnusedImportFix;
import org.netbeans.modules.java.editor.semantic.TokenList;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class SemanticHighlighter
extends JavaParserResultTask {
    private FileObject file;
    private AtomicBoolean cancel = new AtomicBoolean();
    static ErrorDescriptionSetter ERROR_DESCRIPTION_SETTER = new ErrorDescriptionSetter(){

        @Override
        public void setErrors(Document doc, List<ErrorDescription> errors, List<TreePathHandle> allUnusedImports) {
            FileObject file = NbEditorUtilities.getFileObject((Document)doc);
            if (file != null && org.netbeans.modules.editor.java.Utilities.disableErrors(file).contains(Severity.VERIFIER)) {
                return;
            }
            HintsController.setErrors((Document)doc, (String)"semantic-highlighter", errors);
        }

        @Override
        public void setHighlights(final Document doc, final OffsetsBag highlights) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SemanticHighlighter.getImportHighlightsBag(doc).setHighlights(highlights);
                }
            });
        }

        @Override
        public void setColorings(final Document doc, final Map<Token, ColoringAttributes.Coloring> colorings, final Set<Token> addedTokens, final Set<Token> removedTokens) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LexerBasedHighlightLayer.getLayer(SemanticHighlighter.class, doc).setColorings(colorings, addedTokens, removedTokens);
                }
            });
        }
    };

    public static List<TreePathHandle> computeUnusedImports(CompilationInfo info) throws IOException {
        SemanticHighlighter sh = new SemanticHighlighter(info.getFileObject());
        final ArrayList<TreePathHandle> result = new ArrayList<TreePathHandle>();
        Document doc = info.getDocument();
        if (doc == null) {
            Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return result;
        }
        sh.process(info, doc, new ErrorDescriptionSetter(){

            @Override
            public void setErrors(Document doc, List<ErrorDescription> errors, List<TreePathHandle> allUnusedImports) {
                result.addAll(allUnusedImports);
            }

            @Override
            public void setHighlights(Document doc, OffsetsBag highlights) {
            }

            @Override
            public void setColorings(Document doc, Map<Token, ColoringAttributes.Coloring> colorings, Set<Token> addedTokens, Set<Token> removedTokens) {
            }
        });
        return result;
    }

    SemanticHighlighter(FileObject file) {
        super(JavaSource.Phase.RESOLVED);
        this.file = file;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        CompilationInfo info = CompilationInfo.get((Parser.Result)result);
        if (info == null) {
            return;
        }
        this.cancel.set(false);
        final Document doc = result.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return;
        }
        final boolean[] tokenSequenceNull = new boolean[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                tokenSequenceNull[0] = TokenHierarchy.get((Document)doc).tokenSequence() == null;
            }
        });
        if (tokenSequenceNull[0]) {
            return;
        }
        if (this.process(info, doc)) {
            // empty if block
        }
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    boolean process(CompilationInfo info, Document doc) {
        return this.process(info, doc, ERROR_DESCRIPTION_SETTER);
    }

    static ColoringAttributes.Coloring collection2Coloring(Collection<ColoringAttributes> attr) {
        ColoringAttributes.Coloring c = ColoringAttributes.empty();
        for (ColoringAttributes a : attr) {
            c = ColoringAttributes.add(c, a);
        }
        return c;
    }

    boolean process(CompilationInfo info, Document doc, ErrorDescriptionSetter setter) {
        OffsetsBag imports;
        DetectorVisitor v = new DetectorVisitor(info, doc, this.cancel);
        long start = System.currentTimeMillis();
        IdentityHashMap<Token, ColoringAttributes.Coloring> newColoring = new IdentityHashMap<Token, ColoringAttributes.Coloring>();
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        CompilationUnitTree cu = info.getCompilationUnit();
        v.scan(cu, null);
        if (this.cancel.get()) {
            return true;
        }
        boolean computeUnusedImports = "text/x-java".equals(FileUtil.getMIMEType((FileObject)info.getFileObject()));
        ArrayList<TreePathHandle> allUnusedImports = computeUnusedImports ? new ArrayList<TreePathHandle>() : null;
        RemoveUnusedImportFix removeAllUnusedImports = computeUnusedImports ? RemoveUnusedImportFix.create(this.file, allUnusedImports) : null;
        OffsetsBag offsetsBag = imports = computeUnusedImports ? new OffsetsBag(doc) : null;
        if (computeUnusedImports) {
            ColoringAttributes.Coloring unused = ColoringAttributes.add(ColoringAttributes.empty(), ColoringAttributes.UNUSED);
            for (TreePath tree : v.import2Highlight.values()) {
                if (this.cancel.get()) {
                    return true;
                }
                int startPos = (int)info.getTrees().getSourcePositions().getStartPosition(cu, tree.getLeaf());
                int endPos = (int)info.getTrees().getSourcePositions().getEndPosition(cu, tree.getLeaf());
                imports.addHighlight(startPos, endPos, ColoringManager.getColoringImpl(unused));
                int line = (int)info.getCompilationUnit().getLineMap().getLineNumber(startPos);
                TreePathHandle handle = TreePathHandle.create((TreePath)tree, (CompilationInfo)info);
                RemoveUnusedImportFix removeImport = RemoveUnusedImportFix.create(this.file, handle);
                allUnusedImports.add(handle);
                if (!RemoveUnusedImportFix.isEnabled()) continue;
                errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)RemoveUnusedImportFix.getSeverity(), (String)NbBundle.getMessage(SemanticHighlighter.class, (String)"LBL_UnusedImport"), (LazyFixList)new FixAllImportsFixList(removeImport, removeAllUnusedImports, allUnusedImports), (Document)doc, (int)line));
            }
        }
        Map<Token, ColoringAttributes.Coloring> oldColors = LexerBasedHighlightLayer.getLayer(SemanticHighlighter.class, doc).getColorings();
        HashSet<Token> removedTokens = new HashSet<Token>(oldColors.keySet());
        HashSet<Token> addedTokens = new HashSet<Token>();
        for (Element decl : v.type2Uses.keySet()) {
            if (this.cancel.get()) {
                return true;
            }
            List uses = (List)v.type2Uses.get(decl);
            for (Use u : uses) {
                if (u.spec == null) continue;
                if (u.type.contains((Object)UseTypes.DECLARATION) && Utilities.isPrivateElement(decl)) {
                    if ((decl.getKind().isField() && !SemanticHighlighter.isSerialVersionUID(info, decl) || SemanticHighlighter.isLocalVariableClosure(decl)) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.READ, UseTypes.WRITE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                    if ((decl.getKind() == ElementKind.CONSTRUCTOR && !decl.getModifiers().contains((Object)Modifier.PRIVATE) || decl.getKind() == ElementKind.METHOD) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.EXECUTE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                    if ((decl.getKind().isClass() || decl.getKind().isInterface()) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.CLASS_USE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                }
                ColoringAttributes.Coloring c = SemanticHighlighter.collection2Coloring(u.spec);
                Token t = (Token)v.tree2Token.get(u.tree.getLeaf());
                if (t == null) continue;
                newColoring.put(t, c);
                if (removedTokens.remove(t)) continue;
                addedTokens.add(t);
            }
        }
        if (this.cancel.get()) {
            return true;
        }
        if (computeUnusedImports) {
            setter.setErrors(doc, errors, allUnusedImports);
            setter.setHighlights(doc, imports);
        }
        setter.setColorings(doc, newColoring, addedTokens, removedTokens);
        Logger.getLogger("TIMER").log(Level.FINE, "Semantic", new Object[]{NbEditorUtilities.getFileObject((Document)doc), System.currentTimeMillis() - start});
        return false;
    }

    private boolean hasAllTypes(List<Use> uses, Collection<UseTypes> types) {
        EnumSet<UseTypes> e = EnumSet.copyOf(types);
        for (Use u : uses) {
            if (types.isEmpty()) {
                return true;
            }
            types.removeAll(u.type);
        }
        return types.isEmpty();
    }

    private static boolean isLocalVariableClosure(Element el) {
        return el.getKind() == ElementKind.PARAMETER || el.getKind() == ElementKind.LOCAL_VARIABLE || el.getKind() == ElementKind.EXCEPTION_PARAMETER;
    }

    private static boolean isSerialVersionUID(CompilationInfo info, Element el) {
        return el.getKind().isField() && el.getModifiers().contains((Object)Modifier.FINAL) && el.getModifiers().contains((Object)Modifier.STATIC) && info.getTypes().getPrimitiveType(TypeKind.LONG).equals(el.asType()) && el.getSimpleName().toString().equals("serialVersionUID");
    }

    static OffsetsBag getImportHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(FixAllImportsFixList.class);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(FixAllImportsFixList.class, bag);
            Object stream = doc.getProperty("stream");
            if (stream instanceof DataObject) {
                // empty if block
            }
        }
        return bag;
    }

    public static interface ErrorDescriptionSetter {
        public void setErrors(Document var1, List<ErrorDescription> var2, List<TreePathHandle> var3);

        public void setHighlights(Document var1, OffsetsBag var2);

        public void setColorings(Document var1, Map<Token, ColoringAttributes.Coloring> var2, Set<Token> var3, Set<Token> var4);
    }

    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, EnumSet<UseTypes>> {
        private CompilationInfo info;
        private Document doc;
        private Map<Element, List<Use>> type2Uses;
        private final Map<Element, ImportTree> element2Import = new HashMap<Element, ImportTree>();
        private final Map<String, ImportTree> method2Import = new HashMap<String, ImportTree>();
        private final Map<String, Collection<ImportTree>> simpleName2UnresolvableImports = new HashMap<String, Collection<ImportTree>>();
        private final Set<ImportTree> unresolvablePackageImports = new HashSet<ImportTree>();
        private final Map<ImportTree, TreePath> import2Highlight = new HashMap<ImportTree, TreePath>();
        private Map<Tree, Token> tree2Token;
        private TokenList tl;
        private long memberSelectBypass = -1L;
        private SourcePositions sourcePositions;
        private ExecutableElement recursionDetector;
        private static final Set<Tree.Kind> LITERALS = EnumSet.of(Tree.Kind.BOOLEAN_LITERAL, new Tree.Kind[]{Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.STRING_LITERAL});

        private DetectorVisitor(CompilationInfo info, Document doc, AtomicBoolean cancel) {
            super(cancel);
            this.info = info;
            this.doc = doc;
            this.type2Uses = new HashMap<Element, List<Use>>();
            this.tree2Token = new IdentityHashMap<Tree, Token>();
            this.tl = new TokenList(info, doc, cancel);
            this.sourcePositions = info.getTrees().getSourcePositions();
        }

        private void firstIdentifier(String name) {
            this.tl.firstIdentifier(this.getCurrentPath(), name, this.tree2Token);
        }

        public Void visitAssignment(AssignmentTree tree, EnumSet<UseTypes> d) {
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getVariable()), EnumSet.of(UseTypes.WRITE));
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getExpression(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitCompoundAssignment(CompoundAssignmentTree tree, EnumSet<UseTypes> d) {
            EnumSet<UseTypes> useTypes = EnumSet.of(UseTypes.WRITE);
            if (d != null) {
                useTypes.addAll(d);
            }
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getVariable()), useTypes);
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getExpression(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitReturn(ReturnTree tree, EnumSet<UseTypes> d) {
            if (tree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitReturn(tree, EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitMemberSelect(MemberSelectTree tree, EnumSet<UseTypes> d) {
            Element el;
            long memberSelectBypassLoc = this.memberSelectBypass;
            this.memberSelectBypass = -1L;
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            if ((el = this.info.getTrees().getElement(this.getCurrentPath())) != null && el.getKind().isField()) {
                this.handlePossibleIdentifier(this.getCurrentPath(), d == null ? EnumSet.of(UseTypes.READ) : d);
            }
            if (el != null && (el.getKind().isClass() || el.getKind().isInterface()) && this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.CLASS_USE));
            }
            super.visitMemberSelect(tree, null);
            this.tl.moveToEnd(tree.getExpression());
            if (memberSelectBypassLoc != -1L) {
                this.tl.moveToOffset(memberSelectBypassLoc);
            }
            this.firstIdentifier(tree.getIdentifier().toString());
            return null;
        }

        private void addModifiers(Element decl, Collection<ColoringAttributes> c) {
            if (decl.getModifiers().contains((Object)Modifier.STATIC)) {
                c.add(ColoringAttributes.STATIC);
            }
            if (decl.getModifiers().contains((Object)Modifier.ABSTRACT) && !decl.getKind().isInterface()) {
                c.add(ColoringAttributes.ABSTRACT);
            }
            boolean accessModifier = false;
            if (decl.getModifiers().contains((Object)Modifier.PUBLIC)) {
                c.add(ColoringAttributes.PUBLIC);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PROTECTED)) {
                c.add(ColoringAttributes.PROTECTED);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PRIVATE)) {
                c.add(ColoringAttributes.PRIVATE);
                accessModifier = true;
            }
            if (!accessModifier && !SemanticHighlighter.isLocalVariableClosure(decl)) {
                c.add(ColoringAttributes.PACKAGE_PRIVATE);
            }
            if (this.info.getElements().isDeprecated(decl)) {
                c.add(ColoringAttributes.DEPRECATED);
            }
        }

        private Collection<ColoringAttributes> getMethodColoring(ExecutableElement mdecl, boolean nct) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(mdecl, c);
            if (mdecl.getKind() == ElementKind.CONSTRUCTOR) {
                c.add(ColoringAttributes.CONSTRUCTOR);
                if (nct && mdecl.getEnclosingElement() != null && this.info.getElements().isDeprecated(mdecl.getEnclosingElement())) {
                    c.add(ColoringAttributes.DEPRECATED);
                }
            } else {
                c.add(ColoringAttributes.METHOD);
            }
            return c;
        }

        private Collection<ColoringAttributes> getVariableColoring(Element decl) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(decl, c);
            if (decl.getKind().isField()) {
                c.add(ColoringAttributes.FIELD);
                return c;
            }
            if (decl.getKind() == ElementKind.LOCAL_VARIABLE || decl.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                c.add(ColoringAttributes.LOCAL_VARIABLE);
                return c;
            }
            if (decl.getKind() == ElementKind.PARAMETER) {
                c.add(ColoringAttributes.PARAMETER);
                return c;
            }
            assert (false);
            return null;
        }

        private void handlePossibleIdentifier(TreePath expr, Collection<UseTypes> type) {
            this.handlePossibleIdentifier(expr, type, null, false, false);
        }

        private void handlePossibleIdentifier(TreePath expr, Collection<UseTypes> type, Element decl, boolean providesDecl, boolean nct) {
            if (Utilities.isKeyword(expr.getLeaf())) {
                return;
            }
            if (expr.getLeaf().getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                return;
            }
            if (LITERALS.contains((Object)expr.getLeaf().getKind())) {
                return;
            }
            decl = !providesDecl ? this.info.getTrees().getElement(expr) : decl;
            Collection<ColoringAttributes> c = null;
            if (decl != null && (decl.getKind().isField() || SemanticHighlighter.isLocalVariableClosure(decl))) {
                c = this.getVariableColoring(decl);
            }
            if (decl != null && decl instanceof ExecutableElement) {
                c = this.getMethodColoring((ExecutableElement)decl, nct);
            }
            if (decl != null && (decl.getKind().isClass() || decl.getKind().isInterface())) {
                if (type.contains((Object)UseTypes.READ)) {
                    type = EnumSet.copyOf(type);
                    type.remove((Object)UseTypes.READ);
                    type.add(UseTypes.CLASS_USE);
                }
                c = new ArrayList<ColoringAttributes>();
                this.addModifiers(decl, c);
                switch (decl.getKind()) {
                    case CLASS: {
                        c.add(ColoringAttributes.CLASS);
                        break;
                    }
                    case INTERFACE: {
                        c.add(ColoringAttributes.INTERFACE);
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        c.add(ColoringAttributes.ANNOTATION_TYPE);
                        break;
                    }
                    case ENUM: {
                        c.add(ColoringAttributes.ENUM);
                    }
                }
            }
            if (decl != null && type.contains((Object)UseTypes.DECLARATION)) {
                if (c == null) {
                    c = new ArrayList<ColoringAttributes>();
                }
                c.add(ColoringAttributes.DECLARATION);
            }
            if (c != null) {
                this.addUse(decl, type, expr, c);
            }
            this.typeUsed(decl, expr, type);
        }

        private void handleJavadoc(TreePath classMember) {
            if (classMember == null) {
                return;
            }
            for (TypeElement el : JavadocImports.computeReferencedElements(this.info, classMember)) {
                this.typeUsed(el, null, EnumSet.of(UseTypes.CLASS_USE));
            }
        }

        private void addUse(Element decl, Collection<UseTypes> useTypes, TreePath t, Collection<ColoringAttributes> c) {
            List<Use> uses;
            if (decl == this.recursionDetector) {
                useTypes.remove((Object)UseTypes.EXECUTE);
            }
            if ((uses = this.type2Uses.get(decl)) == null) {
                uses = new ArrayList<Use>();
                this.type2Uses.put(decl, uses);
            }
            Use u = new Use(useTypes, t, c);
            uses.add(u);
        }

        public Void visitTypeCast(TypeCastTree tree, EnumSet<UseTypes> d) {
            Tree cast;
            ExpressionTree expr = tree.getExpression();
            if (expr.getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            if ((cast = tree.getType()).getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), cast), EnumSet.of(UseTypes.READ));
            }
            super.visitTypeCast(tree, d);
            return null;
        }

        public Void visitInstanceOf(InstanceOfTree tree, EnumSet<UseTypes> d) {
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            TreePath tp = new TreePath(this.getCurrentPath(), tree.getType());
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            super.visitInstanceOf(tree, null);
            return null;
        }

        public Void visitCompilationUnit(CompilationUnitTree tree, EnumSet<UseTypes> d) {
            this.tl.moveBefore(tree.getImports());
            this.scan(tree.getImports(), d);
            this.tl.moveBefore(tree.getPackageAnnotations());
            this.scan(tree.getPackageAnnotations(), d);
            this.tl.moveToEnd(tree.getImports());
            this.scan(tree.getTypeDecls(), d);
            return null;
        }

        private long startOf(List<? extends Tree> trees) {
            if (trees.isEmpty()) {
                return -1L;
            }
            return this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), trees.get(0));
        }

        private void handleMethodTypeArguments(TreePath method, List<? extends Tree> tArgs) {
            this.tl.moveBefore(tArgs);
            for (Tree tree : tArgs) {
                if (!(tree instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(method, tree), EnumSet.of(UseTypes.CLASS_USE));
            }
        }

        public Void visitMethodInvocation(MethodInvocationTree tree, EnumSet<UseTypes> d) {
            List<? extends Tree> ta;
            String ident;
            ExpressionTree possibleIdent = tree.getMethodSelect();
            boolean handled = false;
            if (possibleIdent.getKind() == Tree.Kind.IDENTIFIER && ("super".equals(ident = ((IdentifierTree)possibleIdent).getName().toString()) || "this".equals(ident))) {
                Element resolved = this.info.getTrees().getElement(this.getCurrentPath());
                this.addUse(resolved, EnumSet.of(UseTypes.EXECUTE), null, null);
                handled = true;
            }
            if (!handled) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), possibleIdent), EnumSet.of(UseTypes.EXECUTE));
            }
            long afterTypeArguments = (ta = tree.getTypeArguments()).isEmpty() ? -1L : this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), ta.get(ta.size() - 1));
            switch (tree.getMethodSelect().getKind()) {
                case IDENTIFIER: 
                case MEMBER_SELECT: {
                    this.memberSelectBypass = afterTypeArguments;
                    this.scan(tree.getMethodSelect(), null);
                    this.memberSelectBypass = -1L;
                    break;
                }
                default: {
                    this.scan(tree.getMethodSelect(), null);
                }
            }
            this.handleMethodTypeArguments(this.getCurrentPath(), ta);
            this.scan(tree.getTypeArguments(), null);
            for (ExpressionTree expressionTree : tree.getArguments()) {
                if (!(expressionTree instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getArguments(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitIdentifier(IdentifierTree tree, EnumSet<UseTypes> d) {
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            if (this.memberSelectBypass != -1L) {
                this.tl.moveToOffset(this.memberSelectBypass);
                this.memberSelectBypass = -1L;
            }
            this.tl.identifierHere(tree, this.tree2Token);
            if (d != null) {
                this.handlePossibleIdentifier(this.getCurrentPath(), d);
            }
            super.visitIdentifier(tree, null);
            return null;
        }

        public Void visitMethod(MethodTree tree, EnumSet<UseTypes> d) {
            String name;
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.DECLARATION));
            for (ExpressionTree expressionTree : tree.getThrows()) {
                TreePath tp = new TreePath(this.getCurrentPath(), expressionTree);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            this.handleJavadoc(this.getCurrentPath());
            EnumSet<UseTypes> paramsUseTypes = element != null && (element.getModifiers().contains((Object)Modifier.ABSTRACT) || element.getModifiers().contains((Object)Modifier.NATIVE) || !element.getModifiers().contains((Object)Modifier.PRIVATE)) ? EnumSet.of(UseTypes.WRITE, UseTypes.READ) : EnumSet.of(UseTypes.WRITE);
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.scan(tree.getTypeParameters(), null);
            this.tl.moveToEnd(tree.getTypeParameters());
            this.scan(tree.getReturnType(), EnumSet.of(UseTypes.CLASS_USE));
            this.tl.moveToEnd(tree.getReturnType());
            if (tree.getReturnType() != null) {
                name = tree.getName().toString();
            } else {
                TreePath tp;
                for (tp = this.getCurrentPath(); tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
                }
                name = tp != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) ? ((ClassTree)tp.getLeaf()).getSimpleName().toString() : null;
            }
            if (name != null) {
                this.firstIdentifier(name);
            }
            this.scan(tree.getParameters(), paramsUseTypes);
            this.scan(tree.getThrows(), null);
            this.scan(tree.getDefaultValue(), null);
            this.recursionDetector = element != null && element.getKind() == ElementKind.METHOD ? (ExecutableElement)element : null;
            this.scan(tree.getBody(), null);
            this.recursionDetector = null;
            return null;
        }

        public Void visitExpressionStatement(ExpressionStatementTree tree, EnumSet<UseTypes> d) {
            super.visitExpressionStatement(tree, null);
            return null;
        }

        public Void visitParenthesized(ParenthesizedTree tree, EnumSet<UseTypes> d) {
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            super.visitParenthesized(tree, d);
            return null;
        }

        public Void visitEnhancedForLoop(EnhancedForLoopTree tree, EnumSet<UseTypes> d) {
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            if (tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getExpression(), null);
            this.scan(tree.getStatement(), null);
            return null;
        }

        private boolean isStar(ImportTree tree) {
            Tree qualIdent = tree.getQualifiedIdentifier();
            if (qualIdent == null || qualIdent.getKind() == Tree.Kind.IDENTIFIER) {
                return false;
            }
            return ((MemberSelectTree)qualIdent).getIdentifier().contentEquals("*");
        }

        private boolean parseErrorInImport(ImportTree imp) {
            if (this.isStar(imp)) {
                return false;
            }
            final StringBuilder fqn = new StringBuilder();
            new TreeScanner<Void, Void>(){

                @Override
                public Void visitMemberSelect(MemberSelectTree node, Void p) {
                    super.visitMemberSelect(node, p);
                    fqn.append('.');
                    fqn.append(node.getIdentifier());
                    return null;
                }

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    fqn.append(node.getName());
                    return null;
                }
            }.scan(imp.getQualifiedIdentifier(), null);
            return !SourceVersion.isName(fqn);
        }

        public Void visitImport(ImportTree tree, EnumSet<UseTypes> d) {
            if (this.parseErrorInImport(tree)) {
                return (Void)super.visitImport(tree, null);
            }
            if (!tree.isStatic()) {
                if (this.isStar(tree)) {
                    MemberSelectTree qualIdent = (MemberSelectTree)tree.getQualifiedIdentifier();
                    Element decl = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), qualIdent), qualIdent.getExpression()));
                    if (decl != null && decl.getKind() == ElementKind.PACKAGE) {
                        if (!ElementFilter.typesIn(decl.getEnclosedElements()).isEmpty()) {
                            for (TypeElement te : ElementFilter.typesIn(decl.getEnclosedElements())) {
                                this.element2Import.put(te, tree);
                            }
                            this.import2Highlight.put(tree, this.getCurrentPath());
                        } else {
                            this.unresolvablePackageImports.add(tree);
                            this.import2Highlight.put(tree, this.getCurrentPath());
                        }
                    }
                } else {
                    Element decl = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), tree.getQualifiedIdentifier()));
                    if (decl != null) {
                        if (decl.asType().getKind() != TypeKind.ERROR) {
                            this.element2Import.put(decl, tree);
                            this.import2Highlight.put(tree, this.getCurrentPath());
                        } else if (tree.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT) {
                            this.addUnresolvableImport(((MemberSelectTree)tree.getQualifiedIdentifier()).getIdentifier(), tree);
                            this.import2Highlight.put(tree, this.getCurrentPath());
                        }
                    }
                }
            } else if (tree.getQualifiedIdentifier() != null && tree.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree qualIdent = (MemberSelectTree)tree.getQualifiedIdentifier();
                Element decl = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), qualIdent), qualIdent.getExpression()));
                if (decl != null && (decl.getKind().isClass() || decl.getKind().isInterface())) {
                    if (decl.asType().getKind() != TypeKind.ERROR) {
                        Name simpleName = this.isStar(tree) ? null : qualIdent.getIdentifier();
                        boolean assign = false;
                        for (Element element : this.info.getElements().getAllMembers((TypeElement)decl)) {
                            if (!element.getModifiers().contains((Object)Modifier.STATIC) || simpleName != null && !((Object)element.getSimpleName()).equals(simpleName)) continue;
                            if (element.getKind() == ElementKind.METHOD) {
                                this.method2Import.put(element.getSimpleName().toString() + ((Object)element.asType()).toString(), tree);
                                assign = true;
                                continue;
                            }
                            if (element.getKind().isField()) {
                                this.element2Import.put(element, tree);
                                assign = true;
                                continue;
                            }
                            if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
                            this.element2Import.put(element, tree);
                            assign = true;
                        }
                        if (!assign) {
                            this.addUnresolvableImport(qualIdent.getIdentifier(), tree);
                        }
                        this.import2Highlight.put(tree, this.getCurrentPath());
                    } else {
                        if (!this.isStar(tree)) {
                            this.addUnresolvableImport(qualIdent.getIdentifier(), tree);
                        } else {
                            this.unresolvablePackageImports.add(tree);
                        }
                        this.import2Highlight.put(tree, this.getCurrentPath());
                    }
                }
            }
            super.visitImport(tree, null);
            return null;
        }

        private void addUnresolvableImport(Name name, ImportTree imp) {
            String key = name.toString();
            Collection<ImportTree> l = this.simpleName2UnresolvableImports.get(key);
            if (l == null) {
                l = new LinkedList<ImportTree>();
                this.simpleName2UnresolvableImports.put(key, l);
            }
            l.add(imp);
        }

        public Void visitVariable(VariableTree tree, EnumSet<UseTypes> d) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            TreePath type = new TreePath(this.getCurrentPath(), tree.getType());
            if (type.getLeaf() instanceof ArrayTypeTree) {
                type = new TreePath(type, ((ArrayTypeTree)type.getLeaf()).getType());
            }
            if (type.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(type, EnumSet.of(UseTypes.CLASS_USE));
            }
            EnumSet<UseTypes> uses = null;
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (tree.getInitializer() != null) {
                uses = EnumSet.of(UseTypes.DECLARATION, UseTypes.WRITE);
                if (tree.getInitializer().getKind() == Tree.Kind.IDENTIFIER) {
                    this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getInitializer()), EnumSet.of(UseTypes.READ));
                }
            } else {
                uses = e != null && e.getKind() == ElementKind.FIELD ? EnumSet.of(UseTypes.DECLARATION, UseTypes.WRITE) : EnumSet.of(UseTypes.DECLARATION);
            }
            if (e != null && e.getKind().isField()) {
                this.handleJavadoc(this.getCurrentPath());
            }
            if (d != null) {
                HashSet<UseTypes> ut = new HashSet<UseTypes>();
                ut.addAll(uses);
                ut.addAll(d);
                uses = EnumSet.copyOf(ut);
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), uses);
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.scan(tree.getType(), null);
            this.tl.moveToEnd(tree.getType());
            this.firstIdentifier(tree.getName().toString());
            this.tl.moveNext();
            this.scan(tree.getInitializer(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitAnnotation(AnnotationTree tree, EnumSet<UseTypes> d) {
            TreePath tp = new TreePath(this.getCurrentPath(), tree.getAnnotationType());
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            super.visitAnnotation(tree, EnumSet.noneOf(UseTypes.class));
            return null;
        }

        public Void visitNewClass(NewClassTree tree, EnumSet<UseTypes> d) {
            ExpressionTree ident = tree.getIdentifier();
            TreePath tp = ident.getKind() == Tree.Kind.PARAMETERIZED_TYPE ? new TreePath(new TreePath(this.getCurrentPath(), ident), ((ParameterizedTypeTree)((Object)ident)).getType()) : new TreePath(this.getCurrentPath(), ident);
            this.typeUsed(this.info.getTrees().getElement(tp), tp, EnumSet.of(UseTypes.CLASS_USE));
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.EXECUTE), this.info.getTrees().getElement(this.getCurrentPath()), true, true);
            Element clazz = this.info.getTrees().getElement(tp);
            if (clazz != null) {
                this.addUse(clazz, EnumSet.of(UseTypes.CLASS_USE), null, null);
            }
            for (ExpressionTree expressionTree : tree.getArguments()) {
                if (!(expressionTree instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            super.visitNewClass(tree, null);
            return null;
        }

        public Void visitParameterizedType(ParameterizedTypeTree tree, EnumSet<UseTypes> d) {
            NewClassTree nct;
            boolean alreadyHandled = false;
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                nct = (NewClassTree)this.getCurrentPath().getParentPath().getLeaf();
                boolean bl = alreadyHandled = nct.getTypeArguments().contains(tree) || nct.getIdentifier() == tree;
            }
            if (this.getCurrentPath().getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                nct = (NewClassTree)this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                Tree tree2 = this.getCurrentPath().getParentPath().getLeaf();
                boolean bl = alreadyHandled = nct.getTypeArguments().contains(tree2) || nct.getIdentifier() == tree2;
            }
            if (!alreadyHandled) {
                TreePath tp = new TreePath(this.getCurrentPath(), tree.getType());
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            for (Tree tree3 : tree.getTypeArguments()) {
                TreePath tp = new TreePath(this.getCurrentPath(), tree3);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            super.visitParameterizedType(tree, null);
            return null;
        }

        public Void visitBinary(BinaryTree tree, EnumSet<UseTypes> d) {
            TreePath tp;
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            if (left instanceof IdentifierTree) {
                tp = new TreePath(this.getCurrentPath(), left);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            if (right instanceof IdentifierTree) {
                tp = new TreePath(this.getCurrentPath(), right);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            super.visitBinary(tree, EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitClass(ClassTree tree, EnumSet<UseTypes> d) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            for (TypeParameterTree typeParameterTree : tree.getTypeParameters()) {
                for (Tree tree2 : typeParameterTree.getBounds()) {
                    TreePath tp = new TreePath(new TreePath(this.getCurrentPath(), typeParameterTree), tree2);
                    this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                Tree extnds = tree.getExtendsClause();
                if (extnds != null) {
                    TreePath treePath = new TreePath(this.getCurrentPath(), extnds);
                    this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                }
                for (Tree tree3 : tree.getImplementsClause()) {
                    TreePath treePath = new TreePath(this.getCurrentPath(), tree3);
                    this.handlePossibleIdentifier(treePath, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.DECLARATION));
            this.handleJavadoc(this.getCurrentPath());
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.firstIdentifier(tree.getSimpleName().toString());
            this.scan(tree.getTypeParameters(), null);
            this.scan(tree.getExtendsClause(), null);
            this.scan(tree.getImplementsClause(), null);
            ExecutableElement prevRecursionDetector = this.recursionDetector;
            this.recursionDetector = null;
            this.scan(tree.getMembers(), null);
            this.recursionDetector = prevRecursionDetector;
            return null;
        }

        public Void visitUnary(UnaryTree tree, EnumSet<UseTypes> d) {
            if (tree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitUnary(tree, d);
            return null;
        }

        public Void visitArrayAccess(ArrayAccessTree tree, EnumSet<UseTypes> d) {
            if (tree.getExpression() != null && tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            if (tree.getIndex() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getIndex()), EnumSet.of(UseTypes.READ));
            }
            super.visitArrayAccess(tree, null);
            return null;
        }

        public Void visitArrayType(ArrayTypeTree node, EnumSet<UseTypes> p) {
            if (node.getType() != null) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), node.getType()), EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitArrayType(node, p);
        }

        public Void visitUnionType(UnionTypeTree node, EnumSet<UseTypes> p) {
            for (Tree tree : node.getTypeAlternatives()) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree), EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitUnionType(node, p);
        }

        public Void visitNewArray(NewArrayTree tree, EnumSet<UseTypes> d) {
            if (tree.getType() != null) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getType()), EnumSet.of(UseTypes.CLASS_USE));
            }
            this.scan(tree.getType(), null);
            this.scan(tree.getDimensions(), EnumSet.of(UseTypes.READ));
            this.scan(tree.getInitializers(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitCatch(CatchTree tree, EnumSet<UseTypes> d) {
            this.scan(tree.getParameter(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getBlock(), null);
            return null;
        }

        public Void visitConditionalExpression(ConditionalExpressionTree node, EnumSet<UseTypes> p) {
            return (Void)super.visitConditionalExpression(node, EnumSet.of(UseTypes.READ));
        }

        public Void visitAssert(AssertTree tree, EnumSet<UseTypes> p) {
            if (tree.getCondition().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getCondition()), EnumSet.of(UseTypes.READ));
            }
            if (tree.getDetail() != null && tree.getDetail().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getDetail()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitAssert(tree, EnumSet.of(UseTypes.READ));
        }

        public Void visitCase(CaseTree tree, EnumSet<UseTypes> p) {
            if (tree.getExpression() != null && tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitCase(tree, null);
        }

        public Void visitThrow(ThrowTree tree, EnumSet<UseTypes> p) {
            if (tree.getExpression() != null && tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitThrow(tree, p);
        }

        public Void visitTypeParameter(TypeParameterTree tree, EnumSet<UseTypes> p) {
            for (Tree tree2 : tree.getBounds()) {
                if (tree2.getKind() != Tree.Kind.IDENTIFIER) continue;
                TreePath tp = new TreePath(this.getCurrentPath(), tree2);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitTypeParameter(tree, p);
        }

        public Void visitForLoop(ForLoopTree node, EnumSet<UseTypes> p) {
            if (node.getCondition() != null && node.getCondition().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), node.getCondition()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitForLoop(node, p);
        }

        public Void visitWildcard(WildcardTree node, EnumSet<UseTypes> p) {
            if (node.getBound() != null && node.getBound().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), node.getBound()), EnumSet.of(UseTypes.CLASS_USE));
            }
            return (Void)super.visitWildcard(node, p);
        }

        private void typeUsed(Element decl, TreePath expr, Collection<UseTypes> type) {
            if (decl != null && (expr == null || expr.getLeaf().getKind() == Tree.Kind.IDENTIFIER || expr.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE)) {
                if (decl.asType() != null && decl.asType().getKind() != TypeKind.ERROR) {
                    ImportTree imp;
                    ImportTree importTree = imp = decl.getKind() != ElementKind.METHOD ? this.element2Import.remove(decl) : this.method2Import.remove(decl.getSimpleName().toString() + ((Object)decl.asType()).toString());
                    if (imp != null) {
                        if (this.isStar(imp)) {
                            this.handleUnresolvableImports(decl, type, false);
                        }
                        this.import2Highlight.remove(imp);
                    }
                } else {
                    this.handleUnresolvableImports(decl, type, true);
                }
            }
        }

        private void handleUnresolvableImports(Element decl, Collection<UseTypes> type, boolean removeStarImports) {
            block2: {
                block3: {
                    Name simpleName = decl.getSimpleName();
                    if (simpleName == null) break block2;
                    Collection<ImportTree> imps = this.simpleName2UnresolvableImports.get(simpleName.toString());
                    if (imps == null) break block3;
                    for (ImportTree imp : imps) {
                        if (!type.contains((Object)UseTypes.CLASS_USE) && !imp.isStatic()) continue;
                        this.import2Highlight.remove(imp);
                    }
                    break block2;
                }
                if (!removeStarImports) break block2;
                for (ImportTree unresolvable : this.unresolvablePackageImports) {
                    if (!type.contains((Object)UseTypes.CLASS_USE) && !unresolvable.isStatic()) continue;
                    this.import2Highlight.remove(unresolvable);
                }
            }
        }
    }

    private static class Use {
        private Collection<UseTypes> type;
        private TreePath tree;
        private Collection<ColoringAttributes> spec;

        public Use(Collection<UseTypes> type, TreePath tree, Collection<ColoringAttributes> spec) {
            this.type = type;
            this.tree = tree;
            this.spec = spec;
        }

        public String toString() {
            return "Use: " + this.type;
        }
    }

    private static enum UseTypes {
        READ,
        WRITE,
        EXECUTE,
        DECLARATION,
        CLASS_USE;

    }

    private static class FixAllImportsFixList
    implements LazyFixList {
        private Fix removeImport;
        private Fix removeAllUnusedImports;
        private List<TreePathHandle> allUnusedImports;
        private List<Fix> fixes;

        public FixAllImportsFixList(Fix removeImport, Fix removeAllUnusedImports, List<TreePathHandle> allUnusedImports) {
            this.removeImport = removeImport;
            this.removeAllUnusedImports = removeAllUnusedImports;
            this.allUnusedImports = allUnusedImports;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public synchronized List<Fix> getFixes() {
            if (this.fixes != null) {
                return this.fixes;
            }
            this.fixes = this.allUnusedImports.size() > 1 ? Arrays.asList(this.removeImport, this.removeAllUnusedImports) : Collections.singletonList(this.removeImport);
            return this.fixes;
        }

        public boolean isComputed() {
            return true;
        }
    }
}

