/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.java.api.common.project.ui.wizards.FolderList;
import org.netbeans.modules.web.project.ui.wizards.SettingsPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private final Panel firer;
    private WizardDescriptor wizardDescriptor;
    private JButton jButtonLibraries;
    private JButton jButtonWebInf;
    private JButton jButtonWebpagesLocation;
    private JLabel jLabel3;
    private JLabel jLabelLibraries;
    private JLabel jLabelWebInf;
    private JLabel jLabelWebPages;
    private JLabel jLabelWebPages1;
    private JTextField jTextFieldLibraries;
    private JTextField jTextFieldWebInf;
    private JTextField jTextFieldWebPages;
    private JPanel sourcePanel;
    private JPanel testsPanel;

    public PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(PanelSourceFolders.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_WebExtSources"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel, FolderList.testRootsFilter());
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
        DocumentListener pl = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelSourceFolders.this.firer.fireChangeEvent();
            }
        };
        this.jTextFieldWebPages.getDocument().addDocumentListener(pl);
        this.jTextFieldWebInf.getDocument().addDocumentListener(pl);
    }

    public void initValues(FileObject fo) {
        ((FolderList)this.sourcePanel).setLastUsedDir(FileUtil.toFile((FileObject)fo));
        ((FolderList)this.testsPanel).setLastUsedDir(FileUtil.toFile((FileObject)fo));
        String webPages = "";
        String webInf = "";
        String libraries = "";
        File[] javaRoots = null;
        FileObject guessFO = FileSearchUtility.guessDocBase((FileObject)fo);
        if (guessFO != null) {
            webPages = FileUtil.toFile((FileObject)guessFO).getPath();
        }
        if ((guessFO = FileSearchUtility.guessWebInf((FileObject)fo)) != null) {
            webInf = FileUtil.toFile((FileObject)guessFO).getPath();
        }
        if ((guessFO = FileSearchUtility.guessLibrariesFolder((FileObject)fo)) != null) {
            libraries = FileUtil.toFile((FileObject)guessFO).getPath();
        }
        javaRoots = FileSearchUtility.guessJavaRootsAsFiles((FileObject)fo);
        if (this.jTextFieldWebPages.getText().trim().equals("")) {
            this.jTextFieldWebPages.setText(webPages);
        }
        if (this.jTextFieldWebInf.getText().trim().equals("")) {
            this.jTextFieldWebInf.setText(webInf);
        }
        if (this.jTextFieldLibraries.getText().trim().equals("")) {
            this.jTextFieldLibraries.setText(libraries);
        }
        if (((FolderList)this.sourcePanel).getFiles().length == 0 && javaRoots.length > 0) {
            ((FolderList)this.sourcePanel).setFiles(javaRoots);
        }
        if (((FolderList)this.testsPanel).getFiles().length == 0 && fo.getFileObject("test") != null) {
            ((FolderList)this.testsPanel).setFiles(new File[]{FileUtil.toFile((FileObject)fo.getFileObject("test"))});
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("files".equals(evt.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(evt.getPropertyName())) {
            if (evt.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)evt.getNewValue());
            } else if (evt.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)evt.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    @Override
    void read(WizardDescriptor settings) {
        File[] testRoot;
        this.wizardDescriptor = settings;
        File[] srcRoot = (File[])settings.getProperty("javaRoot");
        if (srcRoot != null) {
            ((FolderList)this.sourcePanel).setFiles(srcRoot);
        }
        if ((testRoot = (File[])settings.getProperty("testRoot")) != null) {
            ((FolderList)this.testsPanel).setFiles(testRoot);
        }
        File projectLocation = (File)settings.getProperty("sourceRoot");
        ((FolderList)this.sourcePanel).setProjectFolder(projectLocation);
        ((FolderList)this.testsPanel).setProjectFolder(projectLocation);
        this.initValues(FileUtil.toFileObject((File)projectLocation));
    }

    @Override
    void store(WizardDescriptor settings) {
        File[] sourceRoots = ((FolderList)this.sourcePanel).getFiles();
        File[] testRoots = ((FolderList)this.testsPanel).getFiles();
        settings.putProperty("javaRoot", (Object)sourceRoots);
        settings.putProperty("testRoot", (Object)testRoots);
        settings.putProperty("docBase", (Object)this.jTextFieldWebPages.getText().trim());
        settings.putProperty("libFolder", (Object)this.jTextFieldLibraries.getText().trim());
        settings.putProperty("webInfFolder", (Object)this.jTextFieldWebInf.getText().trim());
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        File[] testRoots;
        File[] sourceRoots;
        File webInf;
        File projectLocation = (File)settings.getProperty("projdir");
        if (this.jTextFieldWebPages.getText().trim().length() == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesMandatory"));
            return false;
        }
        if (this.jTextFieldWebInf.getText().trim().length() == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebInfMandatory"));
            return false;
        }
        File webPages = this.getWebPages();
        String result = this.checkValidity(projectLocation, webPages, webInf = this.getWebInfDir(), sourceRoots = ((FolderList)this.sourcePanel).getFiles(), testRoots = ((FolderList)this.testsPanel).getFiles());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    private String checkValidity(File projectLocation, File webPages, File webInf, File[] sources, File[] tests) {
        int i;
        String ploc = projectLocation.getAbsolutePath();
        if (projectLocation.equals(webPages)) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesFolderOverlapsProjectFolder");
        }
        if (!webPages.exists() || !webPages.isDirectory()) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebPagesFolderDoesNotExist");
        }
        if (!webInf.exists() || !webInf.isDirectory()) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_WebInfFolderDoesNotExist");
        }
        FileObject webInfFO = FileUtil.toFileObject((File)webInf);
        FileObject webXml = webInfFO.getFileObject("web.xml");
        if (webXml != null && !webXml.isValid()) {
            webXml = null;
        }
        Profile j2eeProfile = (Profile)this.wizardDescriptor.getProperty("j2eeLevel");
        if (webXml == null && (j2eeProfile == Profile.J2EE_13 || j2eeProfile == Profile.J2EE_14)) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FileNotFound", (Object)webInf.getPath());
        }
        for (i = 0; i < sources.length; ++i) {
            if (!sources[i].isDirectory() || !sources[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalSources"), sources[i].getAbsolutePath());
            }
            String sloc = sources[i].getAbsolutePath();
            if (!ploc.equals(sloc) && !ploc.startsWith(sloc + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (i = 0; i < tests.length; ++i) {
            if (!tests[i].isDirectory() || !tests[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalTests"), sources[i].getAbsolutePath());
            }
            String tloc = tests[i].getAbsolutePath();
            if (!ploc.equals(tloc) && !ploc.startsWith(tloc + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private void searchClassFiles(File[] folders) throws WizardValidationException {
        boolean found = false;
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            if (folder == null) continue;
            Enumeration en = folder.getData(true);
            while (!found && en.hasMoreElements()) {
                Object obj = en.nextElement();
                assert (obj instanceof FileObject) : "Instance of FileObject: " + obj;
                FileObject fo = (FileObject)obj;
                found = "class".equals(fo.getExt());
            }
        }
        if (found) {
            String DELETE_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DeleteOption");
            String KEEP_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_KeepOption");
            String CANCEL_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_CancelOption");
            NotifyDescriptor desc = new NotifyDescriptor((Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{DELETE_OPTION, KEEP_OPTION, CANCEL_OPTION}, null);
            Object result = DialogDisplayer.getDefault().notify(desc);
            if (DELETE_OPTION.equals(result)) {
                this.deleteClassFiles(folders);
            } else if (!KEEP_OPTION.equals(result)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] folders) {
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            Enumeration en = folder.getData(true);
            while (en.hasMoreElements()) {
                Object obj = en.nextElement();
                assert (obj instanceof FileObject) : "Instance of FileObject: " + obj;
                FileObject fo = (FileObject)obj;
                try {
                    if (!"class".equals(fo.getExt())) continue;
                    fo.delete();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jLabelWebPages = new JLabel();
        this.jTextFieldWebPages = new JTextField();
        this.jButtonWebpagesLocation = new JButton();
        this.jLabelWebInf = new JLabel();
        this.jTextFieldWebInf = new JTextField();
        this.jButtonWebInf = new JButton();
        this.jLabelLibraries = new JLabel();
        this.jTextFieldLibraries = new JTextField();
        this.jButtonLibraries = new JButton();
        this.sourcePanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_SourceRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"));
        this.testsPanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_TestRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveTestFolder"));
        this.jLabelWebPages1 = new JLabel();
        this.setPreferredSize(new Dimension(500, 340));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LocationDesc_Label"));
        this.jLabelWebPages.setDisplayedMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_WebPagesLocation_LabelMnemonic").charAt(0));
        this.jLabelWebPages.setLabelFor(this.jTextFieldWebPages);
        this.jLabelWebPages.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_WebPagesLocation_Label"));
        this.jButtonWebpagesLocation.setMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_WebPagesFolder_MNE").charAt(0));
        this.jButtonWebpagesLocation.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_BrowseWebPagesLocation_Button"));
        this.jButtonWebpagesLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSourceFolders.this.jButtonWebpagesLocationActionPerformed(evt);
            }
        });
        this.jLabelWebInf.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/wizards/Bundle").getString("MNE_DeploymentDescriptorFolder").charAt(0));
        this.jLabelWebInf.setLabelFor(this.jTextFieldWebInf);
        this.jLabelWebInf.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_DeploymentDescriptorFolder_Label"));
        this.jButtonWebInf.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/wizards/Bundle").getString("MNE_BrowseWebInfLocation").charAt(0));
        this.jButtonWebInf.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"PanelSourceFolderes.browseWebInf"));
        this.jButtonWebInf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSourceFolders.this.jButtonWebInfActionPerformed(evt);
            }
        });
        this.jLabelLibraries.setDisplayedMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LibrariesLocation_LabelMnemonic").charAt(0));
        this.jLabelLibraries.setLabelFor(this.jTextFieldLibraries);
        this.jLabelLibraries.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_LibrariesLocation_Label"));
        this.jButtonLibraries.setMnemonic(NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_BrowseLibrariesLocation").charAt(0));
        this.jButtonLibraries.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_BrowseLibrariesLocation_Button"));
        this.jButtonLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSourceFolders.this.jButtonLibrariesActionPerformed(evt);
            }
        });
        this.jLabelWebPages1.setText(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_IW_DragAndDrop"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelWebPages).addPreferredGap(0).add((Component)this.jTextFieldWebPages, -1, 252, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelLibraries, -2, 117, -2).addPreferredGap(0).add((Component)this.jTextFieldLibraries, -1, 252, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelWebInf, -2, 117, -2).addPreferredGap(0).add((Component)this.jTextFieldWebInf, -1, 252, Short.MAX_VALUE))).add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonLibraries).add((Component)this.jButtonWebInf).add((Component)this.jButtonWebpagesLocation))).add((Component)this.sourcePanel, -1, 467, Short.MAX_VALUE).add((Component)this.testsPanel, -1, 467, Short.MAX_VALUE).add((Component)this.jLabelWebPages1, -1, 467, Short.MAX_VALUE).add((Component)this.jLabel3, -1, 467, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelWebPages).add((Component)this.jTextFieldWebPages, -2, -1, -2).add((Component)this.jButtonWebpagesLocation)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelWebInf).add((Component)this.jTextFieldWebInf, -2, -1, -2).add((Component)this.jButtonWebInf)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelLibraries).add((Component)this.jTextFieldLibraries, -2, -1, -2).add((Component)this.jButtonLibraries)).add(18, 18, 18).add((Component)this.sourcePanel, -1, 79, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.testsPanel, -1, 85, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabelWebPages1, -2, -1, -2)));
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSN_jLabel3"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSD_jLabel3"));
        this.jTextFieldWebPages.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_WebPagesFolder"));
        this.jButtonWebpagesLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_BrowseWebPageFolder"));
        this.jTextFieldWebInf.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_WebInf"));
        this.jButtonWebInf.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_BrowseWebInf"));
        this.jTextFieldLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_LibrariesFolder"));
        this.jButtonLibraries.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_BrowseLibrariesFolder"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void jButtonWebInfActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (this.jTextFieldWebInf.getText().length() > 0 && this.getWebInfDir().exists()) {
            chooser.setSelectedFile(this.getWebInfDir());
        } else {
            chooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("sourceRoot"));
        }
        if (0 == chooser.showOpenDialog(this)) {
            File webInfDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextFieldWebInf.setText(webInfDir.getAbsolutePath());
        }
    }

    private void jButtonLibrariesActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (this.jTextFieldLibraries.getText().length() > 0 && this.getLibraries().exists()) {
            chooser.setSelectedFile(this.getLibraries());
        } else {
            chooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("sourceRoot"));
        }
        if (0 == chooser.showOpenDialog(this)) {
            File configFilesDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextFieldLibraries.setText(configFilesDir.getAbsolutePath());
        }
    }

    private void jButtonWebpagesLocationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (this.jTextFieldWebPages.getText().length() > 0 && this.getWebPages().exists()) {
            chooser.setSelectedFile(this.getWebPages());
        } else {
            chooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("sourceRoot"));
        }
        if (0 == chooser.showOpenDialog(this)) {
            File webPagesDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextFieldWebPages.setText(webPagesDir.getAbsolutePath());
        }
    }

    private File getAsFile(String filename) {
        return FileUtil.normalizeFile((File)new File(filename));
    }

    public File getWebPages() {
        return this.getAsFile(this.jTextFieldWebPages.getText());
    }

    public File getLibraries() {
        return this.getAsFile(this.jTextFieldLibraries.getText());
    }

    private File getWebInfDir() {
        return this.getAsFile(this.jTextFieldWebInf.getText());
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void readSettings(Object settings) {
            this.settings = (WizardDescriptor)settings;
            this.component.read(this.settings);
            Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.settings.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object settings) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PanelSourceFolders.class);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }
    }
}

