/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.web.project.classpath.ClassPathSupportCallbackImpl;
import org.openide.util.NbBundle;

public final class ClassPathTableModel
extends AbstractTableModel
implements ListDataListener {
    private DefaultListModel model;

    public static ClassPathTableModel createTableModel(Iterator it) {
        return new ClassPathTableModel(ClassPathUiSupport.createListModel((Iterator)it));
    }

    public ClassPathTableModel(DefaultListModel model) {
        this.model = model;
        model.addListDataListener(this);
    }

    public DefaultListModel getDefaultListModel() {
        return this.model;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.model.getSize();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return NbBundle.getMessage(ClassPathTableModel.class, (String)"LBL_CustomizeCompile_TableHeader_Name");
        }
        return NbBundle.getMessage(ClassPathTableModel.class, (String)"LBL_CustomizeCompile_TableHeader_Deploy");
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return ClassPathSupport.Item.class;
        }
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.getItem(row);
        }
        String pathInWar = this.getItem(row).getAdditionalProperty("pathInDeployment");
        return "WEB-INF/lib".equals(pathInWar) || "WEB-INF/classes".equals(pathInWar) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column != 1 || !(value instanceof Boolean)) {
            return;
        }
        if (value == Boolean.TRUE) {
            ClassPathSupport.Item item = this.getItem(row);
            String pathInWar = item.getType() == 0 && item.getResolvedFile().isDirectory() ? "WEB-INF/classes" : "WEB-INF/lib";
            item.setAdditionalProperty("pathInDeployment", pathInWar);
        } else {
            this.getItem(row).setAdditionalProperty("pathInDeployment", ClassPathSupportCallbackImpl.PATH_IN_WAR_NONE);
        }
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
    }

    private ClassPathSupport.Item getItem(int index) {
        return (ClassPathSupport.Item)this.model.get(index);
    }
}

