/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.DocBaseNodeFactory;
import org.netbeans.modules.web.project.ui.WebLogicalViewProvider;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public final class ConfFilesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        WebProject webProject = (WebProject)project.getLookup().lookup(WebProject.class);
        assert (webProject != null);
        return new ConfFilesNodeList(webProject);
    }

    private static Lookup createLookup(Project project) {
        if (project.getProjectDirectory().isValid()) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
            SearchInfo searchInfo = SearchInfoFactory.createSearchInfo((FileObject)dataFolder.getPrimaryFile(), (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER});
            return Lookups.fixed((Object[])new Object[]{project, dataFolder, searchInfo});
        }
        return Lookups.fixed((Object[])new Object[0]);
    }

    private static class ClassPathChangeListener
    implements PropertyChangeListener {
        private ConfFilesChildrenFactory myFactory;

        ClassPathChangeListener(ConfFilesChildrenFactory confFilesChildrenFactory) {
            this.myFactory = confFilesChildrenFactory;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.myFactory.update();
        }
    }

    private static final class NodeComparator
    implements Comparator<FileObject> {
        private NodeComparator() {
        }

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            int n = this.compareType(fileObject, fileObject2);
            if (n == 0) {
                n = this.compareNames(fileObject, fileObject2);
            }
            if (n == 0) {
                return fileObject.getPath().compareTo(fileObject2.getPath());
            }
            return n;
        }

        private int compareType(FileObject fileObject, FileObject fileObject2) {
            int n = fileObject.isFolder() ? 0 : 1;
            int n2 = fileObject2.isFolder() ? 0 : 1;
            return n - n2;
        }

        private int compareNames(FileObject fileObject, FileObject fileObject2) {
            return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof NodeComparator;
        }
    }

    private static final class ConfFilesChildrenFactory
    extends ChildFactory.Detachable<FileObject> {
        private static final String[] WELL_KNOWN_FILES = new String[]{"web.xml", "webservices.xml", "struts-config.xml", "faces-config.xml", "portlet.xml", "navigator.xml", "managed-beans.xml", "beans.xml"};
        private static final Comparator<FileObject> COMPARATOR = new NodeComparator();
        private final FileChangeListener myWebInfListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fileEvent) {
                if (ConfFilesChildrenFactory.this.isWellKnownFile(fileEvent.getFile().getNameExt())) {
                    ConfFilesChildrenFactory.this.refresh(false);
                }
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                if (ConfFilesChildrenFactory.this.myKeys.contains(fileRenameEvent.getFile())) {
                    ConfFilesChildrenFactory.this.refresh(false);
                } else if (ConfFilesChildrenFactory.this.isWellKnownFile(fileRenameEvent.getFile().getNameExt())) {
                    ConfFilesChildrenFactory.this.refresh(false);
                }
            }

            public void fileDeleted(FileEvent fileEvent) {
                if (ConfFilesChildrenFactory.this.isWellKnownFile(fileEvent.getFile().getNameExt())) {
                    ConfFilesChildrenFactory.this.refresh(false);
                }
            }
        };
        private final FileChangeListener myAnyFileListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fileEvent) {
                ConfFilesChildrenFactory.this.refresh(false);
            }

            public void fileFolderCreated(FileEvent fileEvent) {
                ConfFilesChildrenFactory.this.refresh(false);
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                ConfFilesChildrenFactory.this.refresh(false);
            }

            public void fileDeleted(FileEvent fileEvent) {
                ConfFilesChildrenFactory.this.refresh(false);
            }
        };
        private final ConfigurationFilesListener myServerSpecificFilesListener = new ConfigurationFilesListener(){

            public void fileCreated(FileObject fileObject) {
                ConfFilesChildrenFactory.this.refresh(false);
            }

            public void fileDeleted(FileObject fileObject) {
                ConfFilesChildrenFactory.this.refresh(false);
            }
        };
        private final ClassPathChangeListener myClassPathListener = new ClassPathChangeListener(this);
        private ProjectWebModule myWebModule;
        private Set<FileObject> myKeys;
        private FileObject myConfDir;
        private FileObject myPersistenceXmlDir;

        private ConfFilesChildrenFactory(ProjectWebModule projectWebModule) {
            this.myWebModule = projectWebModule;
            this.myKeys = Collections.emptySet();
        }

        public static ConfFilesChildrenFactory forProject(Project project) {
            ProjectWebModule projectWebModule = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class);
            return new ConfFilesChildrenFactory(projectWebModule);
        }

        void update() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfFilesChildrenFactory.this.refresh(false);
                }
            });
        }

        protected void removeNotify() {
            this.removeListeners();
        }

        public Node createNodeForKey(FileObject fileObject) {
            Node node = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                node = dataObject.getNodeDelegate().cloneNode();
                if (fileObject.isFolder()) {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    node = new FilterNode(node, dataFolder.createNodeChildren((DataFilter)new DocBaseNodeFactory.VisibilityQueryDataFilter(null)));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            return node;
        }

        protected boolean createKeys(List<FileObject> list) {
            boolean bl = false;
            this.myKeys = new HashSet<FileObject>();
            if (this.addWellKnownFiles()) {
                bl = true;
            }
            if (!bl && this.addConfDirectoryFiles()) {
                bl = true;
            }
            if (!bl && this.addPersistenceXmlDirectoryFiles()) {
                bl = true;
            }
            if (!bl && this.addServerSpecificFiles()) {
                bl = true;
            }
            if (!bl && this.addFrameworkFiles()) {
                bl = true;
            }
            if (!bl && this.addWebFragments()) {
                bl = true;
            }
            list.addAll(this.myKeys);
            Collections.sort(list, COMPARATOR);
            return true;
        }

        private void removeListeners() {
            this.getWebModule().removeConfigurationFilesListener(this.myServerSpecificFilesListener);
            FileObject fileObject = this.getWebModule().getWebInf(true);
            if (fileObject != null) {
                this.getWebModule().getWebInf().removeFileChangeListener(this.myWebInfListener);
            }
            if (this.myConfDir != null) {
                this.myConfDir.removeFileChangeListener(this.myAnyFileListener);
            }
            if (this.myPersistenceXmlDir != null) {
                this.myPersistenceXmlDir.removeFileChangeListener(this.myAnyFileListener);
            }
        }

        private boolean addWellKnownFiles() {
            FileObject fileObject = this.getWebModule().getWebInf(true);
            if (fileObject == null) {
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < WELL_KNOWN_FILES.length; ++i) {
                FileObject fileObject2 = fileObject.getFileObject(WELL_KNOWN_FILES[i]);
                if (fileObject2 != null) {
                    this.myKeys.add(fileObject2);
                }
                if (!Thread.interrupted()) continue;
                bl = true;
                break;
            }
            fileObject.addFileChangeListener(this.myWebInfListener);
            return bl;
        }

        private boolean addConfDirectoryFiles() {
            this.myConfDir = this.getWebModule().getConfDir();
            if (this.myConfDir == null) {
                return false;
            }
            boolean bl = false;
            FileObject[] fileObjectArray = this.myConfDir.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) {
                    this.myKeys.add(fileObjectArray[i]);
                }
                if (!Thread.interrupted()) continue;
                bl = true;
                break;
            }
            this.myConfDir.addFileChangeListener(this.myAnyFileListener);
            return bl;
        }

        private boolean addPersistenceXmlDirectoryFiles() {
            this.myPersistenceXmlDir = this.getWebModule().getPersistenceXmlDir();
            if (this.myPersistenceXmlDir == null || this.myConfDir != null && FileUtil.toFile((FileObject)this.myPersistenceXmlDir).equals(FileUtil.toFile((FileObject)this.myConfDir))) {
                return false;
            }
            boolean bl = false;
            FileObject[] fileObjectArray = this.myPersistenceXmlDir.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) {
                    this.myKeys.add(fileObjectArray[i]);
                }
                if (!Thread.interrupted()) continue;
                bl = true;
                break;
            }
            this.myPersistenceXmlDir.addFileChangeListener(this.myAnyFileListener);
            return bl;
        }

        private boolean addServerSpecificFiles() {
            FileObject[] fileObjectArray = this.getWebModule().getConfigurationFiles();
            boolean bl = false;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                this.myKeys.add(fileObjectArray[i]);
                if (!Thread.interrupted()) continue;
                bl = true;
                break;
            }
            this.getWebModule().addConfigurationFilesListener(this.myServerSpecificFilesListener);
            return bl;
        }

        private boolean addFrameworkFiles() {
            List list = WebFrameworks.getFrameworks();
            boolean bl = false;
            block0: for (int i = 0; i < list.size(); ++i) {
                WebModule webModule;
                WebFrameworkProvider webFrameworkProvider = (WebFrameworkProvider)list.get(i);
                FileObject fileObject = this.getWebModule().getDocumentBase();
                File[] fileArray = null;
                if (fileObject != null && (webModule = WebModule.getWebModule((FileObject)fileObject)) != null) {
                    fileArray = webFrameworkProvider.getConfigurationFiles(webModule);
                }
                if (fileArray == null) continue;
                for (int j = 0; j < fileArray.length; ++j) {
                    FileObject fileObject2 = FileUtil.toFileObject((File)fileArray[j]);
                    if (fileObject2 != null) {
                        this.myKeys.add(fileObject2);
                    }
                    if (!Thread.interrupted()) continue;
                    bl = true;
                    break block0;
                }
            }
            return bl;
        }

        private boolean addWebFragments() {
            Object object;
            try {
                object = (List)this.getWebModule().getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, List<FileObject>>(){

                    public List<FileObject> run(WebAppMetadata webAppMetadata) throws Exception {
                        return webAppMetadata.getFragmentFiles();
                    }
                });
                this.myKeys.addAll((Collection<FileObject>)object);
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            object = this.getWebModule().getSourceRoots();
            if (object != null) {
                for (FileObject fileObject : object) {
                    ClassPath classPath = this.getWebModule().getClassPathProvider().findClassPath(fileObject, "classpath/compile");
                    if (classPath == null) continue;
                    classPath.removePropertyChangeListener((PropertyChangeListener)this.myClassPathListener);
                    classPath.addPropertyChangeListener((PropertyChangeListener)this.myClassPathListener);
                }
            }
            return Thread.interrupted();
        }

        private ProjectWebModule getWebModule() {
            return this.myWebModule;
        }

        private boolean isWellKnownFile(String string) {
            for (int i = 0; i < WELL_KNOWN_FILES.length; ++i) {
                if (!string.equals(WELL_KNOWN_FILES[i])) continue;
                return true;
            }
            return false;
        }
    }

    private static final class ConfFilesNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private static final Image CONFIGURATION_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/config-badge.gif", (boolean)true);
        private Set files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock = new Object();
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;
        private final Project project;
        private Node iconDelegate;

        public ConfFilesNode(Project project) {
            super(Children.create((ChildFactory)ConfFilesChildrenFactory.forProject(project), (boolean)true), ConfFilesNodeFactory.createLookup(project));
            this.project = project;
            this.setName("configurationFiles");
            this.iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
        }

        public Image getIcon(int n) {
            return this.computeIcon(false, n);
        }

        public Image getOpenedIcon(int n) {
            return this.computeIcon(true, n);
        }

        private Image computeIcon(boolean bl, int n) {
            Image image = bl ? this.iconDelegate.getOpenedIcon(n) : this.iconDelegate.getIcon(n);
            image = ImageUtilities.mergeImages((Image)image, (Image)CONFIGURATION_FILES_BADGE, (int)7, (int)7);
            return image;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ConfFilesNodeFactory.class, (String)"LBL_Node_Config");
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(FindAction.class)};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            Object object = this.privateLock;
            synchronized (object) {
                bl2 = this.iconChange;
                bl = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (bl2) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (bl) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                    for (FileObject fileObject : this.files) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        this.iconChange |= fileStatusEvent.isIconChange();
                        this.nameChange |= fileStatusEvent.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setProjectFiles(this.project);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setProjectFiles(this.project);
        }

        protected void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private void setGroups(Collection collection) {
            if (this.groupsListeners != null) {
                for (SourceGroup object : this.groupsListeners.keySet()) {
                    PropertyChangeListener propertyChangeListener = this.groupsListeners.get(object);
                    object.removePropertyChangeListener(propertyChangeListener);
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet hashSet = new HashSet();
            for (PropertyChangeListener propertyChangeListener : collection) {
                PropertyChangeListener propertyChangeListener2 = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyChangeListener);
                this.groupsListeners.put((SourceGroup)propertyChangeListener, propertyChangeListener2);
                propertyChangeListener.addPropertyChangeListener(propertyChangeListener2);
                FileObject fileObject = propertyChangeListener.getRootFolder();
                hashSet.add(fileObject);
            }
            this.setFiles(hashSet);
        }

        protected void setFiles(Set set) {
            FileStatusListener fileStatusListener;
            if (this.fileSystemListeners != null) {
                for (FileSystem object2 : this.fileSystemListeners.keySet()) {
                    fileStatusListener = this.fileSystemListeners.get(object2);
                    object2.removeFileStatusListener(fileStatusListener);
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = set;
            if (set == null) {
                return;
            }
            Iterator<Object> iterator = set.iterator();
            HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
            while (iterator.hasNext()) {
                fileStatusListener = (FileObject)iterator.next();
                try {
                    FileSystem fileStateInvalidException = fileStatusListener.getFileSystem();
                    if (hashSet.contains(fileStateInvalidException)) continue;
                    hashSet.add(fileStateInvalidException);
                    FileStatusListener fileStatusListener2 = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileStateInvalidException);
                    fileStateInvalidException.addFileStatusListener(fileStatusListener2);
                    this.fileSystemListeners.put(fileStateInvalidException, fileStatusListener2);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)fileStateInvalidException, (String)("Can not get " + fileStatusListener + " filesystem, ignoring...")));
                }
            }
        }
    }

    private static class ConfFilesNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String CONF_FILES = "confFiles";
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        ConfFilesNodeList(WebProject webProject) {
            this.project = webProject;
            WebLogicalViewProvider webLogicalViewProvider = (WebLogicalViewProvider)((Object)this.project.getLookup().lookup(WebLogicalViewProvider.class));
            assert (webLogicalViewProvider != null);
        }

        public List<String> keys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(CONF_FILES);
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(String string) {
            if (string == CONF_FILES) {
                return new ConfFilesNode(this.project);
            }
            assert (false) : "No node for key: " + string;
            return null;
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfFilesNodeList.this.changeSupport.fireChange();
                }
            });
        }
    }
}

