/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ActivatorIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private static final Logger LOG = Logger.getLogger(ActivatorIterator.class.getName());
    private transient int index;
    private transient List<WizardDescriptor.Panel<WizardDescriptor>> panels;
    private transient TemplateWizard wiz;
    private static final long serialVersionUID = -7586964579556513549L;

    protected List<WizardDescriptor.Panel<WizardDescriptor>> createPanels(Project project, TemplateWizard wiz) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        DataFolder targetFolder = null;
        try {
            targetFolder = wiz.getTargetFolder();
        }
        catch (IOException ex) {
            targetFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        return Collections.singletonList(JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sources.getSourceGroups("java")));
    }

    public Set<DataObject> instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)this.wiz));
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        ClassPath cp = ClassPath.getClassPath((FileObject)dobj.getPrimaryFile(), (String)"classpath/source");
        final String path = cp.getResourceName(dobj.getPrimaryFile(), '.', false);
        final NbMavenProject prj = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (prj != null) {
            Utilities.performPOMModelOperations((FileObject)project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    ActivatorIterator.this.addActivator(prj, model, path);
                }
            }));
        }
        return Collections.singleton(dobj);
    }

    private void addActivator(NbMavenProject prj, POMModel mdl, String path) {
        Plugin plugin;
        Plugin old = null;
        Build bld = mdl.getProject().getBuild();
        if (bld != null) {
            old = bld.findPluginById("org.apache.felix", "maven-bundle-plugin");
        } else {
            mdl.getProject().setBuild(mdl.getFactory().createBuild());
        }
        if (old != null) {
            plugin = old;
        } else {
            plugin = mdl.getFactory().createPlugin();
            plugin.setGroupId("org.apache.felix");
            plugin.setArtifactId("maven-bundle-plugin");
            String ver = PluginPropertyUtils.getPluginVersion((MavenProject)prj.getMavenProject(), (String)"org.apache.felix", (String)"maven-bundle-plugin");
            if (ver == null) {
                plugin.setVersion("2.0.1");
            }
            mdl.getProject().getBuild().addPlugin(plugin);
        }
        Configuration conf = plugin.getConfiguration();
        if (conf == null) {
            conf = mdl.getFactory().createConfiguration();
            plugin.setConfiguration(conf);
        }
        List elems = conf.getConfigurationElements();
        POMExtensibilityElement instructions = null;
        for (POMExtensibilityElement el : elems) {
            if (!"instructions".equals(el.getQName().getLocalPart())) continue;
            instructions = el;
            break;
        }
        if (instructions == null) {
            instructions = mdl.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"instructions", (boolean)mdl.getPOMQNames().isNSAware()));
            conf.addExtensibilityElement(instructions);
        }
        elems = instructions.getExtensibilityElements();
        POMExtensibilityElement activator = null;
        for (POMExtensibilityElement el : elems) {
            if (!"Bundle-Activator".equals(el.getQName().getLocalPart())) continue;
            activator = el;
            break;
        }
        if (activator == null) {
            activator = mdl.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"Bundle-Activator", (boolean)mdl.getPOMQNames().isNSAware()));
            instructions.addExtensibilityElement(activator);
        }
        activator.setElementText(path);
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = (TemplateWizard)wiz;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels(project, this.wiz);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = ActivatorIterator.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.size(); ++i) {
            Component c = this.panels.get(i).getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(ActivatorIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.size());
    }

    public boolean hasNext() {
        return this.index < this.panels.size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels.get(this.index);
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    public static String[] createSteps(String[] before, List<WizardDescriptor.Panel<WizardDescriptor>> panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels.get(i - before.length + diff).getComponent().getName();
        }
        return res;
    }
}

