/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.xml.bind.JAXBException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.rest.client.OAuthHelper;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.SecurityParams;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.SubResourceLocator;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.Params;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.jaxb.ServletDescriptor;
import org.netbeans.modules.websvc.saas.model.jaxb.Sign;
import org.netbeans.modules.websvc.saas.model.jaxb.TemplateType;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClientJavaSourceHelper {
    public static void generateJerseyClient(Node node, FileObject fileObject, String string) {
        ClientJavaSourceHelper.generateJerseyClient(node, fileObject, string, new Security(false, Security.Authentication.NONE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateJerseyClient(Node node, FileObject fileObject, String string, Security security) {
        block18: {
            ProgressHandle progressHandle = null;
            try {
                String string2;
                Object object;
                progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_creatingRESTClient"));
                progressHandle.start();
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                ArrayList<Library> arrayList = new ArrayList<Library>();
                if (classPath.findResource("javax/ws/rs/WebApplicationException.class") == null && (object = LibraryManager.getDefault().getLibrary("restapi")) != null) {
                    arrayList.add((Library)object);
                }
                if ((classPath.findResource("com/sun/jersey/api/client/WebResource.class") == null || Security.Authentication.OAUTH == security.getAuthentication() && classPath.findResource("com/sun/jersey/oauth/client/OAuthClientFilter.class") == null) && (object = LibraryManager.getDefault().getLibrary("restlib")) != null) {
                    arrayList.add((Library)object);
                }
                if (arrayList.size() > 0) {
                    try {
                        ProjectClassPathModifier.addLibraries((Library[])arrayList.toArray(new Library[arrayList.size()]), (FileObject)fileObject, (String)"classpath/compile");
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot add Jersey libraries", iOException);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_CannotAddJerseyLib"), 2));
                        progressHandle.finish();
                        return;
                    }
                }
                object = null;
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                object = project != null ? Wadl2JavaHelper.getProjectType(project) : "desktop";
                security.setProjectType((String)object);
                RestServiceDescription restServiceDescription = (RestServiceDescription)node.getLookup().lookup(RestServiceDescription.class);
                if (restServiceDescription != null) {
                    String string3 = restServiceDescription.getUriTemplate();
                    if (string3 != null) {
                        String string4;
                        ResourcePath resourcePath;
                        PathFormat pathFormat = null;
                        if (string3.length() == 0) {
                            resourcePath = ClientJavaSourceHelper.getResourcePath(node, restServiceDescription.getClassName(), "");
                            string3 = resourcePath.getPath();
                            pathFormat = resourcePath.getPathFormat();
                        } else {
                            pathFormat = ClientJavaSourceHelper.getPathFormat(string3);
                        }
                        resourcePath = (Project)node.getLookup().lookup(Project.class);
                        String string5 = string4 = resourcePath == null ? "" : ClientJavaSourceHelper.getBaseURL((Project)resourcePath);
                        if (string4.endsWith("/")) {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                        ClientJavaSourceHelper.addJerseyClient(JavaSource.forFileObject((FileObject)fileObject), string, string4, restServiceDescription, null, pathFormat, security);
                    }
                    break block18;
                }
                WadlSaasResource wadlSaasResource = (WadlSaasResource)node.getLookup().lookup(WadlSaasResource.class);
                if (wadlSaasResource == null) break block18;
                ClientJavaSourceHelper.addSecurityMetadata(security, wadlSaasResource);
                if ("web".equals(security.getProjectType()) && (Security.Authentication.SESSION_KEY == security.getAuthentication() || Security.Authentication.OAUTH == security.getAuthentication()) && (string2 = (RestSupport)project.getLookup().lookup(RestSupport.class)) != null && string2 instanceof WebRestSupport) {
                    security.setDeploymentDescriptor(((WebRestSupport)string2).getDeploymentDescriptor());
                }
                string2 = wadlSaasResource.getSaas().getBaseURL();
                ResourcePath resourcePath = ClientJavaSourceHelper.getResourcePath(wadlSaasResource);
                PathFormat pathFormat = resourcePath.getPathFormat();
                ClientJavaSourceHelper.addJerseyClient(JavaSource.forFileObject((FileObject)fileObject), string, string2, null, wadlSaasResource, pathFormat, security);
                try {
                    Wadl2JavaHelper.generateJaxb(fileObject, wadlSaasResource.getSaas());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (!(!"nb-module".equals(object) || Security.Authentication.OAUTH != security.getAuthentication() && Security.Authentication.SESSION_KEY != security.getAuthentication() || classPath.findResource("org/openide/DialogDisplayer.class.class") != null && classPath.findResource("org/openide/util/NbPreferences.class.class") != null && classPath.findResource("org/openide/awt/HtmlBrowser.class") != null)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_MissingOpenideModules"), 2));
                }
            }
            finally {
                progressHandle.finish();
            }
        }
    }

    private static void addJerseyClient(JavaSource javaSource, final String string, final String string2, final RestServiceDescription restServiceDescription, final WadlSaasResource wadlSaasResource, final PathFormat pathFormat, final Security security) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    ClassTree classTree2 = null;
                    classTree2 = string == null ? ClientJavaSourceHelper.modifyJerseyClientClass(workingCopy, classTree, string2, restServiceDescription, wadlSaasResource, pathFormat, security) : ClientJavaSourceHelper.addJerseyClientClass(workingCopy, classTree, string, string2, restServiceDescription, wadlSaasResource, pathFormat, security);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static ClassTree modifyJerseyClientClass(WorkingCopy workingCopy, ClassTree classTree, String string, RestServiceDescription restServiceDescription, WadlSaasResource wadlSaasResource, PathFormat pathFormat, Security security) {
        return ClientJavaSourceHelper.generateClassArtifacts(workingCopy, classTree, string, restServiceDescription, wadlSaasResource, pathFormat, security, null);
    }

    private static ClassTree addJerseyClientClass(WorkingCopy workingCopy, ClassTree classTree, String string, String string2, RestServiceDescription restServiceDescription, WadlSaasResource wadlSaasResource, PathFormat pathFormat, Security security) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.STATIC));
        ClassTree classTree2 = treeMaker.Class(modifiersTree, (CharSequence)string, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList());
        ClassTree classTree3 = ClientJavaSourceHelper.generateClassArtifacts(workingCopy, classTree2, string2, restServiceDescription, wadlSaasResource, pathFormat, security, classTree.getSimpleName().toString());
        return treeMaker.addClassMember(classTree, (Tree)classTree3);
    }

    /*
     * WARNING - void declaration
     */
    private static ClassTree generateClassArtifacts(WorkingCopy workingCopy, ClassTree classTree, String string, RestServiceDescription restServiceDescription, WadlSaasResource wadlSaasResource, PathFormat pathFormat, Security security, String string2) {
        Object object;
        Object object2;
        Object object3;
        void var19_23;
        Object object4;
        Object object5;
        Tree tree;
        String string32;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ExpressionTree expressionTree = JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.api.client.WebResource");
        VariableTree variableTree = treeMaker.Variable(modifiersTree, (CharSequence)"webResource", (Tree)expressionTree, null);
        ClassTree classTree2 = treeMaker.addClassMember(classTree, (Tree)variableTree);
        modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        expressionTree = JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.api.client.Client");
        variableTree = treeMaker.Variable(modifiersTree, (CharSequence)"client", (Tree)expressionTree, null);
        classTree2 = treeMaker.addClassMember(classTree2, (Tree)variableTree);
        HashSet<Modifier> hashSet = new HashSet<Modifier>();
        hashSet.add(Modifier.PRIVATE);
        hashSet.add(Modifier.STATIC);
        hashSet.add(Modifier.FINAL);
        modifiersTree = treeMaker.Modifiers(hashSet);
        expressionTree = treeMaker.Identifier((CharSequence)"String");
        String string4 = string;
        if (security.isSSL() && string.startsWith("http:")) {
            string4 = "https:" + string.substring(5);
        }
        variableTree = treeMaker.Variable(modifiersTree, (CharSequence)"BASE_URI", (Tree)expressionTree, (ExpressionTree)treeMaker.Literal((Object)string4));
        classTree2 = treeMaker.addClassMember(classTree2, (Tree)variableTree);
        ModifiersTree modifiersTree2 = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        TypeElement typeElement = workingCopy.getElements().getTypeElement("com.sun.jersey.api.client.Client");
        boolean bl = pathFormat.getArguments().length > 0;
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        if (bl) {
            for (String string32 : pathFormat.getArguments()) {
                tree = treeMaker.Identifier((CharSequence)"String");
                object5 = treeMaker.Modifiers(Collections.emptySet());
                object4 = treeMaker.Variable((ModifiersTree)object5, (CharSequence)string32, tree, null);
                arrayList.add((VariableTree)object4);
            }
        }
        Object var19_20 = null;
        String string5 = "";
        if (bl) {
            string5 = "    String resourcePath = " + ClientJavaSourceHelper.getPathExpression(pathFormat) + ";";
            String string6 = "resourcePath";
        } else {
            String string7 = ClientJavaSourceHelper.getPathExpression(pathFormat);
        }
        String string8 = security.isSSL() ? "// SSL configuration\nconfig.getProperties().put(com.sun.jersey.client.urlconnection.HTTPSProperties.PROPERTY_HTTPS_PROPERTIES,                            new com.sun.jersey.client.urlconnection.HTTPSProperties(getHostnameVerifier(), getSSLContext()));" : "";
        string32 = "{   com.sun.jersey.api.client.config.ClientConfig config = new com.sun.jersey.api.client.config.DefaultClientConfig();" + string8 + "   client = " + (typeElement == null ? "com.sun.jersey.api.client." : "") + "Client.create(config);" + string5 + ("\"\"".equals(var19_23) ? "   webResource = client.resource(BASE_URI);" : "   webResource = client.resource(BASE_URI).path(" + (String)var19_23 + ");") + "}";
        tree = treeMaker.Constructor(modifiersTree2, Collections.emptyList(), arrayList, Collections.emptyList(), string32);
        classTree2 = treeMaker.addClassMember(classTree2, tree);
        if (bl) {
            string32 = "{   String resourcePath = " + ClientJavaSourceHelper.getPathExpression(pathFormat) + ";" + "   webResource = client.resource(BASE_URI).path(resourcePath);" + "}";
            object5 = treeMaker.Method(modifiersTree2, (CharSequence)"setResourcePath", (Tree)JavaSourceHelper.createTypeTree(workingCopy, "void"), Collections.emptyList(), arrayList, Collections.emptyList(), string32, null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object5);
        }
        if (restServiceDescription != null) {
            object5 = restServiceDescription.getMethods();
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (RestMethodDescription)object4.next();
                if (!(object3 instanceof HttpMethod)) continue;
                object2 = ClientJavaSourceHelper.createHttpMethods(workingCopy, (HttpMethod)object3);
                object = object2.iterator();
                while (object.hasNext()) {
                    MethodTree methodTree = object.next();
                    classTree2 = treeMaker.addClassMember(classTree2, (Tree)methodTree);
                }
            }
        } else if (wadlSaasResource != null) {
            classTree2 = Wadl2JavaHelper.addHttpMethods(workingCopy, classTree2, wadlSaasResource, security);
        }
        object5 = treeMaker.Method(modifiersTree2, (CharSequence)"close", (Tree)JavaSourceHelper.createTypeTree(workingCopy, "void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{   client.destroy();}", null);
        classTree2 = treeMaker.addClassMember(classTree2, (Tree)object5);
        if (Security.Authentication.BASIC == security.getAuthentication()) {
            object4 = new ArrayList();
            object3 = treeMaker.Identifier((CharSequence)"String");
            object2 = treeMaker.Modifiers(Collections.emptySet());
            object = treeMaker.Variable((ModifiersTree)object2, (CharSequence)"username", (Tree)object3, null);
            object4.add(object);
            object = treeMaker.Variable((ModifiersTree)object2, (CharSequence)"password", (Tree)object3, null);
            object4.add(object);
            string32 = "{   client.addFilter(new com.sun.jersey.api.client.filter.HTTPBasicAuthFilter(username, password));}";
            object5 = treeMaker.Method(modifiersTree2, (CharSequence)"setUsernamePassword", (Tree)JavaSourceHelper.createTypeTree(workingCopy, "void"), Collections.emptyList(), (List)object4, Collections.emptyList(), string32, null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object5);
        } else if (wadlSaasResource != null && Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            object4 = security.getSecurityParams();
            if (object4 != null) {
                classTree2 = Wadl2JavaHelper.addSessionAuthMethods(workingCopy, classTree2, (SecurityParams)object4);
                if ("web".equals(security.getProjectType())) {
                    object3 = security.getDeploymentDescriptor();
                    if (object3 != null) {
                        object2 = workingCopy.getCompilationUnit().getPackageName().toString();
                        object = (string2 == null ? "" : string2 + "$") + classTree.getSimpleName().toString();
                        RequestProcessor.getDefault().post(new Runnable((FileObject)object3, (SecurityParams)object4, (String)object, (String)object2){
                            final /* synthetic */ FileObject val$ddFo;
                            final /* synthetic */ SecurityParams val$securityParams;
                            final /* synthetic */ String val$className;
                            final /* synthetic */ String val$packageName;
                            {
                                this.val$ddFo = fileObject;
                                this.val$securityParams = securityParams;
                                this.val$className = string;
                                this.val$packageName = string2;
                            }

                            @Override
                            public void run() {
                                try {
                                    ClientJavaSourceHelper.addWebXmlArtifacts(this.val$ddFo, this.val$securityParams, this.val$className, this.val$packageName);
                                }
                                catch (IOException iOException) {
                                    Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot add servlet/servlet mapping to web.xml", iOException);
                                }
                            }
                        }, 1000);
                    }
                    classTree2 = Wadl2JavaHelper.addSessionAuthServlets(workingCopy, classTree2, (SecurityParams)object4, object3 == null);
                }
            }
        } else if (wadlSaasResource != null) {
            try {
                object4 = wadlSaasResource.getSaas().getOauthMetadata();
                if (object4 != null) {
                    classTree2 = OAuthHelper.addOAuthMethods(security.getProjectType(), workingCopy, classTree2, (Metadata)object4, classTree.getSimpleName().toString());
                    if ("web".equals(security.getProjectType())) {
                        object3 = security.getDeploymentDescriptor();
                        if (object3 != null) {
                            object2 = workingCopy.getCompilationUnit().getPackageName().toString();
                            object = (string2 == null ? "" : string2 + "$") + classTree.getSimpleName().toString();
                            RequestProcessor.getDefault().post(new Runnable((FileObject)object3, (String)object, (String)object2){
                                final /* synthetic */ FileObject val$ddFo;
                                final /* synthetic */ String val$className;
                                final /* synthetic */ String val$packageName;
                                {
                                    this.val$ddFo = fileObject;
                                    this.val$className = string;
                                    this.val$packageName = string2;
                                }

                                @Override
                                public void run() {
                                    try {
                                        ClientJavaSourceHelper.addWebXmlOAuthArtifacts(this.val$ddFo, this.val$className, this.val$packageName);
                                    }
                                    catch (IOException iOException) {
                                        Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot add servlet/servlet mapping to web.xml", iOException);
                                    }
                                }
                            }, 1000);
                        }
                        classTree2 = OAuthHelper.addOAuthServlets(workingCopy, classTree2, (Metadata)object4, classTree.getSimpleName().toString(), object3 == null);
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot get metadata for oauth", iOException);
            }
            catch (JAXBException jAXBException) {
                Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot get metadata for oauth", jAXBException);
            }
        }
        if (security.isSSL()) {
            object4 = treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE));
            string32 = "{   return new HostnameVerifier() {       @Override       public boolean verify(String hostname, javax.net.ssl.SSLSession sslSession) {           return true;       }   }}";
            object5 = treeMaker.Method((ModifiersTree)object4, (CharSequence)"getHostnameVerifier", (Tree)JavaSourceHelper.createTypeTree(workingCopy, "javax.net.ssl.HostnameVerifier"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), string32, null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object5);
            string32 = "{   javax.net.ssl.TrustManager x509 = new javax.net.ssl.X509TrustManager() {       @Override       public void checkClientTrusted(java.security.cert.X509Certificate[] arg0, String arg1) throws java.security.cert.CertificateException {           return;       }       @Override       public void checkServerTrusted(java.security.cert.X509Certificate[] arg0, String arg1) throws java.security.cert.CertificateException {           return;       }       @Override       public java.security.cert.X509Certificate[] getAcceptedIssuers() {           return null;       }   };   SSLContext ctx = null;   try {       ctx = SSLContext.getInstance(\"SSL\");       ctx.init(null, new javax.net.ssl.TrustManager[] {x509}, null);   } catch (java.security.GeneralSecurityException ex) {}   return ctx;}";
            object5 = treeMaker.Method((ModifiersTree)object4, (CharSequence)"getSSLContext", (Tree)JavaSourceHelper.createTypeTree(workingCopy, "javax.net.ssl.SSLContext"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), string32, null);
            classTree2 = treeMaker.addClassMember(classTree2, (Tree)object5);
        }
        return classTree2;
    }

    private static List<MethodTree> createHttpMethods(WorkingCopy workingCopy, HttpMethod httpMethod) {
        ArrayList<MethodTree> arrayList = new ArrayList<MethodTree>();
        String string = httpMethod.getType();
        if ("GET".equals(string)) {
            boolean bl = false;
            String string2 = httpMethod.getProduceMime();
            if (string2.length() > 0) {
                boolean bl2 = string2.contains(",");
                for (HttpMimeType httpMimeType : HttpMimeType.values()) {
                    if (!string2.contains(httpMimeType.getMimeType())) continue;
                    arrayList.addAll(ClientJavaSourceHelper.createHttpGETMethod(workingCopy, httpMethod, httpMimeType, bl2));
                    bl = true;
                }
            }
            if (!bl) {
                arrayList.addAll(ClientJavaSourceHelper.createHttpGETMethod(workingCopy, httpMethod, null, false));
            }
        } else if ("PUT".equals(string) || "POST".equals(string) || "DELETE".equals(string)) {
            boolean bl = false;
            String string3 = httpMethod.getConsumeMime();
            if (string3.length() > 0) {
                boolean bl3 = string3.contains(",");
                for (HttpMimeType httpMimeType : HttpMimeType.values()) {
                    if (!string3.contains(httpMimeType.getMimeType())) continue;
                    arrayList.add(ClientJavaSourceHelper.createHttpPOSTMethod(workingCopy, httpMethod, httpMimeType, bl3));
                    bl = true;
                }
            }
            if (!bl) {
                arrayList.add(ClientJavaSourceHelper.createHttpPOSTMethod(workingCopy, httpMethod, null, false));
            }
        }
        return arrayList;
    }

    private static Collection<MethodTree> createHttpGETMethod(WorkingCopy workingCopy, HttpMethod httpMethod, HttpMimeType httpMimeType, boolean bl) {
        Object object;
        ArrayList<MethodTree> arrayList = new ArrayList<MethodTree>(2);
        String string = httpMethod.getReturnType();
        String string2 = httpMethod.getPath();
        String string3 = httpMethod.getName() + (bl ? "_" + httpMimeType.name() : "");
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree modifiersTree2 = treeMaker.Modifiers(Collections.emptySet());
        VariableTree variableTree = null;
        IdentifierTree identifierTree = null;
        String string4 = "";
        List<Object> list = null;
        if ("java.lang.String".equals(string)) {
            identifierTree = treeMaker.Identifier((CharSequence)"String");
            string4 = "String.class";
            list = Collections.emptyList();
        } else {
            identifierTree = treeMaker.Identifier((CharSequence)"T");
            string4 = "responseType";
            variableTree = treeMaker.Variable(modifiersTree2, (CharSequence)"responseType", (Tree)treeMaker.Identifier((CharSequence)"Class<T>"), null);
            list = Collections.singletonList(treeMaker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        }
        ArrayList<VariableTree> arrayList2 = new ArrayList<VariableTree>();
        if (variableTree != null) {
            arrayList2.add(variableTree);
        }
        ExpressionTree expressionTree = JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.api.client.UniformInterfaceException");
        StringBuilder stringBuilder = new StringBuilder("{ WebResource resource = webResource;");
        StringBuilder stringBuilder2 = new StringBuilder();
        if (string2.length() == 0) {
            if (httpMimeType != null) {
                stringBuilder2.append(".accept(");
                stringBuilder2.append(httpMimeType.getMediaType());
                stringBuilder2.append(')');
            }
            ClientJavaSourceHelper.buildQueryParams(stringBuilder, httpMethod, arrayList2, treeMaker);
        } else {
            object = ClientJavaSourceHelper.getPathFormat(string2);
            for (String string5 : ((PathFormat)object).getArguments()) {
                IdentifierTree identifierTree2 = treeMaker.Identifier((CharSequence)"String");
                ModifiersTree modifiersTree3 = treeMaker.Modifiers(Collections.emptySet());
                VariableTree variableTree2 = treeMaker.Variable(modifiersTree3, (CharSequence)string5, (Tree)identifierTree2, null);
                arrayList2.add(variableTree2);
            }
            ClientJavaSourceHelper.buildQueryParams(stringBuilder, httpMethod, arrayList2, treeMaker);
            stringBuilder.append("resource=resource.path(");
            stringBuilder.append(ClientJavaSourceHelper.getPathExpression((PathFormat)object));
            stringBuilder.append(')');
            if (httpMimeType != null) {
                stringBuilder2.append(".accept(");
                stringBuilder2.append(httpMimeType.getMediaType());
                stringBuilder2.append(')');
            }
        }
        stringBuilder.append("return resource");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(".get(");
        stringBuilder.append(string4);
        stringBuilder.append(");");
        stringBuilder.append('}');
        object = treeMaker.Method(modifiersTree, (CharSequence)string3, (Tree)identifierTree, list, arrayList2, Collections.singletonList(expressionTree), stringBuilder.toString(), null);
        arrayList.add((MethodTree)object);
        return arrayList;
    }

    private static void buildQueryParams(StringBuilder stringBuilder, HttpMethod httpMethod, List<VariableTree> list, TreeMaker treeMaker) {
        Map map = httpMethod.getQueryParams();
        if (map.size() == 0) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            if (string == null) continue;
            String string2 = ClientJavaSourceHelper.getClientParamName(string, list);
            IdentifierTree identifierTree = treeMaker.Identifier((CharSequence)"String");
            ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.emptySet());
            VariableTree variableTree = treeMaker.Variable(modifiersTree, (CharSequence)string2, (Tree)identifierTree, null);
            list.add(variableTree);
            stringBuilder.append("if (");
            stringBuilder.append(string2);
            stringBuilder.append("!=null){");
            stringBuilder.append("resource = resource.queryParam(\"");
            stringBuilder.append(string);
            stringBuilder.append("\",");
            stringBuilder.append(string2);
            stringBuilder.append(");}");
        }
    }

    private static String getClientParamName(String string, List<VariableTree> list) {
        return ClientJavaSourceHelper.getClientParamName(string, list, 0);
    }

    private static String getClientParamName(String string, List<VariableTree> list, int n) {
        String string2 = string;
        if (n != 0) {
            string2 = string + n;
        }
        for (VariableTree variableTree : list) {
            String string3 = variableTree.getName().toString();
            if (!string3.equals(string2)) continue;
            return ClientJavaSourceHelper.getClientParamName(string, list, n + 1);
        }
        return string2;
    }

    private static MethodTree createHttpPOSTMethod(WorkingCopy workingCopy, HttpMethod httpMethod, HttpMimeType httpMimeType, boolean bl) {
        Tree tree;
        Object object;
        String string = httpMethod.getType().toLowerCase();
        String string2 = httpMethod.getReturnType();
        String string3 = httpMethod.getPath();
        String string4 = httpMethod.getName() + (bl ? "_" + httpMimeType.name() : "");
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree modifiersTree2 = treeMaker.Modifiers(Collections.emptySet());
        VariableTree variableTree = null;
        IdentifierTree identifierTree = null;
        String string5 = "";
        String string6 = "";
        List<Object> list = Collections.emptyList();
        if ("javax.ws.rs.core.Response".equals(string2)) {
            object = workingCopy.getElements().getTypeElement("com.sun.jersey.api.client.ClientResponse");
            string6 = "return ";
            identifierTree = object == null ? workingCopy.getTreeMaker().Identifier((CharSequence)"com.sun.jersey.api.client.ClientResponse") : workingCopy.getTreeMaker().QualIdent((Element)object);
            string5 = object == null ? "com.sun.jersey.api.client.ClientResponse.class" : "ClientResponse.class";
        } else if ("void".equals(string2)) {
            identifierTree = treeMaker.Identifier((CharSequence)"void");
        } else if ("java.lang.String".equals(string2)) {
            identifierTree = treeMaker.Identifier((CharSequence)"String");
            string6 = "return ";
            string5 = "String.class";
        } else {
            identifierTree = treeMaker.Identifier((CharSequence)"T");
            string6 = "return ";
            string5 = "responseType";
            variableTree = treeMaker.Variable(modifiersTree2, (CharSequence)"responseType", (Tree)treeMaker.Identifier((CharSequence)"Class<T>"), null);
            list = Collections.singletonList(treeMaker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        }
        object = new ArrayList();
        if (variableTree != null) {
            object.add(variableTree);
        }
        String string7 = "";
        if (httpMimeType != null && httpMimeType != HttpMimeType.FORM) {
            tree = treeMaker.Variable(modifiersTree2, (CharSequence)"requestEntity", (Tree)treeMaker.Identifier((CharSequence)"Object"), null);
            object.add(tree);
            string7 = (string5.length() > 0 ? ", " : "") + "requestEntity";
        }
        tree = JavaSourceHelper.createTypeTree(workingCopy, "com.sun.jersey.api.client.UniformInterfaceException");
        if (string3.length() == 0) {
            String string8 = "{" + (httpMimeType == null ? "   " + string6 + "webResource." + string + "(" + string5 + string7 + ");" : "   " + string6 + "webResource.type(" + httpMimeType.getMediaType() + ")." + string + "(" + string5 + string7 + ");") + "}";
            return treeMaker.Method(modifiersTree, (CharSequence)string4, (Tree)identifierTree, list, (List)object, Collections.singletonList(tree), string8, null);
        }
        PathFormat pathFormat = ClientJavaSourceHelper.getPathFormat(string3);
        for (String string8 : pathFormat.getArguments()) {
            IdentifierTree identifierTree2 = treeMaker.Identifier((CharSequence)"String");
            ModifiersTree modifiersTree3 = treeMaker.Modifiers(Collections.emptySet());
            VariableTree variableTree2 = treeMaker.Variable(modifiersTree3, (CharSequence)string8, (Tree)identifierTree2, null);
            object.add(variableTree2);
        }
        String string9 = "{" + (httpMimeType == null ? "   " + string6 + "webResource.path(" + ClientJavaSourceHelper.getPathExpression(pathFormat) + ")." + string + "(" + string5 + string7 + ");" : "   " + string6 + "webResource.path(" + ClientJavaSourceHelper.getPathExpression(pathFormat) + ").type(" + httpMimeType.getMediaType() + ")." + string + "(" + string5 + string7 + ");") + "}";
        return treeMaker.Method(modifiersTree, (CharSequence)string4, (Tree)identifierTree, list, (List)object, Collections.singletonList(tree), string9, null);
    }

    private static String getPathExpression(PathFormat pathFormat) {
        String[] stringArray = pathFormat.getArguments();
        if (stringArray.length == 0) {
            return "\"" + pathFormat.getPattern() + "\"";
        }
        return "java.text.MessageFormat.format(\"" + pathFormat.getPattern() + "\", new Object[] {" + ClientJavaSourceHelper.getArgumentList(stringArray) + "})";
    }

    private static String getArgumentList(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("," + stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static PathFormat getPathFormat(String string) {
        String string2 = ClientJavaSourceHelper.normalizePath(string);
        PathFormat pathFormat = new PathFormat();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '{') {
                int n;
                for (n = i + 1; n < string2.length() && string2.charAt(n) != '}'; ++n) {
                }
                String string3 = string2.substring(i + 1, n);
                stringBuffer.append("{" + arrayList.size() + "}");
                arrayList.add(string3);
                i = n;
                continue;
            }
            stringBuffer.append(c);
        }
        pathFormat.setPattern(stringBuffer.toString());
        pathFormat.setArguments(arrayList.toArray(new String[arrayList.size()]));
        return pathFormat;
    }

    private static ResourcePath getResourcePath(WadlSaasResource wadlSaasResource) {
        String string = ClientJavaSourceHelper.normalizePath(wadlSaasResource.getResource().getPath());
        for (WadlSaasResource wadlSaasResource2 = wadlSaasResource.getParent(); wadlSaasResource2 != null; wadlSaasResource2 = wadlSaasResource2.getParent()) {
            String string2 = ClientJavaSourceHelper.normalizePath(wadlSaasResource2.getResource().getPath());
            if (string2.length() <= 0) continue;
            string = string2 + "/" + string;
        }
        return new ResourcePath(ClientJavaSourceHelper.getPathFormat(string), string);
    }

    private static String normalizePath(String string) {
        String string2 = string;
        while (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private static ResourcePath getResourcePath(Node node, String string, String string2) {
        String string3 = ClientJavaSourceHelper.normalizePath(string2);
        Node node2 = node.getParentNode();
        if (node2 != null) {
            for (Node node3 : node2.getChildren().getNodes()) {
                RestServiceDescription restServiceDescription;
                if (node == node3 || (restServiceDescription = (RestServiceDescription)node3.getLookup().lookup(RestServiceDescription.class)) == null) continue;
                for (RestMethodDescription restMethodDescription : restServiceDescription.getMethods()) {
                    SubResourceLocator subResourceLocator;
                    if (!(restMethodDescription instanceof SubResourceLocator) || !string.equals((subResourceLocator = (SubResourceLocator)restMethodDescription).getReturnType())) continue;
                    String string4 = ClientJavaSourceHelper.normalizePath(subResourceLocator.getUriTemplate());
                    String string5 = restServiceDescription.getUriTemplate();
                    if (string5.length() > 0) {
                        String string6 = null;
                        string6 = string4.length() > 0 ? (string3.length() > 0 ? string4 + "/" + string3 : string4) : string3;
                        PathFormat pathFormat = ClientJavaSourceHelper.getPathFormat(ClientJavaSourceHelper.normalizePath(string5) + "/" + string6);
                        return new ResourcePath(pathFormat, string5);
                    }
                    return ClientJavaSourceHelper.getResourcePath(node3, restServiceDescription.getClassName(), string4 + "/" + string2);
                }
            }
        }
        return new ResourcePath(ClientJavaSourceHelper.getPathFormat(string2), string2);
    }

    public static String getBaseURL(Project project) {
        String string;
        Object object;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String string2 = j2eeModuleProvider.getServerInstanceID();
        if (string2 == null) {
            Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
            return "";
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string2);
        String string3 = "8080";
        String string4 = "localhost";
        try {
            object = serverInstance.getDescriptor();
            if (object != null) {
                int n = object.getHttpPort();
                string3 = n == 0 ? "8080" : String.valueOf(n);
                string = object.getHostname();
                if (string != null) {
                    string4 = string;
                }
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Removed ServerInstance", instanceRemovedException);
        }
        object = null;
        J2eeModule.Type type = j2eeModuleProvider.getJ2eeModule().getType();
        if (J2eeModule.Type.WAR.equals(type)) {
            string = j2eeModuleProvider.getConfigSupport();
            try {
                object = string.getWebContextRoot();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            if (object != null && ((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
        }
        string = "resources";
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            try {
                string = restSupport.getApplicationPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "http://" + string4 + ":" + string3 + "/" + (String)(object != null && !((String)object).equals("") ? object : "") + "/" + string;
    }

    private static void addSecurityMetadata(Security security, WadlSaasResource wadlSaasResource) {
        SaasMetadata.Authentication authentication;
        SaasMetadata saasMetadata = wadlSaasResource.getSaas().getSaasMetadata();
        if (saasMetadata != null && (authentication = saasMetadata.getAuthentication()) != null && authentication.getSessionKey().size() > 0) {
            SecurityParams securityParams = new SecurityParams();
            SaasMetadata.Authentication.SessionKey sessionKey = (SaasMetadata.Authentication.SessionKey)authentication.getSessionKey().get(0);
            if (sessionKey != null) {
                Object object;
                Params params;
                securityParams.setSignature(sessionKey.getSigId());
                Sign sign = sessionKey.getSign();
                if (sign != null && (params = sign.getParams()) != null) {
                    object = new ArrayList();
                    for (Params.Param param : params.getParam()) {
                        object.add(param.getName());
                    }
                    securityParams.setParams((List<String>)object);
                }
                if ((params = sessionKey.getAuthenticator()) != null && (object = params.getUseTemplates()) != null) {
                    TemplateType templateType;
                    if ("nb-module".equals(security.getProjectType())) {
                        templateType = object.getNbModule();
                        if (templateType != null) {
                            securityParams.setFieldDescriptors(templateType.getFieldDescriptor());
                            securityParams.setMethodDescriptors(templateType.getMethodDescriptor());
                            securityParams.setServletDescriptors(templateType.getServletDescriptor());
                        }
                    } else if ("web".equals(security.getProjectType())) {
                        templateType = object.getWeb();
                        if (templateType != null) {
                            securityParams.setFieldDescriptors(templateType.getFieldDescriptor());
                            securityParams.setMethodDescriptors(templateType.getMethodDescriptor());
                            securityParams.setServletDescriptors(templateType.getServletDescriptor());
                        }
                    } else {
                        templateType = object.getDesktop();
                        if (templateType != null) {
                            securityParams.setFieldDescriptors(templateType.getFieldDescriptor());
                            securityParams.setMethodDescriptors(templateType.getMethodDescriptor());
                            securityParams.setServletDescriptors(templateType.getServletDescriptor());
                        }
                    }
                }
            }
            security.setSecurityParams(securityParams);
        }
    }

    private static void addWebXmlArtifacts(FileObject fileObject, SecurityParams securityParams, String string, String string2) throws IOException {
        WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
        if (webApp != null) {
            for (ServletDescriptor servletDescriptor : securityParams.getServletDescriptors()) {
                String string3 = string + "$" + servletDescriptor.getClassName();
                String string4 = string2 + "." + string3;
                String string5 = servletDescriptor.getServletMapping();
                try {
                    Servlet servlet = (Servlet)webApp.createBean("Servlet");
                    servlet.setServletName(string3);
                    servlet.setServletClass(string4);
                    ServletMapping servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                    servletMapping.setServletName(string3);
                    if (servletMapping instanceof ServletMapping25) {
                        ((ServletMapping25)servletMapping).addUrlPattern(string5);
                    } else {
                        servletMapping.setUrlPattern(string5);
                    }
                    webApp.addServlet(servlet);
                    webApp.addServletMapping(servletMapping);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            webApp.write(fileObject);
        }
    }

    private static void addWebXmlOAuthArtifacts(FileObject fileObject, String string, String string2) throws IOException {
        String[] stringArray = new String[]{"OAuthLoginServlet", "OAuthCallbackServlet"};
        String[] stringArray2 = new String[]{"/OAuthLogin", "/OAuthCallback"};
        WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
        if (webApp != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = string + "$" + stringArray[i];
                String string4 = string2 + "." + string3;
                try {
                    Servlet servlet = (Servlet)webApp.createBean("Servlet");
                    servlet.setServletName(string3);
                    servlet.setServletClass(string4);
                    ServletMapping servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                    servletMapping.setServletName(string3);
                    if (servletMapping instanceof ServletMapping25) {
                        ((ServletMapping25)servletMapping).addUrlPattern(stringArray2[i]);
                    } else {
                        servletMapping.setUrlPattern(stringArray2[i]);
                    }
                    webApp.addServlet(servlet);
                    webApp.addServletMapping(servletMapping);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            webApp.write(fileObject);
        }
    }

    static enum HttpMimeType {
        XML("application/xml", "javax.ws.rs.core.MediaType.APPLICATION_XML"),
        JSON("application/json", "javax.ws.rs.core.MediaType.APPLICATION_JSON"),
        TEXT("text/plain", "javax.ws.rs.core.MediaType.TEXT_PLAIN"),
        HTML("text/html", "javax.ws.rs.core.MediaType.TEXT_HTML"),
        TEXT_XML("text/xml", "javax.ws.rs.core.MediaType.TEXT_XML"),
        FORM("application/x-www-form-urlencoded", "javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED");

        private String mimeType;
        private String mediaType;

        private HttpMimeType(String string2, String string3) {
            this.mimeType = string2;
            this.mediaType = string3;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getMediaType() {
            return this.mediaType;
        }
    }

    static class ResourcePath {
        private PathFormat pathFormat;
        private String path;

        public ResourcePath() {
        }

        public ResourcePath(PathFormat pathFormat, String string) {
            this.pathFormat = pathFormat;
            this.path = string;
        }

        public PathFormat getPathFormat() {
            return this.pathFormat;
        }

        public void setPathFormat(PathFormat pathFormat) {
            this.pathFormat = pathFormat;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }
    }

    static class PathFormat {
        private String pattern;
        private String[] arguments;

        PathFormat() {
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setArguments(String[] stringArray) {
            this.arguments = stringArray;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String string) {
            this.pattern = string;
        }
    }
}

