/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.issuetable.QueryTableCellRenderer;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.QueryNotifyListener;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.SaveQueryPanel;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.BugzillaConnector;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.BugzillaQueryCellRenderer;
import org.netbeans.modules.bugzilla.query.QueryPanel;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class QueryController
extends BugtrackingController
implements DocumentListener,
ItemListener,
ListSelectionListener,
ActionListener,
FocusListener,
KeyListener {
    protected QueryPanel panel;
    private static final String CHANGED_NOW = "Now";
    private final QueryParameter.ComboParameter summaryParameter;
    private final QueryParameter.ComboParameter commentsParameter;
    private final QueryParameter.ComboParameter whiteboardParameter;
    private final QueryParameter.ComboParameter keywordsParameter;
    private final QueryParameter.ComboParameter peopleParameter;
    private final QueryParameter.ListParameter productParameter;
    private final QueryParameter.ListParameter componentParameter;
    private final QueryParameter.ListParameter versionParameter;
    private final QueryParameter.ListParameter statusParameter;
    private final QueryParameter.ListParameter resolutionParameter;
    private final QueryParameter.ListParameter priorityParameter;
    private final QueryParameter.ListParameter changedFieldsParameter;
    private final QueryParameter.ListParameter severityParameter;
    private final QueryParameter.ListParameter issueTypeParameter;
    private final QueryParameter.ListParameter tmParameter;
    private final Map<String, QueryParameter> parameters;
    private RequestProcessor rp = new RequestProcessor("Bugzilla query", 1, true);
    private final BugzillaRepository repository;
    protected BugzillaQuery query;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private QueryTask refreshTask;
    private final IssueTable issueTable;
    private final boolean isNetbeans;

    public QueryController(BugzillaRepository repository, BugzillaQuery query, String urlParameters, boolean urlDef) {
        this(repository, query, urlParameters, false, true);
    }

    public QueryController(BugzillaRepository repository, BugzillaQuery query, String urlParameters, boolean urlDef, boolean populate) {
        this.repository = repository;
        this.query = query;
        this.issueTable = new IssueTable((Query)query, query.getColumnDescriptors());
        this.setupRenderer(this.issueTable);
        this.panel = new QueryPanel(this.issueTable.getComponent(), this);
        this.isNetbeans = BugzillaUtil.isNbRepository(repository);
        this.panel.setNBFieldsVisible(this.isNetbeans);
        this.panel.productList.addListSelectionListener(this);
        this.panel.filterComboBox.addItemListener(this);
        this.panel.searchButton.addActionListener(this);
        this.panel.refreshCheckBox.addActionListener(this);
        this.panel.keywordsButton.addActionListener(this);
        this.panel.saveChangesButton.addActionListener(this);
        this.panel.cancelChangesButton.addActionListener(this);
        this.panel.gotoIssueButton.addActionListener(this);
        this.panel.webButton.addActionListener((ActionListener)this);
        this.panel.saveButton.addActionListener((ActionListener)this);
        this.panel.urlToggleButton.addActionListener((ActionListener)this);
        this.panel.refreshButton.addActionListener((ActionListener)this);
        this.panel.modifyButton.addActionListener((ActionListener)this);
        this.panel.seenButton.addActionListener((ActionListener)this);
        this.panel.removeButton.addActionListener((ActionListener)this);
        this.panel.refreshConfigurationButton.addActionListener((ActionListener)this);
        this.panel.findIssuesButton.addActionListener((ActionListener)this);
        this.panel.cloneQueryButton.addActionListener((ActionListener)this);
        this.panel.changedFromTextField.addFocusListener(this);
        this.panel.idTextField.addActionListener(this);
        this.panel.productList.addKeyListener(this);
        this.panel.componentList.addKeyListener(this);
        this.panel.versionList.addKeyListener(this);
        this.panel.statusList.addKeyListener(this);
        this.panel.resolutionList.addKeyListener(this);
        this.panel.severityList.addKeyListener(this);
        this.panel.priorityList.addKeyListener(this);
        this.panel.changedList.addKeyListener(this);
        this.panel.tmList.addKeyListener(this);
        this.panel.summaryTextField.addActionListener(this);
        this.panel.commentTextField.addActionListener(this);
        this.panel.whiteboardTextField.addActionListener(this);
        this.panel.keywordsTextField.addActionListener(this);
        this.panel.peopleTextField.addActionListener(this);
        this.panel.changedFromTextField.addActionListener(this);
        this.panel.changedToTextField.addActionListener(this);
        this.panel.changedToTextField.addActionListener(this);
        this.parameters = new LinkedHashMap<String, QueryParameter>();
        this.summaryParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.summaryComboBox, "short_desc_type");
        this.commentsParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.commentComboBox, "long_desc_type");
        this.whiteboardParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.whiteboardComboBox, "status_whiteboard_type");
        this.keywordsParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.keywordsComboBox, "keywords_type");
        this.peopleParameter = this.createQueryParameter(QueryParameter.ComboParameter.class, this.panel.peopleComboBox, "emailtype1");
        this.productParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.productList, "product");
        this.componentParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.componentList, "component");
        this.versionParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.versionList, "version");
        this.statusParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.statusList, "bug_status");
        this.resolutionParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.resolutionList, "resolution");
        this.priorityParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.priorityList, "priority");
        this.changedFieldsParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.changedList, "chfield");
        if (this.isNetbeans) {
            this.issueTypeParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.issueTypeList, "cf_bug_type");
            this.tmParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.tmList, "target_milestone");
            this.severityParameter = null;
        } else {
            this.severityParameter = this.createQueryParameter(QueryParameter.ListParameter.class, this.panel.severityList, "bug_severity");
            this.issueTypeParameter = null;
            this.tmParameter = null;
        }
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.summaryTextField, "short_desc");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.commentTextField, "long_desc");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.whiteboardTextField, "status_whiteboard");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.keywordsTextField, "keywords");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.peopleTextField, "email1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.bugAssigneeCheckBox, "emailassigned_to1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.reporterCheckBox, "emailreporter1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.ccCheckBox, "emailcc1");
        this.createQueryParameter(QueryParameter.CheckBoxParameter.class, this.panel.commenterCheckBox, "emaillongdesc1");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.changedFromTextField, "chfieldfrom");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.changedToTextField, "chfieldto");
        this.createQueryParameter(QueryParameter.TextFieldParameter.class, this.panel.newValueTextField, "chfieldvalue");
        this.panel.filterComboBox.setModel(new DefaultComboBoxModel<Filter>(this.issueTable.getDefinedFilters()));
        if (query.isSaved()) {
            this.setAsSaved();
        }
        if (urlDef) {
            this.panel.switchQueryFields(false);
            this.panel.urlTextField.setText(urlParameters);
        } else {
            this.postPopulate(urlParameters, false);
        }
    }

    private void setupRenderer(IssueTable issueTable) {
        BugzillaQueryCellRenderer renderer = new BugzillaQueryCellRenderer(new QueryTableCellRenderer((Query)this.query, issueTable));
        issueTable.setRenderer((TableCellRenderer)renderer);
    }

    public void opened() {
        boolean autoRefresh = BugzillaConfig.getInstance().getQueryAutoRefresh(this.query.getDisplayName());
        if (autoRefresh) {
            this.scheduleForRefresh();
        }
        if (this.query.isSaved()) {
            this.setIssueCount(this.query.getSize());
            if (!this.query.wasRun()) {
                this.onRefresh();
            }
        }
    }

    public void closed() {
        this.onCancelChanges();
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        if (this.query.isSaved() && !(this.query.getRepository() instanceof KenaiRepository)) {
            this.repository.stopRefreshing(this.query);
        }
    }

    protected void scheduleForRefresh() {
        if (this.query.isSaved()) {
            this.repository.scheduleForRefresh(this.query);
        }
    }

    private <T extends QueryParameter> T createQueryParameter(Class<T> clazz, Component c, String parameter) {
        try {
            Constructor<T> constructor = clazz.getConstructor(c.getClass(), String.class);
            QueryParameter t = (QueryParameter)constructor.newInstance(c, parameter);
            this.parameters.put(parameter, t);
            return (T)t;
        }
        catch (Exception ex) {
            Bugzilla.LOG.log(Level.SEVERE, parameter, ex);
            return null;
        }
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BugzillaQuery.class);
    }

    public boolean isValid() {
        return true;
    }

    public void applyChanges() {
    }

    public String getUrlParameters() {
        if (this.panel.urlPanel.isVisible()) {
            return this.panel.urlTextField.getText();
        }
        StringBuilder sb = new StringBuilder();
        for (QueryParameter p : this.parameters.values()) {
            sb.append(p.get());
        }
        return sb.toString();
    }

    protected BugzillaRepository getRepository() {
        return this.repository;
    }

    protected void postPopulate(final String urlParameters, final boolean forceRefresh) {
        final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
        Cancellable c = new Cancellable(){

            public boolean cancel() {
                if (t[0] != null) {
                    return t[0].cancel();
                }
                return true;
            }
        };
        final String msgPopulating = NbBundle.getMessage(QueryController.class, (String)"MSG_Populating", (Object[])new Object[]{this.repository.getDisplayName()});
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)msgPopulating, (Cancellable)c);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryController.this.enableFields(false);
                QueryController.this.panel.showRetrievingProgress(true, msgPopulating, !QueryController.this.query.isSaved());
                handle.start();
            }
        });
        t[0] = this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (forceRefresh) {
                        QueryController.this.repository.refreshConfiguration();
                    }
                    QueryController.this.populate(urlParameters);
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            QueryController.this.enableFields(true);
                            handle.finish();
                            QueryController.this.panel.showRetrievingProgress(false, null, !QueryController.this.query.isSaved());
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void populate(final String urlParameters) {
        BugzillaConfiguration bc;
        block4: {
            if (Bugzilla.LOG.isLoggable(Level.FINE)) {
                Bugzilla.LOG.log(Level.FINE, "Starting populate query controller{0}", this.query.isSaved() ? " - " + this.query.getDisplayName() : "");
            }
            try {
                bc = this.repository.getConfiguration();
                if (bc != null && bc.isValid()) break block4;
                if (!Bugzilla.LOG.isLoggable(Level.FINE)) return;
            }
            catch (Throwable throwable) {
                if (!Bugzilla.LOG.isLoggable(Level.FINE)) throw throwable;
                Bugzilla.LOG.log(Level.FINE, "Finnished populate query controller{0}", this.query.isSaved() ? " - " + this.query.getDisplayName() : "");
                throw throwable;
            }
            Bugzilla.LOG.log(Level.FINE, "Finnished populate query controller{0}", this.query.isSaved() ? " - " + this.query.getDisplayName() : "");
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryController.this.productParameter.setParameterValues(QueryController.this.toParameterValues(bc.getProducts()));
                QueryController.this.populateProductDetails(new String[0]);
                if (QueryController.this.isNetbeans) {
                    QueryController.this.issueTypeParameter.setParameterValues(QueryController.this.toParameterValues(bc.getIssueTypes()));
                } else {
                    QueryController.this.severityParameter.setParameterValues(QueryController.this.toParameterValues(bc.getSeverities()));
                }
                QueryController.this.statusParameter.setParameterValues(QueryController.this.toParameterValues(bc.getStatusValues()));
                QueryController.this.resolutionParameter.setParameterValues(QueryController.this.toParameterValues(bc.getResolutions()));
                QueryController.this.priorityParameter.setParameterValues(QueryController.this.toParameterValues(bc.getPriorities()));
                QueryController.this.changedFieldsParameter.setParameterValues(QueryParameter.PV_LAST_CHANGE);
                QueryController.this.summaryParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                QueryController.this.commentsParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                QueryController.this.whiteboardParameter.setParameterValues(QueryParameter.PV_TEXT_SEARCH_VALUES);
                QueryController.this.keywordsParameter.setParameterValues(QueryParameter.PV_KEYWORDS_VALUES);
                QueryController.this.peopleParameter.setParameterValues(QueryParameter.PV_PEOPLE_VALUES);
                QueryController.this.panel.changedToTextField.setText(QueryController.CHANGED_NOW);
                QueryController.this.setParameters(urlParameters != null ? urlParameters : QueryController.this.getDefaultParameters());
                if (QueryController.this.query.isSaved()) {
                    boolean autoRefresh = BugzillaConfig.getInstance().getQueryAutoRefresh(QueryController.this.query.getDisplayName());
                    QueryController.this.panel.refreshCheckBox.setSelected(autoRefresh);
                }
            }
        });
        if (!Bugzilla.LOG.isLoggable(Level.FINE)) return;
        Bugzilla.LOG.log(Level.FINE, "Finnished populate query controller{0}", this.query.isSaved() ? " - " + this.query.getDisplayName() : "");
    }

    private String getDefaultParameters() {
        return BugzillaUtil.isNbRepository(this.repository) ? "&bug_status=NEW&bug_status=STARTED&bug_status=REOPENED" : "&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED";
    }

    protected void enableFields(boolean bl) {
        this.panel.enableFields(bl);
        for (Map.Entry<String, QueryParameter> e : this.parameters.entrySet()) {
            QueryParameter pv = this.parameters.get(e.getKey());
            pv.setEnabled(bl);
        }
    }

    protected void disableProduct() {
        this.productParameter.setAlwaysDisabled(true);
    }

    protected void selectFirstProduct() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (QueryController.this.panel.productList.getModel().getSize() > 0) {
                    QueryController.this.panel.productList.setSelectedIndex(0);
                }
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireDataChanged();
        if (e.getSource() == this.panel.filterComboBox) {
            this.onFilterChange((Filter)e.getItem());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.panel.productList) {
            this.onProductChanged(e);
        }
        this.fireDataChanged();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.panel.changedFromTextField.getText().equals("")) {
            String lastChangeFrom = BugzillaConfig.getInstance().getLastChangeFrom();
            this.panel.changedFromTextField.setText(lastChangeFrom);
            this.panel.changedFromTextField.setSelectionStart(0);
            this.panel.changedFromTextField.setSelectionEnd(lastChangeFrom.length());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.searchButton) {
            this.onRefresh();
        } else if (e.getSource() == this.panel.gotoIssueButton) {
            this.onGotoIssue();
        } else if (e.getSource() == this.panel.keywordsButton) {
            this.onKeywords();
        } else if (e.getSource() == this.panel.searchButton) {
            this.onRefresh();
        } else if (e.getSource() == this.panel.saveChangesButton) {
            this.onSave(true);
        } else if (e.getSource() == this.panel.cancelChangesButton) {
            this.onCancelChanges();
        } else if (e.getSource() == this.panel.gotoIssueButton) {
            this.onGotoIssue();
        } else if (e.getSource() == this.panel.webButton) {
            this.onWeb();
        } else if (e.getSource() == this.panel.saveButton) {
            this.onSave(false);
        } else if (e.getSource() == this.panel.urlToggleButton) {
            this.onDefineAs();
        } else if (e.getSource() == this.panel.refreshButton) {
            this.onRefresh();
        } else if (e.getSource() == this.panel.modifyButton) {
            this.onModify();
        } else if (e.getSource() == this.panel.seenButton) {
            this.onMarkSeen();
        } else if (e.getSource() == this.panel.removeButton) {
            this.onRemove();
        } else if (e.getSource() == this.panel.refreshCheckBox) {
            this.onAutoRefresh();
        } else if (e.getSource() == this.panel.refreshConfigurationButton) {
            this.onRefreshConfiguration();
        } else if (e.getSource() == this.panel.findIssuesButton) {
            this.onFindIssues();
        } else if (e.getSource() == this.panel.cloneQueryButton) {
            this.onCloneQuery();
        } else if (e.getSource() == this.panel.idTextField) {
            if (!this.panel.idTextField.getText().trim().equals("")) {
                this.onGotoIssue();
            }
        } else if (e.getSource() == this.panel.idTextField || e.getSource() == this.panel.summaryTextField || e.getSource() == this.panel.commentTextField || e.getSource() == this.panel.keywordsTextField || e.getSource() == this.panel.peopleTextField || e.getSource() == this.panel.changedFromTextField || e.getSource() == this.panel.newValueTextField || e.getSource() == this.panel.changedToTextField) {
            this.onRefresh();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 10) {
            return;
        }
        if (e.getSource() == this.panel.productList || e.getSource() == this.panel.componentList || e.getSource() == this.panel.versionList || e.getSource() == this.panel.statusList || e.getSource() == this.panel.resolutionList || e.getSource() == this.panel.priorityList || e.getSource() == this.panel.changedList) {
            this.onRefresh();
        }
    }

    private void onFilterChange(Filter filter) {
        this.selectFilter(filter);
    }

    private void onSave(final boolean refresh) {
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Bugzilla.LOG.fine("on save start");
                String name = QueryController.this.query.getDisplayName();
                if (!QueryController.this.query.isSaved() && (name = QueryController.this.getSaveName()) == null) {
                    return;
                }
                assert (name != null);
                QueryController.this.save(name);
                Bugzilla.LOG.fine("on save finnish");
                if (refresh) {
                    QueryController.this.onRefresh();
                }
            }
        });
    }

    private void save(String name) {
        Bugzilla.LOG.log(Level.FINE, "saving query '{0}'", new Object[]{name});
        this.query.setName(name);
        this.repository.saveQuery(this.query);
        this.query.setSaved(true);
        this.setAsSaved();
        if (!this.query.wasRun()) {
            Bugzilla.LOG.log(Level.FINE, "refreshing query '{0}' after save", new Object[]{name});
            this.onRefresh();
        }
        Bugzilla.LOG.log(Level.FINE, "query '{0}' saved", new Object[]{name});
    }

    private String getSaveName() {
        SaveQueryPanel.QueryNameValidator v = new SaveQueryPanel.QueryNameValidator(){

            public String isValid(String name) {
                Query[] queries;
                for (Query q : queries = QueryController.this.repository.getQueries()) {
                    if (!q.getDisplayName().equals(name)) continue;
                    return NbBundle.getMessage(QueryController.class, (String)"MSG_SAME_NAME");
                }
                return null;
            }
        };
        return SaveQueryPanel.show((SaveQueryPanel.QueryNameValidator)v, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.query.savePanel"));
    }

    private void onCancelChanges() {
        String urlParameters;
        if (this.query.getDisplayName() != null && (urlParameters = BugzillaConfig.getInstance().getUrlParams(this.repository, this.query.getDisplayName())) != null) {
            this.setParameters(urlParameters);
        }
        this.setAsSaved();
    }

    public void selectFilter(final Filter filter) {
        if (filter != null) {
            Issue[] issues = this.query.getIssues();
            int c = 0;
            if (issues != null) {
                for (Issue issue : issues) {
                    if (!filter.accept(issue)) continue;
                    ++c;
                }
            }
            final int issueCount = c;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    QueryController.this.panel.filterComboBox.setSelectedItem(filter);
                    QueryController.this.setIssueCount(issueCount);
                }
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }
        this.issueTable.setFilter(filter);
    }

    private void setAsSaved() {
        this.panel.setSaved(this.query.getDisplayName(), this.getLastRefresh());
        this.panel.setModifyVisible(false);
        this.panel.refreshCheckBox.setVisible(true);
    }

    private String getLastRefresh() throws MissingResourceException {
        long l = this.query.getLastRefresh();
        return l > 0L ? this.dateFormat.format(new Date(l)) : NbBundle.getMessage(QueryController.class, (String)"LBL_Never");
    }

    private void onGotoIssue() {
        final String id = this.panel.idTextField.getText().trim();
        if (id == null || id.trim().equals("")) {
            return;
        }
        final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
        Cancellable c = new Cancellable(){

            public boolean cancel() {
                if (t[0] != null) {
                    return t[0].cancel();
                }
                return true;
            }
        };
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryController.class, (String)"MSG_Opening", (Object[])new Object[]{id}), (Cancellable)c);
        t[0] = Bugzilla.getInstance().getRequestProcessor().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                handle.start();
                try {
                    QueryController.this.openIssue((BugzillaIssue)QueryController.this.repository.getIssue(id));
                }
                finally {
                    handle.finish();
                }
            }
        });
        t[0].schedule(0);
    }

    protected void openIssue(BugzillaIssue issue) {
        if (issue != null) {
            issue.open();
        }
    }

    private void onWeb() {
        String params = this.getUrlParameters();
        String repoURL = this.repository.getTaskRepository().getRepositoryUrl() + "/query.cgi?format=advanced";
        final String urlString = repoURL + (params != null && !params.equals("") ? params : "");
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                URL url;
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException ex) {
                    Bugzilla.LOG.log(Level.SEVERE, null, ex);
                    return;
                }
                HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                if (displayer != null) {
                    displayer.showURL(url);
                } else {
                    Bugzilla.LOG.warning("No URLDisplayer found.");
                }
            }
        });
    }

    private void onProductChanged(ListSelectionEvent e) {
        Object[] values = this.panel.productList.getSelectedValues();
        String[] products = null;
        if (values != null) {
            products = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                products[i] = ((QueryParameter.ParameterValue)values[i]).getValue();
            }
        }
        this.populateProductDetails(products);
    }

    private void onDefineAs() {
        this.panel.switchQueryFields(this.panel.urlPanel.isVisible());
    }

    private void onKeywords() {
        String keywords = BugzillaUtil.getKeywords(NbBundle.getMessage(QueryController.class, (String)"LBL_SelectKeywords"), this.panel.keywordsTextField.getText(), this.repository);
        if (keywords != null) {
            this.panel.keywordsTextField.setText(keywords);
        }
    }

    public void autoRefresh() {
        this.onRefresh(true);
    }

    public void onRefresh() {
        this.onRefresh(false);
    }

    private void onRefresh(boolean auto) {
        if (this.refreshTask == null) {
            this.refreshTask = new QueryTask();
        } else {
            this.refreshTask.cancel();
        }
        this.refreshTask.post(auto);
    }

    private void onModify() {
        this.panel.setModifyVisible(true);
    }

    private void onMarkSeen() {
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Issue[] issues;
                for (Issue issue : issues = QueryController.this.query.getIssues()) {
                    try {
                        ((BugzillaIssue)issue).setSeen(true);
                    }
                    catch (IOException ex) {
                        Bugzilla.LOG.log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
    }

    private void onRemove() {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(QueryController.class, (String)"MSG_RemoveQuery", (Object[])new Object[]{this.query.getDisplayName()}), NbBundle.getMessage(QueryController.class, (String)"CTL_RemoveQuery"), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
            Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    QueryController.this.remove();
                }
            });
        }
    }

    private void onFindIssues() {
        Query.openNew((Repository)this.repository);
    }

    private void onCloneQuery() {
        String p = this.getUrlParameters();
        BugzillaQuery q = new BugzillaQuery(null, this.getRepository(), p, false, false, true);
        BugtrackingUtil.openQuery((Query)q, (Repository)this.getRepository(), (boolean)false);
    }

    private void onAutoRefresh() {
        boolean autoRefresh = this.panel.refreshCheckBox.isSelected();
        BugzillaConfig.getInstance().setQueryAutoRefresh(this.query.getDisplayName(), autoRefresh);
        this.logAutoRefreshEvent(autoRefresh);
        if (autoRefresh) {
            this.scheduleForRefresh();
        } else {
            this.repository.stopRefreshing(this.query);
        }
    }

    protected void logAutoRefreshEvent(boolean autoRefresh) {
        BugtrackingUtil.logAutoRefreshEvent((String)BugzillaConnector.getConnectorName(), (String)this.query.getDisplayName(), (boolean)false, (boolean)autoRefresh);
    }

    private void onRefreshConfiguration() {
        this.postPopulate(this.getUrlParameters(), true);
    }

    private void remove() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        this.query.remove();
    }

    private void populateProductDetails(String ... products) {
        BugzillaConfiguration bc = this.repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        if (products == null || products.length == 0) {
            products = new String[]{null};
        }
        ArrayList<String> newComponents = new ArrayList<String>();
        ArrayList<String> newVersions = new ArrayList<String>();
        ArrayList<String> newTargetMilestone = new ArrayList<String>();
        for (String p : products) {
            List<String> productComponents = bc.getComponents(p);
            for (String c : productComponents) {
                if (newComponents.contains(c)) continue;
                newComponents.add(c);
            }
            List<String> productVersions = bc.getVersions(p);
            for (String c : productVersions) {
                if (newVersions.contains(c)) continue;
                newVersions.add(c);
            }
            if (!this.isNetbeans) continue;
            List<String> targetMilestone = bc.getTargetMilestones(p);
            for (String c : targetMilestone) {
                if (newTargetMilestone.contains(c)) continue;
                newTargetMilestone.add(c);
            }
        }
        Collections.sort(newComponents);
        Collections.sort(newVersions);
        this.componentParameter.setParameterValues(this.toParameterValues(newComponents));
        this.versionParameter.setParameterValues(this.toParameterValues(newVersions));
        if (this.isNetbeans) {
            this.tmParameter.setParameterValues(this.toParameterValues(newTargetMilestone));
        }
    }

    private List<QueryParameter.ParameterValue> toParameterValues(List<String> values) {
        ArrayList<QueryParameter.ParameterValue> ret = new ArrayList<QueryParameter.ParameterValue>(values.size());
        for (String v : values) {
            ret.add(new QueryParameter.ParameterValue(v, v));
        }
        return ret;
    }

    private void setParameters(String urlParameters) {
        if (urlParameters == null) {
            return;
        }
        String[] params = urlParameters.split("&");
        if (params == null || params.length == 0) {
            return;
        }
        HashMap<String, ArrayList<QueryParameter.ParameterValue>> normalizedParams = new HashMap<String, ArrayList<QueryParameter.ParameterValue>>();
        for (String p : params) {
            int idx = p.indexOf("=");
            if (idx <= -1) continue;
            String parameter = p.substring(0, idx);
            String value = p.substring(idx + 1, p.length());
            QueryParameter.ParameterValue pv = new QueryParameter.ParameterValue(value, value);
            ArrayList<QueryParameter.ParameterValue> values = (ArrayList<QueryParameter.ParameterValue>)normalizedParams.get(parameter);
            if (values == null) {
                values = new ArrayList<QueryParameter.ParameterValue>();
                normalizedParams.put(parameter, values);
            }
            values.add(pv);
        }
        List componentPV = null;
        List versionPV = null;
        for (Map.Entry e : normalizedParams.entrySet()) {
            QueryParameter pv = this.parameters.get(e.getKey());
            if (pv == null) continue;
            if (pv == this.componentParameter) {
                componentPV = (List)e.getValue();
                continue;
            }
            if (pv == this.versionParameter) {
                versionPV = (List)e.getValue();
                continue;
            }
            List pvs = (List)e.getValue();
            pv.setValues(pvs.toArray(new QueryParameter.ParameterValue[pvs.size()]));
        }
        this.setDependentParameter(this.componentParameter, componentPV);
        this.setDependentParameter(this.versionParameter, versionPV);
    }

    private void setDependentParameter(QueryParameter p, List<QueryParameter.ParameterValue> values) {
        if (values != null) {
            p.setValues(values.toArray(new QueryParameter.ParameterValue[values.size()]));
        }
    }

    private void setIssueCount(final int count) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String msg = count == 1 ? NbBundle.getMessage(QueryController.class, (String)"LBL_MatchingIssue", (Object[])new Object[]{count}) : NbBundle.getMessage(QueryController.class, (String)"LBL_MatchingIssues", (Object[])new Object[]{count});
                QueryController.this.panel.tableSummaryLabel.setText(msg);
            }
        });
    }

    boolean isUrlDefined() {
        return this.panel.urlPanel.isVisible();
    }

    void switchToDeterminateProgress(long issuesCount) {
        if (this.refreshTask != null) {
            this.refreshTask.switchToDeterminateProgress(issuesCount);
        }
    }

    void addProgressUnit(String issueDesc) {
        if (this.refreshTask != null) {
            this.refreshTask.addProgressUnit(issueDesc);
        }
    }

    private class QueryTask
    implements Runnable,
    Cancellable,
    QueryNotifyListener {
        private ProgressHandle handle;
        private RequestProcessor.Task task;
        private int counter;
        private boolean autoRefresh;
        private long progressMaxWorkunits;
        private int progressWorkunits;

        public QueryTask() {
            QueryController.this.query.addNotifyListener(this);
        }

        private synchronized void startQuery() {
            this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryController.class, (String)"MSG_SearchingQuery", (Object[])new Object[]{QueryController.this.query.getDisplayName() != null ? QueryController.this.query.getDisplayName() : QueryController.this.repository.getDisplayName()}), (Cancellable)this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryController.this.enableFields(false);
                    QueryController.this.panel.showSearchingProgress(true, NbBundle.getMessage(QueryController.class, (String)"MSG_Searching"));
                }
            });
            this.handle.start();
        }

        private synchronized void finnishQuery() {
            this.task = null;
            if (this.handle != null) {
                this.handle.finish();
                this.handle = null;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryController.this.panel.setQueryRunning(false);
                    QueryController.this.panel.setLastRefresh(QueryController.this.getLastRefresh());
                    QueryController.this.panel.showNoContentPanel(false);
                    QueryController.this.enableFields(true);
                }
            });
        }

        synchronized void switchToDeterminateProgress(long progressMaxWorkunits) {
            if (this.handle != null) {
                this.handle.switchToDeterminate((int)progressMaxWorkunits);
                this.progressMaxWorkunits = progressMaxWorkunits;
                this.progressWorkunits = 0;
            }
        }

        synchronized void addProgressUnit(String issueDesc) {
            if (this.handle != null && (long)this.progressWorkunits < this.progressMaxWorkunits) {
                this.handle.progress(NbBundle.getMessage(QueryController.class, (String)"LBL_RetrievingIssue", (Object[])new Object[]{issueDesc}), ++this.progressWorkunits);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeQuery() {
            this.setQueryRunning(true);
            String lastChageFrom = QueryController.this.panel.changedFromTextField.getText().trim();
            if (lastChageFrom != null && !lastChageFrom.equals("")) {
                BugzillaConfig.getInstance().setLastChangeFrom(lastChageFrom);
            }
            try {
                if (QueryController.this.panel.urlPanel.isVisible()) {
                    QueryController.this.query.refresh(QueryController.this.panel.urlTextField.getText(), this.autoRefresh);
                } else {
                    QueryController.this.query.refresh(QueryController.this.getUrlParameters(), this.autoRefresh);
                }
            }
            finally {
                this.setQueryRunning(false);
                this.task = null;
            }
        }

        private void setQueryRunning(final boolean running) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryController.this.panel.setQueryRunning(running);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.startQuery();
            try {
                this.executeQuery();
            }
            finally {
                this.finnishQuery();
            }
        }

        synchronized void post(boolean autoRefresh) {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = QueryController.this.rp.create((Runnable)this);
            this.autoRefresh = autoRefresh;
            this.task.schedule(0);
        }

        public boolean cancel() {
            if (this.task != null) {
                this.task.cancel();
                this.finnishQuery();
            }
            return true;
        }

        public void notifyData(Issue issue) {
            if (!QueryController.this.query.contains(issue)) {
                return;
            }
            QueryController.this.setIssueCount(++this.counter);
            if (this.counter == 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        QueryController.this.panel.showNoContentPanel(false);
                    }
                });
            }
        }

        public void started() {
            this.counter = 0;
            QueryController.this.setIssueCount(this.counter);
        }

        public void finished() {
        }
    }
}

