/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.vcs.HookImpl;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.versioning.hooks.SvnHook;
import org.netbeans.modules.versioning.hooks.SvnHookContext;
import org.openide.util.NbBundle;

public class SvnHookImpl
extends SvnHook {
    private static final String[] SUPPORTED_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORTED_REVISION_VARIABLES = new String[]{"revision", "author", "date", "message"};
    private final String name = NbBundle.getMessage(SvnHookImpl.class, (String)"LBL_VCSHook");
    private final HookImpl delegate;

    public SvnHookImpl() {
        VCSHooksConfig config = VCSHooksConfig.getInstance(VCSHooksConfig.HookType.SVN);
        this.delegate = new HookImpl(config, SUPPORTED_ISSUE_INFO_VARIABLES, SUPPORTED_REVISION_VARIABLES);
    }

    public SvnHookContext beforeCommit(SvnHookContext context) throws IOException {
        String msg = this.delegate.beforeCommit(context.getFiles(), context.getMessage());
        return msg != null ? new SvnHookContext(context.getFiles(), msg, new ArrayList()) : null;
    }

    public void afterCommit(SvnHookContext context) {
        String author = ((SvnHookContext.LogEntry)context.getLogEntries().get(0)).getAuthor();
        long revision = ((SvnHookContext.LogEntry)context.getLogEntries().get(0)).getRevision();
        Date date = ((SvnHookContext.LogEntry)context.getLogEntries().get(0)).getDate();
        String message = ((SvnHookContext.LogEntry)context.getLogEntries().get(0)).getMessage();
        this.delegate.afterCommit(context.getFiles(), author, Long.toString(revision), date, message, "SVN", false);
    }

    public JPanel createComponent(SvnHookContext context) {
        HookPanel panel = this.delegate.createComponent(context.getFiles(), true);
        panel.commitRadioButton.setVisible(false);
        panel.pushRadioButton.setVisible(false);
        return panel;
    }

    public String getDisplayName() {
        return this.name;
    }
}

