/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.RunIntoMethodActionProvider;
import org.netbeans.modules.debugger.jpda.actions.StepOperationActionProvider;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.MethodChooser;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MethodChooserSupport
implements PropertyChangeListener {
    private JPDADebuggerImpl debugger;
    private JPDAThread currentThread;
    private String url;
    private ReferenceType clazzRef;
    private MethodChooser chooser;
    ArrayList<Annotation> annotations;
    private int startLine;
    private int endLine;
    private int selectedIndex = -1;
    private EditorContext.Operation[] operations;
    private Location[] locations;
    private boolean[] isCertainlyReachable;

    MethodChooserSupport(JPDADebuggerImpl debugger, String url, ReferenceType clazz, int methodLine, int methodOffset) {
        this.debugger = debugger;
        this.currentThread = debugger.getCurrentThread();
        this.url = url;
        this.clazzRef = clazz;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public MethodChooser.Segment[] getSegments() {
        MethodChooser.Segment[] segments = new MethodChooser.Segment[this.operations.length];
        for (int x = 0; x < segments.length; ++x) {
            int start = this.operations[x].getMethodStartPosition().getOffset();
            int end = this.operations[x].getMethodEndPosition().getOffset();
            segments[x] = this.isCertainlyReachable[x] ? new MethodChooser.Segment(start, end) : new UncertainSegment(start, end);
        }
        return segments;
    }

    public int getSegmentsCount() {
        return this.operations.length;
    }

    public String getHint() {
        return NbBundle.getMessage(MethodChooserSupport.class, (String)"MSG_RunIntoMethod_Status_Line_Help");
    }

    public KeyStroke[] getStopEvents() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(119, 0), KeyStroke.getKeyStroke(118, 64), KeyStroke.getKeyStroke(118, 128)};
    }

    public KeyStroke[] getConfirmEvents() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(118, 0)};
    }

    public MethodChooser createChooser() {
        return new MethodChooser(this.url, this.getSegments(), this.selectedIndex, this.getHint(), this.getStopEvents(), this.getConfirmEvents());
    }

    public void tearUp(MethodChooser selector) {
        System.setProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips", "true");
        this.chooser = selector;
        this.debugger.addPropertyChangeListener(this);
        this.debugger.getThreadsCollector().addPropertyChangeListener(this);
        this.annotateLines();
    }

    public void tearDown() {
        System.clearProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips");
        this.debugger.removePropertyChangeListener(this);
        this.debugger.getThreadsCollector().removePropertyChangeListener(this);
        this.clearAnnotations();
    }

    public void doStepInto() {
        final int index = this.chooser.getSelectedIndex();
        final String name = this.operations[index].getMethodName();
        this.debugger.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                RunIntoMethodActionProvider.doAction(MethodChooserSupport.this.debugger, name, MethodChooserSupport.this.locations[index], true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        int i;
        int i2;
        int x;
        int index;
        this.operations = new EditorContext.Operation[0];
        Method method = ((JPDAThreadImpl)this.currentThread).getTopMethod();
        List<Object> locs = Collections.emptyList();
        try {
            for (int methodLine = this.currentThread.getLineNumber(null); methodLine > 0 && (locs = MethodWrapper.locationsOfLine(method, methodLine)).isEmpty(); --methodLine) {
            }
        }
        catch (InternalExceptionWrapper aiex) {
        }
        catch (VMDisconnectedExceptionWrapper aiex) {
            return false;
        }
        catch (AbsentInformationException aiex) {
            ErrorManager.getDefault().notify(1, (Throwable)aiex);
        }
        if (locs.isEmpty()) {
            return false;
        }
        ExpressionPool.Expression expr = this.debugger.getExpressionPool().getExpressionAt((Location)locs.get(0), this.url);
        if (expr == null) {
            return false;
        }
        EditorContext.Operation currOp = this.currentThread.getCurrentOperation();
        List lastOpsList = this.currentThread.getLastOperations();
        EditorContext.Operation lastOp = lastOpsList != null && lastOpsList.size() > 0 ? (EditorContext.Operation)lastOpsList.get(lastOpsList.size() - 1) : null;
        EditorContext.Operation selectedOp = null;
        EditorContext.Operation[] tempOps = expr.getOperations();
        if (tempOps.length == 0) {
            return false;
        }
        Location[] tempLocs = expr.getLocations();
        this.operations = new EditorContext.Operation[tempOps.length];
        this.locations = new Location[tempOps.length];
        for (int x2 = 0; x2 < tempOps.length; ++x2) {
            this.operations[x2] = tempOps[x2];
            this.locations[x2] = tempLocs[x2];
        }
        this.startLine = this.operations[0].getMethodStartPosition().getLine();
        this.endLine = this.operations[this.operations.length - 1].getMethodEndPosition().getLine();
        for (int i3 = 1; i3 < this.operations.length - 1; ++i3) {
            int line = this.operations[i3].getMethodStartPosition().getLine();
            if (line < this.startLine) {
                this.startLine = line;
            }
            if (line <= this.endLine) continue;
            this.endLine = line;
        }
        int currOpIndex = -1;
        int lastOpIndex = -1;
        if (currOp != null) {
            index = currOp.getBytecodeIndex();
            for (x = 0; x < this.operations.length; ++x) {
                if (this.operations[x].getBytecodeIndex() != index) continue;
                currOpIndex = x;
                break;
            }
        }
        if (lastOp != null) {
            index = lastOp.getBytecodeIndex();
            for (x = 0; x < this.operations.length; ++x) {
                if (this.operations[x].getBytecodeIndex() != index) continue;
                lastOpIndex = x;
                break;
            }
        }
        EditorContext.Operation opToExecute = null;
        if (currOpIndex == -1) {
            selectedOp = this.operations[this.operations.length - 1];
            opToExecute = this.operations[0];
        } else {
            int splitIndex;
            int n = splitIndex = currOpIndex == lastOpIndex ? currOpIndex : currOpIndex - 1;
            if (splitIndex + 1 < this.operations.length) {
                opToExecute = this.operations[splitIndex + 1];
            }
            tempOps = new EditorContext.Operation[this.operations.length - 1 - splitIndex];
            tempLocs = new Location[this.operations.length - 1 - splitIndex];
            for (int x3 = 0; x3 < tempOps.length; ++x3) {
                tempOps[x3] = this.operations[x3 + splitIndex + 1];
                tempLocs[x3] = this.locations[x3 + splitIndex + 1];
            }
            this.operations = tempOps;
            this.locations = tempLocs;
            if (this.operations.length == 0) {
                return false;
            }
            selectedOp = this.operations[0];
        }
        Object[][] elems = new Object[this.operations.length][2];
        for (i2 = 0; i2 < this.operations.length; ++i2) {
            elems[i2][0] = this.operations[i2];
            elems[i2][1] = this.locations[i2];
        }
        Arrays.sort(elems, new OperatorsComparator());
        this.isCertainlyReachable = new boolean[this.operations.length];
        for (i2 = 0; i2 < this.operations.length; ++i2) {
            this.operations[i2] = (EditorContext.Operation)elems[i2][0];
            this.locations[i2] = (Location)elems[i2][1];
            this.isCertainlyReachable[i2] = true;
        }
        int[] flags = new int[this.operations.length];
        for (int i4 = 0; i4 < flags.length; ++i4) {
            flags[i4] = 0;
        }
        this.detectUnreachableOps(flags, currOp);
        int count = 0;
        for (int i5 = 0; i5 < flags.length; ++i5) {
            if (flags[i5] >= 2) continue;
            ++count;
        }
        tempOps = this.operations;
        tempLocs = this.locations;
        this.operations = new EditorContext.Operation[count];
        this.locations = new Location[count];
        this.isCertainlyReachable = new boolean[count];
        int index2 = 0;
        int opToExecuteIndex = -1;
        for (i = 0; i < flags.length; ++i) {
            if (flags[i] >= 2) continue;
            this.operations[index2] = tempOps[i];
            this.locations[index2] = tempLocs[i];
            boolean bl = this.isCertainlyReachable[index2] = flags[i] == 0;
            if (opToExecute == this.operations[index2]) {
                opToExecuteIndex = index2;
            }
            ++index2;
        }
        this.selectedIndex = 0;
        for (i = 0; i < this.operations.length; ++i) {
            if (!this.operations[i].equals((Object)selectedOp) || !this.isCertainlyReachable[i]) continue;
            this.selectedIndex = i;
        }
        if (opToExecuteIndex >= 0 && !this.isCertainlyReachable[opToExecuteIndex]) {
            MethodChooserSupport i6 = this;
            synchronized (i6) {
                StepOperationActionProvider.doAction(this.debugger, this);
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.init();
        }
        if (this.operations.length == 1) {
            String name = this.operations[this.selectedIndex].getMethodName();
            RunIntoMethodActionProvider.doAction(this.debugger, name, this.locations[this.selectedIndex], true);
            return true;
        }
        return false;
    }

    private void detectUnreachableOps(final int[] flags, final EditorContext.Operation currOp) {
        FileObject fileObj = null;
        try {
            fileObj = URLMapper.findFileObject((URL)new URL(this.url));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (fileObj == null) {
            return;
        }
        DataObject dobj = null;
        try {
            dobj = DataObject.find((FileObject)fileObj);
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        if (dobj == null) {
            return;
        }
        final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        if (ec == null) {
            return;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)fileObj);
        if (js == null) {
            return;
        }
        final JEditorPane[] editorPane = new JEditorPane[1];
        if (SwingUtilities.isEventDispatchThread()) {
            JEditorPane[] openedPanes = ec.getOpenedPanes();
            if (openedPanes != null && openedPanes.length > 0) {
                editorPane[0] = openedPanes[0];
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane[] openedPanes = ec.getOpenedPanes();
                        if (openedPanes != null && openedPanes.length > 0) {
                            editorPane[0] = openedPanes[0];
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        try {
            Future scanFinished = js.runWhenScanFinished((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController ci) throws Exception {
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    SourcePositions positions = ci.getTrees().getSourcePositions();
                    CompilationUnitTree compUnit = ci.getCompilationUnit();
                    TreeUtilities treeUtils = ci.getTreeUtilities();
                    int pcOffset = currOp == null ? 0 : currOp.getMethodStartPosition().getOffset() + 1;
                    for (int i = 0; i < MethodChooserSupport.this.operations.length; ++i) {
                        int offset = MethodChooserSupport.this.operations[i].getMethodStartPosition().getOffset() + 1;
                        for (TreePath path = treeUtils.pathFor(offset); path != null; path = path.getParentPath()) {
                            Tree tree = path.getLeaf();
                            if (tree instanceof ConditionalExpressionTree) {
                                ConditionalExpressionTree ternaryOpTree = (ConditionalExpressionTree)tree;
                                ExpressionTree trueTree = ternaryOpTree.getTrueExpression();
                                ExpressionTree falseTree = ternaryOpTree.getFalseExpression();
                                long trueStart = positions.getStartPosition(compUnit, trueTree);
                                long trueEnd = positions.getEndPosition(compUnit, trueTree);
                                long falseStart = positions.getStartPosition(compUnit, falseTree);
                                long falseEnd = positions.getEndPosition(compUnit, falseTree);
                                if (trueStart <= (long)offset && (long)offset <= trueEnd) {
                                    if ((long)pcOffset >= trueStart) continue;
                                    this.markSegment(i, false);
                                    continue;
                                }
                                if (falseStart > (long)offset || (long)offset > falseEnd) continue;
                                if ((long)pcOffset < trueStart) {
                                    this.markSegment(i, false);
                                    continue;
                                }
                                if (trueStart > (long)pcOffset || (long)pcOffset > trueEnd) continue;
                                this.markSegment(i, true);
                                continue;
                            }
                            if (tree.getKind() != Tree.Kind.CONDITIONAL_AND && tree.getKind() != Tree.Kind.CONDITIONAL_OR) continue;
                            BinaryTree binaryTree = (BinaryTree)tree;
                            ExpressionTree rightTree = binaryTree.getRightOperand();
                            long rightStart = positions.getStartPosition(compUnit, rightTree);
                            long rightEnd = positions.getEndPosition(compUnit, rightTree);
                            if (rightStart > (long)offset || (long)offset > rightEnd || (long)pcOffset >= rightStart) continue;
                            this.markSegment(i, false);
                        }
                    }
                }

                public void markSegment(int index, boolean excludeSegment) {
                    if (flags[index] == 2) {
                        return;
                    }
                    flags[index] = excludeSegment ? 2 : 1;
                }
            }, true);
            if (!scanFinished.isDone()) {
                if (EventQueue.isDispatchThread()) {
                    return;
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                }
                catch (ExecutionException eex) {
                    ErrorManager.getDefault().notify((Throwable)eex);
                }
            }
        }
        catch (IOException ioex) {
            ErrorManager.getDefault().notify((Throwable)ioex);
        }
    }

    private void annotateLines() {
        this.annotations = new ArrayList();
        EditorContext context = EditorContextBridge.getContext();
        JPDAThread thread = this.debugger.getCurrentThread();
        EditorContext.Operation currOp = thread.getCurrentOperation();
        int currentLine = currOp != null ? currOp.getStartPosition().getLine() : thread.getLineNumber(null);
        String annoType = currOp != null ? "CurrentExpressionLine" : "CurrentPC";
        for (int lineNum = this.startLine; lineNum <= this.endLine; ++lineNum) {
            Object anno;
            if (lineNum == currentLine || !((anno = context.annotate(this.url, lineNum, annoType, null)) instanceof Annotation)) continue;
            this.annotations.add((Annotation)anno);
        }
    }

    private void clearAnnotations() {
        if (this.annotations != null) {
            for (Annotation anno : this.annotations) {
                anno.detach();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("exec".equals(evt.getPropertyName())) {
            MethodChooserSupport methodChooserSupport = this;
            synchronized (methodChooserSupport) {
                this.notifyAll();
            }
        }
        if (this.debugger.getState() == 4 || this.currentThread != this.debugger.getCurrentThread() || !this.currentThread.isSuspended()) {
            MethodChooserSupport methodChooserSupport = this;
            synchronized (methodChooserSupport) {
                this.notifyAll();
            }
            this.chooser.releaseUI(false);
        }
    }

    private static class UncertainSegment
    extends MethodChooser.Segment {
        public UncertainSegment(int start, int end) {
            super(start, end);
        }
    }

    private static final class OperatorsComparator
    implements Comparator {
        private OperatorsComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object[] a1 = (Object[])o1;
            Object[] a2 = (Object[])o2;
            EditorContext.Operation op1 = (EditorContext.Operation)a1[0];
            EditorContext.Operation op2 = (EditorContext.Operation)a2[0];
            return op1.getMethodStartPosition().getOffset() - op2.getMethodStartPosition().getOffset();
        }
    }
}

