/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;

public class JPDAStepImpl
extends JPDAStep
implements Executor {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private static final String INIT = "<init>";
    private EditorContext.Operation[] currentOperations;
    private EditorContext.Operation lastOperation;
    private MethodExitBreakpointListener lastMethodExitBreakpointListener;
    private Set<BreakpointRequest> operationBreakpoints;
    private StepRequest boundaryStepRequest;
    private Set<EventRequest> requestsToCancel = new HashSet<EventRequest>();
    private Properties p;
    private Session session;

    public JPDAStepImpl(JPDADebugger debugger, Session session, int size, int depth) {
        super(debugger, size, depth);
        this.session = session;
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStep(JPDAThread tr) {
        JPDADebuggerImpl debuggerImpl = (JPDADebuggerImpl)this.debugger;
        JPDAThreadImpl trImpl = (JPDAThreadImpl)tr;
        VirtualMachine vm = debuggerImpl.getVirtualMachine();
        if (vm == null) {
            return;
        }
        SourcePath sourcePath = ((JPDADebuggerImpl)this.debugger).getEngineContext();
        boolean[] setStoppedStateNoContinue = new boolean[]{false};
        int suspendPolicy = debuggerImpl.getSuspend();
        Lock lock = suspendPolicy == 1 ? trImpl.accessLock.writeLock() : debuggerImpl.accessLock.writeLock();
        lock.lock();
        try {
            ((JPDAThreadImpl)tr).waitUntilMethodInvokeDone();
            EventRequestManager erm = VirtualMachineWrapper.eventRequestManager(vm);
            List<StepRequest> stepRequests = EventRequestManagerWrapper.stepRequests(erm);
            try {
                EventRequestManagerWrapper.deleteEventRequests(erm, stepRequests);
            }
            catch (InvalidRequestStateExceptionWrapper irex) {
                ArrayList<StepRequest> assureDeletedAllstepRequests = new ArrayList<StepRequest>(stepRequests);
                for (StepRequest sr : assureDeletedAllstepRequests) {
                    try {
                        EventRequestManagerWrapper.deleteEventRequest(erm, sr);
                    }
                    catch (InvalidRequestStateExceptionWrapper ex) {}
                }
            }
            for (StepRequest stepRequest : stepRequests) {
                debuggerImpl.getOperator().unregister(stepRequest);
            }
            int size = this.getSize();
            boolean stepAdded = false;
            logger.log(Level.FINE, "Step " + (size == 10 ? "operation" : "line") + " " + (this.getDepth() == 1 ? "into" : (this.getDepth() == 2 ? "over" : "out")) + " in thread " + tr.getName());
            if (size == 10 && !(stepAdded = this.addOperationStep(trImpl, false, sourcePath, setStoppedStateNoContinue))) {
                size = -2;
                logger.log(Level.FINE, "Operation step changed to line step");
            }
            if (!stepAdded) {
                StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), trImpl.getThreadReference(), size, this.getDepth());
                String[] exclusionPatterns = debuggerImpl.getSmartSteppingFilter().getExclusionPatterns();
                for (int i = 0; i < exclusionPatterns.length; ++i) {
                    StepRequestWrapper.addClassExclusionFilter(stepRequest, exclusionPatterns[i]);
                    logger.finer("   add pattern: " + exclusionPatterns[i]);
                }
                debuggerImpl.getOperator().register(stepRequest, this);
                EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
                try {
                    EventRequestWrapper.enable(stepRequest);
                    trImpl.setInStep(true, stepRequest);
                    this.requestsToCancel.add(stepRequest);
                }
                catch (IllegalThreadStateException itsex) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                    stepRequest = null;
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                    stepRequest = null;
                }
                catch (InvalidRequestStateExceptionWrapper ex) {
                    debuggerImpl.getOperator().unregister(stepRequest);
                    stepRequest = null;
                }
            }
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (VMDisconnectedExceptionWrapper ex) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
        }
        finally {
            lock.unlock();
        }
        if (setStoppedStateNoContinue[0]) {
            debuggerImpl.setStoppedStateNoContinue(trImpl.getThreadReference());
        }
    }

    private boolean addOperationStep(JPDAThreadImpl tr, boolean lineStepExec, SourcePath sourcePath, boolean[] setStoppedStateNoContinue) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        ExpressionPool.OperationLocation[] nextOperationLocations;
        String methodName;
        EditorContext.Operation currentOp;
        StackFrame sf;
        ThreadReference trRef = tr.getThreadReference();
        try {
            sf = ThreadReferenceWrapper.frame(trRef, 0);
        }
        catch (IncompatibleThreadStateException itsex) {
            return false;
        }
        catch (IllegalThreadStateExceptionWrapper itsex) {
            return false;
        }
        catch (IndexOutOfBoundsException ioobex) {
            return false;
        }
        Location loc = LocatableWrapper.location(sf);
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        String language = currentSession == null ? null : currentSession.getCurrentLanguage();
        String url = sourcePath.getURL(loc, language);
        ExpressionPool exprPool = ((JPDADebuggerImpl)this.debugger).getExpressionPool();
        ExpressionPool.Expression expr = exprPool.getExpressionAt(loc, url);
        if (expr == null) {
            return false;
        }
        EditorContext.Operation[] ops = expr.getOperations();
        int opIndex = -1;
        int codeIndex = (int)LocationWrapper.codeIndex(loc);
        if (codeIndex <= ops[0].getBytecodeIndex()) {
            if (!lineStepExec) {
                tr.clearLastOperations();
            }
            if (!ops[0].equals((Object)tr.getCurrentOperation()) && (opIndex = expr.findNextOperationIndex(codeIndex - 1)) >= 0 && ops[opIndex].getBytecodeIndex() == codeIndex) {
                tr.setCurrentOperation(ops[opIndex]);
                if (lineStepExec) {
                    return false;
                }
                if (!this.getHidden()) {
                    setStoppedStateNoContinue[0] = true;
                }
                return true;
            }
        }
        if ((currentOp = tr.getCurrentOperation()) != null) {
            EditorContext.Operation theLastOperation = null;
            List<EditorContext.Operation> lastOperations = tr.getLastOperations();
            if (lastOperations != null && lastOperations.size() > 0) {
                theLastOperation = lastOperations.get(lastOperations.size() - 1);
            }
            if (theLastOperation == currentOp) {
                for (EditorContext.Operation op : ops) {
                    if (op.getBytecodeIndex() != codeIndex) continue;
                    tr.setCurrentOperation(op);
                    if (!this.getHidden()) {
                        setStoppedStateNoContinue[0] = true;
                    }
                    return true;
                }
            }
        }
        this.lastOperation = currentOp;
        VirtualMachine vm = MirrorWrapper.virtualMachine(loc);
        if (this.lastOperation != null && (methodName = this.lastOperation.getMethodName()) != null && !INIT.equals(methodName) && vm.canGetMethodReturnValues()) {
            MethodBreakpoint mb = MethodBreakpoint.create((String)this.lastOperation.getMethodClassType(), (String)methodName);
            mb.setClassFilters(JPDAStepImpl.createClassFilters(vm, this.lastOperation.getMethodClassType(), methodName));
            mb.setThreadFilters(this.debugger, new JPDAThread[]{tr});
            mb.setBreakpointType(2);
            mb.setHidden(true);
            mb.setSuspend(0);
            this.lastMethodExitBreakpointListener = new MethodExitBreakpointListener(mb);
            mb.addJPDABreakpointListener((JPDABreakpointListener)this.lastMethodExitBreakpointListener);
            try {
                Method setSessionMethod = JPDABreakpoint.class.getDeclaredMethod("setSession", JPDADebugger.class);
                setSessionMethod.setAccessible(true);
                setSessionMethod.invoke((Object)mb, this.debugger);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        }
        tr.holdLastOperations(true);
        if (opIndex < 0) {
            nextOperationLocations = expr.findNextOperationLocations(codeIndex);
        } else {
            Location[] locations = expr.getLocations();
            nextOperationLocations = new ExpressionPool.OperationLocation[]{new ExpressionPool.OperationLocation(ops[opIndex], locations[opIndex], opIndex)};
        }
        boolean isNextOperationFromDifferentExpression = false;
        if (nextOperationLocations != null) {
            this.operationBreakpoints = new HashSet<BreakpointRequest>();
            for (int ni = 0; ni < nextOperationLocations.length; ++ni) {
                Location nloc = nextOperationLocations[ni].getLocation();
                if (nextOperationLocations[ni].getIndex() < 0) {
                    isNextOperationFromDifferentExpression = true;
                    EditorContext.Operation[] newOps = new EditorContext.Operation[ops.length + 1];
                    System.arraycopy(ops, 0, newOps, 0, ops.length);
                    newOps[ops.length] = nextOperationLocations[ni].getOperation();
                    ops = newOps;
                }
                BreakpointRequest brReq = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(vm), nloc);
                this.operationBreakpoints.add(brReq);
                ((JPDADebuggerImpl)this.debugger).getOperator().register(brReq, this);
                EventRequestWrapper.setSuspendPolicy(brReq, this.debugger.getSuspend());
                BreakpointRequestWrapper.addThreadFilter(brReq, trRef);
                EventRequestWrapper.putProperty(brReq, "thread", trRef);
                try {
                    EventRequestWrapper.enable(brReq);
                }
                catch (InvalidRequestStateExceptionWrapper ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                tr.setInStep(true, brReq);
                this.requestsToCancel.add(brReq);
            }
        } else if (lineStepExec) {
            return false;
        }
        this.boundaryStepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), trRef, -2, 2);
        if (isNextOperationFromDifferentExpression) {
            EventRequestWrapper.addCountFilter(this.boundaryStepRequest, 2);
        } else {
            EventRequestWrapper.addCountFilter(this.boundaryStepRequest, 1);
        }
        ((JPDADebuggerImpl)this.debugger).getOperator().register(this.boundaryStepRequest, this);
        EventRequestWrapper.setSuspendPolicy(this.boundaryStepRequest, this.debugger.getSuspend());
        try {
            EventRequestWrapper.enable(this.boundaryStepRequest);
            this.requestsToCancel.add(this.boundaryStepRequest);
        }
        catch (IllegalThreadStateException itsex) {
            ((JPDADebuggerImpl)this.debugger).getOperator().unregister(this.boundaryStepRequest);
            this.boundaryStepRequest = null;
            return false;
        }
        catch (InvalidRequestStateExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
            ((JPDADebuggerImpl)this.debugger).getOperator().unregister(this.boundaryStepRequest);
            this.boundaryStepRequest = null;
            return false;
        }
        this.currentOperations = ops;
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exec(Event event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removed(EventRequest eventRequest) {
        block14: {
            JPDADebuggerImpl debuggerImpl;
            VirtualMachine vm;
            try {
                this.stepDone(eventRequest);
            }
            catch (InternalExceptionWrapper ex) {
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return;
            }
            if (this.lastMethodExitBreakpointListener != null) {
                this.lastMethodExitBreakpointListener.destroy();
                this.lastMethodExitBreakpointListener = null;
            }
            if ((vm = (debuggerImpl = (JPDADebuggerImpl)this.debugger).getVirtualMachine()) == null) {
                return;
            }
            try {
                EventRequestManager erm = VirtualMachineWrapper.eventRequestManager(vm);
                if (this.operationBreakpoints != null) {
                    for (BreakpointRequest br : this.operationBreakpoints) {
                        try {
                            EventRequestManagerWrapper.deleteEventRequest(erm, br);
                        }
                        catch (InvalidRequestStateExceptionWrapper ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        debuggerImpl.getOperator().unregister(br);
                    }
                    this.operationBreakpoints = null;
                }
                if (this.boundaryStepRequest == null) break block14;
                try {
                    EventRequestManagerWrapper.deleteEventRequest(erm, this.boundaryStepRequest);
                }
                catch (InvalidRequestStateExceptionWrapper ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                debuggerImpl.getOperator().unregister(this.boundaryStepRequest);
            }
            catch (VMDisconnectedExceptionWrapper e) {
            }
            catch (InternalExceptionWrapper e) {
                // empty catch block
            }
        }
    }

    private void stepDone(EventRequest er) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        JPDAThreadImpl t;
        if (er instanceof StepRequest) {
            StepRequest sr = (StepRequest)er;
            t = ((JPDADebuggerImpl)this.debugger).getThread(StepRequestWrapper.thread(sr));
        } else {
            ThreadReference tr = (ThreadReference)EventRequestWrapper.getProperty(er, "thread");
            t = tr != null ? ((JPDADebuggerImpl)this.debugger).getThread(tr) : null;
        }
        if (t != null) {
            t.setInStep(false, null);
        }
    }

    private static String[] createClassFilters(VirtualMachine vm, String className, String methodName) throws VMDisconnectedExceptionWrapper {
        return JPDAStepImpl.createClassFilters(vm, className, methodName, new ArrayList<String>()).toArray(new String[0]);
    }

    private static List<String> createClassFilters(VirtualMachine vm, String className, String methodName, List<String> filters) throws VMDisconnectedExceptionWrapper {
        List<ReferenceType> classTypes = VirtualMachineWrapper.classesByName0(vm, className);
        for (ReferenceType type : classTypes) {
            try {
                ClassType clazz;
                ClassType superClass;
                List<com.sun.jdi.Method> methods;
                try {
                    methods = ReferenceTypeWrapper.methodsByName0(type, methodName);
                }
                catch (ClassNotPreparedExceptionWrapper ex) {
                    continue;
                }
                boolean hasNonStatic = methods.isEmpty();
                for (com.sun.jdi.Method method : methods) {
                    if (!filters.contains(ReferenceTypeWrapper.name(type))) {
                        filters.add(ReferenceTypeWrapper.name(type));
                    }
                    if (TypeComponentWrapper.isStatic(method)) continue;
                    hasNonStatic = true;
                }
                if (!hasNonStatic || !(type instanceof ClassType) || (superClass = ClassTypeWrapper.superclass(clazz = (ClassType)type)) == null) continue;
                JPDAStepImpl.createClassFilters(vm, ReferenceTypeWrapper.name(superClass), methodName, filters);
            }
            catch (InternalExceptionWrapper ex) {
            }
            catch (ObjectCollectedExceptionWrapper ex) {}
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldNotStopHere(StepEvent event) {
        JPDADebuggerImpl debuggerImpl = (JPDADebuggerImpl)this.debugger;
        try {
            boolean doStepAgain;
            ThreadReference tr = LocatableEventWrapper.thread(event);
            JPDAThreadImpl t = debuggerImpl.getThread(tr);
            t.accessLock.readLock().lock();
            try {
                boolean filterConstructors;
                if (!ThreadReferenceWrapper.isSuspended(tr)) {
                    boolean bl = false;
                    return bl;
                }
                com.sun.jdi.Method m = LocationWrapper.method(StackFrameWrapper.location(ThreadReferenceWrapper.frame(tr, 0)));
                doStepAgain = false;
                int doStepDepth = this.getDepth();
                boolean useStepFilters = this.p.getBoolean("UseStepFilters", true);
                boolean filterSyntheticMethods = useStepFilters && this.p.getBoolean("FilterSyntheticMethods", true);
                boolean filterStaticInitializers = useStepFilters && this.p.getBoolean("FilterStaticInitializers", false);
                boolean bl = filterConstructors = useStepFilters && this.p.getBoolean("FilterConstructors", false);
                if (filterSyntheticMethods && TypeComponentWrapper.isSynthetic(m)) {
                    doStepAgain = true;
                }
                if (filterStaticInitializers && MethodWrapper.isStaticInitializer(m) || filterConstructors && MethodWrapper.isConstructor(m)) {
                    doStepAgain = true;
                    doStepDepth = 3;
                }
                if (doStepAgain) {
                    VirtualMachine vm = debuggerImpl.getVirtualMachine();
                    if (vm == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), tr, -2, doStepDepth);
                    EventRequestWrapper.addCountFilter(stepRequest, 1);
                    String[] exclusionPatterns = debuggerImpl.getSmartSteppingFilter().getExclusionPatterns();
                    for (int i = 0; i < exclusionPatterns.length; ++i) {
                        StepRequestWrapper.addClassExclusionFilter(stepRequest, exclusionPatterns[i]);
                    }
                    debuggerImpl.getOperator().register(stepRequest, this);
                    EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
                    try {
                        EventRequestWrapper.enable(stepRequest);
                        this.requestsToCancel.add(stepRequest);
                    }
                    catch (IllegalThreadStateException itsex) {
                        debuggerImpl.getOperator().unregister(stepRequest);
                    }
                    catch (InvalidRequestStateExceptionWrapper irse) {
                        Exceptions.printStackTrace((Throwable)irse);
                    }
                    boolean bl3 = true;
                    return bl3;
                }
                if (debuggerImpl.stopHere(t)) {
                    return false;
                }
            }
            catch (IncompatibleThreadStateException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                doStepAgain = false;
                return doStepAgain;
            }
            catch (InvalidStackFrameExceptionWrapper e) {
                ErrorManager.getDefault().notify((Throwable)e);
                doStepAgain = false;
                return doStepAgain;
            }
            catch (IllegalThreadStateExceptionWrapper e) {
                doStepAgain = false;
                return doStepAgain;
            }
            catch (ObjectCollectedExceptionWrapper e) {
                doStepAgain = false;
                return doStepAgain;
            }
            VirtualMachine vm = debuggerImpl.getVirtualMachine();
            if (vm == null) {
                return false;
            }
            Map properties = (Map)this.session.lookupFirst(null, Map.class);
            boolean smartSteppingStepOut = properties != null && properties.containsKey("SS_ACTION_STEPOUT");
            boolean useStepFilters = this.p.getBoolean("UseStepFilters", true);
            boolean stepThrough = useStepFilters && this.p.getBoolean("StepThroughFilters", false);
            int depth = !stepThrough || smartSteppingStepOut ? 3 : ((StepRequest)event.request()).depth();
            StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), tr, -2, depth);
            if (logger.isLoggable(Level.FINE)) {
                try {
                    logger.fine("Can not stop at " + ThreadReferenceWrapper.frame(tr, 0) + ", smart-stepping. Submitting step = " + stepRequest + "; depth = " + depth);
                }
                catch (InternalExceptionWrapper ex) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                }
                catch (IllegalThreadStateExceptionWrapper ex) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                }
                catch (IncompatibleThreadStateException ex) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", ex);
                }
            }
            String[] exclusionPatterns = debuggerImpl.getSmartSteppingFilter().getExclusionPatterns();
            for (int i = 0; i < exclusionPatterns.length; ++i) {
                StepRequestWrapper.addClassExclusionFilter(stepRequest, exclusionPatterns[i]);
                logger.finer("   add pattern: " + exclusionPatterns[i]);
            }
            debuggerImpl.getOperator().register(stepRequest, this);
            EventRequestWrapper.setSuspendPolicy(stepRequest, this.debugger.getSuspend());
            try {
                EventRequestWrapper.enable(stepRequest);
                this.requestsToCancel.add(stepRequest);
                return true;
            }
            catch (IllegalThreadStateException itsex) {
                debuggerImpl.getOperator().unregister(stepRequest);
                return true;
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
                debuggerImpl.getOperator().unregister(stepRequest);
                return true;
            }
            catch (InvalidRequestStateExceptionWrapper irse) {
                Exceptions.printStackTrace((Throwable)irse);
                return true;
            }
            finally {
                t.accessLock.readLock().unlock();
            }
        }
        catch (InternalExceptionWrapper e) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return false;
        }
    }

    public void cancel() {
        JPDADebuggerImpl debuggerImpl = (JPDADebuggerImpl)this.debugger;
        VirtualMachine vm = debuggerImpl.getVirtualMachine();
        if (vm == null) {
            return;
        }
        try {
            EventRequestManager erm = VirtualMachineWrapper.eventRequestManager(vm);
            for (EventRequest er : this.requestsToCancel) {
                try {
                    EventRequestManagerWrapper.deleteEventRequest(erm, er);
                }
                catch (InvalidRequestStateExceptionWrapper ex) {
                    // empty catch block
                }
                debuggerImpl.getOperator().unregister(er);
            }
        }
        catch (VMDisconnectedExceptionWrapper e) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
    }

    public static final class MethodExitBreakpointListener
    implements JPDABreakpointListener {
        private MethodBreakpoint mb;
        private Variable returnValue;

        public MethodExitBreakpointListener(MethodBreakpoint mb) {
            this.mb = mb;
        }

        public void breakpointReached(JPDABreakpointEvent event) {
            this.returnValue = event.getVariable();
        }

        public Variable getReturnValue() {
            return this.returnValue;
        }

        public void destroy() {
            this.mb.removeJPDABreakpointListener((JPDABreakpointListener)this);
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.mb);
        }
    }
}

