/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant;

import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class ForEach
extends Task
implements TaskContainer {
    private String list;
    private String separator = " ";
    private int from = 0;
    private int to = 0;
    private int increment = 1;
    private String property;
    private List<Task> children = new LinkedList<Task>();
    private boolean wrongArgs;
    private static final String DEFAULT_SEPARATOR = " ";
    private static final int DEFAULT_FROM = 0;
    private static final int DEFAULT_TO = 0;
    private static final int DEFAULT_INCREMENT = 1;

    public void setList(String list) {
        this.list = list;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setFrom(String from) {
        try {
            this.from = Integer.parseInt(from);
        }
        catch (NumberFormatException e) {
            this.log("Wrong value for parameter 'from' : " + from);
            this.wrongArgs = true;
        }
    }

    public void setTo(String to) {
        try {
            this.to = Integer.parseInt(to);
        }
        catch (NumberFormatException e) {
            this.log("Wrong value for parameter 'to' : " + to);
            this.wrongArgs = true;
        }
    }

    public void setIncrement(String increment) {
        try {
            this.increment = Integer.parseInt(increment);
        }
        catch (NumberFormatException e) {
            this.log("Wrong value for parameter 'increment' : " + increment);
            this.wrongArgs = true;
        }
    }

    public void addTask(Task task) {
        this.children.add(task);
    }

    public void execute() throws BuildException {
        if (this.wrongArgs) {
            throw new BuildException("Correct parameters were not supplied.");
        }
        if (this.list != null) {
            String[] items;
            for (String value : items = this.list.split(this.separator)) {
                this.executeChildren(value);
            }
            return;
        }
        for (int i = this.from; i <= this.to; i += this.increment) {
            this.executeChildren(Integer.toString(i));
        }
    }

    private void executeChildren(String value) throws BuildException {
        this.getProject().setProperty(this.property, value);
        for (Task task : this.children) {
            task.perform();
        }
    }
}

