/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import nu.validator.htmlparser.annotation.IdType;
import nu.validator.htmlparser.annotation.Local;
import nu.validator.htmlparser.annotation.NsUri;
import nu.validator.htmlparser.annotation.Prefix;
import nu.validator.htmlparser.annotation.QName;
import nu.validator.htmlparser.common.Interner;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributeName;
import nu.validator.htmlparser.impl.NCName;
import nu.validator.htmlparser.impl.Portability;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlAttributes
implements Attributes {
    private static final AttributeName[] EMPTY_ATTRIBUTENAMES = new AttributeName[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    public static final HtmlAttributes EMPTY_ATTRIBUTES = new HtmlAttributes(0);
    private int mode;
    private int length;
    private AttributeName[] names;
    private String[] values;
    private String idValue;
    private int xmlnsLength;
    private AttributeName[] xmlnsNames;
    private String[] xmlnsValues;

    public HtmlAttributes(int mode) {
        this.mode = mode;
        this.length = 0;
        this.names = new AttributeName[5];
        this.values = new String[5];
        this.idValue = null;
        this.xmlnsLength = 0;
        this.xmlnsNames = EMPTY_ATTRIBUTENAMES;
        this.xmlnsValues = EMPTY_STRINGS;
    }

    void destructor() {
        this.clear(0);
        Portability.releaseArray(this.names);
        Portability.releaseArray(this.values);
    }

    public int getIndex(AttributeName name) {
        for (int i = 0; i < this.length; ++i) {
            if (this.names[i] != name) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String qName) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.names[i].getQName(this.mode).equals(qName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri, String localName) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.names[i].getLocal(this.mode).equals(localName) || !this.names[i].getUri(this.mode).equals(uri)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @IdType
    public String getType(String qName) {
        int index = this.getIndex(qName);
        if (index == -1) {
            return null;
        }
        return this.getType(index);
    }

    @Override
    @IdType
    public String getType(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        if (index == -1) {
            return null;
        }
        return this.getType(index);
    }

    @Override
    public String getValue(String qName) {
        int index = this.getIndex(qName);
        if (index == -1) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public String getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        if (index == -1) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    @Local
    public String getLocalName(int index) {
        if (index < this.length && index >= 0) {
            return this.names[index].getLocal(this.mode);
        }
        return null;
    }

    @Override
    @QName
    public String getQName(int index) {
        if (index < this.length && index >= 0) {
            return this.names[index].getQName(this.mode);
        }
        return null;
    }

    @Override
    @IdType
    public String getType(int index) {
        if (index < this.length && index >= 0) {
            return this.names[index].getType(this.mode);
        }
        return null;
    }

    public AttributeName getAttributeName(int index) {
        if (index < this.length && index >= 0) {
            return this.names[index];
        }
        return null;
    }

    @Override
    @NsUri
    public String getURI(int index) {
        if (index < this.length && index >= 0) {
            return this.names[index].getUri(this.mode);
        }
        return null;
    }

    @Prefix
    public String getPrefix(int index) {
        if (index < this.length && index >= 0) {
            return this.names[index].getPrefix(this.mode);
        }
        return null;
    }

    @Override
    public String getValue(int index) {
        if (index < this.length && index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public String getValue(AttributeName name) {
        int index = this.getIndex(name);
        if (index == -1) {
            return null;
        }
        return this.getValue(index);
    }

    public String getId() {
        return this.idValue;
    }

    public int getXmlnsLength() {
        return this.xmlnsLength;
    }

    @Local
    public String getXmlnsLocalName(int index) {
        if (index < this.xmlnsLength && index >= 0) {
            return this.xmlnsNames[index].getLocal(this.mode);
        }
        return null;
    }

    @NsUri
    public String getXmlnsURI(int index) {
        if (index < this.xmlnsLength && index >= 0) {
            return this.xmlnsNames[index].getUri(this.mode);
        }
        return null;
    }

    public String getXmlnsValue(int index) {
        if (index < this.xmlnsLength && index >= 0) {
            return this.xmlnsValues[index];
        }
        return null;
    }

    public int getXmlnsIndex(AttributeName name) {
        for (int i = 0; i < this.xmlnsLength; ++i) {
            if (this.xmlnsNames[i] != name) continue;
            return i;
        }
        return -1;
    }

    public String getXmlnsValue(AttributeName name) {
        int index = this.getXmlnsIndex(name);
        if (index == -1) {
            return null;
        }
        return this.getXmlnsValue(index);
    }

    public AttributeName getXmlnsAttributeName(int index) {
        if (index < this.xmlnsLength && index >= 0) {
            return this.xmlnsNames[index];
        }
        return null;
    }

    void addAttribute(AttributeName name, String value, XmlViolationPolicy xmlnsPolicy) throws SAXException {
        String[] newValues;
        AttributeName[] newNames;
        int newLen;
        if (name == AttributeName.ID) {
            this.idValue = value;
        }
        if (name.isXmlns()) {
            if (this.xmlnsNames.length == this.xmlnsLength) {
                newLen = this.xmlnsLength == 0 ? 2 : this.xmlnsLength << 1;
                newNames = new AttributeName[newLen];
                System.arraycopy(this.xmlnsNames, 0, newNames, 0, this.xmlnsNames.length);
                this.xmlnsNames = newNames;
                newValues = new String[newLen];
                System.arraycopy(this.xmlnsValues, 0, newValues, 0, this.xmlnsValues.length);
                this.xmlnsValues = newValues;
            }
            this.xmlnsNames[this.xmlnsLength] = name;
            this.xmlnsValues[this.xmlnsLength] = value;
            ++this.xmlnsLength;
            switch (xmlnsPolicy) {
                case FATAL: {
                    throw new SAXException("Saw an xmlns attribute.");
                }
                case ALTER_INFOSET: {
                    return;
                }
            }
        }
        if (this.names.length == this.length) {
            newLen = this.length << 1;
            newNames = new AttributeName[newLen];
            System.arraycopy(this.names, 0, newNames, 0, this.names.length);
            Portability.releaseArray(this.names);
            this.names = newNames;
            newValues = new String[newLen];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            Portability.releaseArray(this.values);
            this.values = newValues;
        }
        this.names[this.length] = name;
        this.values[this.length] = value;
        ++this.length;
    }

    void clear(int m) {
        int i;
        for (i = 0; i < this.length; ++i) {
            this.names[i].release();
            this.names[i] = null;
            Portability.releaseString(this.values[i]);
            this.values[i] = null;
        }
        this.length = 0;
        this.mode = m;
        this.idValue = null;
        for (i = 0; i < this.xmlnsLength; ++i) {
            this.xmlnsNames[i] = null;
            this.xmlnsValues[i] = null;
        }
        this.xmlnsLength = 0;
    }

    void releaseValue(int i) {
        Portability.releaseString(this.values[i]);
    }

    void clearWithoutReleasingContents() {
        for (int i = 0; i < this.length; ++i) {
            this.names[i] = null;
            this.values[i] = null;
        }
        this.length = 0;
    }

    boolean contains(AttributeName name) {
        int i;
        for (i = 0; i < this.length; ++i) {
            if (!name.equalsAnother(this.names[i])) continue;
            return true;
        }
        for (i = 0; i < this.xmlnsLength; ++i) {
            if (!name.equalsAnother(this.xmlnsNames[i])) continue;
            return true;
        }
        return false;
    }

    public void adjustForMath() {
        this.mode = 1;
    }

    public void adjustForSvg() {
        this.mode = 2;
    }

    public HtmlAttributes cloneAttributes(Interner interner) throws SAXException {
        int i;
        assert (this.length == 0 && this.xmlnsLength == 0 || this.mode == 0 || this.mode == 3);
        HtmlAttributes clone = new HtmlAttributes(0);
        for (i = 0; i < this.length; ++i) {
            clone.addAttribute(this.names[i].cloneAttributeName(interner), Portability.newStringFromString(this.values[i]), XmlViolationPolicy.ALLOW);
        }
        for (i = 0; i < this.xmlnsLength; ++i) {
            clone.addAttribute(this.xmlnsNames[i], this.xmlnsValues[i], XmlViolationPolicy.ALLOW);
        }
        return clone;
    }

    void processNonNcNames(TreeBuilder<?> treeBuilder, XmlViolationPolicy namePolicy) throws SAXException {
        block5: for (int i = 0; i < this.length; ++i) {
            AttributeName attName = this.names[i];
            if (attName.isNcName(this.mode)) continue;
            String name = attName.getLocal(this.mode);
            switch (namePolicy) {
                case ALTER_INFOSET: {
                    this.names[i] = AttributeName.create(NCName.escapeName(name));
                }
                case ALLOW: {
                    if (attName == AttributeName.XML_LANG) continue block5;
                    treeBuilder.warn("Attribute \u201c" + name + "\u201d is not serializable as XML 1.0.");
                    continue block5;
                }
                case FATAL: {
                    treeBuilder.fatal("Attribute \u201c" + name + "\u201d is not serializable as XML 1.0.");
                }
            }
        }
    }

    public void merge(HtmlAttributes attributes) throws SAXException {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            AttributeName name = attributes.getAttributeName(i);
            if (this.contains(name)) continue;
            this.addAttribute(name, attributes.getValue(i), XmlViolationPolicy.ALLOW);
        }
    }
}

