/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.netigso;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import org.netbeans.core.netigso.Netigso;
import org.openide.modules.ModuleInfo;
import org.osgi.framework.Bundle;

final class NetigsoActivator
extends HashMap<Bundle, ClassLoader> {
    private final Set<ModuleInfo> all = new CopyOnWriteArraySet<ModuleInfo>();

    @Override
    public ClassLoader get(Object o) {
        if (o instanceof Bundle) {
            String loc = ((Bundle)o).getLocation();
            String pref = "netigso://";
            if (loc != null && loc.startsWith("netigso://")) {
                String cnb = loc.substring("netigso://".length());
                for (ModuleInfo mi : this.all) {
                    if (!cnb.equals(mi.getCodeNameBase())) continue;
                    return new DelegateLoader(mi);
                }
            }
        }
        return null;
    }

    void register(Collection<? extends ModuleInfo> m) {
        Netigso.LOG.log(Level.FINER, "register module {0}", m);
        this.all.addAll(m);
    }

    private static final class DelegateLoader
    extends ClassLoader {
        private final ModuleInfo mi;

        public DelegateLoader(ModuleInfo mi) {
            this.mi = mi;
        }

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            return this.getDelegate().loadClass(string);
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            return this.getDelegate().getResources(string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            return this.getDelegate().getResourceAsStream(string);
        }

        @Override
        public URL getResource(String string) {
            return this.getDelegate().getResource(string);
        }

        private ClassLoader getDelegate() {
            return this.mi.getClassLoader();
        }
    }
}

