/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Option;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionClient;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSetSupport;

public class OptionValue {
    private final OptionSetSupport owner;
    private final Option type;
    private final String defaultValue;
    private String currValue;
    private boolean dirty = false;

    OptionValue(OptionSetSupport owner, Option type, String initialValue) {
        this.owner = owner;
        this.type = type;
        this.defaultValue = initialValue;
        this.currValue = initialValue;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    public String get() {
        return this.currValue;
    }

    public OptionSet owner() {
        return this.owner;
    }

    public Option type() {
        return this.type;
    }

    private boolean setHelp(String newValue) {
        if (this.type.isTrim() && newValue != null) {
            newValue = newValue.trim();
        }
        if (this.currValue == newValue) {
            return false;
        }
        if (this.currValue != null && this.currValue.equals(newValue)) {
            return false;
        }
        this.currValue = newValue;
        return true;
    }

    void setInitialValue(String newValue) {
        this.setHelp(newValue);
    }

    public void set(String newValue) {
        if (this.setHelp(newValue)) {
            this.setDirty(true);
            this.owner.needSave();
        }
    }

    void deltaWithRespectTo(OptionValue that) {
        if (IpeUtils.sameString(this.currValue, that.currValue)) {
            this.setDirty(false);
        } else {
            this.setDirty(true);
        }
    }

    void applyTo(OptionClient client) {
        if (this.dirty && this.type().isClientOption()) {
            client.apply(this);
        }
    }

    public void setEnabled(boolean enabled) {
        assert (this.type.isYesNoOption());
        if (enabled) {
            this.set("on");
        } else {
            this.set("off");
        }
    }

    public boolean isEnabled() {
        assert (this.type.isYesNoOption());
        return this.get().equals("on");
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

