/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Catalog;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegistersWindow
extends TopComponent
implements ActionListener {
    static final String preferredID = "RegistersWindow";
    static RegistersWindow DEFAULT;
    private transient JComponent tree = null;
    private String name = Catalog.get("TITLE_RegistersWindow");
    private String view_name = Catalog.get("TITLE_RegistersView");
    private NativeDebugger debugger = null;
    private DefaultTableModel dataModel;
    private JMenuItem menuItemHide;
    private JPopupMenu popup;
    private JPanel hp;
    private JTable tab;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JScrollPane tab_sp;
    private List<String> previous_regs;
    private List<String> current_regs;
    private List<String> hidden_regs;
    private PopupListener popupListener;
    private boolean needInitData = true;
    private boolean seen_sparc_regs = false;
    private String selected_text = null;
    private int selected_area_start = 0;
    private int selected_area_end = 0;
    private int view_model = 1;

    public static TopComponent getDefault() {
        if (DEFAULT == null && (DEFAULT = (RegistersWindow)WindowManager.getDefault().findTopComponent(preferredID)) == null) {
            DEFAULT = new RegistersWindow();
        }
        return DEFAULT;
    }

    public RegistersWindow() {
        super.setName(this.name);
        String iconDir = "org/netbeans/modules/cnd/debugger/common2/icons/";
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/debugger/common2/icons/registers.png"));
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentHidden() {
        if (this.debugger != null) {
            this.debugger.registerRegistersWindow(null);
        }
        super.componentHidden();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.connectToDebugger(DebuggerManager.get().currentDebugger());
        this.needInitData = true;
        this.updateWindow();
    }

    protected void componentClosed() {
        if (this.debugger != null) {
            this.debugger.registerRegistersWindow(null);
        }
        super.componentClosed();
    }

    protected void connectToDebugger(NativeDebugger debugger) {
        this.debugger = debugger;
        if (debugger == null) {
            return;
        }
        debugger.registerRegistersWindow(this);
    }

    public void requestActive() {
        super.requestActive();
        this.tab.requestFocusInWindow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateWindow() {
        if (this.tree == null) {
            String symbol = "\"main()\"";
            this.ta = new JTextArea();
            this.ta_sp = new JScrollPane(this.ta);
            Object[] columnNames = new Object[]{Catalog.get("LBL_NameCol"), Catalog.get("LBL_ValueCol")};
            this.dataModel = new DefaultTableModel(columnNames, 0);
            this.tab = new JTable(this.dataModel);
            this.tab.getColumnModel().getColumn(0).setPreferredWidth(40);
            this.tab.getColumnModel().getColumn(1).setPreferredWidth(300);
            this.tab.setGridColor(Color.LIGHT_GRAY);
            this.tab_sp = new JScrollPane(this.tab);
            this.previous_regs = new ArrayList<String>();
            this.current_regs = new ArrayList<String>();
            this.hidden_regs = new ArrayList<String>();
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(this.view_name);
            this.ta.setEditable(false);
            this.ta.setWrapStyleWord(false);
            Font f = this.ta.getFont();
            this.ta.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            f = this.tab.getFont();
            this.tab.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            BorderLayout bl = new BorderLayout();
            bl.setHgap(118);
            this.hp = new JPanel(bl);
            JLabel hp_name = new JLabel(Catalog.get("RegisterName"));
            JLabel hp_value = new JLabel(Catalog.get("RegisterValue"));
            hp_name.setToolTipText(Catalog.get("LBL_RegisterName"));
            hp_value.setToolTipText(Catalog.get("LBL_RegisterValue"));
            this.hp.add((Component)hp_name, "West");
            this.hp.add((Component)hp_value, "Center");
            this.hp.setToolTipText(Catalog.get("LBL_RegisterName"));
            if (this.view_model == 0) {
                this.tree.add((Component)this.hp, "North");
                this.tree.add((Component)this.ta_sp, "Center");
            } else {
                this.tree.add((Component)this.tab_sp, "Center");
            }
            AccessibleContext ac = this.tree.getAccessibleContext();
            ac.setAccessibleDescription(Catalog.get("ACSD_RegisterView"));
            ac.setAccessibleName(Catalog.get("TITLE_RegistersView"));
            this.add(this.tree, "Center");
            this.popup = new JPopupMenu();
            this.popup.add(new ShowAllRegistersAction());
            this.menuItemHide = new JMenuItem(new HideSelectedRegistersAction());
            this.popup.add(this.menuItemHide);
            this.popupListener = new PopupListener(this.popup);
            this.ta.addMouseListener(this.popupListener);
            this.tab.addMouseListener(this.popupListener);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
            this.hidden_regs.add("cs\t");
            this.hidden_regs.add("ds\t");
            this.hidden_regs.add("es\t");
            this.hidden_regs.add("fs\t");
            this.hidden_regs.add("gs\t");
            this.hidden_regs.add("ss\t");
        }
        if (this.needInitData) {
            this.needInitData = false;
        }
        int carpos = this.ta.getCaretPosition();
        this.ta.setText(null);
        this.dataModel.setRowCount(0);
        int k = this.current_regs.size();
        int i = 0;
        while (true) {
            int j;
            int l;
            String s;
            if (i < k) {
                s = this.current_regs.get(i);
                l = this.hidden_regs.size();
            } else {
                try {
                    this.ta.setCaretPosition(carpos);
                }
                catch (IllegalArgumentException e) {
                    this.ta.setCaretPosition(0);
                }
                this.invalidate();
                this.dataModel.fireTableDataChanged();
                return;
            }
            for (j = 0; j < l && !s.startsWith("   " + this.hidden_regs.get(j)); ++j) {
            }
            if (j == l) {
                int m;
                if (i < this.previous_regs.size()) {
                    try {
                        String prev_s = this.previous_regs.get(i);
                        if (!prev_s.equals(s)) {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        System.err.println("RegistersWindow.updateWindow(): exception: " + e);
                    }
                }
                this.ta.append(s);
                Object[] row = new Object[]{"", ""};
                int n = 0;
                for (m = 0; m < s.length(); ++m) {
                    if (s.charAt(m) == ' ' || s.charAt(m) == '\t') continue;
                    for (n = m + 1; n < s.length() && s.charAt(n) != ' ' && s.charAt(n) != '\t'; ++n) {
                    }
                }
                if (m < s.length() && m < n) {
                    row[0] = s.substring(m, n);
                    ++n;
                    while (n < s.length() && (s.charAt(n) == ' ' || s.charAt(n) == '\t')) {
                        ++n;
                    }
                    if (n > s.length()) {
                        n = s.length();
                    }
                    row[1] = s.substring(n, s.length());
                }
                this.dataModel.addRow(row);
            }
            if (i < this.previous_regs.size()) {
                this.previous_regs.set(i, s);
            } else {
                this.previous_regs.add(s);
            }
            ++i;
        }
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.view_name;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void updateData(List<String> regs) {
        if (regs == null || regs.isEmpty()) {
            return;
        }
        this.current_regs.clear();
        this.current_regs.addAll(regs);
        this.updateWindow();
    }

    protected void HideSelectedRegisters(String regs) {
        if (regs == null) {
            return;
        }
        int l = regs.length();
        for (int i = 0; i < l; ++i) {
            int j;
            int k = regs.indexOf(10, i);
            if (k < 0) {
                k = l - 1;
            }
            if (k <= i) break;
            String s = regs.substring(i, k + 1);
            i = k;
            String regname = null;
            k = 0;
            for (j = 0; j < s.length(); ++j) {
                if (s.charAt(j) == ' ') continue;
                if (k == 0) {
                    k = s.indexOf(32, j);
                    if (k < 0) {
                        k = s.length();
                    }
                    if (k < j) break;
                    regname = s.substring(j, k);
                    j = k;
                    continue;
                }
                k = s.indexOf(10, j);
                if (k >= j) break;
                break;
            }
            if (regname == null) continue;
            k = this.hidden_regs.size();
            for (j = 0; j < k && (s = this.hidden_regs.get(j)).compareTo(regname) != 0; ++j) {
            }
            if (j != k) continue;
            this.hidden_regs.add(regname);
        }
        this.updateWindow();
    }

    protected void ShowAllRegisters() {
        this.hidden_regs.clear();
        this.updateWindow();
    }

    protected void ChangeView() {
        ++this.view_model;
        if (this.view_model > 1) {
            this.view_model = 0;
        }
        if (this.view_model == 0) {
            this.tree.remove(this.tab_sp);
            this.tree.add((Component)this.hp, "North");
            this.tree.add((Component)this.ta_sp, "Center");
        } else {
            this.tree.remove(this.hp);
            this.tree.remove(this.ta_sp);
            this.tree.add((Component)this.tab_sp, "Center");
        }
        this.updateWindow();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(preferredID);
    }

    class PopupListener
    extends MouseAdapter
    implements ActionListener,
    PopupMenuListener {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void selectCurrentLine(int x, int y) {
            int ln = RegistersWindow.this.ta.getLineCount();
            if (ln > 0) {
                try {
                    RegistersWindow.this.selected_area_start = RegistersWindow.this.ta.getLineStartOffset(ln);
                    RegistersWindow.this.selected_area_end = RegistersWindow.this.ta.getLineEndOffset(ln);
                    RegistersWindow.this.ta.select(RegistersWindow.this.selected_area_start, RegistersWindow.this.selected_area_end);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                boolean selected = false;
                if (RegistersWindow.this.view_model == 0) {
                    RegistersWindow.this.selected_text = RegistersWindow.this.ta.getSelectedText();
                    if (RegistersWindow.this.selected_text != null) {
                        selected = true;
                    }
                } else if (RegistersWindow.this.tab.getSelectedRowCount() > 0) {
                    selected = true;
                }
                if (selected) {
                    RegistersWindow.this.menuItemHide.setEnabled(true);
                } else {
                    RegistersWindow.this.menuItemHide.setEnabled(false);
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent ev) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    class HideSelectedRegistersAction
    extends AbstractAction {
        public HideSelectedRegistersAction() {
            super(Catalog.get("Reg_ACT_Hide"), null);
        }

        public void actionPerformed(ActionEvent ev) {
            if (RegistersWindow.this.view_model == 0) {
                RegistersWindow.this.selected_text = RegistersWindow.this.ta.getSelectedText();
            } else {
                if (RegistersWindow.this.tab.getSelectedRowCount() <= 0) {
                    return;
                }
                int[] rows = RegistersWindow.this.tab.getSelectedRows();
                RegistersWindow.this.selected_text = "";
                for (int i = 0; i < rows.length; ++i) {
                    RegistersWindow.this.selected_text = RegistersWindow.this.selected_text + (RegistersWindow.this.tab.getValueAt(rows[i], 0) + "\t " + RegistersWindow.this.tab.getValueAt(rows[i], 1) + " \n");
                }
            }
            RegistersWindow.this.HideSelectedRegisters(RegistersWindow.this.selected_text);
        }
    }

    class ShowAllRegistersAction
    extends AbstractAction {
        public ShowAllRegistersAction() {
            super(Catalog.get("Reg_ACT_Show_All_Registers"), null);
        }

        public void actionPerformed(ActionEvent ev) {
            RegistersWindow.this.ShowAllRegisters();
        }
    }
}

