/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;

public class ReadTransformerMetadata
extends ORMetadata {
    private MetadataClass m_transformerClass;
    private String m_transformerClassName;
    private String m_method;

    public ReadTransformerMetadata() {
        super("<read-transformer>");
    }

    protected ReadTransformerMetadata(String xmlElement) {
        super(xmlElement);
    }

    public ReadTransformerMetadata(MetadataAnnotation readTransformer, MetadataAccessibleObject accessibleObject) {
        super(readTransformer, accessibleObject);
        if (readTransformer != null) {
            this.m_transformerClass = this.getMetadataClass((String)readTransformer.getAttributeString("transformerClass"));
            this.m_method = (String)readTransformer.getAttributeString("method");
        }
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ReadTransformerMetadata) {
            ReadTransformerMetadata readTransformer = (ReadTransformerMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_transformerClassName, readTransformer.getTransformerClassName())) {
                return false;
            }
            return this.valuesMatch(this.m_method, readTransformer.getMethod());
        }
        return false;
    }

    public String getMethod() {
        return this.m_method;
    }

    public MetadataClass getTransformerClass() {
        return this.m_transformerClass;
    }

    public String getTransformerClassName() {
        return this.m_transformerClassName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_transformerClass = this.initXMLClassName(this.m_transformerClassName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(TransformationMapping mapping, String annotatedElementName) {
        if (this.m_method == null || this.m_method.equals("")) {
            if (this.m_transformerClass.isVoid()) {
                throw ValidationException.readTransformerHasNeitherClassNorMethod(annotatedElementName);
            }
            if (!this.m_transformerClass.extendsInterface(AttributeTransformer.class)) throw ValidationException.readTransformerClassDoesntImplementAttributeTransformer(annotatedElementName);
            mapping.setAttributeTransformerClassName(this.m_transformerClass.getName());
            return;
        } else {
            if (!this.m_transformerClass.isVoid()) throw ValidationException.readTransformerHasBothClassAndMethod(annotatedElementName);
            mapping.setAttributeTransformation(this.m_method);
        }
    }

    public void setMethod(String method) {
        this.m_method = method;
    }

    public void setTransformerClass(MetadataClass transformerClass) {
        this.m_transformerClass = transformerClass;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.m_transformerClassName = transformerClassName;
    }
}

