/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.codehaus.plexus.util.IOUtil;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;

public final class RepositoryUtil {
    private RepositoryUtil() {
    }

    public static Artifact createArtifact(NBVersionInfo info) {
        return RepositoryUtil.createArtifact(info, null);
    }

    public static Artifact createJavadocArtifact(NBVersionInfo info) {
        return RepositoryUtil.createArtifact(info, "javadoc");
    }

    private static Artifact createArtifact(NBVersionInfo info, String classifier) {
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        Artifact art = info.getClassifier() != null || classifier != null ? online.createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getType() != null ? info.getType() : "jar", classifier == null ? info.getClassifier() : classifier) : online.createArtifact(info.getGroupId(), info.getArtifactId(), info.getVersion(), null, info.getType() != null ? info.getType() : "jar");
        ArtifactRepository repo = online.getLocalRepository();
        String localPath = repo.pathOf(art);
        art.setFile(new File(repo.getBasedir(), localPath));
        return art;
    }

    public static String calculateSHA1Checksum(File file) throws IOException {
        MessageDigest digest;
        byte[] buffer = RepositoryUtil.readFile(file);
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException x) {
            throw new IOException(x);
        }
        digest.update(buffer);
        return String.format("%040x", new BigInteger(1, digest.digest()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(File file) throws IOException {
        FileInputStream is = null;
        byte[] bytes = new byte[(int)file.length()];
        try {
            is = new FileInputStream(file);
            int numRead = 0;
            for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(is);
            throw throwable;
        }
        IOUtil.close((InputStream)is);
        return bytes;
    }
}

