/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.index.ArtifactAvailablility;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Field;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Grouping;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.expr.StringSearchExpression;
import org.apache.maven.index.search.grouping.GGrouping;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.settings.Mirror;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.RemoteIndexTransferListener;
import org.netbeans.modules.maven.indexer.RepositoryIndexerListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexerImplementation;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;

public class NexusRepositoryIndexerImpl
implements RepositoryIndexerImplementation,
BaseQueries,
ChecksumQueries,
ArchetypeQueries,
DependencyInfoQueries,
ClassesQuery,
GenericFindQuery,
ContextLoadedQuery {
    private static final String MAVENINDEX_PATH = "mavenindex";
    private PlexusContainer embedder;
    private ArtifactRepository repository;
    private NexusIndexer indexer;
    private SearchEngine searcher;
    private IndexUpdater remoteIndexUpdater;
    private ArtifactContextProducer contextProducer;
    private boolean inited = false;
    private static final String NB_DEPENDENCY_GROUP = "nbdg";
    private static final String NB_DEPENDENCY_ARTIFACT = "nbda";
    private static final String NB_DEPENDENCY_VERSION = "nbdv";
    private static final Logger LOGGER = Logger.getLogger(NexusRepositoryIndexerImpl.class.getName());
    private static final HashMap<String, Mutex> repoMutexMap = new HashMap(4);
    private Lookup lookup = Lookups.singleton((Object)this);
    private static final int MAX_RESULT_COUNT = 512;

    private Mutex getRepoMutex(RepositoryInfo repo) {
        return this.getRepoMutex(repo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mutex getRepoMutex(String repoId) {
        HashMap<String, Mutex> hashMap = repoMutexMap;
        synchronized (hashMap) {
            Mutex m = repoMutexMap.get(repoId);
            if (m == null) {
                m = new Mutex();
                repoMutexMap.put(repoId, m);
            }
            return m;
        }
    }

    public static String createLocalRepositoryPath(FileObject fo) {
        return EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir();
    }

    @Override
    public String getType() {
        return "nexus";
    }

    @Override
    public Lookup getCapabilityLookup() {
        return this.lookup;
    }

    private void initIndexer() {
        if (!this.inited) {
            try {
                DefaultContainerConfiguration config = new DefaultContainerConfiguration();
                ClassWorld world = new ClassWorld();
                ClassRealm embedderRealm = world.newRealm("maven.embedder", MavenEmbedder.class.getClassLoader());
                ClassLoader indexerLoader = NexusRepositoryIndexerImpl.class.getClassLoader();
                ClassRealm indexerRealm = world.newRealm("maven.indexer", indexerLoader);
                ClassRealm plexusRealm = world.newRealm("plexus.core", indexerLoader);
                plexusRealm.importFrom(embedderRealm.getId(), "META-INF/plexus");
                plexusRealm.importFrom(embedderRealm.getId(), "META-INF/maven");
                plexusRealm.importFrom(indexerRealm.getId(), "META-INF/plexus");
                plexusRealm.importFrom(indexerRealm.getId(), "META-INF/maven");
                config.setClassWorld(world);
                this.embedder = new DefaultPlexusContainer((ContainerConfiguration)config);
                this.repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
                this.indexer = (NexusIndexer)this.embedder.lookup(NexusIndexer.class);
                this.searcher = (SearchEngine)this.embedder.lookup(SearchEngine.class);
                this.remoteIndexUpdater = (IndexUpdater)this.embedder.lookup(IndexUpdater.class);
                this.contextProducer = (ArtifactContextProducer)this.embedder.lookup(ArtifactContextProducer.class);
                this.inited = true;
            }
            catch (DuplicateRealmException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (NoSuchRealmException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ComponentLookupException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (PlexusContainerException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadIndexingContext(RepositoryInfo info) throws IOException {
        block19: {
            if (!NexusRepositoryIndexerImpl.$assertionsDisabled && !this.getRepoMutex(info).isWriteAccess()) {
                throw new AssertionError();
            }
            this.initIndexer();
            context = this.indexer.getIndexingContexts().get(info.getId());
            indexUpdateUrl = this.findIndexUpdateUrlConsideringMirrors(info);
            if (context == null) ** GOTO lbl20
            contexturl = context.getIndexUpdateUrl();
            contextfile = context.getRepository();
            v0 = repofile = info.getRepositoryPath() != null ? new File(info.getRepositoryPath()) : null;
            if (Utilities.compareObjects((Object)contexturl, (Object)indexUpdateUrl)) break block19;
            NexusRepositoryIndexerImpl.LOGGER.fine("Remote context changed:" + info.getId() + ", unload/load");
            this.unloadIndexingContext(new RepositoryInfo[]{info});
            ** GOTO lbl20
        }
        if (Utilities.compareObjects((Object)contextfile, (Object)repofile)) {
            NexusRepositoryIndexerImpl.LOGGER.fine("Skipping Context :" + info.getId() + ", already loaded.");
        } else {
            NexusRepositoryIndexerImpl.LOGGER.fine("Local context changed:" + info.getId() + ", unload/load");
            this.unloadIndexingContext(new RepositoryInfo[]{info});
lbl20:
            // 3 sources

            NexusRepositoryIndexerImpl.LOGGER.fine("Loading Context :" + info.getId());
            if (info.isLocal() || info.isRemoteDownloadable()) {
                loc = new File(this.getDefaultIndexLocation(), info.getId());
                index = false;
                if (!loc.exists() || loc.listFiles().length <= 0) {
                    index = true;
                    NexusRepositoryIndexerImpl.LOGGER.finer("Index Not Available :" + info.getId() + " At :" + loc.getAbsolutePath());
                }
                creators = new ArrayList<IndexCreator>();
                try {
                    creators.addAll(this.embedder.lookupList(IndexCreator.class));
                }
                catch (ComponentLookupException x) {
                    throw new IOException(x);
                }
                if (info.isLocal()) {
                    creators.add(new NbIndexCreator());
                } else {
                    creators.add(new NotifyingIndexCreator(info));
                }
                try {
                    this.indexer.addIndexingContextForced(info.getId(), info.getId(), info.isLocal() != false ? new File(info.getRepositoryPath()) : null, loc, info.isRemoteDownloadable() != false ? info.getRepositoryUrl() : null, info.isRemoteDownloadable() != false ? indexUpdateUrl : null, creators);
                }
                catch (IOException ex) {
                    NexusRepositoryIndexerImpl.LOGGER.log(Level.INFO, "Found a broken index at " + loc.getAbsolutePath(), ex);
                    FileUtils.deleteDirectory((File)loc);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NexusRepositoryIndexerImpl.class, (String)"MSG_Reconstruct_Index"));
                    try {
                        this.indexer.addIndexingContextForced(info.getId(), info.getId(), info.isLocal() != false ? new File(info.getRepositoryPath()) : null, loc, info.isRemoteDownloadable() != false ? info.getRepositoryUrl() : null, info.isRemoteDownloadable() != false ? indexUpdateUrl : null, creators);
                    }
                    catch (LockObtainFailedException x) {
                        NexusRepositoryIndexerImpl.LOGGER.log(Level.INFO, "#195357: could not clean up from broken index", x);
                    }
                }
                if (index) {
                    this.indexLoadedRepo(info, true);
                }
            }
        }
        currents = new HashSet<String>();
        for (RepositoryInfo info2 : RepositoryPreferences.getInstance().getRepositoryInfos()) {
            currents.add(info2.getId());
        }
        toRemove = new HashSet<String>(this.indexer.getIndexingContexts().keySet());
        toRemove.removeAll(currents);
        if (!toRemove.isEmpty()) {
            for (final String repo : toRemove) {
                try {
                    this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            NexusRepositoryIndexerImpl.this.unloadIndexingContext(repo);
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private String findIndexUpdateUrlConsideringMirrors(RepositoryInfo info) {
        String direct = info.getIndexUpdateUrl();
        if (direct == null) {
            return null;
        }
        MavenEmbedder embedder2 = EmbedderFactory.getOnlineEmbedder();
        DefaultMirrorSelector selectorNoGroups = new DefaultMirrorSelector();
        DefaultMirrorSelector selectorWithGroups = new DefaultMirrorSelector();
        for (Mirror mirror : embedder2.getSettings().getMirrors()) {
            String mirrorOf = mirror.getMirrorOf();
            if (!mirrorOf.contains("*")) {
                selectorNoGroups.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirrorOf, mirror.getMirrorOfLayouts());
            }
            selectorWithGroups.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirrorOf, mirror.getMirrorOfLayouts());
        }
        RemoteRepository original = new RemoteRepository(info.getId(), "default", info.getRepositoryUrl());
        RemoteRepository mirrored = selectorNoGroups.getMirror(original);
        if (mirrored != null) {
            String index = this.addIndex(mirrored.getUrl());
            LOGGER.log(Level.FINE, "Mirroring {0} to {1}", new Object[]{direct, index});
            return index;
        }
        mirrored = selectorWithGroups.getMirror(original);
        if (mirrored != null) {
            LOGGER.log(Level.WARNING, "Will not mirror {0} to {1}", new Object[]{direct, this.addIndex(mirrored.getUrl())});
        } else {
            LOGGER.log(Level.FINE, "No mirror for {0}", direct);
        }
        return direct;
    }

    private String addIndex(String baseURL) {
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL + ".index/";
    }

    private Collection<IndexingContext> getContexts(RepositoryInfo[] allrepos) {
        ArrayList<IndexingContext> toRet = new ArrayList<IndexingContext>();
        for (RepositoryInfo info : allrepos) {
            assert (this.getRepoMutex(info).isWriteAccess());
            IndexingContext context = this.indexer.getIndexingContexts().get(info.getId());
            if (context != null) {
                toRet.add(context);
                continue;
            }
            if (!info.isLocal() && !info.isRemoteDownloadable()) continue;
            LOGGER.info("The context '" + info.getId() + "' isn't loaded. Please file under component: maven in NetBeans issue tracking system");
        }
        return toRet;
    }

    private FlatSearchResponse repeatedFlatSearch(FlatSearchRequest fsr, Collection<IndexingContext> contexts, boolean shouldThrow) throws IOException {
        Query q1;
        BooleanClause[] c;
        int MAX_MAX_CLAUSE = 2048;
        Query q = fsr.getQuery();
        if (q instanceof BooleanQuery && (c = ((BooleanQuery)q).getClauses()).length == 1 && (q1 = c[0].getQuery()) instanceof PrefixQuery && "u".equals(((PrefixQuery)q1).getPrefix().field())) {
            MAX_MAX_CLAUSE = 8196;
        }
        fsr.setResultHitLimit(1001);
        int oldMax = BooleanQuery.getMaxClauseCount();
        try {
            int max = oldMax;
            while (true) {
                try {
                    FlatSearchResponse response;
                    while (true) {
                        BooleanQuery.setMaxClauseCount((int)max);
                        response = this.searcher.searchFlatPaged(fsr, contexts);
                        if (!response.isHitLimitExceeded()) break;
                        int limit = fsr.getResultHitLimit();
                        LOGGER.log(Level.FINE, "#197036: passed on {0} clauses processing {1} but encountered hit limit of {2}", new Object[]{max, q, limit});
                        fsr.setResultHitLimit(limit * 2);
                    }
                    LOGGER.log(Level.FINE, "passed on {0} clauses processing {1} with {2} hits", new Object[]{max, q, response.getTotalHits()});
                    FlatSearchResponse limit = response;
                    return limit;
                }
                catch (BooleanQuery.TooManyClauses exc) {
                    block11: {
                        LOGGER.log(Level.FINE, "TooManyClauses on {0} clauses processing {1}", new Object[]{max, q});
                        if ((max *= 2) <= MAX_MAX_CLAUSE) break block11;
                        if (shouldThrow) {
                            throw exc;
                        }
                        LOGGER.log(Level.WARNING, "Encountered more than {0} clauses processing {1}", new Object[]{MAX_MAX_CLAUSE, q});
                        FlatSearchResponse flatSearchResponse = null;
                        BooleanQuery.setMaxClauseCount((int)oldMax);
                        return flatSearchResponse;
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            BooleanQuery.setMaxClauseCount((int)oldMax);
        }
    }

    private void unloadIndexingContext(RepositoryInfo ... repos) throws IOException {
        for (RepositoryInfo repo : repos) {
            assert (this.getRepoMutex(repo).isWriteAccess());
            LOGGER.finer("Unloading Context :" + repo.getId());
            IndexingContext ic = this.indexer.getIndexingContexts().get(repo.getId());
            if (ic == null) continue;
            this.indexer.removeIndexingContext(ic, false);
        }
    }

    private void unloadIndexingContext(String repo) throws IOException {
        assert (this.getRepoMutex(repo).isWriteAccess());
        LOGGER.fine("Unloading Context :" + repo);
        IndexingContext ic = this.indexer.getIndexingContexts().get(repo);
        if (ic != null) {
            this.indexer.removeIndexingContext(ic, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void indexLoadedRepo(RepositoryInfo repo, boolean updateLocal) {
        assert (this.getRepoMutex(repo).isWriteAccess());
        try {
            Map<String, IndexingContext> indexingContexts = this.indexer.getIndexingContexts();
            IndexingContext indexingContext = indexingContexts.get(repo.getId());
            if (indexingContext == null) {
                LOGGER.info("Indexing context could not be found :" + repo.getId());
                return;
            }
            if (repo.isRemoteDownloadable()) {
                LOGGER.finer("Indexing Remote Repository :" + repo.getId());
                RemoteIndexTransferListener listener = new RemoteIndexTransferListener(repo);
                try {
                    WagonHelper.WagonFetcher fetcher = new WagonHelper.WagonFetcher((Wagon)this.embedder.lookup(Wagon.class, URI.create(repo.getRepositoryUrl()).getScheme()), listener, null, null);
                    IndexUpdateRequest iur = new IndexUpdateRequest(indexingContext, fetcher);
                    NotifyingIndexCreator nic = null;
                    for (IndexCreator ic : indexingContext.getIndexCreators()) {
                        if (!(ic instanceof NotifyingIndexCreator)) continue;
                        nic = (NotifyingIndexCreator)ic;
                        break;
                    }
                    if (nic != null) {
                        nic.start();
                    }
                    try {
                        this.remoteIndexUpdater.fetchAndUpdateIndex(iur);
                        if (nic == null) return;
                    }
                    catch (Throwable throwable) {
                        if (nic == null) throw throwable;
                        nic.end();
                        throw throwable;
                    }
                    nic.end();
                    return;
                }
                finally {
                    listener.close();
                }
            }
            LOGGER.finer("Indexing Local Repository :" + repo.getId());
            RepositoryIndexerListener listener = new RepositoryIndexerListener(indexingContext);
            try {
                this.indexer.scan(indexingContext, listener, updateLocal);
                return;
            }
            finally {
                listener.close();
            }
        }
        catch (Cancellation x) {
            LOGGER.log(Level.INFO, "canceled indexing of {0}", repo.getId());
            return;
        }
        catch (IOException x) {
            LOGGER.log(Level.INFO, "could not index " + repo.getId(), x);
            return;
        }
        catch (ComponentLookupException x) {
            LOGGER.log(Level.INFO, "could not find protocol handler for " + repo.getRepositoryUrl(), x);
            return;
        }
        finally {
            RepositoryPreferences.getInstance().setLastIndexUpdate(repo.getId(), new Date());
            this.fireChangeIndex(repo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexRepo(final RepositoryInfo repo) {
        LOGGER.finer("Indexing Context :" + repo);
        try {
            RemoteIndexTransferListener.addToActive(Thread.currentThread());
            this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    NexusRepositoryIndexerImpl.this.initIndexer();
                    IndexingContext cntx = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repo.getId());
                    if (cntx != null) {
                        NexusRepositoryIndexerImpl.this.indexer.removeIndexingContext(cntx, true);
                    }
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                    NexusRepositoryIndexerImpl.this.indexLoadedRepo(repo, false);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            RemoteIndexTransferListener.removeFromActive(Thread.currentThread());
        }
    }

    public void shutdownAll() {
        LOGGER.finer("Shutting Down All Contexts");
        try {
            if (this.inited) {
                for (IndexingContext ic : this.indexer.getIndexingContexts().values()) {
                    LOGGER.log(Level.FINER, "Shutting Down: {0}", ic.getId());
                    this.indexer.removeIndexingContext(ic, false);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void updateIndexWithArtifacts(final RepositoryInfo repo, final Collection<Artifact> artifacts) {
        try {
            this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                    Map<String, IndexingContext> indexingContexts = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts();
                    IndexingContext indexingContext = indexingContexts.get(repo.getId());
                    if (indexingContext == null) {
                        LOGGER.warning("Indexing context could not be created :" + repo.getId());
                        return null;
                    }
                    for (Artifact artifact : artifacts) {
                        File art;
                        String absolutePath;
                        if (artifact.getFile() != null) {
                            absolutePath = artifact.getFile().getAbsolutePath();
                        } else {
                            if (artifact.getVersion() == null) continue;
                            absolutePath = repo.getRepositoryPath() + File.separator + NexusRepositoryIndexerImpl.this.repository.pathOf(artifact);
                        }
                        if (!(art = new File(absolutePath)).exists()) continue;
                        ArtifactContext ac = NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, art);
                        NexusRepositoryIndexerImpl.this.indexer.addArtifactToIndex(ac, indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChangeIndex(repo);
    }

    @Override
    public void deleteArtifactFromIndex(final RepositoryInfo repo, final Artifact artifact) {
        try {
            this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    String absolutePath;
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                    Map<String, IndexingContext> indexingContexts = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts();
                    IndexingContext indexingContext = indexingContexts.get(repo.getId());
                    if (indexingContext == null) {
                        LOGGER.warning("Indexing context chould not be created :" + repo.getId());
                        return null;
                    }
                    if (artifact.getFile() != null) {
                        absolutePath = artifact.getFile().getAbsolutePath();
                    } else if (artifact.getVersion() != null) {
                        absolutePath = repo.getRepositoryPath() + File.separator + NexusRepositoryIndexerImpl.this.repository.pathOf(artifact);
                    } else {
                        return null;
                    }
                    String extension = artifact.getArtifactHandler().getExtension();
                    String pomPath = absolutePath.substring(0, absolutePath.length() - extension.length());
                    pomPath = pomPath + "pom";
                    File pom = new File(pomPath);
                    if (pom.exists()) {
                        NexusRepositoryIndexerImpl.this.indexer.deleteArtifactFromIndex(NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, pom), indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChangeIndex(repo);
    }

    private void fireChangeIndex(final RepositoryInfo repo) {
        if (this.getRepoMutex(repo).isWriteAccess()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    NexusRepositoryIndexerImpl.this.fireChangeIndex(repo);
                }
            });
            return;
        }
        assert (!this.getRepoMutex(repo).isWriteAccess() && !this.getRepoMutex(repo).isReadAccess());
        repo.fireChangeIndex();
    }

    private File getDefaultIndexLocation() {
        File cacheDir;
        String userdir = System.getProperty("netbeans.user");
        if (userdir != null) {
            cacheDir = new File(new File(new File(userdir, "var"), "cache"), MAVENINDEX_PATH);
        } else {
            File root = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            cacheDir = new File(root, MAVENINDEX_PATH);
        }
        cacheDir.mkdirs();
        return cacheDir;
    }

    @Override
    public Set<String> getGroups(List<RepositoryInfo> repos) {
        return this.filterGroupIds("", repos);
    }

    @Override
    public Set<String> filterGroupIds(final String prefix, List<RepositoryInfo> repos) {
        try {
            final TreeSet<String> groups = new TreeSet<String>();
            final ArrayList slowCheck = new ArrayList();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        if (repo.isLocal() || repo.isRemoteDownloadable()) {
                            Set<String> all;
                            IndexingContext context = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repo.getId());
                            if (context == null) {
                                return null;
                            }
                            try {
                                all = context.getAllGroups();
                            }
                            catch (FileNotFoundException x) {
                                LOGGER.log(Level.INFO, "#179624: corrupt index?", x);
                                all = Collections.emptySet();
                            }
                            if (all.size() > 0) {
                                if (prefix.length() == 0) {
                                    groups.addAll(all);
                                } else {
                                    for (String gr : all) {
                                        if (!gr.startsWith(prefix)) continue;
                                        groups.add(gr);
                                    }
                                }
                            } else {
                                slowCheck.add(repo);
                            }
                        }
                        return null;
                    }
                });
            }
            for (final RepositoryInfo slowrepo : slowCheck) {
                this.getRepoMutex(slowrepo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(new BooleanClause((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, prefix)), BooleanClause.Occur.MUST));
                        GroupedSearchRequest gsr = new GroupedSearchRequest((Query)bq, (Grouping)new GGrouping(), new Comparator<String>(){

                            @Override
                            public int compare(String o1, String o2) {
                                return o1.compareTo(o2);
                            }
                        });
                        try {
                            GroupedSearchResponse response = NexusRepositoryIndexerImpl.this.searcher.searchGrouped(gsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{slowrepo}));
                            groups.addAll(response.getResults().keySet());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            return groups;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public List<NBVersionInfo> getRecords(final String groupId, final String artifactId, final String version, List<RepositoryInfo> repos) {
        try {
            final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        String id = groupId + "|" + artifactId + "|" + version + "|";
                        bq.add(new BooleanClause((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id)), BooleanClause.Occur.MUST));
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}));
                        infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                        return null;
                    }
                });
            }
            return infos;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public Set<String> getArtifacts(final String groupId, List<RepositoryInfo> repos) {
        try {
            final TreeSet<String> artifacts = new TreeSet<String>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        BooleanQuery bq = new BooleanQuery();
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        String id = groupId + "|";
                        bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            for (ArtifactInfo artifactInfo : response.getResults()) {
                                artifacts.add(artifactInfo.artifactId);
                            }
                        }
                        return null;
                    }
                });
            }
            return artifacts;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public List<NBVersionInfo> getVersions(final String groupId, final String artifactId, List<RepositoryInfo> repos) {
        try {
            final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        String id = groupId + "|" + artifactId + "|";
                        bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                        }
                        return null;
                    }
                });
            }
            return infos;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findVersionsByClass(final String className, List<RepositoryInfo> repos) {
        try {
            final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        String clsname = className.replace(".", "/");
                        FlatSearchRequest fsr = new FlatSearchRequest(NexusRepositoryIndexerImpl.setBooleanRewrite(NexusRepositoryIndexerImpl.this.indexer.constructQuery(MAVEN.CLASSNAMES, new StringSearchExpression(clsname.toLowerCase()))), ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(NexusRepositoryIndexerImpl.this.postProcessClasses(response.getResults(), clsname)));
                        }
                        return null;
                    }
                });
            }
            return infos;
        }
        catch (MutexException ex) {
            this.rethrowTooManyClauses(ex);
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findDependencyUsage(final String groupId, final String artifactId, final String version, List<RepositoryInfo> repos) {
        try {
            final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_GROUP, groupId)), BooleanClause.Occur.MUST));
                        bq.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_ARTIFACT, artifactId)), BooleanClause.Occur.MUST));
                        bq.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_VERSION, version)), BooleanClause.Occur.MUST));
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                        }
                        return null;
                    }
                });
            }
            return infos;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findBySHA1(final String sha1, List<RepositoryInfo> repos) {
        try {
            final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite(NexusRepositoryIndexerImpl.this.indexer.constructQuery(MAVEN.SHA1, new StringSearchExpression(sha1))), BooleanClause.Occur.SHOULD));
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                        }
                        return null;
                    }
                });
            }
            return infos;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findArchetypes(List<RepositoryInfo> repos) {
        try {
            final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-archetype")), BooleanClause.Occur.MUST));
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            List results = NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults());
                            infos.addAll(results);
                        }
                        return null;
                    }
                });
            }
            return infos;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public Set<String> filterPluginArtifactIds(final String groupId, final String prefix, List<RepositoryInfo> repos) {
        try {
            final TreeSet<String> artifacts = new TreeSet<String>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        String id = groupId + "|" + prefix;
                        bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST));
                        bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            for (ArtifactInfo artifactInfo : response.getResults()) {
                                artifacts.add(artifactInfo.artifactId);
                            }
                        }
                        return null;
                    }
                });
            }
            return artifacts;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> filterPluginGroupIds(final String prefix, List<RepositoryInfo> repos) {
        try {
            final TreeSet<String> artifacts = new TreeSet<String>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(new BooleanClause((Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST));
                        if (prefix.length() > 0) {
                            bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.GROUP_ID, prefix))), BooleanClause.Occur.MUST));
                        }
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            for (ArtifactInfo artifactInfo : response.getResults()) {
                                artifacts.add(artifactInfo.groupId);
                            }
                        }
                        return null;
                    }
                });
            }
            return artifacts;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> filterArtifactIdForGroupId(final String groupId, final String prefix, List<RepositoryInfo> repos) {
        try {
            final TreeSet<String> artifacts = new TreeSet<String>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        String id = groupId + "|" + prefix;
                        bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST));
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), false);
                        if (response != null) {
                            for (ArtifactInfo artifactInfo : response.getResults()) {
                                artifacts.add(artifactInfo.artifactId);
                            }
                        }
                        return null;
                    }
                });
            }
            return artifacts;
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public List<NBVersionInfo> find(final List<QueryField> fields, List<RepositoryInfo> repos) {
        try {
            final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
            for (final RepositoryInfo repo : repos) {
                this.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        NexusRepositoryIndexerImpl.this.loadIndexingContext(repo);
                        BooleanQuery bq = new BooleanQuery();
                        for (QueryField field : fields) {
                            Object q;
                            BooleanClause.Occur occur;
                            BooleanClause.Occur occur2 = occur = field.getOccur() == 1 ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
                            String fieldName = NexusRepositoryIndexerImpl.this.toNexusField(field.getField());
                            if (fieldName == null) continue;
                            if (ArtifactInfo.NAMES.equals(fieldName)) {
                                String clsname = field.getValue().replace(".", "/");
                                q = NexusRepositoryIndexerImpl.this.indexer.constructQuery(MAVEN.CLASSNAMES, new StringSearchExpression(clsname.toLowerCase()));
                            } else {
                                q = ArtifactInfo.ARTIFACT_ID.equals(fieldName) ? NexusRepositoryIndexerImpl.this.indexer.constructQuery(MAVEN.ARTIFACT_ID, new StringSearchExpression(field.getValue())) : (field.getMatch() == 0 ? new TermQuery(new Term(fieldName, field.getValue())) : new PrefixQuery(new Term(fieldName, field.getValue())));
                            }
                            BooleanClause bc = new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite(q), occur);
                            bq.add(bc);
                        }
                        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                        fsr.setAiCount(512);
                        FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(new RepositoryInfo[]{repo}), true);
                        infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                        return null;
                    }
                });
            }
            return infos;
        }
        catch (MutexException ex) {
            this.rethrowTooManyClauses(ex);
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<RepositoryInfo> getLoaded(List<RepositoryInfo> repos) {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>(repos.size());
        for (RepositoryInfo repo : repos) {
            File timestamp;
            File loc = new File(this.getDefaultIndexLocation(), repo.getId());
            if (!loc.exists() || !(timestamp = new File(loc, "timestamp")).exists()) continue;
            toRet.add(repo);
        }
        return toRet;
    }

    private String toNexusField(String field) {
        if ("artifactId".equals(field)) {
            return ArtifactInfo.ARTIFACT_ID;
        }
        if ("groupId".equals(field)) {
            return ArtifactInfo.GROUP_ID;
        }
        if ("version".equals(field)) {
            return ArtifactInfo.VERSION;
        }
        if ("classes".equals(field)) {
            return ArtifactInfo.NAMES;
        }
        if ("name".equals(field)) {
            return ArtifactInfo.NAME;
        }
        if ("description".equals(field)) {
            return ArtifactInfo.DESCRIPTION;
        }
        if ("packaging".equals(field)) {
            return ArtifactInfo.PACKAGING;
        }
        return field;
    }

    private void rethrowTooManyClauses(MutexException mutEx) {
        Exception cause = mutEx.getException();
        if (cause instanceof BooleanQuery.TooManyClauses) {
            throw (BooleanQuery.TooManyClauses)((Object)cause);
        }
    }

    private Collection<ArtifactInfo> postProcessClasses(Collection<ArtifactInfo> artifactInfos, String classname) {
        int patter = 40;
        boolean isPath = classname.contains("/");
        if (isPath) {
            return artifactInfos;
        }
        String pattStr = ".*/" + classname + "$.*";
        Pattern patt = Pattern.compile(pattStr, patter);
        Iterator<ArtifactInfo> it = artifactInfos.iterator();
        while (it.hasNext()) {
            ArtifactInfo ai = it.next();
            Matcher m = patt.matcher(ai.classNames);
            if (m.matches()) continue;
            it.remove();
        }
        return artifactInfos;
    }

    private List<NBVersionInfo> convertToNBVersionInfo(Collection<ArtifactInfo> artifactInfos) {
        ArrayList<NBVersionInfo> bVersionInfos = new ArrayList<NBVersionInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            if ("javadoc".equals(ai.classifier) || "sources".equals(ai.classifier)) continue;
            NBVersionInfo nbvi = new NBVersionInfo(ai.repository, ai.groupId, ai.artifactId, ai.version, ai.packaging, ai.packaging, ai.name, ai.description, ai.classifier);
            nbvi.setJavadocExists(ai.javadocExists == ArtifactAvailablility.PRESENT);
            nbvi.setSourcesExists(ai.sourcesExists == ArtifactAvailablility.PRESENT);
            nbvi.setSignatureExists(ai.signatureExists == ArtifactAvailablility.PRESENT);
            nbvi.setLastModified(ai.lastModified);
            nbvi.setSize(ai.size);
            bVersionInfos.add(nbvi);
        }
        return bVersionInfos;
    }

    private static Query setBooleanRewrite(Query q) {
        if (q instanceof MultiTermQuery) {
            ((MultiTermQuery)q).setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
        } else if (q instanceof BooleanQuery) {
            for (BooleanClause c : ((BooleanQuery)q).getClauses()) {
                NexusRepositoryIndexerImpl.setBooleanRewrite(c.getQuery());
            }
        }
        return q;
    }

    private static class NbIndexCreator
    extends AbstractIndexCreator {
        private final List<ArtifactRepository> remoteRepos;
        private WeakReference<MavenEmbedder> embedderRef = null;
        private final Map<ArtifactInfo, List<Dependency>> dependenciesByArtifact = new WeakHashMap<ArtifactInfo, List<Dependency>>();
        private static final String NS = "urn:NbIndexCreator";
        private static IndexerField FLD_NB_DEPENDENCY_GROUP = new IndexerField(new Field(null, "urn:NbIndexCreator", "nbdg", "Dependency group"), IndexerFieldVersion.V3, "nbdg", "Dependency group", Field.Store.NO, Field.Index.NOT_ANALYZED);
        private static IndexerField FLD_NB_DEPENDENCY_ARTIFACT = new IndexerField(new Field(null, "urn:NbIndexCreator", "nbda", "Dependency artifact"), IndexerFieldVersion.V3, "nbda", "Dependency artifact", Field.Store.NO, Field.Index.NOT_ANALYZED);
        private static IndexerField FLD_NB_DEPENDENCY_VERSION = new IndexerField(new Field(null, "urn:NbIndexCreator", "nbdv", "Dependency version"), IndexerFieldVersion.V3, "nbdv", "Dependency version", Field.Store.NO, Field.Index.NOT_ANALYZED);

        NbIndexCreator() {
            this.remoteRepos = new ArrayList<ArtifactRepository>();
            for (RepositoryInfo info : RepositoryPreferences.getInstance().getRepositoryInfos()) {
                if (info.isLocal()) continue;
                this.remoteRepos.add((ArtifactRepository)new MavenArtifactRepository(info.getId(), info.getRepositoryUrl(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy()));
            }
        }

        private MavenEmbedder getEmbedder() {
            MavenEmbedder res;
            MavenEmbedder mavenEmbedder = res = null != this.embedderRef ? (MavenEmbedder)this.embedderRef.get() : null;
            if (null == res) {
                res = EmbedderFactory.getOnlineEmbedder();
                this.embedderRef = new WeakReference<MavenEmbedder>(res);
            }
            return res;
        }

        @Override
        public void populateArtifactInfo(ArtifactContext context) throws IOException {
            ArtifactInfo ai = context.getArtifactInfo();
            if (ai.classifier != null) {
                return;
            }
            try {
                MavenProject mp = this.load(ai);
                if (mp != null) {
                    List dependencies = mp.getDependencies();
                    LOGGER.log(Level.FINE, "Successfully loaded project model from repository for {0} with {1} dependencies", new Object[]{ai, dependencies.size()});
                    this.dependenciesByArtifact.put(ai, dependencies);
                }
            }
            catch (InvalidArtifactRTException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void updateDocument(ArtifactInfo ai, Document doc) {
            List<Dependency> dependencies = this.dependenciesByArtifact.get(ai);
            if (dependencies != null) {
                for (Dependency d : dependencies) {
                    doc.add((Fieldable)FLD_NB_DEPENDENCY_GROUP.toField(d.getGroupId()));
                    doc.add((Fieldable)FLD_NB_DEPENDENCY_ARTIFACT.toField(d.getArtifactId()));
                    doc.add((Fieldable)FLD_NB_DEPENDENCY_VERSION.toField(d.getVersion()));
                }
            }
        }

        @Override
        public Collection<IndexerField> getIndexerFields() {
            return Arrays.asList(FLD_NB_DEPENDENCY_GROUP, FLD_NB_DEPENDENCY_ARTIFACT, FLD_NB_DEPENDENCY_VERSION);
        }

        private MavenProject load(ArtifactInfo ai) {
            try {
                Artifact projectArtifact = this.getEmbedder().createArtifact(ai.groupId, ai.artifactId, ai.version, ai.packaging != null ? ai.packaging : "jar");
                DefaultProjectBuildingRequest dpbr = new DefaultProjectBuildingRequest();
                dpbr.setLocalRepository(this.getEmbedder().getLocalRepository());
                dpbr.setRemoteRepositories(this.remoteRepos);
                dpbr.setValidationLevel(0);
                dpbr.setSystemProperties(this.getEmbedder().getSystemProperties());
                ProjectBuildingResult res = this.getEmbedder().buildProject(projectArtifact, (ProjectBuildingRequest)dpbr);
                if (res.getProject() != null) {
                    return res.getProject();
                }
                LOGGER.log(Level.FINE, "No project model from repository for {0}: {1}", new Object[]{ai, res.getProblems()});
            }
            catch (ProjectBuildingException ex) {
                LOGGER.log(Level.FINE, "Failed to load project model from repository for {0}: {1}", new Object[]{ai, ex});
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, "Failed to load project model from repository for " + ai, exception);
            }
            return null;
        }

        @Override
        public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
            return false;
        }
    }

    private static final class NotifyingIndexCreator
    implements IndexCreator {
        private final RepositoryInfo beingIndexed;
        private ProgressHandle handle;
        private final AtomicBoolean canceled = new AtomicBoolean();

        NotifyingIndexCreator(RepositoryInfo info) {
            this.beingIndexed = info;
        }

        private void start() {
            this.handle = null;
            this.canceled.set(false);
        }

        private void end() {
            if (this.handle != null) {
                this.handle.finish();
                this.handle = null;
            }
            this.canceled.set(false);
        }

        @Override
        public void updateDocument(ArtifactInfo artifactInfo, Document document) {
            if (this.canceled.get()) {
                throw new Cancellation();
            }
            if (this.handle == null) {
                this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NexusRepositoryIndexerImpl.class, (String)"LBL_unpacking", (Object)this.beingIndexed.getName()), (Cancellable)new Cancellable(){
                    {
                        Cancellation.register(this);
                    }

                    public boolean cancel() {
                        return NotifyingIndexCreator.this.canceled.compareAndSet(false, true);
                    }
                });
                this.handle.start();
            }
            this.handle.progress(artifactInfo.groupId + ':' + artifactInfo.artifactId);
        }

        @Override
        public Collection<IndexerField> getIndexerFields() {
            return Collections.emptySet();
        }

        @Override
        public void populateArtifactInfo(ArtifactContext artifactContext) throws IOException {
        }

        @Override
        public boolean updateArtifactInfo(Document document, ArtifactInfo artifactInfo) {
            return false;
        }
    }
}

