/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.java.plugins.ChangeParametersPlugin;
import org.netbeans.modules.refactoring.java.plugins.CopyClassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldsPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractSuperclassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.InnerToOuterRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PullUpRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PushDownRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.SafeDeleteRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.UseSuperTypeRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class JavaRefactoringsFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        Lookup look = refactoring.getRefactoringSource();
        FileObject file = (FileObject)look.lookup(FileObject.class);
        NonRecursiveFolder folder = (NonRecursiveFolder)look.lookup(NonRecursiveFolder.class);
        TreePathHandle handle = (TreePathHandle)look.lookup(TreePathHandle.class);
        if (refactoring instanceof WhereUsedQuery) {
            if (handle != null) {
                return new JavaWhereUsedQueryPlugin((WhereUsedQuery)refactoring);
            }
        } else if (refactoring instanceof RenameRefactoring) {
            if (handle != null || file != null && RetoucheUtils.isJavaFile(file)) {
                return new RenameRefactoringPlugin((RenameRefactoring)refactoring);
            }
            if (file != null && RetoucheUtils.isOnSourceClasspath(file) && file.isFolder()) {
                return new MoveRefactoringPlugin((RenameRefactoring)refactoring);
            }
            if (folder != null && RetoucheUtils.isOnSourceClasspath(folder.getFolder())) {
                return new MoveRefactoringPlugin((RenameRefactoring)refactoring);
            }
        } else if (refactoring instanceof SafeDeleteRefactoring) {
            if (this.checkSafeDelete(refactoring.getRefactoringSource())) {
                return new SafeDeleteRefactoringPlugin((SafeDeleteRefactoring)refactoring);
            }
        } else if (refactoring instanceof MoveRefactoring) {
            if (this.checkMove(refactoring.getRefactoringSource())) {
                return new MoveRefactoringPlugin((MoveRefactoring)refactoring);
            }
        } else if (refactoring instanceof SingleCopyRefactoring) {
            if (this.checkCopy(refactoring.getRefactoringSource())) {
                return new CopyClassRefactoringPlugin((SingleCopyRefactoring)refactoring);
            }
        } else if (handle != null) {
            if (refactoring instanceof ExtractInterfaceRefactoring) {
                return new ExtractInterfaceRefactoringPlugin((ExtractInterfaceRefactoring)refactoring);
            }
            if (refactoring instanceof ExtractSuperclassRefactoring) {
                return new ExtractSuperclassRefactoringPlugin((ExtractSuperclassRefactoring)refactoring);
            }
            if (refactoring instanceof PullUpRefactoring) {
                return new PullUpRefactoringPlugin((PullUpRefactoring)refactoring);
            }
            if (refactoring instanceof PushDownRefactoring) {
                return new PushDownRefactoringPlugin((PushDownRefactoring)refactoring);
            }
            if (refactoring instanceof UseSuperTypeRefactoring) {
                return new UseSuperTypeRefactoringPlugin((UseSuperTypeRefactoring)refactoring);
            }
            if (refactoring instanceof InnerToOuterRefactoring) {
                return new InnerToOuterRefactoringPlugin((InnerToOuterRefactoring)refactoring);
            }
            if (refactoring instanceof ChangeParametersRefactoring) {
                return new ChangeParametersPlugin((ChangeParametersRefactoring)refactoring);
            }
            if (refactoring instanceof EncapsulateFieldRefactoring) {
                return new EncapsulateFieldRefactoringPlugin((EncapsulateFieldRefactoring)refactoring);
            }
            if (refactoring instanceof EncapsulateFieldsRefactoring) {
                return new EncapsulateFieldsPlugin((EncapsulateFieldsRefactoring)refactoring);
            }
        }
        return null;
    }

    private boolean checkMove(Lookup refactoringSource) {
        for (FileObject f : refactoringSource.lookupAll(FileObject.class)) {
            if (RetoucheUtils.isJavaFile(f)) {
                return true;
            }
            if (!f.isFolder()) continue;
            return true;
        }
        return false;
    }

    private boolean checkSafeDelete(Lookup object) {
        boolean a = false;
        NonRecursiveFolder folder = (NonRecursiveFolder)object.lookup(NonRecursiveFolder.class);
        if (folder != null) {
            return true;
        }
        for (FileObject f : object.lookupAll(FileObject.class)) {
            a = true;
            if (!f.isValid()) {
                return false;
            }
            if (RetoucheUtils.isJavaFile(f) || JavaRefactoringsFactory.isPackage(f)) continue;
            return false;
        }
        if (object.lookup(TreePathHandle.class) != null) {
            return true;
        }
        return a;
    }

    private boolean checkCopy(Lookup object) {
        FileObject f = (FileObject)object.lookup(FileObject.class);
        return f != null && RetoucheUtils.isJavaFile(f);
    }

    private static boolean isPackage(FileObject fileObject) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            return false;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }
}

