/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;

public class DeleteTransformer
extends RefactoringVisitor {
    @Override
    public Tree visitMethod(MethodTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitMethod(tree, p);
    }

    @Override
    public Tree visitClass(ClassTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitClass(tree, p);
    }

    @Override
    public Tree visitVariable(VariableTree tree, Element p) {
        this.deleteDeclIfMatch(tree, p);
        return (Tree)super.visitVariable(tree, p);
    }

    private void deleteDeclIfMatch(Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return;
        }
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (((Object)elementToFind).equals(el)) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            Tree newOne = null;
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind())) {
                newOne = this.make.removeClassMember((ClassTree)parent, tree);
            } else if (parent.getKind() == Tree.Kind.COMPILATION_UNIT) {
                newOne = this.make.removeCompUnitTypeDecl((CompilationUnitTree)parent, tree);
            } else if (tree.getKind() == Tree.Kind.VARIABLE) {
                newOne = parent.getKind() == Tree.Kind.METHOD ? this.make.removeMethodParameter((MethodTree)parent, (VariableTree)tree) : this.make.removeBlockStatement((BlockTree)parent, (StatementTree)((VariableTree)tree));
            }
            if (newOne != null) {
                this.rewrite(parent, newOne);
            }
        }
    }
}

