/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.NbBundle;

public class AnalyzeExecLog
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    public static final String EXEC_LOG_KEY = "exec-log-file";
    private Progress progress;

    public AnalyzeExecLog() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(EXEC_LOG_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeExecLog.i18n("Exec_Log_File_Name");
            }

            public String getDescription() {
                return AnalyzeExecLog.i18n("Exec_Log_File_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.MakeLogFile;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecLog.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecLog.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecLog.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecLog.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return "exec-log";
    }

    public String getName() {
        return AnalyzeExecLog.i18n("Exec_Log_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeExecLog.i18n("Exec_Log_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String string) {
        return this.myProperties.get(string);
    }

    @Override
    public boolean isApplicable(ProjectProxy projectProxy) {
        String string = (String)this.getProperty(EXEC_LOG_KEY).getValue();
        if (string == null || string.length() == 0) {
            return false;
        }
        Object object = this.getProperty("restrict_compile_root").getValue();
        if (object == null || "".equals(object.toString())) {
            this.getProperty("restrict_compile_root").setValue((Object)projectProxy.getSourceRoot());
            return true;
        }
        return false;
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy projectProxy) {
        String string = (String)this.getProperty(EXEC_LOG_KEY).getValue();
        if (string == null || string.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecLog.class, (String)"NotFoundExecLog")));
        }
        return new ApplicableImpl(true, null, null, 80, false, null, null, null, null);
    }

    @Override
    protected List<SourceFileProperties> getSourceFileProperties(String string, Map<String, SourceFileProperties> map, ProjectProxy projectProxy, Set<String> set) {
        ProviderProperty providerProperty = this.getProperty("restrict_compile_root");
        String string2 = "";
        if (providerProperty != null) {
            string2 = (String)providerProperty.getValue();
        }
        List<SourceFileProperties> list = this.runLogReader(string, string2, this.progress, projectProxy);
        this.progress = null;
        return list;
    }

    private List<SourceFileProperties> runLogReader(String string, String string2, Progress progress, ProjectProxy projectProxy) {
        ExecLogReader execLogReader = new ExecLogReader(string, string2, projectProxy);
        List<SourceFileProperties> list = execLogReader.getResults(progress, this.isStoped);
        return list;
    }

    public List<Configuration> analyze(final ProjectProxy projectProxy, Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        this.setCommpilerSettings(projectProxy);
        this.progress = progress;
        if (!this.isStoped.get()) {
            Configuration configuration = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles = new ArrayList<String>();

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration());
                }

                public List<String> getDependencies() {
                    return null;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    String string;
                    if (this.myFileProperties == null && (string = (String)AnalyzeExecLog.this.getProperty(AnalyzeExecLog.EXEC_LOG_KEY).getValue()) != null && string.length() > 0) {
                        this.myFileProperties = AnalyzeExecLog.this.getSourceFileProperties(new String[]{string}, null, projectProxy, null);
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    return this.myIncludedFiles;
                }
            };
            arrayList.add(configuration);
        }
        return arrayList;
    }

    private static String i18n(String string) {
        return NbBundle.getMessage(AnalyzeExecLog.class, (String)string);
    }

    private static class ExecSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private String compiler;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();

        /*
         * WARNING - void declaration
         */
        private ExecSource(String string, List<String> list, PathMap pathMap) {
            ArrayList arrayList;
            HashMap hashMap;
            ArrayList arrayList2;
            String string2;
            Iterator<String> iterator;
            this.compiler = string.lastIndexOf(47) > 0 ? string.substring(string.lastIndexOf(47) + 1) : string;
            this.language = this.compiler.equals("cc") || this.compiler.equals("gcc") ? ItemProperties.LanguageKind.C : (this.compiler.equals("CC") || this.compiler.equals("g++") ? ItemProperties.LanguageKind.CPP : (this.compiler.equals("ffortran") || this.compiler.equals("f77") || this.compiler.equals("f90") || this.compiler.equals("f95") || this.compiler.equals("gfortran") || this.compiler.equals("g77") || this.compiler.equals("g90") || this.compiler.equals("g95") ? ItemProperties.LanguageKind.Fortran : ItemProperties.LanguageKind.Unknown));
            if (list.size() > 0) {
                this.compilePath = pathMap != null ? pathMap.getLocalPath(list.get(0)) : list.get(0);
            }
            if ((iterator = list.iterator()).hasNext()) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                iterator.next();
            }
            if ((string2 = DiscoveryUtils.gatherCompilerLine(iterator, (boolean)false, arrayList2 = new ArrayList(), hashMap = new HashMap(), null, arrayList = new ArrayList())) == null) {
                throw new IllegalArgumentException();
            }
            if (string2.endsWith(".s") || string2.endsWith(".S")) {
                throw new IllegalArgumentException();
            }
            this.userIncludes = new ArrayList<String>(arrayList2.size());
            for (String string3 : arrayList2) {
                void object;
                if (string3.startsWith("/") && pathMap != null) {
                    String string4 = pathMap.getLocalPath(string2);
                }
                this.userIncludes.add(PathCache.getString((String)object));
            }
            this.userMacros = new HashMap<String, String>(hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                if (entry.getValue() == null) {
                    this.userMacros.put(PathCache.getString((String)entry.getKey()), null);
                    continue;
                }
                this.userMacros.put(PathCache.getString((String)entry.getKey()), PathCache.getString((String)entry.getValue()));
            }
            if (string2.startsWith("/")) {
                if (pathMap != null) {
                    string2 = pathMap.getLocalPath(string2);
                }
                this.fullName = string2;
                this.sourceName = DiscoveryUtils.getRelativePath((String)this.compilePath, (String)string2);
            } else {
                this.fullName = this.compilePath + "/" + string2;
                this.sourceName = string2;
            }
            File file = new File(this.fullName);
            if (file.exists() && file.isFile()) {
                File file2 = new File(this.fullName);
                this.fullName = CndFileUtils.normalizeFile((File)file2).getAbsolutePath();
                this.fullName = PathCache.getString(this.fullName);
                if (arrayList.contains("c")) {
                    this.language = ItemProperties.LanguageKind.C;
                } else if (arrayList.contains("c++")) {
                    this.language = ItemProperties.LanguageKind.CPP;
                } else {
                    String string5 = MIMESupport.getKnownMIMETypeByExtension((String)this.fullName);
                    if ("text/x-c++".equals(string5)) {
                        this.language = ItemProperties.LanguageKind.CPP;
                    } else if ("text/x-c".equals(string5)) {
                        this.language = ItemProperties.LanguageKind.C;
                    }
                }
            } else {
                throw new IllegalArgumentException();
            }
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }

        public String getCompilerName() {
            return this.compiler;
        }

        public ItemProperties.LanguageStandard getLanguageStandard() {
            return ItemProperties.LanguageStandard.Unknown;
        }
    }

    private static final class ExecLogReader {
        private static final boolean TRACE = false;
        private final String root;
        private final String fileName;
        private List<SourceFileProperties> result;
        private final ProjectProxy project;
        private final PathMap pathMapper;

        public ExecLogReader(String string, String string2, ProjectProxy projectProxy) {
            this.root = string2.length() > 0 ? CndFileUtils.normalizeFile((File)new File(string2)).getAbsolutePath() : string2;
            this.fileName = string;
            this.project = projectProxy;
            this.pathMapper = this.getPathMapper(projectProxy);
        }

        private PathMap getPathMapper(ProjectProxy projectProxy) {
            Project project = projectProxy.getProject();
            if (project != null) {
                return RemoteSyncSupport.getPathMap((Project)project);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run(Progress progress, AtomicBoolean atomicBoolean) {
            this.result = new ArrayList<SourceFileProperties>();
            File file = new File(this.fileName);
            if (file.exists() && file.canRead()) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    long l = file.length();
                    long l2 = 0L;
                    int n = 0;
                    if (l <= 0L) {
                        progress = null;
                    }
                    if (progress != null) {
                        progress.start(100);
                    }
                    try {
                        String string = null;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while (!atomicBoolean.get()) {
                            String string2 = bufferedReader.readLine();
                            if (string2 == null) {
                                break;
                            }
                            if ((l2 += (long)(string2.length() + 1)) * 100L / l > (long)n && n < 100) {
                                ++n;
                                if (progress != null) {
                                    progress.increment(null);
                                }
                            }
                            if (string2.startsWith("called:")) {
                                string = string2.substring(7).trim();
                                continue;
                            }
                            if (string2.startsWith("\t")) {
                                arrayList.add(string2.substring(1).trim());
                                continue;
                            }
                            if (string2.length() != 0) continue;
                            try {
                                this.result.add(new ExecSource(string, arrayList, this.pathMapper));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            string = null;
                            arrayList = new ArrayList();
                        }
                    }
                    finally {
                        if (progress != null) {
                            progress.done();
                        }
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }

        public List<SourceFileProperties> getResults(Progress progress, AtomicBoolean atomicBoolean) {
            if (this.result == null) {
                this.run(progress, atomicBoolean);
            }
            return this.result;
        }
    }
}

